/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ThreadPreferredHost;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.ClusteredAsyncResultImpl;
import weblogic.rmi.internal.ClusteredFutureResultRetryHelper;
import weblogic.rmi.internal.FutureResultHandle;
import weblogic.rmi.internal.FutureResultID;
import weblogic.rmi.spi.FutureResult;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundResponse;

public class ClusteredFutureResultImpl
extends ClusteredAsyncResultImpl
implements Future,
FutureResult {
    private Remote invoker;
    private final FutureResultID id;
    private HostID hostID;
    private ClusterableRemoteRef clusteredRef;
    private boolean cancelled = false;
    private ClusteredFutureResultRetryHelper helper;
    private Class<?> remoteExceptionWrapperClass;
    private Constructor<?> constructor;

    public ClusteredFutureResultImpl(Remote stub, HostID hostID, ClusterableRemoteRef clusteredRef) throws RemoteException {
        this.invoker = stub;
        this.hostID = hostID;
        this.clusteredRef = clusteredRef;
        this.id = new FutureResultID(this.hashCode());
    }

    public ClusteredFutureResultImpl(Remote stub, HostID hostID, ClusterableRemoteRef clusteredRef, RuntimeMethodDescriptor md, ClusteredFutureResultRetryHelper helper) throws RemoteException {
        this.invoker = stub;
        this.hostID = hostID;
        this.clusteredRef = clusteredRef;
        this.id = new FutureResultID(this.hashCode());
        this.helper = helper;
        String remoteExceptionWrapperName = md.getRemoteExceptionWrapperClassName();
        if (remoteExceptionWrapperName != null && !remoteExceptionWrapperName.equals("")) {
            try {
                this.remoteExceptionWrapperClass = Class.forName(remoteExceptionWrapperName);
                this.constructor = this.remoteExceptionWrapperClass.getConstructor(Throwable.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public ClusteredFutureResultRetryHelper getHelper() {
        return this.helper;
    }

    public ClusteredFutureResultImpl(Remote stub, HostID hostID, ClusterableRemoteRef clusteredRef, ClusteredFutureResultRetryHelper helper) throws RemoteException {
        this(stub, hostID, clusteredRef, helper.getMethodDescriptor(), helper);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.isDone()) {
            return false;
        }
        HostID prevHostID = ThreadPreferredHost.get();
        ThreadPreferredHost.set(this.hostID);
        try {
            this.cancelled = ((FutureResultHandle)this.invoker).__WL_cancel(this.id, mayInterruptIfRunning);
        }
        finally {
            ThreadPreferredHost.set(prevHostID);
        }
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.hasResults();
    }

    @Override
    public synchronized boolean hasResults() {
        block5: {
            if (this.inboundResponse != null) {
                return true;
            }
            if (this.throwable == null) break block5;
            try {
                if (this.shouldRetry(this.throwable)) {
                    this.retryRequest();
                    return false;
                }
            }
            finally {
                return true;
            }
            {
            }
        }
        return false;
    }

    private void retryRequest() throws Throwable {
        this.clusteredRef.invoke(this, this.invoker);
    }

    private boolean shouldRetry(Throwable t) throws Exception {
        if (this.helper != null) {
            return this.clusteredRef.handleException((Exception)t, this.helper);
        }
        return false;
    }

    public Object get() throws InterruptedException, ExecutionException, CancellationException {
        try {
            return this.unWrappedFutureResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof CancellationException) {
                throw (CancellationException)throwable;
            }
            if (throwable instanceof RemoteException) {
                throw (RuntimeException)this.throwUserDefinedException(throwable, this.remoteExceptionWrapperClass, this.constructor);
            }
            throw new ExecutionException(throwable);
        }
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException, CancellationException {
        long timeoutVal = timeout;
        if (timeout > 0L) {
            timeoutVal = TimeUnit.MILLISECONDS.convert(timeout, unit);
        }
        this.setTimeOut(timeoutVal);
        try {
            return this.unWrappedFutureResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof TimeoutException) {
                throw new TimeoutException("Timed out. Unable to retrieve object after " + timeoutVal + (Object)((Object)unit));
            }
            if (throwable instanceof CancellationException) {
                throw (CancellationException)throwable;
            }
            if (throwable instanceof RemoteException) {
                Exception exception = (Exception)this.throwUserDefinedException(throwable, this.remoteExceptionWrapperClass, this.constructor);
                if (exception instanceof TimeoutException) {
                    throw (TimeoutException)exception;
                }
                throw (RuntimeException)exception;
            }
            throw new ExecutionException(throwable);
        }
    }

    private Object unWrappedFutureResult() throws Throwable {
        if (this.cancelled) {
            throw new CancellationException("Results cannot be retrieved from a cancelled future!");
        }
        try {
            Future future = (Future)this.getObject();
            this.clusteredRef.setPiggybackResponse(this.getReplicaInfo());
            return future.get();
        }
        catch (Throwable t) {
            if (this.shouldRetry(t)) {
                this.retryRequest();
            }
            throw t;
        }
    }

    @Override
    public FutureResultID getId() {
        return this.id;
    }

    @Override
    public synchronized void setInboundResponse(InboundResponse inboundResponse) {
        super.setInboundResponse(inboundResponse);
        if (this.cancelled) {
            try {
                this.clusteredRef.setPiggybackResponse(this.getReplicaInfo());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public synchronized void updateClusterableRemoteRef(ClusterableRemoteRef crr) {
        this.clusteredRef = crr;
    }
}

