/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.rmi.RemoteException;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.ServerReferenceInterceptor;
import weblogic.rmi.spi.InboundRequest;

class ClientInfoInterceptor
extends ServerReferenceInterceptor {
    static ServerReferenceInterceptor INSTANCE = new ClientInfoInterceptor();

    @Override
    public void preInvoke(ServerReference serverRef, InboundRequest request, RuntimeMethodDescriptor descriptor) throws RemoteException {
        ServerHelper.setClientInfo(request.getEndPoint(), request.getServerChannel());
    }

    @Override
    boolean isUnconditional() {
        return true;
    }

    @Override
    void postInvokeUnconditional(ServerReference serverRef, InboundRequest request, RuntimeMethodDescriptor md) {
        ServerHelper.setClientInfo(null, null);
    }

    private ClientInfoInterceptor() {
    }
}

