/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.Future;
import weblogic.rmi.extensions.server.CBVInputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.rmi.internal.CBVFutureImpl;
import weblogic.rmi.internal.DescriptorManager;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RuntimeDescriptor;

public abstract class CBVWrapper {
    public abstract Remote getDelegate();

    protected final Object copy(Object o) {
        Object replacement = RMIEnvironment.getEnvironment().replaceSpecialCBVObject(o);
        if (replacement != null) {
            return replacement;
        }
        if (o instanceof Remote) {
            RuntimeDescriptor desc;
            if (o instanceof CBVWrapper) {
                return o;
            }
            try {
                desc = DescriptorManager.getDescriptor(o);
            }
            catch (RemoteException re) {
                throw new AssertionError((Object)re);
            }
            if (desc.getEnforceCallByValue()) {
                return CBVWrapper.getCBVWrapper(desc, o);
            }
        }
        if (o instanceof Serializable) {
            try {
                CBVOutputStream out = new CBVOutputStream();
                out.writeObject(o);
                out.flush();
                CBVInputStream in = out.makeCBVInputStream();
                Object returnValue = in.readObject();
                out.close();
                in.close();
                return returnValue;
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssertionError((Object)cnfe);
            }
        }
        return o;
    }

    public static CBVWrapper getCBVWrapper(RuntimeDescriptor desc, Object impl) {
        try {
            Constructor cons = desc.getCBVWrapper();
            CBVWrapper wrapper = (CBVWrapper)cons.newInstance(impl);
            return wrapper;
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
        catch (InstantiationException ie) {
            throw new AssertionError((Object)ie);
        }
        catch (InvocationTargetException ite) {
            throw new AssertionError((Object)ite);
        }
    }

    protected final <V> Future<V> getFutureWrapper(Future<V> f) {
        return new CBVFutureImpl<V>(f, this);
    }
}

