/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.UnmarshalException;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import weblogic.common.internal.VersionInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.health.OOMENotifier;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.QueueFullException;
import weblogic.kernel.QueueThrottleException;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.protocol.ChannelHelperBase;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.LocalRemoteJVM;
import weblogic.rmi.RMILogger;
import weblogic.rmi.RemoteEJBInvokeException;
import weblogic.rmi.ServerShuttingDownException;
import weblogic.rmi.extensions.NotificationListener;
import weblogic.rmi.extensions.server.Collectable;
import weblogic.rmi.extensions.server.InvokableServerReference;
import weblogic.rmi.extensions.server.RemoteExceptionWrapper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.facades.RmiInvocationFacade;
import weblogic.rmi.internal.BasicFutureResponse;
import weblogic.rmi.internal.BasicRuntimeDescriptor;
import weblogic.rmi.internal.CertificateValidationInterceptor;
import weblogic.rmi.internal.ClientInfoInterceptor;
import weblogic.rmi.internal.CollocatedRemoteRef;
import weblogic.rmi.internal.DescriptorManager;
import weblogic.rmi.internal.DyeInjectionInterceptor;
import weblogic.rmi.internal.FutureResultHandle;
import weblogic.rmi.internal.FutureResultID;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.OneWayMethodInterceptor;
import weblogic.rmi.internal.OperationConstants;
import weblogic.rmi.internal.PhantomRef;
import weblogic.rmi.internal.RMIDiagnosticUtil;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.ReplyOnError;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.ServerReferenceInterceptor;
import weblogic.rmi.internal.Skeleton;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.ThreadPreferredHost;
import weblogic.rmi.internal.TimeoutChecker;
import weblogic.rmi.internal.dgc.DGCPolicyConstants;
import weblogic.rmi.internal.dgc.DGCServerImpl;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.rmi.spi.InvokeHandler;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.trace.Trace;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class BasicServerRef
implements InvokableServerReference,
InvokeHandler,
Collectable,
OperationConstants,
DGCPolicyConstants {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean ASSERT = false;
    private static final boolean DEBUG = false;
    private static final boolean KERNEL_ID_MUST_USE_ADMIN_CHANNEL = BasicServerRef.initProperty("weblogic.checkKernelIdUsage", false);
    private static final boolean KERNEL_ID_MUST_USE_ADMIN_CHANNEL_LOG_ONLY = BasicServerRef.initProperty("weblogic.checkKernelIdUsageLogOnly", false);
    private static final boolean tracingEnabled = RMIEnvironment.getEnvironment().isTracingEnabled();
    private static final List<ServerReferenceInterceptor> commonInterceptors;
    private static AtomicReference<ServerReferenceInterceptor> wldfDyeInjectionInterceptor;
    private ComponentInvocationContext invocationContext;
    private List<ServerReferenceInterceptor> interceptors = new ArrayList<ServerReferenceInterceptor>();
    private Object implementation;
    private ClassLoader classloader;
    private RuntimeDescriptor descriptor;
    private final AtomicLong refCount = new AtomicLong(0L);
    private long lease = 0L;
    private String applicationName;
    private int oid;
    private final String networkAccessPoint;
    private final String implementationClassName;
    private NotificationListener notificationListener;
    private static final DebugLogger debugDgcEnrollment;
    private static final DebugLogger debugMessaging;
    protected static final AuthenticatedSubject kernelId;
    private static final AuditableThreadLocal remoteIndicator;
    private static final AuditableThreadLocal unTrustedClient;
    private static final DebugLogger debugAllowList;
    private static OOMENotifier oomeNotifier;
    private static final ServerError PRE_ALLOC_SERVER_ERROR;

    public static boolean isRemote() {
        return (Boolean)remoteIndicator.get();
    }

    public static boolean isUnTrustedClient() {
        return (Boolean)unTrustedClient.get();
    }

    static List<ServerReferenceInterceptor> getCommonInterceptors() {
        return commonInterceptors;
    }

    private static boolean initProperty(String name, boolean defaultValue) {
        try {
            boolean flag = Boolean.getBoolean(name);
            if (flag) {
                System.out.println("********************************************");
                System.out.println("-D" + name + "=" + flag);
                System.out.println("********************************************");
            }
            return flag;
        }
        catch (SecurityException se) {
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static void initOOMENotifier(OOMENotifier oomeNotifier) {
        BasicServerRef.oomeNotifier = oomeNotifier;
    }

    BasicServerRef(int oid) {
        this.oid = oid;
        this.networkAccessPoint = null;
        this.implementationClassName = "";
        this.invocationContext = null;
    }

    public BasicServerRef(Object o) throws RemoteException {
        this(OIDManager.getInstance().getNextObjectID(), o);
    }

    public BasicServerRef(int oid, Object o) throws RemoteException {
        this(o.getClass(), oid);
        this.implementation = o;
        if (this.implementation instanceof NotificationListener) {
            this.notificationListener = (NotificationListener)this.implementation;
        }
    }

    public BasicServerRef(Object o, int dgcPolicy) throws RemoteException {
        this(o);
        if (dgcPolicy == 3) {
            this.lease = OIDManagerMaker.SINGLETON.getNewLease();
        }
        ((BasicRuntimeDescriptor)this.descriptor).nullifyActivationRuntimeProperties();
    }

    protected BasicServerRef(Class c, int oid) throws RemoteException {
        this.invocationContext = RmiInvocationFacade.getCurrentComponentInvocationContext(kernelId);
        this.oid = oid;
        this.implementationClassName = c.getName();
        this.initializeDGCPolicy(c);
        this.networkAccessPoint = this.descriptor.getNetworkAccessPoint();
        this.classloader = c.getClassLoader();
        if (this.classloader instanceof GenericClassLoader) {
            this.applicationName = ((GenericClassLoader)this.classloader).getAnnotation().getAnnotationString();
        } else {
            this.classloader = null;
        }
        if (KernelStatus.DEBUG && debugDgcEnrollment.isDebugEnabled()) {
            BasicServerRef.logExportingRemoteObject(c.getName(), oid);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicServerRef)) {
            return false;
        }
        BasicServerRef other = (BasicServerRef)obj;
        return other.oid == this.oid;
    }

    public int hashCode() {
        return this.oid;
    }

    @Override
    public final int getObjectID() {
        return this.oid;
    }

    @Override
    public void addInterceptor(ServerReferenceInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    List<ServerReferenceInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    private static void logExportingRemoteObject(String className, int oid) {
        RMILogger.logExportingRemoteObject(className, oid);
    }

    public String toString() {
        return String.valueOf(System.identityHashCode(this));
    }

    private void initializeDGCPolicy(Class c) throws RemoteException {
        this.descriptor = DescriptorManager.getDescriptor(c);
        switch (this.descriptor.getDGCPolicy()) {
            case -1: 
            case 0: 
            case 1: 
            case 3: {
                this.lease = OIDManagerMaker.SINGLETON.getNewLease();
                break;
            }
            case 2: {
                this.refCount.set(Integer.MAX_VALUE);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown DGC Policy specified: " + this.descriptor.getDGCPolicy()));
            }
        }
    }

    @Override
    public ServerReference exportObject() {
        OIDManagerMaker.SINGLETON.ensureExported(this);
        return this;
    }

    protected static void trySendThrowableBeforeInterceptor(InboundRequest request, Throwable t) {
        try {
            new ReplyOnError(request.getOutboundResponse(), t);
        }
        catch (IOException ioe) {
            RMILogger.logException("Unable to send error response to client", ioe);
        }
    }

    protected static void trySendThrowable(InboundRequest request, Throwable t) {
        try {
            Throwable throwable = t;
            if (t instanceof QueueFullException) {
                throwable = new QueueThrottleException(t.getMessage(), t);
            }
            new ReplyOnError(request, request.getOutboundResponse(), throwable);
        }
        catch (IOException ioe) {
            RMILogger.logException("Unable to send error response to client", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispatch(InboundRequest request, InvokeHandler invoker) {
        RuntimeMethodDescriptor md = null;
        try {
            try {
                md = request.getRuntimeMethodDescriptor(this.descriptor);
            }
            catch (IOException ioe) {
                BasicServerRef.trySendThrowableBeforeInterceptor(request, new UnmarshalException("Could not unmarshal method ID", ioe));
                return;
            }
            Interceptor ti = InterceptorManager.getManager().getTransactionInterceptor();
            if (ti != null) {
                if (md.isTransactionalOnewayResponse()) {
                    ti.receiveResponse(request.getTxContext());
                } else {
                    ti.receiveRequest(request.getTxContext());
                }
            }
            if (request.isCollocated()) {
                this.handleRequest(request, invoker, md);
                return;
            } else if (this.isBootstrapCall()) {
                byte qos = request.getServerChannel().getProtocol().getQOS();
                WorkManager manager = this.getWorkManager(md, qos);
                manager.schedule(RMIEnvironment.getEnvironment().createExecuteRequest(this, request, md, invoker, null));
                return;
            } else {
                if (!this.acceptRequest(request)) {
                    throw new ServerShuttingDownException("Server is being shut down");
                }
                AuthenticatedSubject subject = (AuthenticatedSubject)request.getSubject();
                ServerChannel sc = request.getServerChannel();
                this.checkPriviledges(subject, sc, request.getEndPoint());
                WorkManager wm = this.getWorkManager(sc, md, subject);
                wm.schedule(RMIEnvironment.getEnvironment().createExecuteRequest(this, request, md, invoker, subject));
            }
            return;
        }
        catch (RuntimeException rte) {
            RMILogger.logRuntimeException(this.toString(), rte);
            if (md.isOneway()) return;
            BasicServerRef.trySendThrowable(request, rte);
            return;
        }
        catch (RemoteException re) {
            if (!md.isOneway()) {
                BasicServerRef.trySendThrowable(request, re);
                return;
            } else {
                if (!KernelStatus.DEBUG || !debugMessaging.isDebugEnabled()) return;
                RMILogger.logException(this.toString(), re);
            }
            return;
        }
        catch (Error er) {
            try {
                RMILogger.logErrorDisp(er);
                if (md.isOneway()) return;
                BasicServerRef.trySendThrowable(request, new ServerError("A error occurred while attampting to dispatch the server", er));
                return;
            }
            catch (Throwable ignore) {
                RMILogger.logError("Throwable was thrown and ignored while executing: " + this.getMethodStr(md), ignore);
                return;
            }
            finally {
                if (er instanceof OutOfMemoryError) {
                    if (oomeNotifier == null) throw er;
                    oomeNotifier.notifyOOME((OutOfMemoryError)er);
                } else if (er instanceof ThreadDeath) {
                    throw er;
                }
            }
        }
    }

    private void ensureAdministratorUsesAdminChannel(AuthenticatedSubject subject, ServerChannel channel, EndPoint endPoint) throws RemoteException {
        if (!KernelStatus.isServer()) {
            return;
        }
        if ((KERNEL_ID_MUST_USE_ADMIN_CHANNEL || endPoint.getCreationTime() <= ChannelHelperBase.getAdminChannelCreationTime()) && ChannelHelperBase.isLocalAdminChannelEnabled() && !ChannelHelperBase.isAdminChannel(channel) && SubjectUtils.isUserAnAdministrator(subject)) {
            SecurityException se = new SecurityException("User '" + subject + "' has administration role. All tasks by adminstrators must go through an Administration Port. Channel:" + channel + ", endpoint:" + endPoint + ", serverRef:" + this.toString());
            RMILogger.logException("Remote call rejected due to wrong channel usage", se);
            throw new RemoteException(se.getMessage(), se);
        }
        if (KERNEL_ID_MUST_USE_ADMIN_CHANNEL_LOG_ONLY && ChannelHelperBase.isLocalAdminChannelEnabled() && !ChannelHelperBase.isAdminChannel(channel) && SubjectUtils.isUserAnAdministrator(subject)) {
            SecurityException se = new SecurityException("User '" + subject + "' has administration role. All tasks by adminstrators must go through an Administration Port. Channel:" + channel + ", endpoint:" + endPoint + ", serverRef:" + this.toString());
            RMILogger.logException("Remote call rejected due to wrong channel usage", se);
        }
    }

    protected WorkManager getWorkManager(ServerChannel sc, RuntimeMethodDescriptor md, AuthenticatedSubject subject) {
        return this.getWorkManager(md, subject);
    }

    protected WorkManager getWorkManager(RuntimeMethodDescriptor md, AuthenticatedSubject subject) {
        return md.getWorkManager();
    }

    private WorkManager getWorkManager(RuntimeMethodDescriptor md, byte qos) {
        if (qos == 103) {
            return WorkManagerFactory.getInstance().getSystem();
        }
        return md.getWorkManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(final InboundRequest request, final InvokeHandler invoker, final RuntimeMethodDescriptor md) {
        block30: {
            Throwable e = null;
            Thread currentThread = null;
            ClassLoader clSave = null;
            ClassLoader newCCL = this.getApplicationClassLoader();
            if (newCCL != null) {
                currentThread = Thread.currentThread();
                clSave = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(newCCL);
            }
            OutboundResponse resp = null;
            try {
                resp = md.isOneway() ? null : request.getOutboundResponse();
                this.preInvoke(request, md);
                final OutboundResponse response = resp;
                AuthenticatedSubject subject = null;
                try {
                    subject = (AuthenticatedSubject)request.getSubject();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (this.isBootstrapCall() && subject == null) {
                    subject = SubjectUtils.getAnonymousSubject();
                }
                TimeoutChecker tc = null;
                try {
                    tc = RMIDiagnosticUtil.initTimeoutCheckerIfNeeded();
                    SecurityManager.runAs(kernelId, subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            invoker.invoke(md, request, response);
                            return null;
                        }
                    });
                }
                finally {
                    if (tc != null) {
                        tc.checkTimeout();
                    }
                }
            }
            catch (PrivilegedActionException pae) {
                e = pae.getException();
            }
            catch (OutOfMemoryError oome) {
                e = oome;
                if (oomeNotifier != null) {
                    oomeNotifier.notifyOOME(oome);
                    break block30;
                }
                throw oome;
            }
            catch (Throwable ee) {
                e = ee instanceof UndeclaredThrowableException ? ((UndeclaredThrowableException)ee).getUndeclaredThrowable() : ee;
            }
            finally {
                try {
                    this.postInvoke(md, request, resp, e);
                }
                finally {
                    if (clSave != null) {
                        currentThread.setContextClassLoader(clSave);
                    }
                }
            }
        }
    }

    private void preInvoke(InboundRequest request, RuntimeMethodDescriptor md) throws RemoteException {
        ServerReferenceInterceptor dyeInjectionInterceptor;
        for (ServerReferenceInterceptor interceptor : commonInterceptors) {
            interceptor.preInvoke(this, request, md);
        }
        for (ServerReferenceInterceptor interceptor : this.interceptors) {
            interceptor.preInvoke(this, request, md);
        }
        Interceptor ti = InterceptorManager.getManager().getTransactionInterceptor();
        if (ti != null) {
            ti.dispatchRequest(request.getTxContext());
        }
        try {
            byte[] trace;
            if (tracingEnabled && (trace = (byte[])request.getContext(4)) != null) {
                Trace.propagateTrace(trace);
            }
            request.retrieveThreadLocalContext();
        }
        catch (IOException ioe) {
            throw new UnmarshalException("Unable to read thread-local data from request.", ioe);
        }
        if (md.hasAsyncResponse()) {
            this.setFutureObjectID(request, md);
        }
        if (this.getDescriptor().getDGCPolicy() == 3) {
            this.renewLease();
        }
        if ((dyeInjectionInterceptor = wldfDyeInjectionInterceptor.get()) != null) {
            dyeInjectionInterceptor.preInvoke(this, request, md);
        }
    }

    public static void enableWLDFDyeInjection(Boolean enabled) throws Exception {
        if (enabled.booleanValue()) {
            wldfDyeInjectionInterceptor.set(DyeInjectionInterceptor.getInstance());
        } else {
            wldfDyeInjectionInterceptor.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(RuntimeMethodDescriptor md, InboundRequest request, OutboundResponse response) throws Exception {
        String inboundChannel;
        if (this.networkAccessPoint != null && !this.networkAccessPoint.equals(inboundChannel = request.getServerChannel().getChannelName())) {
            throw new SecurityException("Remote method calls are allowed only over NetworkAccessPoint '" + this.networkAccessPoint + "'");
        }
        remoteIndicator.set(true);
        Skeleton skeleton = this.getDescriptor().getSkeleton();
        if (md.getImplRespondsToClient()) {
            response = new BasicFutureResponse(request, response);
        }
        if (this.notificationListener != null) {
            this.notificationListener.notifyRemoteCallBegin();
        }
        try {
            EndPoint endPoint = request.getEndPoint();
            if (endPoint != null && endPoint instanceof LocalRemoteJVM) {
                ThreadPreferredHost.set(endPoint.getHostID());
                this.setUnTrustedClient(request, endPoint);
            }
            try {
                skeleton.invoke(md.getIndex(), request, response, this.implementation);
            }
            catch (OutOfMemoryError oome) {
                new Exception("how did we get here").printStackTrace();
                throw oome;
            }
        }
        finally {
            ThreadPreferredHost.set(null);
            remoteIndicator.set(false);
            unTrustedClient.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postInvoke(RuntimeMethodDescriptor md, InboundRequest request, OutboundResponse response, Throwable t) {
        try {
            try {
                if (this.getDescriptor().getDGCPolicy() == 4) {
                    this.unexportObject(true);
                }
            }
            catch (RemoteException re) {
                RMILogger.logUnexport(this.toString());
            }
            if (t != null) {
                throw t;
            }
            if (response != null && !md.getImplRespondsToClient()) {
                if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                    this.debugDisplayResponseInfo(md, request, response);
                }
                response.send();
            }
        }
        catch (Throwable th) {
            this.logThrowable(md, th);
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException interceptor) {
                    // empty catch block
                }
                try {
                    response = request.getOutboundResponse();
                    response.transferThreadLocalContext(request);
                }
                catch (IOException ioe) {
                    RMILogger.logAssociateTX(ioe);
                }
            }
            BasicServerRef.handleThrowable(th, response);
        }
        finally {
            for (ServerReferenceInterceptor interceptor : commonInterceptors) {
                if (!interceptor.isUnconditional()) continue;
                interceptor.postInvokeUnconditional(this, request, md);
            }
            for (ServerReferenceInterceptor interceptor : this.interceptors) {
                if (!interceptor.isUnconditional()) continue;
                interceptor.postInvokeUnconditional(this, request, md);
            }
            try {
                this.resetFutureObjectID(request);
            }
            catch (UnmarshalException re) {}
            if (this.notificationListener != null) {
                this.notificationListener.notifyRemoteCallEnd();
            }
        }
    }

    private void debugDisplayResponseInfo(RuntimeMethodDescriptor md, InboundRequest request, OutboundResponse response) throws IOException {
        int maxSize;
        int rspSize;
        if (response instanceof OutgoingMessage && (rspSize = ((OutgoingMessage)((Object)response)).getLength()) > (maxSize = request.getServerChannel().getMaxMessageSize())) {
            debugMessaging.debug("BasicServerRef.postInvoke response message size: " + rspSize + " for method '" + md + "' to sender: " + request.getEndPoint() + " max size: " + maxSize, new Throwable());
        }
    }

    private void logThrowable(RuntimeMethodDescriptor md, Throwable th) {
        if (th instanceof RuntimeException) {
            RMILogger.logRuntimeException(this.getMethodStr(md), th);
        } else if (th instanceof Error) {
            RMILogger.logError(this.getMethodStr(md), th);
        } else if (RMIEnvironment.getEnvironment().isLogRemoteExceptions()) {
            RMILogger.logException(this.getMethodStr(md), th);
        }
    }

    protected void setFutureObjectID(InboundRequest request, RuntimeMethodDescriptor md) throws UnmarshalException {
        try {
            Object obj = request.getContext(25);
            if (obj != null) {
                ((FutureResultHandle)this.implementation).__WL_setFutureResultID((FutureResultID)obj, kernelId);
            } else {
                Class<?> cls = md.getMethod().getReturnType();
                if (Future.class.isAssignableFrom(cls)) {
                    throw new UnmarshalException("Request received from client that is incompatible with WLS server " + VersionInfo.theOne().getReleaseVersion());
                }
            }
        }
        catch (IOException ioe) {
            throw new UnmarshalException("Unable to get FUTURE_OBJECT_ID from request. ", ioe);
        }
    }

    private void resetFutureObjectID(InboundRequest request) throws UnmarshalException {
        try {
            Object obj = request.getContext(25);
            if (obj != null) {
                ((FutureResultHandle)this.implementation).__WL_setFutureResultID(null, kernelId);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getMethodStr(RuntimeMethodDescriptor md) {
        if (this.implementationClassName == null) {
            return this.oid + "." + md;
        }
        return this.implementationClassName + "." + md;
    }

    private static final ServerError allocServerError() {
        OutOfMemoryError oome = new OutOfMemoryError();
        oome.setStackTrace(new StackTraceElement[0]);
        ServerError se = new ServerError("A error occurred the server", oome);
        se.setStackTrace(new StackTraceElement[0]);
        return se;
    }

    protected static void handleThrowable(Throwable t, OutboundResponse response) {
        if (response != null) {
            if (BasicServerRef.requireUnwrapRemoteException(t, response)) {
                response.sendThrowable(t.getCause());
            } else if (t instanceof OutOfMemoryError) {
                response.sendThrowable(PRE_ALLOC_SERVER_ERROR);
            } else if (t instanceof Error && !RMIEnvironment.getEnvironment().isIIOPResponse(response)) {
                response.sendThrowable(new ServerError("A error occurred the server", (Error)t));
            } else {
                response.sendThrowable(t);
            }
        }
        if (t instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
    }

    private static boolean requireUnwrapRemoteException(Throwable t, OutboundResponse response) {
        if (t instanceof RemoteEJBInvokeException && RMIEnvironment.getEnvironment().isIIOPResponse(response)) {
            return true;
        }
        return t instanceof RemoteExceptionWrapper;
    }

    @Override
    public final ClassLoader getApplicationClassLoader() {
        return this.classloader;
    }

    @Override
    public final Object getImplementation() {
        return this.implementation;
    }

    @Override
    public ComponentInvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    @Override
    public void setInvocationContext(ComponentInvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    @Override
    public final boolean unexportObject(boolean force) throws NoSuchObjectException {
        if (force) {
            return OIDManagerMaker.SINGLETON.removeServerReference(this) != null;
        }
        this.decrementRefCount();
        return true;
    }

    @Override
    public final boolean isExported() {
        return false;
    }

    @Override
    public RuntimeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public StubReference getStubReference() throws RemoteException {
        return new StubInfo(this.getLocalRef(), this.descriptor.getClientRuntimeDescriptor(this.getApplicationName()), this.descriptor.getStubClassName());
    }

    @Override
    public ServerReference getDelegate() {
        return this;
    }

    @Override
    public RemoteReference getRemoteRef() throws RemoteException {
        return this.descriptor.getRemoteReference(this.getObjectID(), this.getImplementation());
    }

    @Override
    public final RemoteReference getLocalRef() {
        CollocatedRemoteRef crr = new CollocatedRemoteRef(this);
        if (this.getDescriptor().getDGCPolicy() != 2) {
            DGCServerImpl.addPhantomRef(new PhantomRef(crr, DGCServerImpl.getReferenceQueue()));
        }
        return crr;
    }

    @Override
    public final void sweep(long expiredLease) {
        if (this.lease > expiredLease) {
            return;
        }
        if (this.refCount.get() > 0L) {
            return;
        }
        OIDManagerMaker.SINGLETON.removeServerReference(this);
        if (this.getImplementation() instanceof Unreferenced) {
            WorkManagerFactory.getInstance().getSystem().schedule(new UnreferencedExecuteRequest((Unreferenced)this.getImplementation()));
        }
    }

    @Override
    public final void incrementRefCount() {
        if (this.descriptor.getDGCPolicy() == 2) {
            return;
        }
        this.refCount.incrementAndGet();
    }

    @Override
    public final void decrementRefCount() {
        if (this.descriptor.getDGCPolicy() == 2) {
            return;
        }
        this.refCount.decrementAndGet();
    }

    @Override
    public final void renewLease() {
        switch (this.descriptor.getDGCPolicy()) {
            case -1: 
            case 0: 
            case 3: {
                this.lease = OIDManagerMaker.SINGLETON.getNewLease();
                return;
            }
            case 1: 
            case 2: 
            case 4: {
                return;
            }
        }
        throw new AssertionError((Object)("Unknown DGC Policy specified: " + this.descriptor.getDGCPolicy()));
    }

    public final String getImplementationClassName() {
        return this.implementationClassName;
    }

    @Override
    public final String getApplicationName() {
        return this.applicationName;
    }

    private boolean acceptRequest(InboundRequest request) {
        return RMIEnvironment.getEnvironment().rmiShutdownAcceptRequest(this.oid, (AuthenticatedSubject)request.getSubject()) && RMIEnvironment.getEnvironment().nonTxRmiShutdownAcceptRequest(this.oid, (AuthenticatedSubject)request.getSubject(), request.getTxContext());
    }

    private final boolean isBootstrapCall() {
        return this.getObjectID() == 27;
    }

    @Override
    public void dispatchError(InboundRequest request, Throwable t) {
        boolean hasNoOutboundResponse;
        try {
            hasNoOutboundResponse = request.getRuntimeMethodDescriptor(this.descriptor).isOneway();
        }
        catch (IOException ioe) {
            RMILogger.logException("Error getting runtimeMethodDescriptor for request: " + request, ioe);
            hasNoOutboundResponse = true;
        }
        if (hasNoOutboundResponse) {
            BasicServerRef.handleThrowable(t, null);
            RMILogger.logException("Logging error for request: " + request, t);
            return;
        }
        WorkManager wm = WorkManagerFactory.getInstance().getSystem();
        wm.schedule(new ErrorReporter(request, t));
    }

    private boolean isExportedForApplication() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while (cl instanceof GenericClassLoader) {
            GenericClassLoader gcl = (GenericClassLoader)cl;
            String appName = gcl.getAnnotation().getAnnotationString();
            if (appName != null && appName.length() != 0) {
                return true;
            }
            cl = gcl.getParent();
        }
        return false;
    }

    @Override
    public void dispatch(InboundRequest request) {
        this.dispatch(request, this);
    }

    protected void checkPriviledges(AuthenticatedSubject subject, ServerChannel channel, EndPoint endPoint) throws RemoteException {
        this.ensureAdministratorUsesAdminChannel(subject, channel, endPoint);
    }

    void setUnTrustedClient(InboundRequest request, EndPoint endPoint) {
        ServerChannel serverChannel = request.getServerChannel();
        HostID hostId = endPoint.getHostID();
        if (hostId == null || hostId.objectToString().isEmpty() && this.isAllowListEnabled(serverChannel)) {
            unTrustedClient.set(true);
        }
    }

    boolean isAllowListEnabled(ServerChannel serverChannel) {
        if (debugAllowList.isDebugEnabled()) {
            debugAllowList.debug("serverChannel.getAllowListViolationAction() " + serverChannel.getAllowListViolationAction());
        }
        return serverChannel.getAllowListViolationAction().equals("log") || serverChannel.getAllowListViolationAction().equals("deny");
    }

    static {
        wldfDyeInjectionInterceptor = new AtomicReference();
        debugDgcEnrollment = DebugLogger.getDebugLogger("DebugDGCEnrollment");
        debugMessaging = DebugLogger.getDebugLogger("DebugMessaging");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        remoteIndicator = AuditableThreadLocalFactory.createThreadLocal(new ThreadLocalInitialValue(){

            @Override
            protected Object initialValue() {
                return false;
            }
        });
        unTrustedClient = AuditableThreadLocalFactory.createThreadLocal(new ThreadLocalInitialValue(){

            @Override
            protected Object initialValue() {
                return Boolean.FALSE;
            }
        });
        debugAllowList = DebugLogger.getDebugLogger("DebugAllowList");
        ArrayList<ServerReferenceInterceptor> ci = new ArrayList<ServerReferenceInterceptor>();
        ci.add(CertificateValidationInterceptor.INSTANCE);
        ci.add(ClientInfoInterceptor.INSTANCE);
        ci.add(OneWayMethodInterceptor.INSTANCE);
        commonInterceptors = new CopyOnWriteArrayList<ServerReferenceInterceptor>(ci);
        PRE_ALLOC_SERVER_ERROR = BasicServerRef.allocServerError();
    }

    private static class ErrorReporter
    implements Runnable {
        InboundRequest request;
        Throwable problem;

        ErrorReporter(InboundRequest request, Throwable problem) {
            this.request = request;
            this.problem = problem;
        }

        @Override
        public void run() {
            try {
                Interceptor ti = InterceptorManager.getManager().getTransactionInterceptor();
                if (ti != null) {
                    ti.dispatchRequest(this.request.getTxContext());
                }
                OutboundResponse response = this.request.getOutboundResponse();
                response.transferThreadLocalContext(this.request);
                BasicServerRef.handleThrowable(this.problem, response);
            }
            catch (IOException e) {
                RMILogger.logException("Unable to send error response to client", e);
            }
        }

        public final String toString() {
            return super.toString() + " - problem: '" + this.problem + "'";
        }
    }

    private static final class UnreferencedExecuteRequest
    extends WorkAdapter {
        final Unreferenced unrefed;

        UnreferencedExecuteRequest(Unreferenced unrefed) {
            this.unrefed = unrefed;
        }

        @Override
        public void run() {
            this.unrefed.unreferenced();
        }
    }

    private static final class OIDManagerMaker {
        private static final OIDManager SINGLETON = OIDManager.getInstance();

        private OIDManagerMaker() {
        }
    }
}

