/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions.server;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import javax.naming.Context;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import org.jvnet.hk2.annotations.Service;
import weblogic.core.base.api.FastThreadLocalMarker;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.ClientServerURL;
import weblogic.rmi.cluster.BasicReplicaHandler;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.rmi.extensions.server.ClusterAwareRemoteReference;
import weblogic.rmi.extensions.server.CollocatedRemoteReference;
import weblogic.rmi.extensions.server.DescriptorHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.CBVWrapper;
import weblogic.rmi.internal.ClientMethodDescriptor;
import weblogic.rmi.internal.DescriptorManager;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RedeployableRef;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.Source;

@Service
public final class ServerHelper
extends RemoteHelper
implements FastThreadLocalMarker {
    private static final boolean DEBUG_EXPORT_OBJECT = !KernelStatus.isApplet() && Boolean.getBoolean("weblogic.rmi.extensions.server.ServerHelper.DebugExportObject");
    private static final DebugLogger debugServerHelper = DebugLogger.getDebugLogger("ServerHelper");
    private static AuditableThreadLocal clientInfo = AuditableThreadLocalFactory.createThreadLocal(new ClientInfo());
    private static String wlsStubVersion = null;

    protected ServerHelper() {
    }

    public static String getWlsStubVersion() {
        if (wlsStubVersion == null) {
            wlsStubVersion = RMIEnvironment.getEnvironment().getStubVersion();
        }
        return wlsStubVersion;
    }

    private static ClientInfo getClientInfo() {
        return (ClientInfo)clientInfo.get();
    }

    public static void setClientInfo(EndPoint endPoint, ServerChannel channel) {
        ClientInfo cinfo = ServerHelper.getClientInfo();
        cinfo.endPoint = endPoint;
        cinfo.serverChannel = channel;
    }

    public static void setServerChannel(ServerChannel channel) {
        ClientInfo cinfo = ServerHelper.getClientInfo();
        cinfo.serverChannel = channel;
    }

    public static EndPoint getClientEndPoint() throws ServerNotActiveException {
        EndPoint endPoint = ServerHelper.getClientInfo().endPoint;
        if (endPoint != null) {
            return endPoint;
        }
        throw new ServerNotActiveException();
    }

    public static String getClientAddress() {
        ClientInfo clientInfo = ServerHelper.getClientInfo();
        if (clientInfo == null) {
            return null;
        }
        InetAddress inetAddress = clientInfo.getInetAddress();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.toString();
    }

    public static EndPoint getClientEndPointInternal() {
        return ServerHelper.getClientInfo().endPoint;
    }

    public static ServerChannel getServerChannel() {
        return ServerHelper.getClientInfo().serverChannel;
    }

    public static boolean unexportObject(Remote impl, boolean force) throws NoSuchObjectException {
        return ServerHelper.unexportObject(impl, force, false);
    }

    public static boolean unexportObject(Object o, boolean force, boolean removeDescriptor) throws NoSuchObjectException {
        ServerReference sRef;
        Object object = o;
        if (o instanceof RemoteWrapper) {
            RemoteWrapper wrapper = (RemoteWrapper)o;
            object = wrapper.getRemoteDelegate();
        }
        if ((sRef = OIDManager.getInstance().getServerReference(object)) == null) {
            return false;
        }
        if (sRef.getImplementation() != object) {
            return false;
        }
        boolean success = sRef.unexportObject(force);
        if (removeDescriptor) {
            DescriptorManager.removeDescriptor(sRef.getImplementation().getClass());
        }
        return success;
    }

    public static boolean unexportObject(Activator activator) throws NoSuchObjectException {
        return OIDManager.getInstance().removeServerReference(activator) != null;
    }

    public static RuntimeDescriptor getDescriptor(Remote remote) throws NoSuchObjectException {
        ServerReference sref = ServerHelper.getServerReference(remote);
        return sref == null ? null : sref.getDescriptor();
    }

    public static ServerReference getServerReference(Remote remote) throws NoSuchObjectException {
        if (!RemoteHelper.isCollocated(remote)) {
            throw new AssertionError((Object)("getServerReference only works for colocated objects, trying with  " + remote));
        }
        if (remote instanceof StubInfoIntf) {
            RemoteReference ref = ((StubInfoIntf)((Object)remote)).getStubInfo().getRemoteRef();
            return OIDManager.getInstance().getServerReference(ref.getObjectID());
        }
        return OIDManager.getInstance().getServerReference(remote);
    }

    public static int getObjectId(Remote object) throws NoSuchObjectException {
        return ServerHelper.getServerReference(object).getObjectID();
    }

    public static void unexportObject(int oid) throws NoSuchObjectException {
        ServerReference serverRef = OIDManager.getInstance().getServerReference(oid);
        if (serverRef != null) {
            OIDManager.getInstance().removeServerReference(serverRef);
        }
    }

    public static Remote exportObject(Remote o) throws RemoteException {
        try {
            Object obj = RemoteObjectReplacer.getReplacer().replaceObject(o);
            if (obj instanceof StubInfo) {
                StubInfo info = (StubInfo)obj;
                info.getDescriptor().intern();
                return (Remote)StubFactory.getStub(info);
            }
            return (Remote)obj;
        }
        catch (IOException e) {
            throw new RemoteException("Failed to export " + o.getClass(), e);
        }
    }

    public static Remote exportObject(Remote o, int timeout) throws RemoteException {
        try {
            Object obj = RemoteObjectReplacer.getReplacer().replaceObject(o);
            if (obj instanceof StubInfo) {
                StubInfo info = (StubInfo)obj;
                ClientMethodDescriptor defaultMethodDescriptor = info.getDefaultClientMethodDescriptor();
                if (defaultMethodDescriptor == null) {
                    defaultMethodDescriptor = new ClientMethodDescriptor("*", false, false, false, false, timeout);
                    info.setDefaultClientMethodDescriptor(defaultMethodDescriptor);
                } else {
                    defaultMethodDescriptor.setTimeOut(timeout);
                }
                info.getDescriptor().intern();
                return (Remote)StubFactory.getStub(info);
            }
            return (Remote)obj;
        }
        catch (IOException e) {
            throw new RemoteException("Failed to export " + o.getClass(), e);
        }
    }

    public static Remote exportObjectWithPeerReplacement(Remote o) throws RemoteException {
        try {
            Object obj = RemoteObjectReplacer.getReplacer().replaceObject(o);
            if (obj instanceof StubInfo) {
                return (Remote)StubFactory.getStub(((StubInfo)obj).getReplaceableInfo());
            }
            return (Remote)obj;
        }
        catch (IOException e) {
            throw new RemoteException("Failed to export " + o.getClass(), e);
        }
    }

    public static Object getStubWithPinnedRef(Remote o, String url) throws RemoteException {
        if (o == null || url == null) {
            return o;
        }
        EndPoint hostVM = null;
        ClusterAwareRemoteReference ref = null;
        Remote object = ServerHelper.exportObject(o);
        if (object != null && object instanceof StubInfoIntf) {
            StubInfoIntf stub = (StubInfoIntf)((Object)object);
            try {
                ref = (ClusterAwareRemoteReference)stub.getStubInfo().getRemoteRef();
                hostVM = new ClientServerURL(url).findOrCreateRJVM();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ref == null || hostVM == null || hostVM.isDead()) {
                return null;
            }
            if (ref.pin(hostVM.getID())) {
                return stub;
            }
            return null;
        }
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Remote exportObject(Remote o, String jndiName) throws RemoteException {
        RuntimeDescriptor rtd;
        StubInfoIntf stub = (StubInfoIntf)((Object)ServerHelper.exportObject(o));
        if (DEBUG_EXPORT_OBJECT && !RemoteHelper.isCollocated(o)) {
            debugServerHelper.debug("**** Attempting to export a remote object that is not collocated:" + jndiName + ':' + o);
        }
        if ((rtd = ServerHelper.getDescriptor(o)) == null) return (Remote)((Object)stub);
        if (!rtd.isClusterable()) throw new AssertionError((Object)("Cannot export non clusterable object with jndiName:" + o + ':' + jndiName));
        ClusterAwareRemoteReference rref = null;
        RemoteReference ref = stub.getStubInfo().getRemoteRef();
        if (ref instanceof CollocatedRemoteReference) {
            try {
                Object obj = RemoteObjectReplacer.getReplacer().replaceObject(ref);
                Debug.assertion(obj instanceof ClusterAwareRemoteReference);
                rref = (ClusterAwareRemoteReference)obj;
            }
            catch (IOException ioe) {
                throw new RemoteException("Unexpected exception", ioe);
            }
        } else {
            rref = (ClusterAwareRemoteReference)ref;
        }
        ServerReference serverReference = ServerHelper.getServerReference(o);
        if (serverReference == null) return (Remote)((Object)stub);
        try {
            rref.initialize(serverReference, jndiName);
            return (Remote)((Object)stub);
        }
        catch (RuntimeException re) {
            if (re.getCause() == null || !(re.getCause() instanceof NoSuchObjectException)) throw re;
            if (!DEBUG_EXPORT_OBJECT) return (Remote)((Object)stub);
            debugServerHelper.debug("**** Attempting to export a remote object that is being unexported. " + jndiName);
            return (Remote)((Object)stub);
        }
    }

    public static void exportObject(Class c, Activator activator) throws RemoteException {
        OIDManager.getInstance().makeActivatableServerReference(c, activator).exportObject();
    }

    public static RuntimeDescriptor getRuntimeDescriptor(Class c) throws RemoteException {
        return DescriptorManager.getDescriptor(c);
    }

    public static Object getCBVWrapperObject(Object obj) throws RemoteException {
        return CBVWrapper.getCBVWrapper(ServerHelper.getRuntimeDescriptor(obj.getClass()), obj);
    }

    public static Object getRedeployableStub(Object obj, Context context, String jndiName) throws RemoteException {
        StubReference stubInfo = null;
        stubInfo = obj instanceof Remote ? OIDManager.getInstance().getReplacement(obj) : (StubReference)obj;
        RemoteReference ref = stubInfo.getRemoteRef();
        RedeployableRef deployRef = new RedeployableRef(ref, context, jndiName);
        ((StubInfo)stubInfo).setRemoteRef(deployRef);
        return StubFactory.getStub(stubInfo);
    }

    public static RemoteReference getLocalRef(int oid) throws NoSuchObjectException {
        return OIDManager.getInstance().getServerReference(oid).getLocalRef();
    }

    public static Object getRemoteObject(int oid) throws NoSuchObjectException {
        return OIDManager.getInstance().getServerReference(oid).getImplementation();
    }

    public static Object replaceAndResolveRemoteObject(Remote remote) throws RemoteException, IOException {
        StubReference replaced = (StubReference)RemoteObjectReplacer.getReplacer().replaceObject(remote);
        return RemoteObjectReplacer.resolveStubInfo(replaced);
    }

    public static final Source getRuntimeDescriptorSource(int oid) throws IOException {
        ServerReference sRef = OIDManager.getInstance().findServerReference(oid);
        if (sRef != null) {
            return sRef.getDescriptor().getRuntimeDescriptorSource();
        }
        return null;
    }

    public static boolean isClusterable(Remote remote) {
        if (remote instanceof Proxy) {
            return false;
        }
        if (remote instanceof StubInfoIntf) {
            StubInfoIntf stub = (StubInfoIntf)((Object)remote);
            return stub.getStubInfo().getRemoteRef() instanceof ClusterAwareRemoteReference;
        }
        try {
            RuntimeDescriptor desc = DescriptorHelper.getDescriptor(remote.getClass());
            return desc.isClusterable();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public static void ensureJNDIName(Object object, String jndiName) {
        ClusterableRemoteRef ref;
        StubInfoIntf stub;
        Remote remote;
        if (jndiName == null || object == null) {
            return;
        }
        if (object instanceof RemoteWrapper) {
            object = ((RemoteWrapper)object).getRemoteDelegate();
        }
        if (object instanceof Remote && (remote = (Remote)object) instanceof StubInfoIntf && (stub = (StubInfoIntf)((Object)remote)).getStubInfo().getRemoteRef() instanceof ClusterableRemoteRef && (ref = (ClusterableRemoteRef)stub.getStubInfo().getRemoteRef()).getReplicaHandler() instanceof BasicReplicaHandler) {
            BasicReplicaHandler handler = (BasicReplicaHandler)ref.getReplicaHandler();
            handler.setJNDIName(jndiName);
        }
    }

    public static Remote getLocalInitialReference(Class implClass) throws RemoteException {
        return (Remote)OIDManager.getInstance().getServerReference(DescriptorManager.getDescriptor(implClass).getInitialReference()).getImplementation();
    }

    public static boolean isIIOPStub(Remote remote) {
        if (remote instanceof StubInfoIntf) {
            StubInfoIntf stub = (StubInfoIntf)((Object)remote);
            return stub.getStubInfo().getStubName().toLowerCase().contains("_iiop_wlstub");
        }
        return false;
    }

    public static boolean isWLSStub(Remote remote) {
        if (remote instanceof StubInfoIntf) {
            StubInfoIntf stub = (StubInfoIntf)((Object)remote);
            return stub.getStubInfo().getStubName().contains(RMIEnvironment.getEnvironment().getStubVersion());
        }
        return false;
    }

    public static boolean isLocal(Remote remote) {
        if (remote instanceof StubInfoIntf) {
            StubInfoIntf stub = (StubInfoIntf)((Object)remote);
            return stub.getStubInfo().getRemoteRef().getHostID().isLocal();
        }
        if (remote instanceof Stub) {
            try {
                return Util.isLocal((Stub)((Object)remote));
            }
            catch (RemoteException re) {
                return false;
            }
        }
        return true;
    }

    public static String getStubClassName(String className) {
        return className + ServerHelper.getWlsStubVersion();
    }

    public static boolean isURLValid(String url) {
        try {
            new ClientServerURL(url);
        }
        catch (MalformedURLException mfue) {
            return false;
        }
        return true;
    }

    public static void removeRuntimeDescriptor(Class c) {
        DescriptorManager.removeDescriptor(c);
    }

    public static int getTransactionTimeoutMillis() {
        if (KernelStatus.isServer()) {
            return RMIEnvironment.getEnvironment().getTransactionTimeoutMillis();
        }
        return 0;
    }

    @Override
    public String getFastThreadLocalClassName() {
        return this.getClass().getCanonicalName();
    }

    private static final class ClientInfo
    extends ThreadLocalInitialValue {
        private EndPoint endPoint;
        private ServerChannel serverChannel;
        private Channel oldRemoteChannel;

        private ClientInfo() {
            super(true);
        }

        @Override
        protected final Object initialValue() {
            return new ClientInfo();
        }

        @Override
        protected final Object resetValue(Object currentValue) {
            EndPoint endPoint;
            ClientInfo cli = (ClientInfo)currentValue;
            if (cli.oldRemoteChannel == null && (endPoint = cli.endPoint) != null) {
                cli.oldRemoteChannel = endPoint.getRemoteChannel();
            }
            cli.endPoint = null;
            cli.serverChannel = null;
            return cli;
        }

        @Override
        protected final Object childValue(Object parentValue) {
            ClientInfo parent = (ClientInfo)parentValue;
            ClientInfo child = new ClientInfo();
            child.endPoint = parent.endPoint;
            child.serverChannel = parent.serverChannel;
            child.oldRemoteChannel = parent.oldRemoteChannel;
            return child;
        }

        protected final InetAddress getInetAddress() {
            Channel channel;
            EndPoint currentEndPoint = this.endPoint;
            if (currentEndPoint != null && (channel = currentEndPoint.getRemoteChannel()) != null) {
                return channel.getInetAddress();
            }
            if (this.oldRemoteChannel == null) {
                return null;
            }
            return this.oldRemoteChannel.getInetAddress();
        }
    }
}

