/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions.server;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;
import weblogic.rmi.internal.DescriptorConstants;
import weblogic.rmi.internal.GenericMethodDescriptor;
import weblogic.rmi.internal.MethodDescriptor;
import weblogic.utils.collections.ArrayMap;
import weblogic.utils.reflect.MethodSignatureBuilder;

final class RMIDDParser
implements DescriptorConstants {
    private static final boolean debug = false;
    private static final String RMI = "rmi";
    private static final Set<String> dgcPolicies = new HashSet<String>();
    private static final Set<String> securityOptions = new HashSet<String>();
    private static final Set<String> loadAlgorithms = new HashSet<String>();
    private static final Set<String> clusterDescriptorElements = new HashSet<String>();
    private static final Set<String> lifecycleDescriptorElements = new HashSet<String>();
    private static final Set<String> rmiDescriptorElements = new HashSet<String>();
    private static final Set<String> rmiDescriptorSkipElements = new HashSet<String>();
    private static final Set<String> methodDescriptorElements = new HashSet<String>();
    private static final Set<String> securityDescriptorElements = new HashSet<String>();
    private static final String CLUSTER = "cluster";
    private static final String SECURITY = "security";
    private static final String LIFECYCLE = "lifecycle";
    private static final String METHOD = "method";
    private ArrayMap securityDescriptorMap;
    private ArrayMap methodDescriptorsMap;
    private ArrayMap clusterDescriptorMap;
    private ArrayMap lifecycleDescriptorMap;
    private ArrayMap rmiDescriptorMap;
    private int count;
    private boolean isDTD = false;
    private static final XMLInputFactory factory;
    private InputStream inputStream;
    private XMLStreamReader parser;
    private static boolean validatingParser;

    public RMIDDParser(InputStream stream) {
        this.inputStream = stream;
    }

    public ArrayMap getDescriptorAsMap() throws XMLStreamException {
        this.parser = factory.createXMLStreamReader(this.inputStream);
        try {
            this.parse();
        }
        finally {
            try {
                this.parser.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        return this.getParsedDescriptorMap();
    }

    private ArrayMap getParsedDescriptorMap() {
        ArrayMap<String, ArrayMap> rtdDescriptorMap = new ArrayMap<String, ArrayMap>();
        if (this.rmiDescriptorMap != null && !this.rmiDescriptorMap.isEmpty()) {
            rtdDescriptorMap.put("rmidescriptor", this.rmiDescriptorMap);
        }
        if (this.methodDescriptorsMap != null && !this.methodDescriptorsMap.isEmpty()) {
            rtdDescriptorMap.put("methoddescriptor", this.methodDescriptorsMap);
        }
        if (this.clusterDescriptorMap != null && !this.clusterDescriptorMap.isEmpty()) {
            rtdDescriptorMap.put("clusterdescriptor", this.clusterDescriptorMap);
        }
        if (this.lifecycleDescriptorMap != null && !this.lifecycleDescriptorMap.isEmpty()) {
            rtdDescriptorMap.put("lifecycledescriptor", this.lifecycleDescriptorMap);
        }
        if (this.securityDescriptorMap != null && !this.securityDescriptorMap.isEmpty()) {
            rtdDescriptorMap.put("securitydescriptor", this.securityDescriptorMap);
        }
        return rtdDescriptorMap;
    }

    private void parse() throws XMLStreamException {
        int event = this.parser.getEventType();
        while (true) {
            switch (event) {
                case 7: {
                    break;
                }
                case 6: {
                    break;
                }
                case 1: {
                    this.parseElement();
                    break;
                }
                case 4: {
                    if (!this.parser.isWhiteSpace()) break;
                    break;
                }
                case 2: {
                    break;
                }
                case 8: {
                    break;
                }
                case 11: {
                    this.isDTD = true;
                }
            }
            if (!this.parser.hasNext()) break;
            event = this.parser.next();
        }
        this.isDTD = false;
    }

    private void parseElement() throws XMLStreamException {
        String name = this.parser.getName().getLocalPart();
        if (this.count == 0 && !RMI.equals(name)) {
            throw new XMLStreamException("RMI Runtime Documents must be enclosed by a single <rmi></rmi> element");
        }
        if (name.equals(RMI)) {
            ++this.count;
            this.parseRMIAttributes();
        } else if (name.equals(CLUSTER)) {
            this.parseCluster();
        } else if (name.equals(LIFECYCLE)) {
            this.parseLifecycle();
        } else if (name.equals(METHOD)) {
            this.parseMethod();
        } else if (name.equals(SECURITY)) {
            this.parseSecurity();
        } else {
            throw new XMLStreamException("An RMI Runtime document must match the following pattern: rmi (cluster?, lifecycle?, method*, eos?, security?), the element " + name + " was not expected in this context");
        }
    }

    private void parseSecurity() throws XMLStreamException {
        this.securityDescriptorMap = new ArrayMap();
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (validatingParser && !this.parser.isAttributeSpecified(i)) continue;
            String name = this.parser.getAttributeName(i).getLocalPart();
            String value = this.parser.getAttributeValue(i);
            if (securityDescriptorElements.contains(name) && securityOptions.contains(value)) {
                this.securityDescriptorMap.put(name, value);
                continue;
            }
            throw new XMLStreamException("The <security> element is allowed to have the following attributes: confidentiality, integrity, client-authentication, client-cert-authentication, identity-assertion");
        }
    }

    private void parseMethod() throws XMLStreamException {
        if (this.methodDescriptorsMap == null) {
            this.methodDescriptorsMap = new ArrayMap();
        }
        String key = null;
        ArrayMap<String, String> h = new ArrayMap<String, String>();
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (validatingParser && !this.parser.isAttributeSpecified(i)) continue;
            String name = this.parser.getAttributeName(i).getLocalPart();
            String value = this.parser.getAttributeValue(i);
            if (name.equals("name")) {
                try {
                    key = MethodSignatureBuilder.compute(value);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    if (MethodDescriptor.isGenericMethodSignatureModeEnabled()) {
                        key = GenericMethodDescriptor.computeGenericMethodSignature(value);
                        continue;
                    }
                    throw new XMLStreamException("Found invalid method signature '" + value + "'", iae);
                }
            }
            if (methodDescriptorElements.contains(name)) {
                h.put(name, value);
                continue;
            }
            throw new XMLStreamException("The <method> element is allowed to have the following attributes: name,future,dispatch-context,dispatch-policy,transactional,requires-transaction,oneway,oneway-transactional-request,oneway-transactional-response,timeout,idempotent,asynchronous,remote-exception-wrapper-classname");
        }
        if (key != null) {
            this.methodDescriptorsMap.put(key, h);
        }
    }

    private void parseLifecycle() throws XMLStreamException {
        this.lifecycleDescriptorMap = new ArrayMap();
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (validatingParser && !this.parser.isAttributeSpecified(i)) continue;
            String name = this.parser.getAttributeName(i).getLocalPart();
            String value = this.parser.getAttributeValue(i);
            if (lifecycleDescriptorElements.contains(name)) {
                this.lifecycleDescriptorMap.put(name, value);
                continue;
            }
            throw new XMLStreamException("The <lifecyle> element is allowed to have the following attributes: dgc-policy,activation-identifier-classname");
        }
    }

    private void parseCluster() throws XMLStreamException {
        this.clusterDescriptorMap = new ArrayMap();
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (validatingParser && !this.parser.isAttributeSpecified(i)) continue;
            String name = this.parser.getAttributeName(i).getLocalPart();
            String value = this.parser.getAttributeValue(i);
            if (clusterDescriptorElements.contains(name)) {
                this.clusterDescriptorMap.put(name, value);
                continue;
            }
            throw new XMLStreamException("The <cluster> element is allowed to have the following attributes: clusterable,load-algorithm,replica-handler-classname,call-router-classname,stick-to-first-server,propagate-environment");
        }
    }

    private void parseRMIAttributes() throws XMLStreamException {
        this.rmiDescriptorMap = new ArrayMap();
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (validatingParser && !this.parser.isAttributeSpecified(i)) continue;
            String name = this.parser.getAttributeName(i).getLocalPart();
            String value = this.parser.getAttributeValue(i);
            if (rmiDescriptorElements.contains(name)) {
                this.rmiDescriptorMap.put(name, value);
                continue;
            }
            if (rmiDescriptorSkipElements.contains(name)) continue;
            throw new XMLStreamException("The <rmi> element is allowed to have the following attributes: name , use-server-side-stubs, enable-call-by-reference, remote-ref-classname, server-ref-classname, initial-reference " + name);
        }
    }

    static {
        loadAlgorithms.add("random");
        loadAlgorithms.add("round-robin");
        loadAlgorithms.add("weight-based");
        loadAlgorithms.add("server-affinity");
        loadAlgorithms.add("round-robin-affinity");
        loadAlgorithms.add("random-affinity");
        loadAlgorithms.add("weight-based-affinity");
        loadAlgorithms.add("default");
        dgcPolicies.add("leased");
        dgcPolicies.add("referenceCounted");
        dgcPolicies.add("managed");
        dgcPolicies.add("useItOrLoseIt");
        dgcPolicies.add("deactivateOnMethodBoundaries");
        securityOptions.add("none");
        securityOptions.add("supported");
        securityOptions.add("required");
        securityOptions.add("config");
        clusterDescriptorElements.add("clusterable");
        clusterDescriptorElements.add("replica-handler-classname");
        clusterDescriptorElements.add("call-router-classname");
        clusterDescriptorElements.add("propagate-environment");
        clusterDescriptorElements.add("load-algorithm");
        clusterDescriptorElements.add("stick-to-first-server");
        lifecycleDescriptorElements.add("dgc-policy");
        lifecycleDescriptorElements.add("activation-identifier-classname");
        rmiDescriptorElements.add("use-server-side-stubs");
        rmiDescriptorElements.add("remote-ref-classname");
        rmiDescriptorElements.add("server-ref-classname");
        rmiDescriptorElements.add("name");
        rmiDescriptorElements.add("initial-reference");
        rmiDescriptorElements.add("enable-call-by-reference");
        rmiDescriptorElements.add("network-access-point");
        rmiDescriptorSkipElements.add("schemaLocation");
        rmiDescriptorSkipElements.add("version");
        methodDescriptorElements.add("future");
        methodDescriptorElements.add("timeout");
        methodDescriptorElements.add("idempotent");
        methodDescriptorElements.add("oneway-transactional-request");
        methodDescriptorElements.add("oneway-transactional-response");
        methodDescriptorElements.add("dispatch-context");
        methodDescriptorElements.add("requires-transaction");
        methodDescriptorElements.add("transactional");
        methodDescriptorElements.add("dispatch-policy");
        methodDescriptorElements.add("oneway");
        methodDescriptorElements.add("asynchronous");
        methodDescriptorElements.add("remote-exception-wrapper-classname");
        securityDescriptorElements.add("confidentiality");
        securityDescriptorElements.add("client-cert-authentication");
        securityDescriptorElements.add("client-authentication");
        securityDescriptorElements.add("identity-assertion");
        securityDescriptorElements.add("integrity");
        validatingParser = false;
        factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try {
            Class.forName("com.ctc.wstx.stax.WstxInputFactory");
            validatingParser = true;
        }
        catch (Throwable t) {
            try {
                Class.forName("org.codehaus.stax2.XMLInputFactory2");
                validatingParser = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        factory.setXMLResolver(new DefaultRMIEntityResolver());
    }

    private static class DefaultRMIEntityResolver
    implements XMLResolver {
        private DefaultRMIEntityResolver() {
        }

        @Override
        public Object resolveEntity(String publicID, final String systemID, String baseURI, String namespace) throws XMLStreamException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (systemID != null && systemID.equals("rmi.dtd")) {
                            InputStream in = this.getClass().getClassLoader().getResourceAsStream("weblogic/rmi/internal/rmi.dtd");
                            if (in != null) {
                                return new InputSource(in).getByteStream();
                            }
                        } else {
                            InputStream in = this.getClass().getClassLoader().getResourceAsStream("weblogic/rmi/internal/rmi.xsd");
                            if (in != null) {
                                return new InputSource(in).getByteStream();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof XMLStreamException) {
                    throw (XMLStreamException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }
}

