/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.ClientMethodDescriptor;
import weblogic.rmi.internal.ClientRuntimeDescriptor;
import weblogic.rmi.internal.DescriptorManager;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.StubGenerator;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.spi.HostID;

public final class StubFactory {
    private static final Class[] STUB_CON_PARAMS = new Class[]{StubInfo.class};
    private static final ClientMethodDescriptor cmd = new ClientMethodDescriptor("*", false, false, false, false, 0);

    public static Object getStub(String[] interf, RemoteReference ror, String stubName) {
        ClientRuntimeDescriptor crd = new ClientRuntimeDescriptor(interf, null, null, null, stubName, ror.getCodebase()).intern();
        StubInfo info = new StubInfo(ror, crd, stubName);
        return StubGenerator.generateStub(info);
    }

    public static Object getNonTransactionalStub(String[] interf, RemoteReference ror, String stubName) {
        return StubGenerator.generateStub(StubFactory.getNonTransactionalStubInfo(interf, ror, stubName));
    }

    public static StubInfo getNonTransactionalStubInfo(String[] interf, RemoteReference ror, String stubName) {
        return new StubInfo(ror, new ClientRuntimeDescriptor(interf, null, null, cmd, stubName), stubName);
    }

    public static Object getStub(RemoteReference ror, String stubName, ClientRuntimeDescriptor crd) {
        StubInfo info = new StubInfo(ror, crd, stubName);
        return StubGenerator.generateStub(info);
    }

    public static Object getStub(Remote r) {
        Object stub = r;
        StubInfo info = null;
        try {
            info = (StubInfo)OIDManager.getInstance().getReplacement(r);
            info.getDescriptor().setStubName(info.getStubName());
            info.getDescriptor().intern();
            stub = StubGenerator.generateStub(info);
        }
        catch (Exception e) {
            throw new AssertionError("Failed to generate stub for " + r, e);
        }
        return stub;
    }

    public static Object getStub(StubReference info) {
        if (KernelStatus.isApplet()) {
            return StubFactory.loadClassOverNetwork(info);
        }
        return StubGenerator.generateStub(info);
    }

    private static Object loadClassOverNetwork(StubReference info) {
        String stubName = info.getStubName();
        Class<?> stubCls = null;
        try {
            stubCls = Class.forName(stubName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            ClassLoader cl;
            if (stubCls == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                stubCls = cl.loadClass(stubName);
            }
            if (stubCls == null) {
                throw new ClassNotFoundException("Failed to load class " + stubName);
            }
            Constructor<?> con = stubCls.getConstructor(StubInfo.class);
            return con.newInstance(info);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError("Failed to load with ClassNotFoundException " + stubName, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError("Failed to find default constructor " + stubName, nsme);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError("Failed with IllegalAccessException " + stubName, iae);
        }
        catch (InvocationTargetException ite) {
            throw new AssertionError("Failed with invocation target exception " + stubName, ite);
        }
        catch (InstantiationException ie) {
            throw new AssertionError("Failed to instantiate " + stubName, ie);
        }
    }

    public static Object getStub(Class implClass, HostID hostID, String serverChannel) throws RemoteException {
        return StubFactory.getStub(implClass, hostID, serverChannel, null);
    }

    public static Object getStub(Class implClass, HostID hostID, String serverChannel, ClientRuntimeDescriptor crd) throws RemoteException {
        if (hostID.isLocal()) {
            return ServerHelper.getLocalInitialReference(implClass);
        }
        try {
            RuntimeDescriptor desc = DescriptorManager.getDescriptor(implClass);
            Class<?> c = Class.forName(desc.getStubClassName());
            BasicRemoteRef ref = new BasicRemoteRef(desc.getInitialReference(), hostID, serverChannel);
            if (crd == null) {
                crd = desc.getClientRuntimeDescriptor(null);
            }
            Constructor<?> cc = c.getConstructor(STUB_CON_PARAMS);
            return cc.newInstance(new StubInfo(ref, crd, desc.getStubClassName()));
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError("Failed to load stub for class " + implClass, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError("Unexpected exception looking up constructor " + implClass, nsme);
        }
        catch (InstantiationException ie) {
            throw new AssertionError("Failed to instantiate stub for class " + implClass, ie);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError("Failed with IllegalAccessException try to  create stub for " + implClass, iae);
        }
        catch (InvocationTargetException ite) {
            throw new AssertionError("Failed with InvocationTargetException try  to create stub for " + implClass, ite);
        }
    }

    public static Object getStub(Class implClass, HostID hostID) {
        try {
            return StubFactory.getStub(implClass, hostID, null);
        }
        catch (RemoteException re) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)("Failed to generate stub for " + implClass)))).initCause(re);
        }
    }

    public static Object getStubWithTimeout(Class implClass, HostID hostID, String serverChannel, long timeout) throws RemoteException {
        if (hostID.isLocal()) {
            return ServerHelper.getLocalInitialReference(implClass);
        }
        RuntimeDescriptor desc = DescriptorManager.getDescriptor(implClass);
        BasicRemoteRef ref = new BasicRemoteRef(desc.getInitialReference(), hostID, serverChannel);
        ClientRuntimeDescriptor crd = desc.getClientRuntimeDescriptor(null);
        StubInfo info = new StubInfo(ref, crd, desc.getStubClassName());
        info.setJndiSpecifiedTimeout((int)timeout);
        return StubGenerator.generateStub(info, Thread.currentThread().getContextClassLoader());
    }
}

