/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.rmi.extensions.server.ReferenceHelper;

public final class PortableRemoteObject {
    private static AuditableThreadLocal recursive = AuditableThreadLocalFactory.createThreadLocal();

    public static void exportObject(Remote obj) throws RemoteException {
        if (obj == null) {
            throw new NullPointerException("Invalid argument");
        }
        if (ReferenceHelper.exists()) {
            ReferenceHelper.getReferenceHelper().exportObject(obj);
        }
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            throw new NullPointerException("Invalid argument");
        }
        return ReferenceHelper.exists() ? ReferenceHelper.getReferenceHelper().toStub(obj) : obj;
    }

    public static void unexportObject(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            throw new NullPointerException("Invalid argument");
        }
        if (ReferenceHelper.exists()) {
            ReferenceHelper.getReferenceHelper().unexportObject(obj);
        }
    }

    public static Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        if (narrowFrom == null || narrowTo == null) {
            throw new NullPointerException("narrowFrom'" + narrowFrom + '\'' + " \tnarrowTo:" + '\'' + narrowTo + "'It is invalid to call narrow with null parameters");
        }
        if (!ReferenceHelper.exists()) {
            if (narrowTo.isInstance(narrowFrom)) {
                return narrowFrom;
            }
            PortableRemoteObject.checkAndSetRecursive(narrowFrom, narrowTo);
            try {
                Object object = javax.rmi.PortableRemoteObject.narrow(narrowFrom, narrowTo);
                return object;
            }
            finally {
                PortableRemoteObject.clearRecursive();
            }
        }
        PortableRemoteObject.checkAndSetRecursive(narrowFrom, narrowTo);
        try {
            Object object = ReferenceHelper.getReferenceHelper().narrow(narrowFrom, narrowTo);
            return object;
        }
        catch (NamingException e) {
            ClassCastException cce = new ClassCastException(String.format("narrowFrom(%s) can not be cast to narrowTo(%s).", narrowFrom, narrowTo));
            cce.initCause(e);
            throw cce;
        }
        finally {
            PortableRemoteObject.clearRecursive();
        }
    }

    private static void checkAndSetRecursive(Object narrowFrom, Class narrowTo) {
        if (Boolean.TRUE.equals(recursive.get())) {
            recursive.set(null);
            throw new ClassCastException("narrowFrom'" + narrowFrom + '\'' + " \tnarrowTo:" + '\'' + narrowTo + "'Recursive narrow detected");
        }
        recursive.set(Boolean.TRUE);
    }

    private static void clearRecursive() {
        recursive.set(null);
    }
}

