/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions;

import java.rmi.Remote;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorList;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;

public class DisconnectMonitorListImpl
implements DisconnectMonitor,
DisconnectMonitorList {
    private static ArrayList disconnectMonitorList = new ArrayList();

    private DisconnectMonitorListImpl() {
    }

    private static DisconnectMonitorListImpl getInstance() {
        return DisconnectMonitorListImplSingleton.theDisconnectMonitorList;
    }

    public static DisconnectMonitorList getDisconnectMonitorList() {
        return DisconnectMonitorListImpl.getInstance();
    }

    public static DisconnectMonitor getDisconnectMonitor() {
        return DisconnectMonitorListImpl.getInstance();
    }

    @Override
    public synchronized void addDisconnectMonitor(DisconnectMonitorProvider monitor) {
        disconnectMonitorList.add(monitor);
    }

    @Override
    public synchronized void removeDisconnectMonitor(DisconnectMonitorProvider monitor) {
        disconnectMonitorList.remove(monitor);
    }

    @Override
    public synchronized void addDisconnectListener(Remote remoteStub, DisconnectListener listener) throws DisconnectMonitorUnavailableException {
        for (DisconnectMonitorProvider next : disconnectMonitorList) {
            if (!next.addDisconnectListener(remoteStub, listener)) continue;
            return;
        }
        throw new DisconnectMonitorUnavailableException("Could not register a DisconnectListener for [" + remoteStub + "]");
    }

    @Override
    public synchronized void removeDisconnectListener(Remote remoteObject, DisconnectListener listener) throws DisconnectMonitorUnavailableException {
        for (DisconnectMonitorProvider dcm : disconnectMonitorList) {
            if (!dcm.removeDisconnectListener(remoteObject, listener)) continue;
            return;
        }
        throw new DisconnectMonitorUnavailableException("No registration found for [" + remoteObject + "]");
    }

    public static void bindToJNDI(Context ctx) throws NamingException {
        ctx.bind("weblogic.DisconnectMonitor", (Object)DisconnectMonitorListImpl.getDisconnectMonitor());
    }

    public static void unbindFromJNDI(Context ctx) throws NamingException {
        ctx.unbind("weblogic.DisconnectMonitor");
    }

    private static final class DisconnectMonitorListImplSingleton {
        private static final DisconnectMonitorListImpl theDisconnectMonitorList = new DisconnectMonitorListImpl();

        private DisconnectMonitorListImplSingleton() {
        }
    }
}

