/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;

public class TransactionalAffinityHandler {
    private static final DebugLogger debugLBLogger = DebugLogger.getDebugLogger("DebugLoadBalancing");
    private static Interceptor ti;

    private static void setInterceptor(Interceptor i) {
        ti = i;
    }

    public TransactionalAffinityHandler() {
        TransactionalAffinityHandler.setInterceptor(this.getInterceptor());
    }

    Interceptor getInterceptor() {
        return InterceptorManager.getManager().getTransactionInterceptor();
    }

    boolean requiresAffinityBasedHandling(RuntimeMethodDescriptor md) {
        if (ti == null) {
            TransactionalAffinityHandler.setInterceptor(this.getInterceptor());
        }
        return ti != null && md.isTransactional() && ti.needsInterception();
    }

    public RemoteReference findTxnAffinityBasedRef(RemoteReference currentRef, String jndiName, ReplicaList replicaList) {
        if (ti == null) {
            TransactionalAffinityHandler.setInterceptor(this.getInterceptor());
        }
        RemoteReference newRef = null;
        if (ti != null) {
            RemoteReference[] currentList;
            if (currentRef != null && ti.isParticipant(currentRef.getHostID().getServerName())) {
                return currentRef;
            }
            for (RemoteReference aCurrentList : currentList = replicaList.toArray()) {
                RemoteReference ref = aCurrentList;
                if (!ti.isParticipant(ref.getHostID().getServerName())) continue;
                newRef = ref;
                break;
            }
        }
        if (debugLBLogger.isDebugEnabled() && newRef != null) {
            debugLBLogger.debug(jndiName + " request routing from " + currentRef.getHostID() + " to " + newRef.getHostID());
        }
        return newRef;
    }
}

