/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.cluster.ServerInfo;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.spi.HostID;

public final class ServerInfoManager {
    private static final Object LOCK = new Object(){};
    private Map serverNameMap = new HashMap();
    private Map serverIdMap = new HashMap();

    public static ServerInfoManager theOne() {
        return SingletonMaker.SINGLETON;
    }

    private ServerInfoManager() {
    }

    public ServerInfo getServerInfo(String name) {
        return (ServerInfo)this.serverNameMap.get(name);
    }

    public ServerInfo getServerInfo(HostID id) {
        return (ServerInfo)this.serverIdMap.get(id);
    }

    public ServerInfo getServerInfo(Object remoteObj) {
        return this.getServerInfo(RemoteHelper.getHostID(remoteObj));
    }

    public ServerInfo getServerInfo(RemoteReference ror) {
        return this.getServerInfo(ror.getHostID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(String name, HostID id, int loadWeight) {
        ServerInfo newServer = new ServerInfo(name, id, loadWeight);
        Object object = LOCK;
        synchronized (object) {
            this.serverNameMap.put(name, newServer);
            this.serverIdMap.put(id, newServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(HostID id) {
        Object object = LOCK;
        synchronized (object) {
            this.serverNameMap.remove(this.getServerInfo(id).getName());
            this.serverIdMap.remove(id);
        }
    }

    public Object writeLocalInfoUpdate() throws IOException {
        return new Object[]{this.getServerInfo(LocalServerIdentity.getIdentity())};
    }

    Object writeUpdate() {
        return this.serverNameMap == null ? null : this.serverNameMap.values().toArray();
    }

    public void readUpdate(Object in) throws IOException {
        Object[] infoList = (Object[])in;
        if (infoList != null) {
            for (int i = 0; i < infoList.length; ++i) {
                this.updateServerInfo((ServerInfo)infoList[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerInfo(ServerInfo server) throws IOException {
        if (server == null) {
            throw new IOException("Reference to server no longer exists.\n Possible reasons for failure include having servers with duplicate names running on a cluster.  Please check your configuration for this error.");
        }
        String name = server.getName();
        HostID id = server.getID();
        Object object = LOCK;
        synchronized (object) {
            ServerInfo old = (ServerInfo)this.serverNameMap.get(name);
            if (old != null && old.getID() != id) {
                if (old.getID().isLocal() && !id.isLocal()) {
                    return;
                }
                this.serverIdMap.remove(old.getID());
            }
            this.serverNameMap.put(name, server);
            this.serverIdMap.put(server.getID(), server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerInfo[] getServerInfos() {
        Object object = LOCK;
        synchronized (object) {
            Collection c = this.serverIdMap.values();
            return c.toArray(new ServerInfo[c.size()]);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Server Info\n");
        buf.append("-----------\n");
        Iterator it = this.serverIdMap.values().iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString() + "\n");
        }
        return buf.toString();
    }

    private static final class SingletonMaker {
        private static final ServerInfoManager SINGLETON = new ServerInfoManager();

        private SingletonMaker() {
        }
    }
}

