/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import weblogic.rmi.cluster.BasicAffinityReplicaHandler;
import weblogic.rmi.cluster.BasicReplicaHandler;
import weblogic.rmi.cluster.CallRouter;
import weblogic.rmi.cluster.ClusterableServerRef;
import weblogic.rmi.cluster.MigratableReplicaHandler;
import weblogic.rmi.cluster.PiggybackRequester;
import weblogic.rmi.cluster.PiggybackResponder;
import weblogic.rmi.cluster.PiggybackResponse;
import weblogic.rmi.cluster.PrimarySecondaryReplicaHandler;
import weblogic.rmi.cluster.RandomAffinityReplicaHandler;
import weblogic.rmi.cluster.RandomReplicaHandler;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.Version;
import weblogic.rmi.cluster.WeightBasedAffinityReplicaHandler;
import weblogic.rmi.cluster.WeightBasedReplicaHandler;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RuntimeDescriptor;

public final class ReplicaAwareInfo {
    private final boolean propagateEnvironment;
    private final boolean stickToFirstServer;
    private String jndiName;
    private String callRouterName;
    private String replicaHandlerClassName;
    private transient CallRouter callRouter;
    private transient Class replicaHandlerClass;

    ReplicaAwareInfo(boolean stickToFirstServer, String jndiName, String callRouterName, boolean propagateEnvironment, String replicaHandlerClassName) {
        this.stickToFirstServer = stickToFirstServer;
        this.jndiName = jndiName;
        this.callRouterName = callRouterName;
        this.propagateEnvironment = propagateEnvironment;
        this.replicaHandlerClassName = replicaHandlerClassName;
    }

    public ReplicaAwareInfo(RuntimeDescriptor desc) throws IllegalArgumentException {
        this(desc.getStickToFirstServer(), null, desc.getCallRouterClassName(), desc.getPropagateEnvironment(), ReplicaAwareInfo.getReplicaHandlerClass(desc));
    }

    public ReplicaAwareInfo(boolean stickToFirstServer, String algorithm, String jndiName) throws IllegalArgumentException {
        this(stickToFirstServer, jndiName, null, true, ReplicaAwareInfo.getReplicaHandlerClass(null, algorithm));
    }

    public ReplicaAwareInfo(boolean stickToFirstServer, String replicaHandler, String algorithm, boolean propagateEnvironment) {
        this(stickToFirstServer, null, null, true, ReplicaAwareInfo.getReplicaHandlerClass(replicaHandler, algorithm));
    }

    public ReplicaAwareInfo(String jndiName, Class replicaHandlerClass) {
        this(false, jndiName, null, true, null);
        this.replicaHandlerClass = replicaHandlerClass;
    }

    private static String getReplicaHandlerClass(RuntimeDescriptor desc) {
        return ReplicaAwareInfo.getReplicaHandlerClass(desc.getReplicaHandlerClassName(), desc.getLoadAlgorithm());
    }

    private static String getReplicaHandlerClass(String className, String algorithm) {
        if (className == null) {
            if (algorithm.equals("default") && (algorithm = RMIEnvironment.getEnvironment().getClusterDefaultLoadAlgorithm()) == null) {
                algorithm = "round-robin";
            }
            className = algorithm.equals("random") ? RandomReplicaHandler.class.getName() : (algorithm.equals("round-robin") ? BasicReplicaHandler.class.getName() : (algorithm.equals("weight-based") ? WeightBasedReplicaHandler.class.getName() : (algorithm.equals("server-affinity") ? BasicAffinityReplicaHandler.class.getName() : (algorithm.equals("round-robin-affinity") ? BasicAffinityReplicaHandler.class.getName() : (algorithm.equals("random-affinity") ? RandomAffinityReplicaHandler.class.getName() : (algorithm.equals("weight-based-affinity") ? WeightBasedAffinityReplicaHandler.class.getName() : (algorithm.equals("primary-secondary") ? PrimarySecondaryReplicaHandler.class.getName() : (algorithm.equals("migratable") ? MigratableReplicaHandler.class.getName() : BasicReplicaHandler.class.getName()))))))));
        }
        return className;
    }

    private Class getReplicaHandlerClass() {
        if (this.replicaHandlerClass == null) {
            this.replicaHandlerClass = ReplicaAwareInfo.classForName(this.replicaHandlerClassName, ReplicaHandler.class);
        }
        return this.replicaHandlerClass;
    }

    public boolean getStickToFirstServer() {
        return this.stickToFirstServer;
    }

    ReplicaHandler getReplicaHandler(RemoteReference primary) {
        Class[] sig = new Class[]{ReplicaAwareInfo.class, RemoteReference.class};
        Object[] params = new Object[]{this, primary};
        return (ReplicaHandler)ReplicaAwareInfo.instantiate(this.getReplicaHandlerClass(), sig, params);
    }

    PiggybackResponder getReplicaListUpdater(ClusterableServerRef serverRef) {
        if (PiggybackRequester.class.isAssignableFrom(this.getReplicaHandlerClass())) {
            return new ReplicaListUpdater(serverRef);
        }
        return null;
    }

    CallRouter getCallRouter() {
        if (this.callRouterName != null) {
            Class cls = ReplicaAwareInfo.classForName(this.callRouterName, CallRouter.class);
            Class[] sig = new Class[]{};
            Object[] params = new Object[]{};
            this.callRouter = (CallRouter)ReplicaAwareInfo.instantiate(cls, sig, params);
            return this.callRouter;
        }
        return this.callRouter;
    }

    boolean getPropagateEnvironment() {
        return this.propagateEnvironment;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String name) {
        this.jndiName = name;
    }

    private static Class classForName(String className, Class expectedType) throws IllegalArgumentException {
        if (className == null) {
            return null;
        }
        try {
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            Class<?> c = Class.forName(className, true, currentCL);
            if (expectedType.isAssignableFrom(c)) {
                return c;
            }
            throw new IllegalArgumentException("Class is not an instanceof " + expectedType.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + className + " not found", e);
        }
    }

    private static Object instantiate(Class c, Class[] signature, Object[] params) throws IllegalArgumentException {
        try {
            Constructor constructor = c.getConstructor(signature);
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to instantiate " + c.getName() + " due to " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to instantiate " + c.getName() + " due to " + e.getTargetException(), e);
        }
    }

    static boolean isServerInCluster() {
        return RMIEnvironment.getEnvironment().isServerInCluster();
    }

    public String toString() {
        return super.toString() + " - stickToFirstServer: '" + this.stickToFirstServer + "', jndiName: '" + this.jndiName + "'callRouter: '" + this.callRouter + "', replicaHandlerClass: '" + this.replicaHandlerClass + "'";
    }

    private static class ReplicaListUpdater
    implements PiggybackResponder {
        private ClusterableServerRef serverRef;

        public ReplicaListUpdater(ClusterableServerRef serverRef) {
            this.serverRef = serverRef;
        }

        @Override
        public PiggybackResponse handlePiggybackRequest(Object request) {
            Version serverVersion = this.serverRef.getReplicaList().version();
            if (this.isClientVersionObsolete(request, serverVersion)) {
                return this.serverRef.getReplicaList();
            }
            if (this.serverRef.getReplicaList().isReplicaVersionChanged()) {
                return this.serverRef.getReplicaList().getReplicaVersion();
            }
            return null;
        }

        private boolean isClientVersionObsolete(Object request, Version serverVersion) {
            return serverVersion.getVersion() != 0L && !serverVersion.equals(request);
        }
    }
}

