/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.Context;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfoable;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.RMILogger;
import weblogic.rmi.RemoteEJBInvokeException;
import weblogic.rmi.RemoteEJBPreInvokeException;
import weblogic.rmi.cluster.BasicReplicaHandler;
import weblogic.rmi.cluster.BasicReplicaList;
import weblogic.rmi.cluster.PiggybackRequester;
import weblogic.rmi.cluster.RemoteReplicaService;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.ReplicaID;
import weblogic.rmi.cluster.ReplicaInfo;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.ReplicaVersion;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.cluster.TransactionalAffinityHandler;
import weblogic.rmi.cluster.Version;
import weblogic.rmi.cluster.ejb.PreInvokeDeserializationException;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.UnrecoverableConnectionException;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.facades.RmiInvocationFacade;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtilsClient;

public final class PrimarySecondaryReplicaHandler
implements ReplicaHandler,
PiggybackRequester,
Externalizable {
    private static final DebugLogger debugFailoverLogger = DebugLogger.getDebugLogger("DebugFailOver");
    private static final DebugLogger debugFailoverVerboseLogger = DebugLogger.getDebugLogger("DebugFailOverVerbose");
    private static final long serialVersionUID = -1707367770014954050L;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static int DEFAULT_REPLICA_QUERY_TIMEOUT = 30000;
    private ReplicaList replicaList;
    private transient Hashtable<HostID, RemoteReference> staledReplicas = new Hashtable();
    private transient String clusterURL = null;
    private transient Object env = null;
    private transient String partitionName = null;

    public PrimarySecondaryReplicaHandler(ReplicaAwareInfo info, RemoteReference primary) {
        this.replicaList = new BasicReplicaList(primary);
    }

    private boolean isConnectionFailure(Exception e) {
        Throwable t = e;
        while (t != null) {
            if (e instanceof PeerGoneException) {
                return true;
            }
            if (t instanceof EOFException) {
                return true;
            }
            if (t instanceof ConnectException) {
                return true;
            }
            if (t instanceof java.rmi.ConnectException) {
                return true;
            }
            if (t instanceof UnrecoverableConnectionException) {
                return true;
            }
            if (!(t instanceof IOException)) {
                t = t.getCause();
                continue;
            }
            String msg = t.getMessage();
            if (msg == null) {
                t = t.getCause();
                continue;
            }
            if (msg.contains("UnrecoverableConnectionException")) {
                return true;
            }
            if (msg.contains("No available router to destination")) {
                return true;
            }
            if (msg.contains("Connection reset by peer")) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    protected boolean isRecoverableFailure(RuntimeMethodDescriptor md, RemoteException e, List recorder) {
        if (e instanceof RemoteEJBPreInvokeException) {
            return true;
        }
        if (!(e instanceof RemoteEJBInvokeException)) {
            ReplicaID ri = this.replicaList.getReplicaID();
            if (ri != null && ri.getID() instanceof byte[] && this.isConnectionFailure(e)) {
                return true;
            }
        } else {
            Throwable t = BasicReplicaHandler.unwrapRemoteEJBInvokeException((RemoteEJBInvokeException)e);
            if (t instanceof RemoteException) {
                e = (RemoteException)t;
            } else {
                return false;
            }
        }
        if (md.isIdempotent()) {
            boolean b = RemoteHelper.isRecoverableFailure(e);
            if (!b) {
                recorder.add("[" + md + "]UnrecoverableFailure");
            }
            return b;
        }
        boolean b = RemoteHelper.isRecoverablePreInvokeFailure(e);
        if (!b) {
            recorder.add("[" + md + "]Non-RecoverablePreInvokeFailure");
        }
        return b;
    }

    @Override
    public RemoteReference loadBalance(RemoteReference currentReplica, Method method, Object[] params, TransactionalAffinityHandler txnAffinityHandler, RuntimeMethodDescriptor md) {
        if (debugFailoverVerboseLogger.isDebugEnabled()) {
            debugFailoverVerboseLogger.debug("In PrimarySecondaryReplicaHandler.LOADBALANCE(currentReplica=" + currentReplica + ", txnAffinityHandler=" + txnAffinityHandler + "), replicaList=[" + this.replicaList + "]");
        }
        if (txnAffinityHandler != null && txnAffinityHandler.requiresAffinityBasedHandling(md)) {
            RemoteReference preferredRef = txnAffinityHandler.findTxnAffinityBasedRef(currentReplica, "", this.replicaList);
            if (debugFailoverVerboseLogger.isDebugEnabled()) {
                debugFailoverVerboseLogger.debug("PrimarySecondaryReplicaHandler.localbalance(currentReplica=" + currentReplica + ", txnAffinityHandler=" + txnAffinityHandler + "): Found preferred replica " + preferredRef);
            }
            if (preferredRef != null) {
                return preferredRef;
            }
        }
        return currentReplica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteReference failOver(RemoteReference failedReplica, RuntimeMethodDescriptor md, Method method, Object[] params, RemoteException re, RetryHandler retryHandler) throws RemoteException {
        this.DEBUG("failOver", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + ", class=" + failedReplica.getClass().getName() + "]), exception=" + re.getMessage() + ", repliaList=[" + this.replicaList + "]" + retryHandler.isStaleListRevivingAttempted());
        this.replicaList.remove(failedReplica);
        this.staledReplicas.put(failedReplica.getHostID(), failedReplica);
        ArrayList<String> recorder = new ArrayList<String>();
        boolean replicaliststaled = false;
        boolean isrecoverable = this.isRecoverableFailure(md, re, recorder);
        ReplicaList replicaList = this.replicaList;
        synchronized (replicaList) {
            if (this.replicaList.size() > 0 && isrecoverable) {
                this.DEBUG("failOver", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Failing over to " + this.replicaList.getPrimary().getHostID());
                return this.replicaList.getPrimary();
            }
            if (this.replicaList.size() == 0) {
                replicaliststaled = true;
            } else {
                recorder.add("ReplicaListSize[" + this.replicaList.size() + "]");
            }
        }
        if (replicaliststaled && isrecoverable) {
            this.DEBUG("failOver", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): replicaliststaled=true, isRecoverableFailure=true, exception=[" + re.getClass() + ", " + re.getCause() + "]");
            RemoteReference ref = null;
            if (re instanceof PreInvokeDeserializationException) {
                ref = ((PreInvokeDeserializationException)re).getFailoverRemoteRef();
            } else if (re.getCause() instanceof PreInvokeDeserializationException) {
                ref = ((PreInvokeDeserializationException)re.getCause()).getFailoverRemoteRef();
            }
            if (ref != null) {
                this.DEBUG("failOver", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): exception=" + re + ", failoverRef=" + ref);
                return ref;
            }
            ref = this.tryQueryReplica(failedReplica, re, retryHandler, recorder);
            if (ref != null) {
                this.DEBUG("failOver", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): return ref=" + ref + "[class=" + ref.getClass().getName() + "]");
                return ref;
            }
        }
        if (retryHandler.getRetryCount() >= retryHandler.getMaxRetryCount()) {
            this.logFailureTrace(recorder, retryHandler.getMaxRetryCount());
        }
        this.DEBUG("failOver", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Unable to failover");
        throw RemoteHelper.returnOrUnwrap(re);
    }

    private void logFailureTrace(List recorder, int maxRetries) {
        StringBuilder builder = new StringBuilder();
        for (Object item : recorder) {
            if (item instanceof String) {
                builder.append(item + "\n");
                continue;
            }
            if (!(item instanceof Throwable)) continue;
            builder.append("\n" + StackTraceUtilsClient.throwable2StackTrace((Throwable)item) + "\n");
        }
        RMILogger.logFailOverFailureTrace(builder.toString(), maxRetries);
    }

    @Override
    public ReplicaList getReplicaList() {
        return this.replicaList;
    }

    @Override
    public void resetReplicaList(ReplicaList newList) {
        this.replicaList = newList;
    }

    public void resetRefreshedCount() {
    }

    @Override
    public Version getPiggybackRequest() {
        return this.replicaList.version();
    }

    @Override
    public void setPiggybackResponse(Object response) {
        if (response instanceof ReplicaList) {
            this.replicaList.reset((ReplicaList)response);
        } else if (response instanceof ReplicaVersion) {
            this.replicaList.setReplicaVersion((ReplicaVersion)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoteReference tryQueryReplica(RemoteReference failedReplica, RemoteException re, RetryHandler retryHandler, List recorder) throws RemoteException {
        this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]), exception=" + re.getMessage() + ", query attempted=" + retryHandler.isStaleListRevivingAttempted());
        if (retryHandler.isStaleListRevivingAttempted()) {
            recorder.add("QueryReplicaAlreadyAttempted");
            return null;
        }
        ReplicaID replicaID = this.replicaList.getReplicaID();
        ReplicaVersion replicaVersion = this.replicaList.getReplicaVersion();
        if (replicaID == null) {
            recorder.add("ReplicaID null");
            this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): The ReplicaID used for query replica not available");
            return null;
        }
        if (replicaVersion == null) {
            recorder.add("ReplicaVersion null");
            this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): The ReplicaVersion used for query replica not available");
            return null;
        }
        retryHandler.setStaleListRevivingAttempted();
        try {
            ReplicaInfo rinfo;
            Object myenv = this.env;
            boolean isnewenv = false;
            recorder.add("Environment: " + myenv);
            if (myenv == null) {
                myenv = RMIEnvironment.getEnvironment().threadEnvironmentGet();
                recorder.add("Thread Environment: " + myenv);
            }
            if (myenv == null) {
                myenv = RMIEnvironment.getEnvironment().newEnvironment();
                isnewenv = true;
                recorder.add("New Environment: " + myenv);
                this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): threadEnvironmentGet returns null, use newEnvironment");
            }
            ReplicaInfo replicaInfo = null;
            ReplicaInfo replicaInfoFromCluster = null;
            boolean isIIOP = failedReplica.getHostID().getHostURI().startsWith("iiop");
            if (!(isnewenv && isIIOP || (replicaInfo = this.tryDefaultJNDIContext(failedReplica, myenv, replicaID, replicaVersion, recorder)) == null || replicaInfo.getRemoteRef() == null)) {
                return replicaInfo.getRemoteRef();
            }
            String myurl = this.clusterURL;
            if (myurl != null) {
                recorder.add("Try ClusterURL " + myurl);
                this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Try cluster url " + myurl);
                Context ctx = this.getJNDIContextFromEnvForURL(failedReplica, myurl, myenv, recorder);
                if (ctx != null) {
                    try {
                        replicaInfoFromCluster = this.findReplicaRemoteRef(failedReplica, ctx, replicaID, replicaVersion, recorder);
                        if (replicaInfoFromCluster != null && replicaInfoFromCluster.getRemoteRef() != null) {
                            RemoteReference remoteReference = replicaInfoFromCluster.getRemoteRef();
                            return remoteReference;
                        }
                    }
                    finally {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            if ((rinfo = this.tryStaledReplicaList(failedReplica, myenv, replicaID, replicaVersion, recorder)) != null && rinfo.getRemoteRef() != null) {
                return rinfo.getRemoteRef();
            }
            if (rinfo != null) {
                replicaInfo = rinfo;
            }
            Object[] targetClusterAddress = null;
            if (replicaInfoFromCluster != null) {
                targetClusterAddress = replicaInfoFromCluster.getTargetClusterAddresses();
            }
            if (targetClusterAddress == null && replicaInfo != null) {
                targetClusterAddress = replicaInfo.getTargetClusterAddresses();
            }
            if (targetClusterAddress == null) return null;
            if (targetClusterAddress.length == 0) {
                return null;
            }
            recorder.add("Try TargetClusterAddress[" + Arrays.toString(targetClusterAddress) + "][partition=" + this.partitionName + "]");
            Object[] objectArray = targetClusterAddress;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object address = objectArray[n2];
                if (isIIOP && ((String)address).startsWith("t3")) {
                    address = ((String)address).replaceFirst("t3", "iiop");
                }
                this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Try target cluster address " + (String)address + " for partition: " + this.partitionName);
                Context ctx = this.getJNDIContextFromEnvForURL(failedReplica, (String)address, myenv, recorder);
                if (ctx != null) {
                    try {
                        rinfo = this.findReplicaRemoteRef(failedReplica, ctx, replicaID, replicaVersion, recorder);
                        if (rinfo != null && rinfo.getRemoteRef() != null) {
                            RemoteReference remoteReference = rinfo.getRemoteRef();
                            return remoteReference;
                        }
                    }
                    finally {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                ++n2;
            }
            return null;
        }
        catch (Exception e) {
            recorder.add(e);
            this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Got exception while attempting to revive replicalist: " + e, e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicaInfo tryDefaultJNDIContext(RemoteReference failedReplica, Object myenv, ReplicaID replicaID, ReplicaVersion replicaVersion, List recorder) {
        Hashtable propsDefault = RMIEnvironment.getEnvironment().getProperties(myenv);
        Hashtable propsDefaultLog = new Hashtable(propsDefault);
        propsDefaultLog.remove("java.naming.security.credentials");
        Context ctxDefault = null;
        try (ManagedInvocationContext ignored = RmiInvocationFacade.setPartitionName(kernelId, RmiInvocationFacade.getGlobalPartitionName());){
            ctxDefault = RMIEnvironment.getEnvironment().getContext(myenv);
        }
        catch (Exception e) {
            if (recorder != null) {
                recorder.add(e);
            }
            this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]):Exception on getting JNDI context using default env[" + propsDefaultLog + "]: " + e);
        }
        if (ctxDefault == null) {
            return null;
        }
        if (recorder != null) {
            recorder.add("Try Default JNDI Context");
        }
        this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Try default JNDI environment[" + propsDefaultLog + "]");
        try {
            ReplicaInfo replicaInfo = this.findReplicaRemoteRef(failedReplica, ctxDefault, replicaID, replicaVersion, recorder);
            return replicaInfo;
        }
        finally {
            try {
                ctxDefault.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicaInfo tryStaledReplicaList(RemoteReference failedReplica, Object myenv, ReplicaID replicaID, ReplicaVersion replicaVersion, List recorder) throws Exception {
        ArrayList<RemoteReference> replicas = new ArrayList<RemoteReference>(this.staledReplicas.values());
        this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Try provider urls from staled replicalist " + replicas);
        for (RemoteReference replica : replicas) {
            HostID oldhid = replica.getHostID();
            String uri = oldhid.getHostURI();
            Context ctx = this.getJNDIContextFromEnvForURL(failedReplica, uri, myenv, recorder);
            if (ctx == null) continue;
            try {
                ReplicaInfo info = this.findReplicaRemoteRef(failedReplica, ctx, replicaID, replicaVersion, recorder);
                if (info == null) continue;
                ReplicaInfo replicaInfo = info;
                return replicaInfo;
            }
            finally {
                try {
                    ctx.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    private Context getJNDIContextFromEnvForURL(RemoteReference failedReplica, String url, Object myenv, List recorder) throws Exception {
        Class<?> c = Class.forName("weblogic.jndi.Environment");
        Method m = c.getMethod("setProviderURL", String.class);
        m.invoke(myenv, url);
        if (recorder != null) {
            recorder.add("JNDI Context URL: " + url);
        }
        Context ctx = null;
        int retries = 1;
        for (int i = 0; i < retries; ++i) {
            try (ManagedInvocationContext ignored = RmiInvocationFacade.setPartitionName(kernelId, RmiInvocationFacade.getGlobalPartitionName());){
                ctx = RMIEnvironment.getEnvironment().getContext(myenv);
                continue;
            }
            catch (Exception e) {
                if (recorder != null) {
                    recorder.add(e);
                }
                this.DEBUG("tryQueryReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Exception on getting JNDI context using url " + url + ": " + e, e);
                if (!(e instanceof CommunicationException)) break;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ctx;
    }

    private ReplicaInfo findReplicaRemoteRef(RemoteReference failedReplica, Context ctx, ReplicaID replicaID, ReplicaVersion replicaVersion, List recorder) {
        ReplicaInfo info = null;
        try {
            info = this.findReplica(failedReplica, ctx, replicaID, replicaVersion, recorder);
        }
        catch (Exception e) {
            if (recorder != null) {
                recorder.add(e);
            }
            this.DEBUG("findReplicaRemoteRef", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Exception on findReplica(): " + e, e);
        }
        return info;
    }

    private ReplicaInfo findReplica(RemoteReference failedReplica, Context ctx, ReplicaID replicaID, ReplicaVersion replicaVersion, List recorder) throws Exception {
        this.DEBUG("findReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Lookup ReplicaService with url " + ctx.getEnvironment().get("java.naming.provider.url"));
        RemoteReplicaService rrs = (RemoteReplicaService)ctx.lookup("weblogic.cluster.RemoteReplicaService");
        if (recorder != null) {
            recorder.add("RemoteReplicaService@" + rrs);
        }
        this.DEBUG("findReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Looked up ReplicaService[" + rrs + "]");
        ReplicaInfo info = rrs.findReplica(replicaID, replicaVersion, this.partitionName);
        this.DEBUG("findReplica", "failedReplica[" + failedReplica.getHostID() + ", " + failedReplica.getObjectID() + "]): Found replica " + info);
        return info;
    }

    public String toString() {
        if (this.replicaList != null) {
            return this.replicaList.toString();
        }
        return super.toString();
    }

    public PrimarySecondaryReplicaHandler() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (out instanceof WLObjectOutput) {
            WLObjectOutput wlOut = (WLObjectOutput)out;
            wlOut.writeObjectWL(this.replicaList);
        } else {
            out.writeObject(this.replicaList);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in instanceof WLObjectInput) {
            WLObjectInput wlIn = (WLObjectInput)in;
            this.replicaList = (ReplicaList)wlIn.readObjectWL();
        } else {
            this.replicaList = (ReplicaList)in.readObject();
        }
        try {
            String v;
            this.env = RMIEnvironment.getEnvironment().threadEnvironmentGet();
            RemoteReference ref = null;
            HostID host = null;
            EndPoint ep = null;
            if (this.replicaList != null && (ref = this.replicaList.getPrimary()) != null && (host = ref.getHostID()) != null && (ep = RMIRuntime.findEndPoint(host)) != null && (v = ep.getClusterURL(in)) != null) {
                this.clusterURL = v;
            }
            if (this.clusterURL == null && in instanceof PeerInfoable) {
                this.DEBUG("readExternal", "env=" + this.env + ", clusterURL=" + this.clusterURL + ", replicaList=" + this.replicaList + ", ref=" + ref + ", host=" + host + ", ep=" + ep);
            }
        }
        catch (Exception e) {
            this.DEBUG("readExternal", "Exception while getting env=" + this.env + " or clusterURL=" + this.clusterURL + ": " + e, e);
        }
    }

    void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    private void DEBUG(String method, String msg) {
        this.DEBUG(method, msg, null);
    }

    private void DEBUG(String method, String msg, Throwable e) {
        if (debugFailoverLogger.isDebugEnabled()) {
            if (e == null) {
                debugFailoverLogger.debug("PrimarySecondaryReplicaHandler." + method + "(): " + msg);
            } else {
                debugFailoverLogger.debug(msg, e);
            }
        }
    }
}

