/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import jakarta.transaction.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.rmi.cluster.EntityBeanReplicaHandler;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.Enrollable;
import weblogic.rmi.internal.dgc.DGCClientHelper;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

public final class EntityRemoteRef
extends BasicRemoteRef {
    private static final long serialVersionUID = -3542562121173822208L;
    private static final boolean DEBUG = false;
    private ReplicaHandler replicaHandler;
    private String jndiName;
    private Object pk;
    private Environment environment;
    private Enrollable enrollable;

    protected void finalize() throws Throwable {
        if (this.enrollable != null) {
            this.enrollable.unenroll();
        }
    }

    public EntityRemoteRef(int oid, HostID hostID, String jndiName, Object pk) {
        super(oid, hostID);
        this.jndiName = jndiName;
        this.pk = pk;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EntityRemoteRef) {
            EntityRemoteRef other = (EntityRemoteRef)obj;
            if (!other.pk.equals(this.pk)) {
                return false;
            }
            return other.jndiName.equals(this.jndiName);
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " - hostID: '" + this.hostID + "', oid: '" + this.oid + "' PK " + this.pk;
    }

    @Override
    public final Object invoke(Remote stub, RuntimeMethodDescriptor md, Object[] args, Method m) throws Throwable {
        if (this.environment != null) {
            ThreadEnvironment.push(this.environment);
        }
        String partitionURL = this.getPartitionURL(stub);
        try {
            RetryHandler retryHandler = new RetryHandler();
            int retryCount = 0;
            while (true) {
                try {
                    retryHandler.setRetryCount(retryCount);
                    Object object = this.privateInvoke(md, args, partitionURL);
                    return object;
                }
                catch (RemoteException e) {
                    RemoteReference ref = this.replicaHandler.failOver(null, md, m, args, e, retryHandler);
                    this.oid = ref.getObjectID();
                    this.hostID = ref.getHostID();
                    ++retryCount;
                    continue;
                }
                break;
            }
        }
        finally {
            if (this.environment != null) {
                ThreadEnvironment.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object privateInvoke(RuntimeMethodDescriptor md, Object[] args, String partitionURL) throws Throwable {
        Transaction tx = null;
        TransactionManager tm = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
        if (!md.isTransactional()) {
            tx = tm.forceSuspend();
        }
        OutboundRequest request = this.getOutboundRequest(md, partitionURL);
        InboundResponse response = null;
        try {
            request.marshalArgs(args);
            response = request.sendReceive();
            Object object = response.unmarshalReturn();
            return object;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException ioe) {
                throw new UnmarshalException("failed to close response stream", ioe);
            }
            if (!md.isTransactional()) {
                tm.forceResume(tx);
            }
        }
    }

    public EntityRemoteRef() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.jndiName);
        out.writeObject(this.pk);
        if (this.enrollable != null) {
            this.enrollable.renewLease();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.jndiName = (String)in.readObject();
        this.pk = in.readObject();
        HostID id = this.getHostID();
        this.environment = new Environment();
        if (!id.isLocal()) {
            this.environment.setProviderUrl(RMIRuntime.findEndPoint(id).getClusterURL(in));
        }
        this.replicaHandler = new EntityBeanReplicaHandler(this.pk, this.jndiName, this.environment);
        this.enrollable = DGCClientHelper.findAndEnroll(this);
    }
}

