/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.PiggybackResponder;
import weblogic.rmi.cluster.PiggybackResponse;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.ReplicaVersion;
import weblogic.rmi.extensions.server.Collectable;
import weblogic.rmi.extensions.server.InvokableServerReference;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.ClusterAwareServerReference;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.ServerReferenceInterceptor;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.InvokeHandler;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.utils.Debug;

public class ClusterableServerRef
implements ClusterAwareServerReference,
InvokeHandler,
Collectable {
    private static final boolean ASSERT = true;
    protected ClusterableRemoteRef remoteRef;
    private ReplicaList replicaList;
    private ReplicaAwareInfo info;
    private PiggybackResponder replicaListUpdater = null;
    private boolean isInitialized = false;
    private final InvokableServerReference serverRef;
    private final InvokeHandler invoker;

    public ClusterableServerRef(Object o) throws RemoteException {
        this(new BasicServerRef(o));
    }

    public ClusterableServerRef(int oid, Object o) throws RemoteException {
        this(new BasicServerRef(oid, o));
    }

    public ClusterableServerRef(InvokableServerReference delegate) {
        this(delegate, (InvokeHandler)((Object)delegate));
    }

    public ClusterableServerRef(InvokableServerReference delegate, InvokeHandler invoker) {
        this.serverRef = delegate;
        this.invoker = invoker;
        this.remoteRef = this.getUninitializedRemoteRef();
        this.info = new ReplicaAwareInfo(this.getDescriptor());
    }

    protected ClusterableRemoteRef getUninitializedRemoteRef() {
        return new ClusterableRemoteRef(this.getLocalRef());
    }

    protected void initialize(ClusterableRemoteRef ref, ReplicaAwareInfo info) {
        this.remoteRef = ref;
        this.info = info;
        this.replicaList = ref.getReplicaList();
        this.replicaListUpdater = info.getReplicaListUpdater(this);
        this.isInitialized = true;
    }

    public void initialize(String jndiName) {
        this.info.setJNDIName(jndiName);
        this.replicaListUpdater = this.info.getReplicaListUpdater(this);
        this.isInitialized = true;
    }

    @Override
    public void addInterceptor(ServerReferenceInterceptor interceptor) {
        this.serverRef.addInterceptor(interceptor);
    }

    final void reset(ClusterableRemoteRef ref) {
        this.remoteRef = ref;
        this.replicaList = ref.getReplicaList();
    }

    @Override
    public final ReplicaAwareInfo getInfo() {
        return this.info;
    }

    ReplicaList getReplicaList() {
        return this.replicaList;
    }

    @Override
    public ComponentInvocationContext getInvocationContext() {
        return this.serverRef.getInvocationContext();
    }

    @Override
    public void setInvocationContext(ComponentInvocationContext invocationContext) {
        this.serverRef.setInvocationContext(invocationContext);
    }

    public final ClusterableRemoteRef getReplicaAwareRemoteRef() {
        return (ClusterableRemoteRef)this.remoteRef.clone();
    }

    @Override
    public final RemoteReference getGenericReplicaAwareRemoteRef() {
        return this.getReplicaAwareRemoteRef();
    }

    @Override
    public ServerReference getDelegate() {
        return this.serverRef.getDelegate();
    }

    @Override
    public PiggybackResponse handlePiggybackRequest(Object piggybackRequest) {
        if (ReplicaAwareInfo.isServerInCluster() && this.replicaListUpdater != null && piggybackRequest != null) {
            return this.replicaListUpdater.handlePiggybackRequest(piggybackRequest);
        }
        return null;
    }

    public ServerReference getServerRef() {
        return this.serverRef;
    }

    public boolean equals(Object obj) {
        return this.serverRef.equals(obj);
    }

    public int hashCode() {
        return this.serverRef.hashCode();
    }

    @Override
    public final int getObjectID() {
        return this.serverRef.getObjectID();
    }

    @Override
    public ServerReference exportObject() {
        OIDManager.getInstance().ensureExported(this);
        return this;
    }

    public String toString() {
        return this.serverRef.toString();
    }

    @Override
    public final ClassLoader getApplicationClassLoader() {
        return this.serverRef.getApplicationClassLoader();
    }

    @Override
    public final String getApplicationName() {
        return this.serverRef.getApplicationName();
    }

    @Override
    public final Object getImplementation() {
        return this.serverRef.getImplementation();
    }

    @Override
    public final boolean unexportObject(boolean force) throws NoSuchObjectException {
        return this.serverRef.unexportObject(force);
    }

    @Override
    public final boolean isExported() {
        return this.serverRef.isExported();
    }

    @Override
    public final RuntimeDescriptor getDescriptor() {
        return this.serverRef.getDescriptor();
    }

    @Override
    public RemoteReference getRemoteRef() throws RemoteException {
        return this.getReplicaAwareRemoteRef();
    }

    @Override
    public final RemoteReference getLocalRef() {
        return this.serverRef.getLocalRef();
    }

    @Override
    public final void sweep(long expiredLease) {
        if (this.serverRef instanceof Collectable) {
            ((Collectable)((Object)this.serverRef)).sweep(expiredLease);
        }
    }

    @Override
    public final void incrementRefCount() {
        if (this.serverRef instanceof Collectable) {
            ((Collectable)((Object)this.serverRef)).incrementRefCount();
        }
    }

    @Override
    public final void decrementRefCount() {
        if (this.serverRef instanceof Collectable) {
            ((Collectable)((Object)this.serverRef)).decrementRefCount();
        }
    }

    @Override
    public final void renewLease() {
        if (this.serverRef instanceof Collectable) {
            ((Collectable)((Object)this.serverRef)).renewLease();
        }
    }

    @Override
    public final StubReference getStubReference() throws RemoteException {
        StubReference stub = this.serverRef.getStubReference();
        if (stub != null) {
            return new StubInfo(this.getReplicaAwareRemoteRef(), stub.getDescriptor(), stub.getStubName(), stub.getStubBaseClassName());
        }
        return stub;
    }

    @Override
    public void invoke(RuntimeMethodDescriptor md, InboundRequest request, OutboundResponse response) throws Exception {
        Debug.assertion(this.isInitialized);
        if (RMIEnvironment.getEnvironment().isIIOPInboundRequest(request)) {
            this.handlePiggybackRequestResponse(request, response);
        }
        this.invoker.invoke(md, request, response);
        if (!RMIEnvironment.getEnvironment().isIIOPInboundRequest(request)) {
            this.handlePiggybackRequestResponse(request, response);
        }
    }

    private void handlePiggybackRequestResponse(InboundRequest request, OutboundResponse response) throws Exception {
        Object inboundReplicaInfo = request.getReplicaInfo();
        PiggybackResponse piggybackResponse = this.handlePiggybackRequest(inboundReplicaInfo);
        if (piggybackResponse instanceof ReplicaVersion && !ClusterableServerRef.doesPeerSupportReplicaVersionPiggy(request.getMsgInput())) {
            piggybackResponse = null;
        }
        if (response != null) {
            response.setPiggybackResponse(piggybackResponse);
        }
    }

    @Override
    public void dispatch(InboundRequest request) {
        this.serverRef.dispatch(request, this);
    }

    @Override
    public void dispatchError(InboundRequest request, Throwable t) {
        this.serverRef.dispatchError(request, t);
    }

    private static boolean doesPeerSupportReplicaVersionPiggy(Object o) {
        return ReplicaVersion.doesPeerSupportReplicaVersion(o);
    }
}

