/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfoable;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolStack;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerChannelStream;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rmi.cluster.ReplicaID;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.ReplicaVersion;
import weblogic.rmi.cluster.Version;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.Debug;

public class BasicReplicaList
implements ReplicaList,
Externalizable,
Cloneable {
    private static final boolean filterReplicaOnChannel;
    private static final DebugLogger debugCluster;
    private static final DebugLogger debugDetailCluster;
    private static final long serialVersionUID = 8963841168514959418L;
    private ArrayList<RemoteReference> replicas;
    private ReplicaID replicaID = null;
    private ReplicaVersion replicaVersion = null;
    private transient Map<HostID, RemoteReference> hostToReplicaMap;
    private transient Version version;
    protected transient RemoteReference localRef;
    private static boolean enableQOSOnStub;

    public BasicReplicaList(RemoteReference primary) {
        this();
        this.initialize();
        if (primary != null) {
            this.add(primary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            return this.replicas.size();
        }
    }

    @Override
    public Version version() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(RemoteReference replica) {
        if (replica.getHostID().isLocal()) {
            this.localRef = replica;
        }
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            if (!this.replicas.contains(replica)) {
                this.replicas.add(replica);
                this.version.addServer(replica.getHostID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteReference get(int idx) {
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            if (idx < 0 || idx >= this.replicas.size()) {
                return null;
            }
            return this.replicas.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteReference getPrimary() {
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            if (this.replicas.isEmpty()) {
                return null;
            }
            return this.replicas.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            this.replicas.clear();
            this.version = new Version(0L);
            this.clearHostToReplicaMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(RemoteReference ref) {
        Debug.assertion(ref != null);
        if (ref.getHostID().isLocal()) {
            this.localRef = null;
        }
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            this.replicas.remove(ref);
            if (this.hostToReplicaMap != null) {
                HostID replicaHost = ref.getHostID();
                this.hostToReplicaMap.remove(replicaHost);
            }
            this.version.removeServer(ref.getHostID());
            int sizeOfReplicas = this.replicas.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteReference removeOne(HostID id) {
        if (id.isLocal()) {
            this.localRef = null;
        }
        int sizeOfReplicas = 1;
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            ListIterator<RemoteReference> it = this.replicas.listIterator();
            while (it.hasNext()) {
                RemoteReference replica = it.next();
                if (!replica.getHostID().equals(id)) continue;
                it.remove();
                sizeOfReplicas = this.replicas.size();
                if (this.hostToReplicaMap != null) {
                    this.hostToReplicaMap.remove(id);
                }
                this.version.removeServer(replica.getHostID());
                return replica;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator iterator() {
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            return this.replicas.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteReference[] toArray() {
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            return this.replicas.toArray(new RemoteReference[this.replicas.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteReference findReplicaHostedBy(HostID hostID) {
        RemoteReference replica;
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            replica = this.getHostToReplicaMap().get(hostID);
            if (replica == null) {
                replica = this.findAndCacheReplica(hostID);
            }
        }
        if (replica != null && !replica.getHostID().equals(hostID)) {
            throw new AssertionError((Object)("host ID of new replica (" + replica.getHostID() + ") must equal " + hostID));
        }
        return replica;
    }

    private RemoteReference findAndCacheReplica(HostID hostID) {
        for (RemoteReference replica : this.replicas) {
            if (!hostID.equals(replica.getHostID())) continue;
            this.getHostToReplicaMap().put(hostID, replica);
            return replica;
        }
        return null;
    }

    private Map<HostID, RemoteReference> getHostToReplicaMap() {
        if (this.hostToReplicaMap == null) {
            this.hostToReplicaMap = new HashMap<HostID, RemoteReference>(5);
        }
        return this.hostToReplicaMap;
    }

    @Override
    public void reset(ReplicaList newList) {
        this.resetInternal(newList, true);
    }

    @Override
    public void resetWithoutShuffle(ReplicaList newList) {
        this.resetInternal(newList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInternal(ReplicaList newList, boolean shuffle) {
        if (newList instanceof BasicReplicaList) {
            Version tempVersion;
            ArrayList tempReplicas;
            BasicReplicaList list = (BasicReplicaList)newList;
            Debug.assertion(list.size() > 0);
            BasicReplicaList basicReplicaList = list;
            synchronized (basicReplicaList) {
                tempReplicas = (ArrayList)list.replicas.clone();
                tempVersion = new Version(list.version.getVersion());
            }
            if (shuffle) {
                Collections.shuffle(tempReplicas);
            }
            basicReplicaList = this;
            synchronized (basicReplicaList) {
                this.replicas = tempReplicas;
                this.version = tempVersion;
                this.clearHostToReplicaMap();
            }
        }
        throw new AssertionError((Object)"reset() called with foreign ReplicaList");
    }

    protected final void clearHostToReplicaMap() {
        if (this.hostToReplicaMap != null) {
            this.hostToReplicaMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        BasicReplicaList basicReplicaList = this;
        synchronized (basicReplicaList) {
            if (this.replicas.size() > 0) {
                Iterator<RemoteReference> it = this.replicas.iterator();
                while (it.hasNext()) {
                    RemoteReference ref = it.next();
                    buf.append(ref.getHostID());
                    buf.append("/").append(ref.getObjectID());
                    if (!it.hasNext()) continue;
                    buf.append(", ");
                }
            }
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        try {
            BasicReplicaList basicReplicaList = this;
            synchronized (basicReplicaList) {
                return super.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"impossible exception"))).initCause(e));
        }
    }

    @Override
    public ReplicaList getListWithRefHostedBy(HostID hostID) {
        RemoteReference ref = this.findReplicaHostedBy(hostID);
        return ref != null ? new BasicReplicaList(ref) : this;
    }

    public BasicReplicaList() {
        this.initialize();
    }

    private void initialize() {
        this.replicas = new ArrayList(1);
        this.version = new Version(0L);
    }

    @Override
    public boolean isReplicaVersionChanged() {
        return this.replicaVersion != null && this.replicaVersion.hasVersionChanged();
    }

    @Override
    public ReplicaVersion getReplicaVersion() {
        return this.replicaVersion;
    }

    @Override
    public void setReplicaVersion(ReplicaVersion rv) {
        if (this.replicaVersion == null) {
            this.replicaVersion = rv;
            return;
        }
        this.replicaVersion.copy(rv);
    }

    @Override
    public void setReplicaID(ReplicaID id) {
        this.replicaID = id;
    }

    @Override
    public ReplicaID getReplicaID() {
        return this.replicaID;
    }

    private boolean doesPeerSupportReplicaID(Object o) {
        return ReplicaVersion.doesPeerSupportReplicaVersion(o);
    }

    private boolean isPeerInfoable(Object o) {
        return o instanceof PeerInfoable;
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        if (out instanceof WLObjectOutput) {
            ServerChannel sc;
            ArrayList<RemoteReference> clone = this.replicas;
            if (filterReplicaOnChannel && RJVMEnvironment.getEnvironment().isServer() && out instanceof ServerChannelStream && (sc = ((ServerChannelStream)((Object)out)).getServerChannel()) != null && sc.getChannelName() != null && !sc.getChannelName().startsWith("Default")) {
                clone = this.filterReplicaListOnChannel(this.replicas, sc.getChannelName());
            }
            WLObjectOutput wlOut = (WLObjectOutput)out;
            wlOut.writeArrayList(clone);
            wlOut.writeLong(this.version.getVersion());
        } else {
            out.writeObject(this.replaceReplicaList(this.replicas));
            out.writeLong(this.version.getVersion());
        }
        if (this.doesPeerSupportReplicaID(out) || !this.isPeerInfoable(out)) {
            out.writeObject(this.replicaID);
            out.writeObject(this.replicaVersion);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        block11: {
            this.replicaID = null;
            if (in instanceof WLObjectInput) {
                WLObjectInput wlIn = (WLObjectInput)in;
                if (enableQOSOnStub && wlIn instanceof ServerChannelStream) {
                    Protocol protocol = ((ServerChannelStream)((Object)wlIn)).getServerChannel().getProtocol();
                    ProtocolStack.push(protocol);
                    this.replicas = wlIn.readArrayList();
                    ProtocolStack.pop();
                } else {
                    this.replicas = wlIn.readArrayList();
                }
                this.version = new Version(wlIn.readLong());
            } else {
                this.replicas = (ArrayList)in.readObject();
                this.version = new Version(in.readLong());
                this.replicas = this.resolveReplicaList(this.replicas);
            }
            if (this.doesPeerSupportReplicaID(in)) {
                this.replicaID = (ReplicaID)in.readObject();
                this.replicaVersion = (ReplicaVersion)in.readObject();
            } else if (!this.isPeerInfoable(in)) {
                try {
                    this.replicaID = (ReplicaID)in.readObject();
                    this.replicaVersion = (ReplicaVersion)in.readObject();
                }
                catch (IOException e) {
                    this.replicaID = null;
                    if (in instanceof WLObjectInput) {
                        if (debugDetailCluster.isDebugEnabled()) {
                            debugDetailCluster.debug("BasicReplicaList.readExternal() read ReplicaID got exception: " + e);
                        }
                    }
                    if (!debugCluster.isDebugEnabled()) break block11;
                    debugCluster.debug("BasicReplicaList.readExternal() read ReplicaID got exception: " + e);
                }
            }
        }
    }

    private ArrayList replaceReplicaList(ArrayList<RemoteReference> list) throws IOException {
        if (!KernelStatus.isServer()) {
            return list;
        }
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<RemoteReference> newList = new ArrayList<RemoteReference>(list.size());
        for (RemoteReference reference : list) {
            newList.add((RemoteReference)RemoteObjectReplacer.getReplacer().replaceObject(reference));
        }
        return newList;
    }

    private ArrayList<RemoteReference> resolveReplicaList(ArrayList<RemoteReference> list) throws IOException {
        if (!KernelStatus.isServer()) {
            return list;
        }
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<RemoteReference> newList = new ArrayList<RemoteReference>(list.size());
        for (RemoteReference reference : list) {
            newList.add((RemoteReference)RemoteObjectReplacer.getReplacer().resolveObject(reference));
        }
        return newList;
    }

    ArrayList<RemoteReference> filterReplicaListOnChannel(ArrayList<RemoteReference> list, String channelName) throws IOException {
        ArrayList clone = (ArrayList)list.clone();
        for (int i = 0; i < clone.size(); ++i) {
            RemoteReference r = (RemoteReference)clone.get(i);
            if (this.hasSameChannel(r.getHostID(), channelName)) continue;
            clone.remove(i);
            --i;
        }
        return clone;
    }

    boolean hasSameChannel(HostID hostID, String channelName) {
        return ServerChannelManager.findServerChannel(hostID, channelName) != null;
    }

    static {
        String setQOSOnStub;
        filterReplicaOnChannel = Boolean.getBoolean("weblogic.rmi.t3.replicaList.customChannel.excludeDefaultChannels");
        debugCluster = DebugLogger.getDebugLogger("DebugCluster");
        debugDetailCluster = DebugLogger.getDebugLogger("DebugClusterVerbose");
        enableQOSOnStub = true;
        if (!KernelStatus.isApplet() && (setQOSOnStub = System.getProperty("weblogic.t3.setQOSOnStub")) != null) {
            enableQOSOnStub = !setQOSOnStub.equalsIgnoreCase("false");
        }
    }
}

