/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.wls;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessControlException;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.net.http.CompatibleSOAPHttpsURLConnection;
import weblogic.net.http.HttpURLConnection;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.http.HTTPClientConnectionFactory;
import weblogic.rjvm.http.client.HTTPSClientConnectionFactory;
import weblogic.rjvm.t3.client.ConnectionFactoryT3;
import weblogic.rjvm.t3.client.ConnectionFactoryT3S;
import weblogic.rjvm.t3.client.ProtocolHandlerHTTP;
import weblogic.rjvm.t3.client.ProtocolHandlerHTTPS;
import weblogic.rjvm.t3.client.ProtocolHandlerT3;
import weblogic.rjvm.t3.client.ProtocolHandlerT3S;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.URLClassFinder;
import weblogic.utils.io.ChunkedObjectInputStream;
import weblogic.utils.io.ChunkedObjectOutputStream;

public class WLSClientRJVMEnvironment
extends RJVMEnvironment {
    private static final String INTERNAL_CONTEXT_PATH = "/bea_wls_internal";
    private AuditableThreadLocal sslContextThreadLocal = AuditableThreadLocalFactory.createThreadLocal();

    @Override
    public void ensureInitialized() {
        Kernel.ensureInitialized();
    }

    @Override
    public int getHeartbeatIdlePeriodsUntilTimeout() {
        return Kernel.getConfig().getIdlePeriodsUntilTimeout();
    }

    @Override
    public int getHeartbeatPeriodLengthMillis() {
        return Kernel.getConfig().getPeriodLength();
    }

    @Override
    public int getAbbrevTableSize() {
        return Kernel.getConfig().getT3ClientAbbrevTableSize();
    }

    @Override
    public boolean isTracingEnabled() {
        return Kernel.isTracingEnabled();
    }

    @Override
    public int getRjvmIdleTimeout() {
        return Kernel.getConfig().getRjvmIdleTimeout();
    }

    @Override
    public String getDefaultProtocolName() {
        return Kernel.getConfig().getDefaultProtocol();
    }

    @Override
    public String getDefaultSecureProtocolName() {
        return Kernel.getConfig().getDefaultSecureProtocol();
    }

    @Override
    public String getAdminProtocolName() {
        return Kernel.getConfig().getAdministrationProtocol();
    }

    @Override
    public Class resolveProxyClass(String[] interfaces, String annotation, String codeBase) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Class[] intClasses = new Class[interfaces.length];
        GenericClassLoader gcl = null;
        for (int inc = 0; inc < interfaces.length; ++inc) {
            try {
                intClasses[inc] = cl.loadClass(interfaces[inc]);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                if (!RMIEnvironment.getEnvironment().isNetworkClassLoadingEnabled()) {
                    throw cnfe;
                }
                if (gcl == null) {
                    gcl = WLSClientRJVMEnvironment.createNetworkLoader(cl, annotation, codeBase);
                }
                intClasses[inc] = WLSClientRJVMEnvironment.loadFromNetwork(gcl, interfaces[inc], annotation, codeBase);
                cl = intClasses[inc].getClassLoader();
            }
        }
        return Proxy.getProxyClass(cl, intClasses);
    }

    @Override
    public Class resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
        throw new AssertionError((Object)"It is not supported");
    }

    private static GenericClassLoader createNetworkLoader(ClassLoader cl, String annotation, String codeBase) {
        ClassFinder finder = WLSClientRJVMEnvironment.getNetworkFinder(annotation, codeBase);
        GenericClassLoader gcl = AugmentableClassLoaderManager.getAugmentableClassLoader(cl);
        gcl.addClassFinderFirst(finder);
        gcl.setAnnotation(new Annotation(annotation));
        return gcl;
    }

    private static ClassFinder getNetworkFinder(String annotation, String codeBase) {
        String url = annotation != null && annotation.length() > 0 ? codeBase + annotation + "/" : codeBase;
        return new URLClassFinder(url);
    }

    private static Class loadFromNetwork(GenericClassLoader gcl, String className, String annotationString, String codeBase) throws ClassNotFoundException {
        if (className.indexOf("java.lang.") > -1) {
            return null;
        }
        try {
            return Class.forName(className, true, gcl);
        }
        catch (AccessControlException ace) {
            try {
                return RMIClassLoader.loadClass(codeBase, className);
            }
            catch (MalformedURLException mue) {
                throw new ClassNotFoundException(mue.toString(), mue);
            }
        }
    }

    @Override
    public Object copyObject(Object target) throws IOException, ClassNotFoundException {
        ChunkedObjectOutputStream objOut = new ChunkedObjectOutputStream();
        objOut.setReplacer(RemoteObjectReplacer.getReplacer());
        objOut.writeObject(target);
        objOut.close();
        ChunkedObjectInputStream objIn = new ChunkedObjectInputStream(objOut.getChunks(), 0);
        objIn.setReplacer(RemoteObjectReplacer.getReplacer());
        return objIn.readObject();
    }

    @Override
    public void registerRJVMProtocols() {
        RJVMManager.registerRJVMProtocol((byte)0, ProtocolHandlerT3.getProtocolHandler(), new ConnectionFactoryT3());
        RJVMManager.registerRJVMProtocol((byte)2, ProtocolHandlerT3S.getProtocolHandler(), new ConnectionFactoryT3S());
        RJVMManager.registerRJVMProtocol((byte)1, ProtocolHandlerHTTP.getProtocolHandler(), new HTTPClientConnectionFactory());
        RJVMManager.registerRJVMProtocol((byte)3, ProtocolHandlerHTTPS.getProtocolHandler(), new HTTPSClientConnectionFactory());
    }

    @Override
    public String getInternalWebAppContextPath() {
        return INTERNAL_CONTEXT_PATH;
    }

    @Override
    public ServerChannel createDefaultChannel(Protocol protocol) {
        return null;
    }

    @Override
    public boolean isLocalChannel(InetAddress address, int port) {
        return false;
    }

    @Override
    public String createClusterURL(ServerChannel channel) {
        throw new AssertionError((Object)"Clustering is not supported");
    }

    @Override
    public void invokeBootService(RemoteInvokable ri, MsgAbbrevInputStream input) throws RemoteException {
        throw new NoSuchObjectException("T3 Boot Services not implemented");
    }

    @Override
    public boolean isServerClusteringSupported() {
        return true;
    }

    @Override
    public ClassLoader getConnectionManagerClassLoader() {
        return KernelStatus.class.getClassLoader();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public Object getSSLContext() {
        return this.sslContextThreadLocal.get();
    }

    @Override
    public void setSSLContext(Object sslContext) {
        this.sslContextThreadLocal.set(sslContext);
    }

    @Override
    public boolean isUserAnonymous(AuthenticatedSubject subject) {
        return SubjectUtils.isUserAnonymous(subject);
    }

    @Override
    public URLConnection createURLConnection(URL u, ServerChannel networkChannel) throws IOException {
        URLConnection conn = u.openConnection();
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).u11();
        } else if (KernelStatus.isServer() && conn instanceof CompatibleSOAPHttpsURLConnection) {
            ((CompatibleSOAPHttpsURLConnection)conn).u11();
        }
        return conn;
    }

    @Override
    public RJVM getRJVM(byte targetQOS, HostID hostID) throws IOException {
        return null;
    }
}

