/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm.http;

import java.io.IOException;
import java.net.InetAddress;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.RJVMConnectionFactory;
import weblogic.rjvm.http.HTTPClientJVMConnection;
import weblogic.work.WorkManagerFactory;

public class HTTPClientConnectionFactory
implements RJVMConnectionFactory {
    @Override
    public MsgAbbrevJVMConnection createConnection(String host, InetAddress address, int port, ServerChannel networkChannel, JVMID destinationJVMID, int connectionTimeout) throws IOException {
        return this.createConnection(host, address, port, networkChannel, destinationJVMID, connectionTimeout, "http://" + address.getHostName() + ':' + port);
    }

    @Override
    public MsgAbbrevJVMConnection createConnection(String host, InetAddress address, int port, ServerChannel networkChannel, JVMID destinationJVMID, int connectionTimeout, String partitionUrl) throws IOException {
        HTTPClientJVMConnection connection = new HTTPClientJVMConnection(networkChannel, partitionUrl);
        if (destinationJVMID.shouldUseProxy()) {
            connection.setHostAddress(destinationJVMID.getHostAddress());
        }
        connection.connect(host, address, port, connectionTimeout);
        WorkManagerFactory.getInstance().getSystem().schedule(connection);
        return connection;
    }
}

