/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.UnmarshalException;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import weblogic.common.WLObjectInput;
import weblogic.common.internal.PeerInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneException;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.Response;
import weblogic.rmi.cluster.PiggybackResponse;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.ObjectIO;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.MsgInput;
import weblogic.utils.StackTraceUtils;
import weblogic.workarea.WorkContextHelper;

public class ResponseImpl
implements Response,
PeerGoneListener,
InboundResponse {
    private static final DebugLogger debugMessaging = DebugLogger.getDebugLogger("DebugMessaging");
    private int id;
    private WLObjectInput msg;
    private Throwable t;
    private Object txContext;
    private final RuntimeMethodDescriptor md;
    private RJVM rjvm;
    private WLObjectInput msgThrowable = null;
    private int timeout;
    private final Lock lock = new ReentrantLock();
    private final Condition lockCondition = this.lock.newCondition();
    private boolean isThreadLocalContextRetrieved;
    private static final String JNDI_RESPONSE_READ_TIMEOUT = "weblogic.jndi.responseReadTimeout";
    private static final String JNDI_RESPONSE_READ_TIMEOUT_DEPRECATED = "weblogic.rmi.clientTimeout";
    private static final long RJVM_HEALTH_CHECK_INTERVAL = 60000L;
    private static boolean lostPeerGoneTestEnabled = Boolean.getBoolean("weblogic.rjvm.test.CreateConsumerLostPeerGoneTest");

    private static boolean isLostPeerGoneTest() {
        if (lostPeerGoneTestEnabled) {
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            Exception ee = new Exception();
            ee.printStackTrace(new PrintStream(ostr));
            if (ostr.toString().contains("FEConsumer.<init>")) {
                System.out.println(new Date().toString() + " <" + Thread.currentThread().getName() + "> ResponseImpl Thread contains FEConsumer.<init> \n " + ostr);
                return true;
            }
        }
        return false;
    }

    public ResponseImpl(RJVM rjvm, int timeout, RuntimeMethodDescriptor md) {
        int envTimeout = this.getResponseReadTimeout();
        this.timeout = envTimeout != 0 ? envTimeout : timeout;
        this.md = md;
        this.rjvm = rjvm;
    }

    int getTimeout() {
        return this.timeout;
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public final int hashCode() {
        return this.id;
    }

    public final String toString() {
        return "weblogic.rjvm.ResponseImpl - id: '" + this.id + '\'';
    }

    public void notify(WLObjectInput msg) {
        this.lock.lock();
        try {
            this.msg = msg;
            this.lockCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyError(WLObjectInput msgThrowable) {
        this.lock.lock();
        try {
            this.msgThrowable = msgThrowable;
            this.lockCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notify(Throwable t) {
        this.lock.lock();
        try {
            this.t = t;
            this.lockCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForData() {
        String originalThreadName = null;
        try {
            if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                originalThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName(originalThreadName + " [waiting for " + this.rjvm.getID().toString() + "]");
            }
            this.waitForDataInternal();
            if (originalThreadName != null) {
                Thread.currentThread().setName(originalThreadName);
            }
        }
        catch (Throwable throwable) {
            if (originalThreadName != null) {
                Thread.currentThread().setName(originalThreadName);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDataInternal() {
        boolean removePendingResponse = false;
        if (ResponseImpl.isLostPeerGoneTest() && !this.rjvm.isDead()) {
            System.out.println(new Date().toString() + " <" + Thread.currentThread().getName() + "> ResponseImpl.waitForDataInternal() OUTSIDE lock " + this + " timeToWait: " + this.timeout + " rjvm " + this.rjvm + " isDead: " + this.rjvm.isDead() + " CREATE CONSUMER PEER GONE TEST, BLOCK FOR 3 MINUTES ");
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println(new Date().toString() + " <" + Thread.currentThread().getName() + "> ResponseImpl.waitForDataInternal() " + this + " WAKEUP FROM PEER GONE TEST SLEEP,  isDead " + this.rjvm.isDead());
        }
        this.lock.lock();
        try {
            long timeToWait = this.timeout;
            boolean waitNoTimeout = false;
            if (this.timeout == 0) {
                waitNoTimeout = true;
            }
            while (!this.isAvailable() && !this.rjvm.isDead()) {
                try {
                    boolean isTimedOut = false;
                    long startTime = System.currentTimeMillis();
                    if (waitNoTimeout) {
                        timeToWait = 60000L;
                    }
                    this.lockCondition.await(timeToWait, TimeUnit.MILLISECONDS);
                    if (this.timeout > 0) {
                        long timeWaited = System.currentTimeMillis() - startTime;
                        if (timeWaited >= timeToWait) {
                            isTimedOut = true;
                        } else {
                            timeToWait -= timeWaited;
                        }
                    }
                    if (this.isAvailable() || !isTimedOut) continue;
                    this.t = new RequestTimeoutException("RJVM response from '" + this.rjvm + "' for '" + (this.md != null ? this.md.toString() : "null") + "' timed out after: " + this.timeout + "ms.");
                    RJVMLogger.logRequestTimeout(this.id, this.t.getMessage());
                    removePendingResponse = true;
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!this.isAvailable() && this.rjvm.isDead()) {
            this.t = new UnmarshalException("RJVM is already shutdown, Missed Peer Gone: " + this.rjvm.getID());
            RJVMLogger.logDebug("ResponseImpl rjvm isDead, notification never occured, handle missed peer gone " + this.rjvm);
            removePendingResponse = true;
        }
        if (removePendingResponse) {
            RJVMLogger.logDebug("ResponseImpl removePendingResponse: " + this.id);
            this.rjvm.removePendingResponse(this.id);
        }
    }

    final void setTxContext(Object aTxContext) {
        this.txContext = aTxContext;
    }

    @Override
    public final Object getTxContext() {
        this.waitForData();
        return this.txContext;
    }

    public final boolean hasTxContext() {
        return this.txContext != null;
    }

    @Override
    public Object getContext(int id) throws IOException {
        this.waitForData();
        MsgAbbrevInputStream mais = (MsgAbbrevInputStream)(this.msgThrowable != null ? this.msgThrowable : this.msg);
        return mais.getContext(id);
    }

    @Override
    public void retrieveThreadLocalContext() throws IOException {
        this.retrieveThreadLocalContext(true);
    }

    @Override
    public void retrieveThreadLocalContext(boolean forceReset) throws IOException {
        if (this.isThreadLocalContextRetrieved) {
            return;
        }
        this.waitForData();
        MsgAbbrevInputStream mais = (MsgAbbrevInputStream)(this.msgThrowable != null ? this.msgThrowable : this.msg);
        if (mais == null) {
            return;
        }
        if (mais.getMessageHeader().getFlag(16)) {
            mais.readExtendedContexts();
            this.isThreadLocalContextRetrieved = true;
        }
        if (forceReset && mais.getPeerInfo() != null && mais.getPeerInfo().getMajor() >= PeerInfo.VERSION_DIABLO.getMajor() && !mais.hasContext(5)) {
            WorkContextHelper.getWorkContextHelper().getInterceptor().receiveResponse(null);
        }
    }

    @Override
    public final Throwable getThrowable() {
        this.waitForData();
        if (this.msgThrowable != null && this.t == null) {
            try {
                this.t = (Throwable)this.msgThrowable.readObject();
            }
            catch (IOException ioe) {
                this.t = new UnmarshalException("Problem deserializing error response", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                this.t = new UnmarshalException("Problem finding error class", cnfe);
            }
            finally {
                try {
                    this.msgThrowable.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this.t instanceof PeerGoneException && RMIEnvironment.getEnvironment().printExceptionStackTrace()) {
            this.t.fillInStackTrace();
        }
        return this.t;
    }

    @Override
    public final WLObjectInput getMsg() {
        this.waitForData();
        return this.msg;
    }

    @Override
    public final boolean isAvailable() {
        if (ResponseImpl.isLostPeerGoneTest()) {
            return false;
        }
        return this.msg != null || this.msgThrowable != null || this.t != null;
    }

    @Override
    public void peerGone(PeerGoneEvent e) {
        this.notify(e.getReason());
    }

    @Override
    public final MsgInput getMsgInput() {
        return (MsgInput)((Object)this.getMsg());
    }

    @Override
    public Object unmarshalReturn() throws Throwable {
        this.retrieveThreadLocalContext();
        Throwable throwable = this.getThrowable();
        if (throwable != null) {
            if (RMIEnvironment.getEnvironment().printExceptionStackTrace()) {
                throw StackTraceUtils.getThrowableWithCause(throwable);
            }
            throw StackTraceUtils.getThrowableWithCauseAndNoStack(throwable);
        }
        Class returnType = this.md.getReturnType();
        short returnTypeCode = this.md.getReturnTypeAbbrev();
        try {
            return ObjectIO.readObject(this.getMsgInput(), returnType, returnTypeCode);
        }
        catch (IOException ioe) {
            throw new UnmarshalException("failed to unmarshal return type: " + returnType, ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnmarshalException("failed to load return type: " + returnType, cnfe);
        }
    }

    @Override
    public final PiggybackResponse getReplicaInfo() throws IOException {
        try {
            return (PiggybackResponse)this.getMsgInput().readObject(Object.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
    }

    @Override
    public final Object getActivatedPinnedRef() throws IOException {
        try {
            return this.getMsgInput().readObject(Object.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
    }

    @Override
    public final void close() {
        if (this.msg != null) {
            try {
                this.msg.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int getResponseReadTimeout() {
        Object o;
        Hashtable ht = RMIEnvironment.getEnvironment().getFromThreadLocalMap();
        if (ht == null) {
            Object env = RMIEnvironment.getEnvironment().threadEnvironmentGet();
            if (env == null) {
                return 0;
            }
            ht = RMIEnvironment.getEnvironment().getProperties(env);
            if (ht == null) {
                return 0;
            }
        }
        if ((o = ht.get(JNDI_RESPONSE_READ_TIMEOUT)) == null) {
            o = ht.get(JNDI_RESPONSE_READ_TIMEOUT_DEPRECATED);
        }
        long result = o == null ? 0L : (o instanceof String ? Long.parseLong((String)o) : (Long)o);
        return (int)result;
    }
}

