/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerIdentityManager;
import weblogic.rjvm.ClientServerURL;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.DisconnectMonitorImpl;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.LocalRJVM;
import weblogic.rjvm.LocalRemoteJVM;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneException;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.ProxyManager;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMConnectionFactory;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMImpl;
import weblogic.rjvm.RJVMLogger;
import weblogic.rmi.extensions.DisconnectMonitorList;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.EndPointFinder;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;

public final class RJVMManager
implements PeerGoneListener,
EndPointFinder {
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("DebugConnection");
    private static boolean protocolRegistry = RJVMManager.ensureInitialized();
    private static final int MAX_PROTOCOLS = 32;
    private static ProtocolHolder[] rjvmProtocols;
    private static final int MILLISECOND = 1000;
    private static final AuthenticatedSubject kernelId;
    private ConcurrentHashMap<ServerIdentity, Long> rjvmConnectionTimeoutMapping = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> lockTable = new ConcurrentHashMap();
    private static boolean cacheOnConnectAddress;
    private static boolean allowUnknownHost;
    private RJVMScavenger rjvmScav;
    private ProxyManager proxyManager;
    private final ConcurrentHashMap<Object, RJVM> table = new ConcurrentHashMap();
    private final ConcurrentHashMap<SynonymCacheKey, SynonymCacheValue> synonymCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<SynonymCacheKey, RJVM> rjvmCache = new ConcurrentHashMap();
    private String adminID;

    public static RJVMManager getRJVMManager() {
        return SingletonMaker.rjvmManager;
    }

    public final void initialize() {
        RJVMEnvironment.getEnvironment().ensureInitialized();
        int idleTimeoutPeriod = RJVMEnvironment.getEnvironment().getRjvmIdleTimeout();
        if (idleTimeoutPeriod > 0) {
            this.rjvmScav = new RJVMScavenger(idleTimeoutPeriod);
            TimerManagerFactory.getTimerManagerFactory().getTimerManager("RJVMHeartbeats", "weblogic.kernel.System").schedule((TimerListener)this.rjvmScav, 1000L, 1000L);
        }
    }

    static boolean ensureInitialized() {
        rjvmProtocols = new ProtocolHolder[32];
        RJVMEnvironment.getEnvironment().registerRJVMProtocols();
        return true;
    }

    public static RJVM getLocalRJVM() {
        return LocalRJVM.getLocalRJVM();
    }

    private RJVMManager() {
        RMIRuntime.getRMIRuntime().addEndPointFinder(this);
        DisconnectMonitorList dml = DisconnectMonitorListImpl.getDisconnectMonitorList();
        dml.addDisconnectMonitor(new DisconnectMonitorImpl());
        this.proxyManager = ProxyManager.getProxyManager();
    }

    public RJVM findOrCreate(JVMID id) {
        return this.findOrCreateInternal(id, true);
    }

    public RJVM find(JVMID id) {
        return this.findOrCreateInternal(id, false);
    }

    RJVMImpl findRemote(JVMID id) {
        return (RJVMImpl)this.findOrCreateInternal(id, false);
    }

    RJVMImpl findRemoteForRouting(JVMID id) {
        RJVMImpl result = this.findRemote(id);
        if (result == null) {
            result = this.findRemote(JVMID.createForRouteMsgOnly(id));
        }
        return result;
    }

    RJVMImpl findOrCreateRemote(JVMID id) {
        return (RJVMImpl)this.findOrCreateInternal(id, true);
    }

    public RJVM findOrCreate(InetAddress address, int port, String protocol, String channelName, int connectionTimeout, String partitionUrl) throws IOException {
        return this.findOrCreate(address.getCanonicalHostName(), address, port, protocol, channelName, connectionTimeout, partitionUrl);
    }

    public RJVM findOrCreate(String host, InetAddress address, int port, String protocol, String channelName, int connectionTimeout, String partitionUrl) throws IOException {
        return this.findOrCreateRemoteInternal(host, address, port, protocol, channelName, connectionTimeout, partitionUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RJVM record(RJVM rjvm, InetAddress address, int port, ServerChannel channel) {
        int remotePort;
        JVMID id = rjvm.getID();
        InetAddress canonicalAddress = id.address(allowUnknownHost);
        ClientServerURL proxyURL = this.proxyManager.find(id);
        if (proxyURL != null) {
            id.setProxyURL(proxyURL);
        } else if (JVMID.isDummyAddress(canonicalAddress)) {
            return rjvm;
        }
        int n = remotePort = channel == null ? port : id.getPort(channel.getProtocol());
        if (cacheOnConnectAddress) {
            if (address != null) {
                this.rjvmCache.put(new SynonymCacheKey(address, port), rjvm);
            }
        } else if (!JVMID.isDummyAddress(address) && (address != null && !address.equals(canonicalAddress) || address != null && port != remotePort)) {
            this.synonymCache.put(new SynonymCacheKey(address, port), new SynonymCacheValue(canonicalAddress, port != remotePort ? remotePort : port));
        }
        if (!rjvm.isDead()) {
            if (id.shouldUseProxy()) {
                this.proxyManager.putRJVM(id, rjvm);
            } else {
                ConcurrentHashMap<Object, RJVM> concurrentHashMap = this.table;
                synchronized (concurrentHashMap) {
                    this.table.put(id.identityWithChannel(), rjvm);
                }
            }
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("RJVMs: [" + this.table.size() + ']');
        }
        return rjvm;
    }

    public RJVM findRemoteRJVM(InetAddress address, int port, String protocolName) throws IOException {
        return this.findRemoteRJVM(address, port, protocolName, null);
    }

    RJVM findRemoteRJVM(InetAddress address, int port, String protocolName, String host) throws IOException {
        Protocol protocol = ProtocolManager.getProtocolByName(protocolName);
        if (protocol.isUnknown()) {
            throw new UnknownHostException("Unknown protocol: '" + protocolName + '\'');
        }
        ServerChannel channel = ServerChannelManager.findOutboundServerChannel(protocol, null);
        if (channel == null) {
            throw new AssertionError((Object)("Could not find outbound channel for: " + protocol));
        }
        return this.findExisting(address, port, channel, host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RJVM findOrCreateRemoteInternal(String host, InetAddress address, int port, String protocolName, String channelName, int connectionTimeout, String partitionURL) throws IOException {
        Object lock;
        ServerChannel channel;
        AuthenticatedSubject subject;
        Protocol protocol = ProtocolManager.getProtocolByName(protocolName);
        if (protocol.isUnknown()) {
            throw new UnknownHostException("Unknown protocol: '" + protocolName + '\'');
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("[RJVMManager.findOrCreateRemoteInternal] address = " + address + ", port = " + port + ", protocolName = " + protocolName + ", partitionURL = " + partitionURL);
        }
        if (RJVMEnvironment.getEnvironment().isServer() && (subject = SecurityServiceManager.getCurrentSubject(kernelId)) != null && !protocol.isSatisfactoryQOS(subject.getQOS())) {
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("[RJVMManager.findOrCreateRemoteInternal] subject = " + subject + ", subject.getQOS = " + subject.getQOS() + ", protocol.isSatisfactoryQOS(subject.getQOS()) = " + protocol.isSatisfactoryQOS(subject.getQOS()));
            }
            if (!protocol.equals(ProtocolManager.getDefaultAdminProtocol())) {
                throw new ConnectException("Cannot use outbound protocol \"" + protocol + "\", it does not have administrator privileges");
            }
            protocol = ProtocolHandlerAdmin.PROTOCOL_ADMIN;
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("[RJVMManager.findOrCreateRemoteInternal] - setting protocol to admin");
            }
        }
        if ((channel = ServerChannelManager.findOutboundServerChannel(protocol, channelName)) == null) {
            throw new AssertionError((Object)("Could not find outbound channel for: " + protocol + ", " + channelName + ", partitionURL = " + partitionURL));
        }
        RJVM res = this.findExisting(address, port, channel, host);
        if (res != null) {
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("[RJVMManager.findOrCreateRemoteInternal] - Found an existing RJVM for URL : " + partitionURL);
            }
            return res;
        }
        Object object = this;
        synchronized (object) {
            String lockKey = channel.getChannelName() + address.toString() + port;
            lock = this.lockTable.putIfAbsent(lockKey, new Object());
            if (lock == null) {
                lock = this.lockTable.get(lockKey);
            }
        }
        object = lock;
        synchronized (object) {
            res = this.findExisting(address, port, channel, host);
            if (res != null) {
                return res;
            }
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("[RJVMManager.findOrCreateRemoteInternal] - Bootstrapping connection to: '" + address + ':' + port + "' using: '" + protocol + '\'' + " partitionURL: " + partitionURL);
            }
            ConnectionManager bootstrapConMan = ConnectionManager.create(null);
            RJVMImpl rjvm = bootstrapConMan.bootstrap(host, address, port, channel, connectionTimeout, null, partitionURL);
            return this.record(rjvm, address, port, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RJVM findOrCreateInternal(JVMID id, boolean create) {
        if (id.equals(JVMID.localID())) {
            return LocalRJVM.getLocalRJVM();
        }
        if (id.equals(JVMID.localRemoteID())) {
            return LocalRemoteJVM.getLocalRemoteJVM();
        }
        RJVM res = this.proxyManager.getRJVM(id);
        if (res == null) {
            res = this.table.get(id.identityWithChannel());
        }
        if (res != null && !res.isDead() || !create) {
            return res;
        }
        ConcurrentHashMap<Object, RJVM> concurrentHashMap = this.table;
        synchronized (concurrentHashMap) {
            res = this.table.get(id.identityWithChannel());
            if (res != null && !res.isDead()) {
                return res;
            }
            res = new RJVMImpl(id, LocalRJVM.getLocalRJVM().getFinder());
            this.record(res, null, -1, null);
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("Created RJVM for: '" + id.identityWithChannel().toString() + '\'' + ", " + this.toString());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RJVM findExisting(InetAddress address, int port, ServerChannel channel, String host) {
        if (cacheOnConnectAddress) {
            return this.rjvmCache.get(new SynonymCacheKey(address, port));
        }
        SynonymCacheValue synonym = this.synonymCache.get(new SynonymCacheKey(address, port));
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled() && synonym != null) {
            debugConnection.debug("Using Synonym :" + synonym + " to find the RJVM for address: " + address);
        }
        InetAddress inetAddress = address = synonym == null ? address : synonym.address;
        port = synonym == null ? port : (synonym.port != -1 ? synonym.port : port);
        RJVM rjvm = null;
        rjvm = this.proxyManager.findExistingRJVM(host);
        if (rjvm != null) {
            return rjvm;
        }
        for (RJVM r : this.table.values()) {
            JVMID id = r.getID();
            if (!id.matchAddressAndPort(address, port, channel.getProtocol(), host)) continue;
            if (rjvm == null) {
                rjvm = r;
                continue;
            }
            if (r.isDead() || r.getCreationTime() <= rjvm.getCreationTime()) continue;
            System.out.println("**DebugRJVMIssue: Take the newer one [" + r + "] (JVMID = " + r.getID() + ") and leave the older one [" + rjvm + "] (JVMID = " + rjvm.getID() + ") without peer gone");
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("Take the newer one [" + r + "] and leave the older one [" + rjvm + "] without peer gone");
            }
            rjvm = r;
        }
        if (rjvm != null && rjvm.isDead()) {
            System.out.println("**DebugRJVMIssue: got Dead RJVM in the RJVM table. (JVMID " + rjvm.getID() + ") This should never happens, So removing it from table and returning null as resiliency");
            ConcurrentHashMap<Object, RJVM> concurrentHashMap = this.table;
            synchronized (concurrentHashMap) {
                this.table.remove(rjvm.getID().identityWithChannel());
            }
            return null;
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("Found RJVM " + rjvm);
        }
        return rjvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerGone(PeerGoneEvent ev) {
        RJVM rjvm = (RJVM)ev.getSource();
        JVMID id = rjvm.getID();
        this.proxyManager.removeRJVM(id);
        ConcurrentHashMap<Object, RJVM> concurrentHashMap = this.table;
        synchronized (concurrentHashMap) {
            if (!id.shouldUseProxy()) {
                this.table.remove(id.identityWithChannel());
            }
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("RJVMs: [" + this.table.size() + ']');
            }
            if (this.adminID != null && this.adminID.equals(rjvm.getID().getDomainName() + rjvm.getID().getServerName())) {
                ServerIdentityManager.removeTransientAndPersistentIdentity(rjvm.getID());
            } else {
                ServerIdentityManager.removeIdentity(rjvm.getID());
            }
        }
    }

    private Collection<RJVM> getRJVMs() {
        ArrayList<RJVM> rjvms = new ArrayList<RJVM>();
        rjvms.addAll(this.table.values());
        rjvms.addAll(this.proxyManager.getRJVMs());
        return rjvms;
    }

    public void setAdminID(String id) {
        this.adminID = id;
    }

    public String getAdminID() {
        return this.adminID;
    }

    public void suspend() {
        IOException ioe = new IOException("Server has been suspended forcefully");
        for (RJVM r : this.getRJVMs()) {
            RJVMImpl rjvm = (RJVMImpl)r;
            JVMID id = rjvm.getID();
            if (id != null && id.equals(JVMID.localID())) continue;
            ConnectionManager cm = rjvm.findOrSetConMan(null);
            if (cm == null) {
                rjvm.peerGone(new IOException("Server has been suspended forcefully"));
                continue;
            }
            if (cm.hasAdminConnection()) continue;
            rjvm.peerGone(ioe);
        }
    }

    int getScavengeInterval() {
        return this.rjvmScav.getScavengeInterval();
    }

    @Override
    public boolean claimHostID(HostID hostID) {
        return hostID instanceof JVMID;
    }

    @Override
    public boolean claimServerURL(String url) {
        return url != null && (url.startsWith("t3") || url.startsWith("t3s"));
    }

    @Override
    public EndPoint findOrCreateEndPoint(HostID hostID) {
        if (hostID instanceof JVMID) {
            return this.findOrCreateInternal((JVMID)hostID, true);
        }
        return null;
    }

    @Override
    public EndPoint findEndPoint(HostID hostID) {
        if (hostID instanceof JVMID) {
            return this.findOrCreateInternal((JVMID)hostID, false);
        }
        return null;
    }

    @Override
    public EndPoint findOrCreateEndPoint(String url) throws IOException {
        ClientServerURL serverURL = new ClientServerURL(url);
        return serverURL.findOrCreateRJVM();
    }

    @Override
    public EndPoint findEndPoint(String url) throws IOException {
        ClientServerURL serverURL = new ClientServerURL(url);
        return serverURL.findRJVM();
    }

    public static void registerRJVMProtocol(byte protocolNum, ProtocolHandler handler, RJVMConnectionFactory factory) {
        ProtocolHolder holder;
        if (protocolNum >= 32) {
            throw new AssertionError((Object)("Invalid protocol number " + protocolNum));
        }
        RJVMManager.rjvmProtocols[protocolNum] = holder = new ProtocolHolder(handler, factory);
    }

    public RJVMConnectionFactory getConnectionFactory(byte protocolNum) {
        if (protocolNum >= 32) {
            return null;
        }
        if (rjvmProtocols[protocolNum] == null) {
            return null;
        }
        return rjvmProtocols[protocolNum].getConnectionFactory();
    }

    public ProtocolHandler getProtocolHandler(byte protocolNum) {
        if (protocolNum >= 32) {
            return null;
        }
        if (rjvmProtocols[protocolNum] == null) {
            return null;
        }
        return rjvmProtocols[protocolNum].getProtocolHandler();
    }

    public Protocol getProtocol(byte protocolNum) {
        ProtocolHandler handler = this.getProtocolHandler(protocolNum);
        if (handler == null) {
            return null;
        }
        return handler.getProtocol();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Active RJVMs:\n");
        for (Map.Entry<Object, RJVM> entry : this.table.entrySet()) {
            builder.append("Key : ").append(entry.getKey()).append("\tRJVM : ").append(entry.getValue()).append('\n');
        }
        builder.append("\nSynonyms:\n");
        for (Map.Entry<Object, Object> entry : this.synonymCache.entrySet()) {
            builder.append("Key : ").append(entry.getKey()).append('\t').append(entry.getValue()).append('\n');
        }
        return builder.toString();
    }

    protected static void p(String msg) {
        RJVMLogger.logDebug("<RJVMManager>: " + msg);
    }

    public void storeConnectionTimeout(ServerIdentity hostVM, long connectionTimeout) {
        if (hostVM != null) {
            this.rjvmConnectionTimeoutMapping.put(hostVM, connectionTimeout);
        }
    }

    public void removeConnectionTimeout(ServerIdentity hostVM) {
        if (hostVM != null) {
            this.rjvmConnectionTimeoutMapping.remove(hostVM);
        }
    }

    public Long getCachedJNDIConnectionTimeout(ServerIdentity hostVM) {
        if (hostVM != null) {
            return this.rjvmConnectionTimeoutMapping.get(hostVM);
        }
        return null;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        cacheOnConnectAddress = Boolean.getBoolean("weblogic.rjvm.cacheonconnectaddress");
        allowUnknownHost = Boolean.getBoolean("weblogic.rjvm.allowUnknownHost");
    }

    private static final class ProtocolHolder {
        private final ProtocolHandler handler;
        private final RJVMConnectionFactory connectionFactory;

        ProtocolHolder(ProtocolHandler handler, RJVMConnectionFactory factory) {
            this.handler = handler;
            this.connectionFactory = factory;
        }

        public ProtocolHandler getProtocolHandler() {
            return this.handler;
        }

        public RJVMConnectionFactory getConnectionFactory() {
            return this.connectionFactory;
        }
    }

    private static final class SynonymCacheValue
    extends InetAddressAndPort {
        SynonymCacheValue(InetAddress address, int port) {
            super(address, port);
        }

        @Override
        public boolean equals(Object key) {
            return key instanceof SynonymCacheValue && super.equals(key);
        }
    }

    private static final class SynonymCacheKey
    extends InetAddressAndPort {
        SynonymCacheKey(InetAddress address, int port) {
            super(address, port);
        }

        @Override
        public boolean equals(Object key) {
            return key instanceof SynonymCacheKey && super.equals(key);
        }
    }

    private static abstract class InetAddressAndPort {
        protected final InetAddress address;
        protected final int port;

        public InetAddressAndPort(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        public boolean equals(Object o) {
            InetAddressAndPort that = (InetAddressAndPort)o;
            return this.port == that.port && this.address.equals(that.address);
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = 31 * result + this.port;
            return result;
        }

        public String toString() {
            return "[address=" + this.address + ", port=" + this.port + ']';
        }
    }

    private static final class RJVMScavenger
    implements NakedTimerListener {
        private final int scavengeInterval;

        RJVMScavenger(int scavInterval) {
            int newScavInterval = 1;
            if (scavInterval >= 1000) {
                newScavInterval = scavInterval / 1000;
                if (scavInterval % 1000 != 0) {
                    ++newScavInterval;
                }
            }
            this.scavengeInterval = newScavInterval;
        }

        @Override
        public void timerExpired(Timer timer) {
            PeerGoneException pge = new PeerGoneException("Idle RJVM being shut down.");
            for (RJVM r : RJVMManager.getRJVMManager().getRJVMs()) {
                RJVMImpl rjvm = (RJVMImpl)r;
                ConnectionManager cm = rjvm.findOrCreateConMan();
                if (!rjvm.isScavengeable(this.scavengeInterval)) continue;
                MsgAbbrevOutputStream peerGoneMessage = cm.createPeerGoneMsg(JVMID.localID(), rjvm.getID(), cm.qosToChannel((byte)101), (byte)101);
                cm.sendMsg(peerGoneMessage);
                rjvm.peerGone(pge);
            }
        }

        int getScavengeInterval() {
            return this.scavengeInterval;
        }
    }

    private static class SingletonMaker {
        private static RJVMManager rjvmManager = new RJVMManager();

        private SingletonMaker() {
        }
    }
}

