/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.rjvm.ClientServerURL;
import weblogic.rjvm.DualKeysTable;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMLogger;

public class ProxyManager {
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("DebugConnection");
    private static final String DOMAIN_PROXY_PROPNAME_PREFIX = "weblogic.rjvm.domain.proxy.";
    private Map<String, ClientServerURL> proxyUrlMap = ProxyManager.initDomainProxyURLs();
    private ConcurrentHashMap<HostServerTableKey, RJVM> hostServerToRJVM;
    private DualKeysTable<String, RJVM> hostToRJVM;

    public static ProxyManager getProxyManager() {
        return SingletonMaker.proxyManager;
    }

    private ProxyManager() {
        if (!this.proxyUrlMap.isEmpty()) {
            this.hostServerToRJVM = new ConcurrentHashMap();
            this.hostToRJVM = new DualKeysTable();
        }
    }

    public boolean shouldUseProxy(String host) {
        return this.find(host) != null;
    }

    public boolean shouldUseProxy(JVMID jvmid) {
        return this.shouldUseProxy(ProxyManager.getOperatorHostName(jvmid));
    }

    private static String getOperatorHostName(JVMID jvmid) {
        if (jvmid == null) {
            return null;
        }
        if (jvmid.getDomainName() != null && jvmid.getServerName() != null) {
            return jvmid.getDomainName() + "-" + jvmid.getServerName();
        }
        return jvmid.getHostAddress();
    }

    static boolean matchesHostAddress(JVMID jvmid, String hostAddress) {
        if (jvmid != null && hostAddress != null) {
            return hostAddress.equals(jvmid.getHostAddress()) || hostAddress.equals(ProxyManager.getOperatorHostName(jvmid));
        }
        return false;
    }

    ClientServerURL find(JVMID jvmid) {
        return this.find(ProxyManager.getOperatorHostName(jvmid));
    }

    ClientServerURL find(String host) {
        if (host == null || this.proxyUrlMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, ClientServerURL> entry : this.proxyUrlMap.entrySet()) {
            if (!host.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    static Map<String, ClientServerURL> initDomainProxyURLs() {
        ConcurrentHashMap<String, ClientServerURL> domains2urls = new ConcurrentHashMap<String, ClientServerURL>();
        Properties sysprops = System.getProperties();
        Set<String> keys = sysprops.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(DOMAIN_PROXY_PROPNAME_PREFIX)) continue;
            String domain = key.substring(DOMAIN_PROXY_PROPNAME_PREFIX.length());
            String url = sysprops.getProperty(key);
            try {
                ClientServerURL proxyClientServerURL = new ClientServerURL(url);
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    RJVMLogger.logDebug("ProxyManager read proxy (" + domain + "-->" + url + ")");
                }
                domains2urls.put(domain, proxyClientServerURL);
            }
            catch (MalformedURLException e) {
                if (!KernelStatus.DEBUG || !debugConnection.isDebugEnabled()) continue;
                RJVMLogger.logDebug("Malformed URL '" + url + "' found in system property '" + key + "'");
            }
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("ProxyManager initialized with " + domains2urls.size() + " entries");
        }
        return domains2urls;
    }

    private boolean isEnabled() {
        return this.hostToRJVM != null;
    }

    Collection<RJVM> getRJVMs() {
        if (this.isEnabled()) {
            return new ArrayList<RJVM>(this.hostServerToRJVM.values());
        }
        return Collections.EMPTY_LIST;
    }

    RJVM getRJVM(JVMID jvmid) {
        if (!this.isEnabled() || jvmid == null) {
            return null;
        }
        RJVM result = null;
        if (jvmid.getServerName() != null) {
            result = this.hostServerToRJVM.get(HostServerTableKey.create(jvmid));
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("ProxyManager.getRJVM(jvmid=" + jvmid + ") found rjvm=" + result);
            }
        } else {
            result = this.hostToRJVM.get(jvmid.getHostAddress());
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("ProxyManager.getRJVM(hostAddress=" + jvmid.getHostAddress() + ") found rjvm=" + result);
            }
        }
        return result;
    }

    RJVM putRJVM(JVMID jvmid, RJVM rjvm) {
        if (!this.isEnabled() || !jvmid.shouldUseProxy()) {
            return null;
        }
        if (!jvmid.isRouteMsgOnly()) {
            this.hostToRJVM.put(jvmid.getHostAddress(), ProxyManager.getOperatorHostName(jvmid), rjvm);
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("ProxyManager.putRJVM(jvmid=" + jvmid + ", rjvm=" + rjvm + ")");
        }
        return this.hostServerToRJVM.put(HostServerTableKey.create(jvmid), rjvm);
    }

    RJVM findExistingRJVM(String host) {
        if (this.isEnabled() && host != null) {
            RJVM result = this.hostToRJVM.get(host);
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                RJVMLogger.logDebug("ProxyManager.findExistingRJVM(host=" + host + ") found rjvm=" + result);
            }
            return result;
        }
        return null;
    }

    RJVM removeRJVM(JVMID jvmid) {
        if (!this.isEnabled()) {
            return null;
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            RJVMLogger.logDebug("ProxyManager.removeRJVM(jvmid=" + jvmid + ")");
        }
        this.hostToRJVM.remove(jvmid.getHostAddress());
        return this.hostServerToRJVM.remove(HostServerTableKey.create(jvmid));
    }

    static class HostServerTableKey {
        private String host;
        private String serverName;
        private boolean routeMsgOnly;

        private HostServerTableKey(String host, String serverName, boolean routeMsgOnly) {
            this.host = host;
            this.serverName = serverName;
            this.routeMsgOnly = routeMsgOnly;
        }

        private static HostServerTableKey create(JVMID jvmid) {
            return new HostServerTableKey(jvmid.getHostAddress(), jvmid.getServerName(), jvmid.isRouteMsgOnly());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostServerTableKey that = (HostServerTableKey)o;
            return this.routeMsgOnly == that.routeMsgOnly && Objects.equals(this.host, that.host) && Objects.equals(this.serverName, that.serverName);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.serverName, this.routeMsgOnly);
        }
    }

    static class SingletonMaker {
        private static ProxyManager proxyManager = new ProxyManager();

        SingletonMaker() {
        }
    }
}

