/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.util.HashSet;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.rjvm.ConnectionManager;

public class PartitionEventInterceptor
implements NotificationListener {
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("PartitionEventInterceptor");
    private static MBeanServer server;
    private static ObjectName partitionMB;
    private final ConnectionManager manager;

    protected PartitionEventInterceptor(ConnectionManager manager) {
        block7: {
            if (debugConnection.isDebugEnabled()) {
                debugConnection.debug("PartitionEvenInterceptor.<init> is called. " + this);
            }
            this.manager = manager;
            try {
                String combea = "com.bea:Name=";
                String serviceName = "RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
                partitionMB = new ObjectName(combea + serviceName);
                InitialContext ctx = new InitialContext();
                server = (MBeanServer)ctx.lookup("java:comp/jmx/runtime");
            }
            catch (MalformedObjectNameException | NamingException e) {
                debugConnection.debug("Error looking up PartitionRuntimes MBean", e);
            }
            if (server == null || partitionMB == null) {
                return;
            }
            AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute("Partitions");
            try {
                if (debugConnection.isDebugEnabled()) {
                    debugConnection.debug("Successfully Registered PartitionEvenInterceptor for partition property changes");
                }
                server.addNotificationListener(partitionMB, this, (NotificationFilter)filter, null);
            }
            catch (Exception e) {
                if (!debugConnection.isDebugEnabled()) break block7;
                debugConnection.debug("Error adding PartitionEvenInterceptor as listener", e);
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification attributeChange = (AttributeChangeNotification)notification;
            ObjectName[] oldvalue = (ObjectName[])attributeChange.getOldValue();
            ObjectName[] newvalue = (ObjectName[])attributeChange.getNewValue();
            HashSet<String> set = new HashSet<String>();
            for (ObjectName aNewvalue : newvalue) {
                set.add(aNewvalue.getCanonicalName());
            }
            for (ObjectName anOldvalue : oldvalue) {
                if (set.contains(anOldvalue.getCanonicalName())) continue;
                String partName = anOldvalue.getCanonicalName();
                if (debugConnection.isDebugEnabled()) {
                    debugConnection.debug("Closing connections for partition :" + partName);
                }
                this.manager.closeConnectionsForPartition(partName);
            }
        }
    }

    public void close() {
        block5: {
            if (debugConnection.isDebugEnabled()) {
                debugConnection.debug("PartitionEvenInterceptor.close() is called. " + this);
            }
            try {
                if (server != null && partitionMB != null) {
                    server.removeNotificationListener(partitionMB, this);
                    if (debugConnection.isDebugEnabled()) {
                        debugConnection.debug("Successfully unRegistered PartitionEvenInterceptor for partition property changes");
                    }
                }
            }
            catch (InstanceNotFoundException | ListenerNotFoundException e) {
                if (!debugConnection.isDebugEnabled()) break block5;
                debugConnection.debug("Error removing PartitionEvenInterceptor as listener", e);
            }
        }
    }
}

