/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.AsyncOutgoingMessage;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelStream;
import weblogic.rjvm.ClassTableEntry;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.JVMMessage;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.OutboundMsgAbbrev;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.ReplyStream;
import weblogic.rjvm.RequestStream;
import weblogic.rjvm.Response;
import weblogic.rjvm.ResponseImpl;
import weblogic.rjvm.ResponseListener;
import weblogic.rjvm.ResponseWithListener;
import weblogic.rmi.LocalObject;
import weblogic.rmi.cluster.PiggybackResponse;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.provider.BasicServiceContextList;
import weblogic.rmi.provider.WorkServiceContext;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.rmi.spi.ServiceContext;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedObjectOutputStream;
import weblogic.utils.io.Immutable;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;

final class MsgAbbrevOutputStream
extends ChunkedObjectOutputStream
implements AsyncOutgoingMessage,
MsgOutput,
OutboundResponse,
PeerInfoable,
ReplyStream,
RequestStream,
ServerChannelStream,
WLObjectOutput,
WorkContextOutput {
    private static final boolean DEBUG = false;
    private static final boolean tracingEnabled = RJVMEnvironment.getEnvironment().isTracingEnabled();
    private static final long EJBEXCEPTION_SVUID = 796770993296843510L;
    private static ObjectStreamClass OLD_EJBEXCEPTION_OSC;
    private final OutboundMsgAbbrev abbrevs = new OutboundMsgAbbrev(this);
    private final ConnectionManager connectionManager;
    private ServerChannel channel = null;
    private int replyID;
    private AuthenticatedUser user;
    final JVMMessage header;
    private boolean contextsMarshaled;
    private final BasicServiceContextList contexts = new BasicServiceContextList();
    private int timeout;
    private ObjectOutputStream objectStream = new NestedObjectOutputStream(this);
    private int immutableNum;
    private RuntimeMethodDescriptor md;
    private boolean returnToPoolOnClose = true;
    private PeerInfo peerInfo;
    private String partitionName;
    private String partitionURL;
    private MsgAbbrevJVMConnection phantomConnection = null;

    MsgAbbrevOutputStream(ConnectionManager cm, PeerInfo peerInfo, ServerChannel channel, String partitionName) throws IOException {
        this(cm, channel, true);
        this.peerInfo = peerInfo;
        this.partitionName = partitionName;
        this.partitionURL = null;
    }

    MsgAbbrevOutputStream(ConnectionManager cm, ServerChannel channel) throws IOException {
        this(cm, channel, false);
        this.partitionName = "DOMAIN";
        this.partitionURL = null;
    }

    private MsgAbbrevOutputStream(ConnectionManager cm, ServerChannel channel, boolean pool) throws IOException {
        this.connectionManager = cm;
        this.channel = channel;
        this.header = new JVMMessage();
        this.replyID = -1;
        this.returnToPoolOnClose = pool;
        this.skip(19);
        this.partitionURL = null;
    }

    @Override
    public ObjectOutputStream getOutputStream() {
        return this.objectStream;
    }

    void setPhantomConnection(MsgAbbrevJVMConnection phantomConnection) {
        this.phantomConnection = phantomConnection;
    }

    MsgAbbrevJVMConnection getPhantomConnection() {
        return this.phantomConnection;
    }

    @Override
    public void writeContext(WorkContext runtimeContext) throws IOException {
        this.writeASCII(runtimeContext.getClass().getName());
        runtimeContext.writeContext(this);
    }

    void setUser(AuthenticatedUser user) {
        this.user = user;
    }

    AuthenticatedUser getUser() {
        return this.user;
    }

    @Override
    public void transferThreadLocalContext(InboundRequest request) throws IOException {
        if (this.contextsMarshaled) {
            return;
        }
        this.contextsMarshaled = true;
        Interceptor ti = InterceptorManager.getManager().getTransactionInterceptor();
        if (ti != null) {
            this.setTxContext(ti.sendResponse(request.getTxContext()));
        }
        this.marshalCustomCallData();
        WorkContextMapInterceptor interceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
        if (interceptor != null) {
            this.setContext(new WorkServiceContext(false));
        }
        this.marshalUserCustomCallData();
    }

    void setRuntimeMethodDescriptor(RuntimeMethodDescriptor md) {
        this.md = md;
    }

    @Override
    public void setTxContext(Object ptx) throws RemoteException {
        this.contexts.setContextData(0, ptx);
    }

    @Override
    public void setContext(int id, Object data) throws IOException {
        this.contexts.setContextData(id, data);
    }

    public void setContext(ServiceContext sc) {
        this.contexts.setContext(sc);
    }

    byte[] getTrace() {
        return (byte[])this.contexts.getContextData(4);
    }

    Object getTxContext() {
        return this.contexts.getContextData(0);
    }

    Object getContext(int id) {
        return this.contexts.getContextData(id);
    }

    int getReplyID() {
        return this.replyID;
    }

    void setReplyID(int id) {
        this.replyID = id;
    }

    OutboundMsgAbbrev getAbbrevs() {
        return this.abbrevs;
    }

    JVMMessage getMessageHeader() {
        return this.header;
    }

    String getPartitionName() {
        return this.partitionName;
    }

    void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    String getPartitionURL() {
        return this.partitionURL;
    }

    void setPartitionURL(String partitionURL) {
        this.partitionURL = partitionURL;
    }

    @Override
    public void setTimeOut(int mSecs) {
        this.timeout = mSecs;
    }

    @Override
    public void annotateProxyClass(Class c) throws IOException {
        PeerInfo info = this.getPeerInfo();
        if (info.getMajor() > 8 || info.getMajor() == 8 && info.getServicePack() >= 2 || info.getMajor() == 7 && info.getServicePack() >= 5 || info.getMajor() == 6 && info.getServicePack() >= 7) {
            Class<?>[] intf = c.getInterfaces();
            String annotation = "";
            for (int i = 0; i < intf.length; ++i) {
                if (!(intf[i].getClassLoader() instanceof GenericClassLoader)) continue;
                annotation = ((GenericClassLoader)intf[i].getClassLoader()).getAnnotation().getAnnotationString();
                break;
            }
            if (annotation == null) {
                annotation = "";
            }
            this.writeUTF(annotation);
        }
    }

    @Override
    protected final Object replaceNonSerializable(Object o) throws IOException {
        if (KernelStatus.isApplet()) {
            return this.replaceObject(o);
        }
        return o;
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass descriptor) throws IOException {
        PeerInfo info;
        ClassLoader cl = descriptor.forClass().getClassLoader();
        String annotation = null;
        if (cl != null && cl instanceof GenericClassLoader) {
            GenericClassLoader gcl = (GenericClassLoader)cl;
            annotation = gcl.getAnnotation().getAnnotationString();
        }
        if (annotation == null) {
            annotation = "";
        }
        if (descriptor.getSerialVersionUID() == 796770993296843510L && this.getInteropMode() && (info = this.getPeerInfo()).getMajor() == 6 && info.getMinor() == 1) {
            descriptor = MsgAbbrevOutputStream.get61EJBExceptionDescriptor();
        }
        ClassTableEntry cte = new ClassTableEntry(descriptor, annotation);
        this.writeImmutable(cte);
    }

    private static ObjectStreamClass get61EJBExceptionDescriptor() throws IOException {
        if (OLD_EJBEXCEPTION_OSC == null) {
            try {
                ObjectStreamClass target = ObjectStreamClass.lookup(Class.forName("jakarta.ejb.EJBException"));
                ObjectStreamClass result = (ObjectStreamClass)RJVMEnvironment.getEnvironment().copyObject(target);
                Field f = ObjectStreamClass.class.getDeclaredField("suid");
                f.setAccessible(true);
                f.set(result, new Long(-9219910240172116449L));
                OLD_EJBEXCEPTION_OSC = result;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return OLD_EJBEXCEPTION_OSC;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.returnToPoolOnClose) {
            try {
                this.objectStream = new NestedObjectOutputStream(this);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.skip(19);
        this.abbrevs.reset();
        this.immutableNum = 0;
        this.user = null;
        this.replyID = -1;
        this.timeout = 0;
        this.md = null;
        this.header.reset();
        this.contextsMarshaled = false;
        this.contexts.reset();
        this.partitionName = null;
        this.phantomConnection = null;
    }

    @Override
    public void marshalCustomCallData() throws IOException {
        if (this.getPeerInfo().compareTo(PeerInfo.VERSION_DIABLO) < 0) {
            this.write81Contexts();
        } else {
            int sz = this.contexts.size() - this.contexts.sizeUser();
            if (sz > 0) {
                this.header.setFlag(8);
                this.write(sz);
                Iterator i = this.contexts.iterator();
                while (i.hasNext()) {
                    ServiceContext sc = (ServiceContext)i.next();
                    if (sc.isUser()) continue;
                    boolean abbreved = sc instanceof Immutable;
                    this.writeBoolean(abbreved);
                    if (abbreved) {
                        this.writeImmutable(sc);
                        continue;
                    }
                    this.writeObject(sc);
                }
            }
        }
    }

    void marshalUserCustomCallData() throws IOException {
        int sz = this.contexts.sizeUser();
        if (sz > 0) {
            if (this.getPeerInfo().compareTo(PeerInfo.VERSION_DIABLO) < 0) {
                this.write81UserContexts();
            } else {
                this.header.setFlag(16);
                this.write(sz);
                Iterator i = this.contexts.iterator();
                while (i.hasNext()) {
                    ServiceContext sc = (ServiceContext)i.next();
                    if (!sc.isUser()) continue;
                    boolean abbreved = sc instanceof Immutable;
                    this.writeBoolean(abbreved);
                    if (abbreved) {
                        this.writeImmutable(sc);
                        continue;
                    }
                    this.writeObject(sc);
                }
            }
        }
    }

    private void write81Contexts() throws IOException {
        Object ctx = this.contexts.getContextData(0);
        if (ctx != null) {
            this.writeObject(ctx);
            this.header.setFlag(2);
        }
        if (tracingEnabled && (ctx = this.contexts.getContextData(4)) != null && this.getPeerInfo().compareTo(PeerInfo.VERSION_70) >= 0) {
            this.writeObject(ctx);
            this.header.setFlag(4);
        }
        if (this.md != null) {
            this.writeImmutable(this.md);
        }
    }

    private void write81UserContexts() throws IOException {
        Object ctx = this.contexts.getContextData(2);
        if (ctx != null) {
            this.writeObject(ctx);
        }
    }

    private Response flushAndSend(int id, JVMMessage.Command cmd, ResponseImpl res, byte QOS) {
        this.connectionManager.thisRJVM.send(id, cmd, res, this, QOS);
        return res;
    }

    @Override
    public void sendOneWay(int id) throws RemoteException {
        this.flushAndSend(id, JVMMessage.Command.CMD_ONE_WAY, null, (byte)101);
    }

    @Override
    public Response sendRecv(int id) throws RemoteException {
        return this.flushAndSend(id, JVMMessage.Command.CMD_REQUEST, new ResponseImpl((RJVM)this.getEndPoint(), this.timeout, this.md), (byte)101);
    }

    @Override
    public void sendAsync(int id, ResponseListener l) throws RemoteException {
        this.flushAndSend(id, JVMMessage.Command.CMD_REQUEST, new ResponseWithListener((RJVM)this.getEndPoint(), this.timeout, l, this.md), (byte)101);
    }

    @Override
    public void sendOneWay(int id, byte QOS) throws RemoteException {
        this.flushAndSend(id, JVMMessage.Command.CMD_ONE_WAY, null, QOS);
    }

    @Override
    public Response sendRecv(int id, byte QOS) throws RemoteException {
        return this.flushAndSend(id, JVMMessage.Command.CMD_REQUEST, new ResponseImpl((RJVM)this.getEndPoint(), this.timeout, this.md), QOS);
    }

    @Override
    public void sendAsync(int id, ResponseListener l, byte QOS) throws RemoteException {
        this.flushAndSend(id, JVMMessage.Command.CMD_REQUEST, new ResponseWithListener((RJVM)this.getEndPoint(), this.timeout, l, this.md), QOS);
    }

    @Override
    public void send() throws RemoteException {
        this.flushAndSend(this.replyID, JVMMessage.Command.CMD_RESPONSE, null, (byte)101);
    }

    @Override
    public void sendThrowable(Throwable problem) {
        int tempReplyID = this.replyID;
        String curPartitionName = this.getPartitionName();
        if (!RMIEnvironment.getEnvironment().printExceptionStackTrace()) {
            StackTraceUtilsClient.scrubExceptionStackTrace(problem);
        }
        try {
            try {
                this.writeObject(problem);
            }
            catch (IOException ioe) {
                this.flushAndReset();
                try {
                    this.writeObject(new UnmarshalException("Failed to marshal error response: '" + problem + "' because exception ", ioe));
                }
                catch (IOException ioe2) {
                    this.flushAndReset();
                    try {
                        this.writeObject(new UnmarshalException(problem.toString()));
                    }
                    catch (IOException ioe3) {
                        this.writeSomeErrorResponse();
                    }
                }
            }
        }
        catch (RuntimeException re) {
            this.writeSomeErrorResponse();
        }
        if (this.partitionName == null) {
            this.setPartitionName(curPartitionName);
            curPartitionName = null;
        }
        this.connectionManager.thisRJVM.send(tempReplyID, JVMMessage.Command.CMD_ERROR_RESPONSE, null, this, (byte)101);
        if (curPartitionName == null) {
            this.setPartitionName(null);
        }
    }

    private void writeSomeErrorResponse() {
        this.flushAndReset();
        try {
            this.writeObject(new UnmarshalException("Total failure to marshal an error response"));
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    private void flushAndReset() {
        try {
            this.flush();
            this.reset();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    @Override
    public Chunk getChunks() {
        this.setPosition(0);
        this.writeInt(this.getSize());
        this.header.writeHeader(this);
        Chunk c = super.getChunks();
        this.close();
        return c;
    }

    @Override
    public void enqueue() {
    }

    @Override
    public void cleanup() {
        this.close();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.setPosition(0);
        this.writeInt(this.getSize());
        this.header.writeHeader(this);
        super.writeTo(out);
        this.close();
    }

    @Override
    public int getLength() throws IOException {
        return this.getSize();
    }

    @Override
    public void close() {
        if (this.returnToPoolOnClose) {
            this.connectionManager.releaseOutputStream(this);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", reply: '" + this.replyID + " to: '" + this.connectionManager + "', user: '" + this.user + "', tx: '" + this.getTxContext() + '\'';
    }

    @Override
    public MsgOutput getMsgOutput() {
        return this;
    }

    @Override
    public void setPiggybackResponse(PiggybackResponse piggybackResponse) throws IOException {
        this.writeObject(piggybackResponse, Object.class);
    }

    @Override
    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    private boolean getInteropMode() {
        return this.connectionManager.thisRJVM.getInteropMode();
    }

    void setServerChannel(ServerChannel ch) {
        this.channel = ch;
    }

    public EndPoint getEndPoint() {
        return this.connectionManager.thisRJVM;
    }

    @Override
    public ServerChannel getServerChannel() {
        return this.channel;
    }

    @Override
    public final void writeObjectWL(Object o) throws IOException {
        if (!(o instanceof Serializable)) {
            this.writeObject(this.replaceObject(o));
        } else {
            this.writeObject(o);
        }
    }

    @Override
    public final void writeObject(Object o) throws IOException {
        if (this.isPreDiabloPeer()) {
            this.writeObjectToPreDiabloPeer(o);
        } else {
            this.objectStream.writeObject(o);
        }
    }

    @Override
    public final void writeString(String s) throws IOException {
        if (s == null) {
            this.writeByte(112);
        } else {
            this.writeByte(116);
            this.writeUTF(s);
        }
    }

    @Override
    public final void writeDate(Date dateval) throws IOException {
        this.writeObject(dateval);
    }

    @Override
    public final void writeArrayList(ArrayList lst) throws IOException {
        this.writeObject(lst);
    }

    @Override
    public final void writeProperties(Properties propval) throws IOException {
        this.writeObject(propval);
    }

    @Override
    public final void writeBytes(byte[] val) throws IOException {
        this.writeObject(val);
    }

    @Override
    public final void writeArrayOfObjects(Object[] aoo) throws IOException {
        this.writeObject(aoo);
    }

    @Override
    public final void writeImmutable(Object o) throws IOException {
        this.writeLength(this.immutableNum++);
        this.getAbbrevs().addAbbrev(o);
    }

    @Override
    public void writeAbbrevString(String s) throws IOException {
        this.writeImmutable(s);
    }

    @Override
    protected void initNestedStream() throws IOException {
        this.objectStream.reset();
        this.chunkPos = 0;
    }

    private boolean isPreDiabloPeer() {
        PeerInfo info;
        return this.connectionManager == null || this.connectionManager.thisRJVM == null || (info = this.getPeerInfo()) == null || info.compareTo(PeerInfo.VERSION_DIABLO) < 0;
    }

    final class NestedObjectOutputStream
    extends ChunkedObjectOutputStream.NestedObjectOutputStream
    implements WLObjectOutput,
    ServerChannelStream,
    WorkContextOutput,
    PeerInfoable {
        private NestedObjectOutputStream(OutputStream out) throws IOException {
            super(MsgAbbrevOutputStream.this, out);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof Remote && obj instanceof LocalObject) {
                return obj;
            }
            return super.replaceObject(obj);
        }

        @Override
        public ServerChannel getServerChannel() {
            return MsgAbbrevOutputStream.this.getServerChannel();
        }

        @Override
        public void writeObjectWL(Object o) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeObjectWL(o);
        }

        @Override
        public void writeString(String s) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeString(s);
        }

        @Override
        public void writeDate(Date dateval) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeDate(dateval);
        }

        @Override
        public void writeArrayList(ArrayList lst) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeArrayList(lst);
        }

        @Override
        public void writeProperties(Properties propval) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeProperties(propval);
        }

        @Override
        public void writeBytes(byte[] val) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeBytes(val);
        }

        @Override
        public void writeArrayOfObjects(Object[] aoo) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeArrayOfObjects(aoo);
        }

        @Override
        public void writeImmutable(Object o) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeImmutable(o);
        }

        @Override
        public void writeAbbrevString(String s) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeAbbrevString(s);
        }

        @Override
        public void writeContext(WorkContext runtimeContext) throws IOException {
            this.drain();
            MsgAbbrevOutputStream.this.writeContext(runtimeContext);
        }

        @Override
        public PeerInfo getPeerInfo() {
            return MsgAbbrevOutputStream.this.getPeerInfo();
        }
    }
}

