/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.AccessException;
import java.rmi.UnmarshalException;
import java.security.cert.X509Certificate;
import java.util.EmptyStackException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.AsyncMessageSender;
import weblogic.protocol.MessageReceiverStatistics;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.BubblingAbbrever;
import weblogic.rjvm.ClusterInfo;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.InboundMsgAbbrev;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.JVMMessage;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.OutboundMsgAbbrev;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMImpl;
import weblogic.rjvm.RJVMLogger;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.ServerReference;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.ContextHandler;
import weblogic.utils.BlockingCircularQueue;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ReadObjectUtils;

public abstract class MsgAbbrevJVMConnection
implements MessageSenderStatistics,
MessageReceiverStatistics {
    public static final String CONNECT_PARAM_ABBREV_SIZE = "AS";
    public static final String CONNECT_PARAM_HEADER_LEN = "HL";
    public static final String CHANNEL_MAX_MESSAGE_SIZE = "MS";
    public static final String PARTITION_URL = "PU";
    public static final String PARTITION_NAME = "PN";
    public static final String LOCAL_PARTITION_URL = "LU";
    public static final String PROXIED = "PX";
    public static final String UPGRADE = "UP";
    public static final String LOCAL_PARTITION_NAME = "LP";
    private static final boolean ASSERT = false;
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("DebugConnection");
    private static final DebugLogger debugMessaging = DebugLogger.getDebugLogger("DebugMessaging");
    private static final DebugLogger debugAbbrevs = DebugLogger.getDebugLogger("DebugAbbrevs");
    public static final int ABBREV_TABLE_SIZE = RJVMEnvironment.getEnvironment().getAbbrevTableSize();
    private ClusterInfo clusterInfo;
    private BubblingAbbrever abbrevTableOutbound;
    private BubblingAbbrever abbrevTableInbound;
    private boolean needDownGrade;
    private boolean isAdminQOS;
    private int remoteHeaderLength;
    private int peerChannelMaxMessageSize = -1;
    protected boolean proxied = false;
    private boolean authenticated = false;
    private boolean forMultipleSrcs = false;
    private String partitionURL;
    private String partitionName;
    private String localPartitionName;
    private String localPartitionURL;
    protected boolean phantomConnection = false;
    private final Object peerGoneLock = new Object(){};
    private final long connectTime = System.currentTimeMillis();
    private volatile CountDownLatch latch = null;
    private final WritingState writingState = new WritingState();
    private long messagesSent = 0L;
    private long messagesReceived = 0L;
    private long bytesSent = 0L;
    private long bytesReceived = 0L;
    private ConnectionManager dispatcher;
    private boolean waitForPeergone = false;

    final int getRemoteHeaderLength() {
        return this.remoteHeaderLength;
    }

    final ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    final void setClusterInfo(ClusterInfo ci) {
        this.clusterInfo = ci;
    }

    public final void setAdminQOS() {
        this.isAdminQOS = true;
    }

    public abstract ServerChannel getChannel();

    public abstract InetAddress getInetAddress();

    public final void doDownGrade() {
        this.needDownGrade = true;
    }

    final boolean isDownGrade() {
        return this.needDownGrade;
    }

    void markPhantom() {
        this.phantomConnection = true;
    }

    boolean isPhantom() {
        return this.phantomConnection;
    }

    public X509Certificate[] getJavaCertChain() {
        return null;
    }

    public void init(int abbrevSize, int headerLen, int peerChannelMaxMessageSize, String localPartitionName, String remotePartitionURL, String remotePartitionName) {
        this.abbrevTableOutbound = new BubblingAbbrever(abbrevSize);
        this.abbrevTableInbound = new BubblingAbbrever(abbrevSize);
        this.remoteHeaderLength = headerLen;
        this.peerChannelMaxMessageSize = peerChannelMaxMessageSize;
        this.partitionName = remotePartitionName;
        this.partitionURL = remotePartitionURL;
        this.localPartitionName = localPartitionName;
    }

    final void sendMsg(MsgAbbrevOutputStream outputStream) {
        if (this.getChannel().isT3SenderQueueDisabled()) {
            this.sendMsgNow(outputStream);
        } else {
            this.sendMsg(outputStream, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendMsg(MsgAbbrevOutputStream outputStream, boolean shouldSend) {
        boolean canSend;
        if (outputStream.getServerChannel() == null) {
            outputStream.setServerChannel(this.getChannel());
        }
        WritingState writingState = this.writingState;
        synchronized (writingState) {
            boolean isCSharpClient;
            JVMMessage header = outputStream.getMessageHeader();
            header.abbrevOffset = outputStream.getSize();
            boolean bl = isCSharpClient = outputStream.getEndPoint() != null && ((RJVMImpl)outputStream.getEndPoint()).isCSharpClient();
            if (header.cmd != JVMMessage.Command.CMD_IDENTIFY_RESPONSE_CSHARP && !isCSharpClient) {
                this.writeMsgAbbrevs(outputStream);
            }
            canSend = this.canSendMsg(outputStream);
        }
        if (canSend || shouldSend) {
            this.sendOutMsg(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsgNow(MsgAbbrevOutputStream outputStream) {
        if (outputStream.getServerChannel() == null) {
            outputStream.setServerChannel(this.getChannel());
        }
        WritingState writingState = this.writingState;
        synchronized (writingState) {
            block9: {
                boolean isCSharpClient;
                JVMMessage header = outputStream.getMessageHeader();
                header.abbrevOffset = outputStream.getSize();
                boolean bl = isCSharpClient = outputStream.getEndPoint() != null && ((RJVMImpl)outputStream.getEndPoint()).isCSharpClient();
                if (header.cmd != JVMMessage.Command.CMD_IDENTIFY_RESPONSE_CSHARP && !isCSharpClient) {
                    this.writeMsgAbbrevs(outputStream);
                }
                try {
                    int maxMessageSize;
                    if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                        debugMessaging.debug("Sending " + outputStream.getMessageHeader() + ", partitionURL= " + this.partitionURL + '\n' + outputStream.dumpBuf());
                    }
                    int bytesToWrite = outputStream.getLength();
                    if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled() && bytesToWrite > (maxMessageSize = this.getChannel().getMaxMessageSize())) {
                        debugMessaging.debug("MsgAbbrevJVMConnection.sendMsgNow bytesToWrite: " + bytesToWrite + ", maxMessageSize: " + maxMessageSize);
                    }
                    this.sendMsg((OutgoingMessage)outputStream);
                    ++this.messagesSent;
                    this.bytesSent += (long)bytesToWrite;
                }
                catch (IOException ioe) {
                    RJVMLogger.logFailedSendMsgWarning(header.toString(), ioe);
                    if (this.dispatcher == null) break block9;
                    this.dispatcher.gotExceptionSending(header, ioe);
                }
            }
        }
    }

    private void writeMsgAbbrevs(MsgAbbrevOutputStream outputStream) {
        JVMMessage header = outputStream.getMessageHeader();
        OutboundMsgAbbrev abbrevs = outputStream.getAbbrevs();
        try {
            AuthenticatedUser wireUser;
            if (this.forMultipleSrcs) {
                header.hasJVMIDs = true;
            }
            if (header.hasJVMIDs) {
                abbrevs.addAbbrev(header.src, true);
                abbrevs.addAbbrev(header.dest, true);
            }
            if ((wireUser = outputStream.getUser()) instanceof AuthenticatedSubject && RJVMEnvironment.getEnvironment().isUserAnonymous((AuthenticatedSubject)wireUser)) {
                wireUser = null;
            }
            abbrevs.addAbbrev(wireUser, true);
            if (wireUser != null && !this.authenticated && header.src != null && !header.src.hasServerName()) {
                abbrevs.setUser(wireUser);
                this.authenticated = true;
            }
            abbrevs.write(this.abbrevTableOutbound);
            header.hasTX = header.hasTX | outputStream.getTxContext() != null;
            header.hasTrace = header.hasTrace | outputStream.getTrace() != null;
        }
        catch (IOException e) {
            if (debugAbbrevs.isDebugEnabled()) {
                debugAbbrevs.debug("Local abbrevs:\n" + this.abbrevTableOutbound.dump());
            }
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Error writing message header and abbrevs"))).initCause(e);
        }
    }

    final void readMsgAbbrevs(MsgAbbrevInputStream res) throws IOException {
        JVMMessage header = res.getMessageHeader();
        InboundMsgAbbrev abbrevs = res.getAbbrevs();
        try {
            abbrevs.read(res, this.abbrevTableInbound, this);
            if (header.hasJVMIDs) {
                header.src = (JVMID)abbrevs.getAbbrev();
                header.dest = (JVMID)abbrevs.getAbbrev();
            }
            Object user = abbrevs.getAbbrev();
            if (header.invokableId != 41) {
                this.validateRemoteAnonymousRMIT3Access((AuthenticatedUser)user, header, res);
                res.setAuthenticatedUser((AuthenticatedUser)user);
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (debugAbbrevs.isDebugEnabled()) {
                debugAbbrevs.debug("RemoteAbbrevs:\n" + this.abbrevTableInbound.dump());
            }
            RJVMLogger.logExecuteFailed(cnfe);
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Exception creating response stream"))).initCause(cnfe);
        }
    }

    private boolean canSendMsg(MsgAbbrevOutputStream msg) {
        try {
            return this.writingState.sendNow(msg);
        }
        catch (IOException ioe) {
            if (this.dispatcher != null) {
                this.dispatcher.gotExceptionSending(msg.getMessageHeader(), ioe);
            }
            return false;
        }
    }

    private void sendOutMsg(MsgAbbrevOutputStream msg) {
        block5: {
            MsgAbbrevOutputStream towrite = null;
            try {
                long bytesNow = 0L;
                boolean sentMine = false;
                while ((towrite = this.writingState.continueSending(bytesNow >= (long)AsyncMessageSender.MAX_QUEUED_SEND_SIZE && sentMine)) != null) {
                    if (towrite == msg) {
                        sentMine = true;
                    }
                    ++this.messagesSent;
                    bytesNow += (long)towrite.getLength();
                    if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                        debugMessaging.debug("Sending , partitionURL= " + this.partitionURL + towrite.getMessageHeader() + '\n' + towrite.dumpBuf());
                    }
                    this.sendMsg((OutgoingMessage)towrite);
                }
                this.bytesSent += bytesNow;
            }
            catch (IOException ioe) {
                RJVMLogger.logFailedSendMsgWarning(towrite.getMessageHeader().toString(), ioe);
                this.writingState.gotIOException(ioe);
                JVMMessage[] outstanding = this.writingState.dequeue(towrite);
                if (this.dispatcher == null) break block5;
                this.dispatcher.gotExceptionSending(this, outstanding, ioe);
            }
        }
    }

    final void cancelIO(JVMID rjvm) {
        this.writingState.cancelIO(rjvm);
    }

    @Override
    public final long getMessagesSentCount() {
        return this.messagesSent;
    }

    @Override
    public final long getBytesSentCount() {
        return this.bytesSent;
    }

    @Override
    public final long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public final long getMessagesReceivedCount() {
        return this.messagesReceived;
    }

    @Override
    public final long getBytesReceivedCount() {
        return this.bytesReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MsgAbbrevJVMConnection setDispatcher(ConnectionManager dispatcher, boolean close) {
        MsgAbbrevJVMConnection connection = null;
        Object object = this.peerGoneLock;
        synchronized (object) {
            this.dispatcher = dispatcher;
            if (this.partitionName != null) {
                connection = dispatcher.addPartitionConnection(this, close);
            }
            if (this.waitForPeergone) {
                this.waitForPeergone = false;
                this.peerGoneLock.notify();
            }
        }
        return connection;
    }

    public final ConnectionManager getDispatcher() {
        return this.dispatcher;
    }

    final void setForMultipleSrcs(boolean value) {
        this.forMultipleSrcs = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWaitForPeergone(boolean flag) {
        Object object = this.peerGoneLock;
        synchronized (object) {
            this.waitForPeergone = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPeergone() {
        Object object = this.peerGoneLock;
        synchronized (object) {
            while (this.waitForPeergone) {
                try {
                    this.peerGoneLock.wait();
                }
                catch (InterruptedException ie) {
                    if (!KernelStatus.DEBUG || !debugConnection.isDebugEnabled()) continue;
                    debugConnection.debug(" wait was interrupted on thread : [" + Thread.currentThread().getName() + "] : " + StackTraceUtils.throwable2StackTrace(ie));
                }
            }
        }
    }

    public Protocol getProtocol() {
        return this.getChannel().getProtocol();
    }

    public final byte getQOS() {
        if (this.isAdminQOS) {
            return 103;
        }
        return this.getProtocol().getQOS();
    }

    public abstract InetAddress getLocalAddress();

    public abstract int getLocalPort();

    public abstract void connect(String var1, InetAddress var2, int var3, int var4) throws IOException;

    protected abstract void sendMsg(OutgoingMessage var1) throws IOException;

    public abstract void close();

    public final void dispatch(Chunk data) {
        this.waitForPeergone();
        ++this.messagesReceived;
        this.bytesReceived += (long)Chunk.size(data);
        this.bytesReceived += 4L;
        ConnectionManager disp = this.getDispatcher();
        if (disp != null) {
            MsgAbbrevInputStream incomingMessage;
            try {
                incomingMessage = disp.getInputStream();
                this.initIncomingMessage(incomingMessage, data);
            }
            catch (Exception e) {
                RJVMLogger.logUnmarshal(e);
                UnmarshalException ume = new UnmarshalException("Incoming message header or abbreviation processing failed ", e);
                this.gotExceptionReceiving(ume);
                return;
            }
            disp.dispatch(this, incomingMessage);
        }
    }

    private void initIncomingMessage(MsgAbbrevInputStream incomingMessage, Chunk data) throws ClassNotFoundException, IOException {
        int maxMessageSize = this.getChannel().getMaxMessageSize();
        try (ReadObjectUtils readObjectUtils = ReadObjectUtils.withMaxMessageSize(maxMessageSize);){
            incomingMessage.init(data, this);
        }
    }

    public final void gotExceptionReceiving(Throwable t) {
        ConnectionManager disp;
        if (debugAbbrevs.isDebugEnabled()) {
            debugAbbrevs.debug("ExceptionReceiving:" + StackTraceUtils.throwable2StackTrace(t));
            debugAbbrevs.debug("LocalAbbrevs:\n" + this.abbrevTableOutbound.dump());
            debugAbbrevs.debug("RemoteAbbrevs:\n" + this.abbrevTableInbound.dump());
        }
        if ((disp = this.getDispatcher()) != null) {
            disp.gotExceptionReceiving(this, t);
        }
    }

    public ContextHandler getContextHandler() {
        return null;
    }

    protected void ensureForceClose() {
    }

    int getPeerChannelMaxMessageSize() {
        return this.peerChannelMaxMessageSize;
    }

    public String getPartitionUrl() {
        return this.partitionURL;
    }

    public String getRemotePartitionName() {
        return this.partitionName;
    }

    public String getLocalPartitionName() {
        return this.localPartitionName;
    }

    public void setProxied(boolean proxied) {
        this.proxied = proxied;
    }

    public void setLocalPartitionURL(String localPartitionURL) {
        this.localPartitionURL = localPartitionURL;
    }

    public String getLocalPartitionURL() {
        return this.localPartitionURL;
    }

    public void waitIdentify(int timeout) {
        if (this.latch == null) {
            return;
        }
        try {
            if (timeout <= 0) {
                this.latch.await();
            } else {
                this.latch.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void beginIdentify() {
        this.latch = new CountDownLatch(1);
    }

    public void endIdentify() {
        this.latch.countDown();
    }

    void validateRemoteAnonymousRMIT3Access(AuthenticatedUser user, JVMMessage header, MsgAbbrevInputStream res) throws IOException {
        if (!KernelStatus.isServer() || RMIEnvironment.getEnvironment().isRemoteAnonymousRMIT3Enabled()) {
            return;
        }
        if (user == null) {
            if (this.requiresUser(header, res)) {
                InboundMsgAbbrev abbrevs = res.getAbbrevs();
                Object method = null;
                try {
                    method = abbrevs.getAbbrev();
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
                OIDManager mgr = OIDManager.getInstance();
                ServerReference sref = mgr.findServerReference(header.invokableId);
                String className = sref == null ? "" : sref.getDescriptor().getRemoteClassName();
                String mthdName = method == null ? className : className + " " + method.toString();
                String jvmid = header.src == null ? "" : header.src.toString();
                RJVMLogger.logRemoteAnonymousRMIT3AccessNotAllowed(header.cmd.getValue(), header.invokableId, mthdName, jvmid);
                throw new AccessException("Anonymous RMI access not allowed for cmd " + (Object)((Object)header.cmd) + " id " + header.invokableId + " mthd " + mthdName + " JVMID " + jvmid);
            }
            if (header.cmd == JVMMessage.Command.CMD_REQUEST && (header.invokableId == 1 || header.invokableId == 27)) {
                res.setValidatingClass(true);
            }
        } else {
            if (!this.isFromServer(header, res) && this.requiresUser(header, res)) {
                RMIEnvironment.getEnvironment().validateAuthenticatedUser(user);
            }
            this.authenticated = true;
        }
    }

    private boolean requiresUser(JVMMessage header, MsgAbbrevInputStream res) {
        String clsName;
        OIDManager mgr;
        ServerReference sref;
        if (header.cmd != JVMMessage.Command.CMD_REQUEST || this.isFromServer(header, res)) {
            return false;
        }
        if (header.invokableId > 256 && (sref = (mgr = OIDManager.getInstance()).findServerReference(header.invokableId)) != null && "weblogic.management.remote.iiop.IIOPServerImpl".equals(clsName = sref.getDescriptor().getRemoteClassName())) {
            return false;
        }
        return header.invokableId != 1 && header.invokableId != 27 && !this.authenticated;
    }

    private boolean isFromServer(JVMMessage header, MsgAbbrevInputStream res) {
        if (res.isCollocated()) {
            return true;
        }
        return header.src != null && header.src.hasServerName() && header.src.isTrusted();
    }

    boolean requiresUnauthenticatedFilter(JVMMessage header, MsgAbbrevInputStream res) {
        return !this.authenticated && !this.isFromServer(header, res);
    }

    boolean requiresWLSFilter(JVMMessage header, MsgAbbrevInputStream res) {
        return !this.isFromServer(header, res);
    }

    boolean isTrustedClient(JVMMessage header, MsgAbbrevInputStream res) {
        return this.isFromServer(header, res) || !this.isAllowListEnabled();
    }

    boolean isAllowListEnabled() {
        return this.getChannel() != null && ("log".equals(this.getChannel().getAllowListViolationAction()) || "deny".equals(this.getChannel().getAllowListViolationAction()));
    }

    String getAllowListViolationAction() {
        return this.getChannel().getAllowListViolationAction();
    }

    boolean isTrustedClient() {
        return !BasicServerRef.isUnTrustedClient();
    }

    static final class WritingState {
        private final BlockingCircularQueue sendQueue = new BlockingCircularQueue(32);
        private static final int WS_IDLE = 0;
        private static final int WS_WRITING = 1;
        private static final int WS_NEED_A_BREAK = 2;
        private static final int WS_THREAD_WAITING = 3;
        private static final int WS_GOT_IOEXCEPTION = 4;
        private int state = 0;
        private IOException exception;

        WritingState() {
        }

        final int getQLength() {
            return this.sendQueue.size();
        }

        final synchronized boolean sendNow(MsgAbbrevOutputStream mbuf) throws IOException {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.sendQueue.put(mbuf);
                    return true;
                }
                case 1: 
                case 3: {
                    this.sendQueue.put(mbuf);
                    return false;
                }
                case 4: {
                    throw this.exception;
                }
                case 2: {
                    this.state = 3;
                    this.sendQueue.put(mbuf);
                    while (this.state == 3) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return this.state != 4;
                }
            }
            throw new AssertionError((Object)("Invalid writing state: " + this.state));
        }

        final synchronized MsgAbbrevOutputStream continueSending(boolean relieveMe) {
            if (relieveMe) {
                switch (this.state) {
                    case 1: {
                        this.state = 2;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.state = 1;
                        this.notify();
                        return null;
                    }
                    default: {
                        throw new AssertionError((Object)("Invalid writing state: " + this.state));
                    }
                }
            }
            return this.getNextMessage();
        }

        private MsgAbbrevOutputStream getNextMessage() {
            MsgAbbrevOutputStream msg = (MsgAbbrevOutputStream)this.sendQueue.get();
            if (msg == null) {
                this.state = 0;
                return null;
            }
            return msg;
        }

        final synchronized void cancelIO(JVMID rjvm) {
            for (int i = this.sendQueue.size(); i > 0; --i) {
                MsgAbbrevOutputStream msg = (MsgAbbrevOutputStream)this.sendQueue.get();
                JVMMessage header = msg.getMessageHeader();
                if (rjvm.equals(header.dest)) continue;
                this.sendQueue.put(msg);
            }
        }

        final synchronized JVMMessage[] dequeue(MsgAbbrevOutputStream msg) {
            JVMMessage[] outstanding = new JVMMessage[this.getQLength() + 1];
            outstanding[0] = msg.getMessageHeader();
            for (int i = 1; i < outstanding.length; ++i) {
                MsgAbbrevOutputStream message = this.getNextMessage();
                if (message == null) continue;
                outstanding[i] = message.getMessageHeader();
            }
            return outstanding;
        }

        final synchronized void gotIOException(IOException exp) {
            this.exception = exp;
            this.state = 4;
            this.notify();
        }
    }
}

