/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.pfl.basic.reflection.Bridge;
import weblogic.common.WLObjectInput;
import weblogic.common.internal.CodeBaseInfo;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.management.interop.JMXInteropHelper;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerChannelStream;
import weblogic.rjvm.ClassTableEntry;
import weblogic.rjvm.ClusterInfo;
import weblogic.rjvm.ClusterInfoable;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.InboundMsgAbbrev;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.JVMMessage;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMImpl;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteRequest;
import weblogic.rjvm.ReplyStream;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.provider.BasicServiceContextList;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.MsgInput;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.rmi.spi.ServiceContext;
import weblogic.rmi.utils.Utilities;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.utils.Debug;
import weblogic.utils.PropertyHelper;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedObjectInputStream;
import weblogic.utils.io.ExceptionClassReplacer;
import weblogic.utils.io.oif.WebLogicObjectInputFilter;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;

public final class MsgAbbrevInputStream
extends ChunkedObjectInputStream
implements RemoteRequest,
WLObjectInput,
InboundRequest,
PeerInfoable,
MsgInput,
ClusterInfoable,
ServerChannelStream,
WorkContextInput {
    private static final boolean noaccess = !System.getProperty("java.version").startsWith("1.");
    private static final Bridge BRIDGE = MsgAbbrevInputStream.getBridge();
    private static final boolean DEBUG = false;
    private static final boolean USE_DUPLICATE_CONNECTION_RESPONSE = !PropertyHelper.getBoolean("weblogic.rjvm.disableDuplicateConnectionResponse");
    private static final Method CLEAR_METHOD = MsgAbbrevInputStream.getClearMethod();
    private static final Field DATA_END_FLAG = MsgAbbrevInputStream.getField(ObjectInputStream.class, "defaultDataEnd");
    private static final Field BLOCK_DATA_IS = MsgAbbrevInputStream.getField(ObjectInputStream.class, "bin");
    private static final Field BLOCK_DATA_IS_END = MsgAbbrevInputStream.getField(BLOCK_DATA_IS, "end");
    private static final Field BLOCK_DATA_IS_POS = MsgAbbrevInputStream.getField(BLOCK_DATA_IS, "pos");
    private static final Field BLOCK_DATA_IS_UNREAD = MsgAbbrevInputStream.getField(BLOCK_DATA_IS, "unread");
    private static final Field PEEK_IS = MsgAbbrevInputStream.getField(BLOCK_DATA_IS, "in");
    private static final Field PEEK_IS_PEEKB = MsgAbbrevInputStream.getField(PEEK_IS, "peekb");
    private static final boolean OBJECT_INPUT_STREAM_ACCESSIBLE_USING_REFLECTION = CLEAR_METHOD != null && DATA_END_FLAG != null && BLOCK_DATA_IS != null && BLOCK_DATA_IS_END != null && BLOCK_DATA_IS_POS != null && PEEK_IS != null && PEEK_IS_PEEKB != null;
    private static final Object[] NULL_ARGS = new Object[0];
    public static final HashMap PRIMITIVE_MAP = new HashMap(31);
    private static final DebugLogger debugMessaging;
    static final long OLD_EJBEXCEPTION_SVUID = -9219910240172116449L;
    private static final AuthenticatedSubject kernelID;
    private ConnectionManager connectionManager;
    private final InboundMsgAbbrev abbrevs;
    private MsgAbbrevJVMConnection connection;
    private RuntimeMethodDescriptor methodDescriptor;
    final JVMMessage header;
    private int responseId;
    private AuthenticatedUser user;
    final BasicServiceContextList contexts = new BasicServiceContextList();
    private String codebase;
    private int immutableNum = 0;
    private ClassTableEntry lastCTE;
    private NestedObjectInputStream objectStream;
    private Object jep290Lock = new Object();
    private boolean methodInited = false;

    private static Bridge getBridge() {
        return AccessController.doPrivileged(Bridge::get);
    }

    private static Method getClearMethod() {
        if (noaccess) {
            return null;
        }
        try {
            return BRIDGE.toAccessibleMethod(ObjectInputStream.class.getDeclaredMethod("clear", new Class[0]), MsgAbbrevInputStream.class);
        }
        catch (Exception e) {
            RJVMLogger.logDebug2("'clear()' not initialized", e);
            return null;
        }
    }

    private static Field getField(Class c, String fieldName) {
        if (noaccess) {
            return null;
        }
        try {
            return BRIDGE.toAccessibleField(c.getDeclaredField(fieldName), MsgAbbrevInputStream.class);
        }
        catch (Exception e) {
            RJVMLogger.logDebug2('\'' + c.getName() + '.' + fieldName + "' field not initialized", e);
            return null;
        }
    }

    private static Field getField(Field obj, String fieldName) {
        if (noaccess) {
            return null;
        }
        if (obj == null) {
            return null;
        }
        try {
            return BRIDGE.toAccessibleField(obj.getType().getDeclaredField(fieldName), MsgAbbrevInputStream.class);
        }
        catch (Exception e) {
            RJVMLogger.logDebug2('\'' + obj.getName() + '.' + fieldName + "' field not initialized", e);
            return null;
        }
    }

    MsgAbbrevInputStream(ConnectionManager cm) throws IOException {
        super(KernelStatus.isServer(), BasicServerRef.isUnTrustedClient());
        this.objectStream = new NestedObjectInputStream((InputStream)this);
        this.setReplacer(RemoteObjectReplacer.getReplacer());
        this.connectionManager = cm;
        this.header = new JVMMessage();
        this.abbrevs = new InboundMsgAbbrev();
    }

    public void resetMTLFilter() {
        WebLogicObjectInputFilter.resetMTLFilter(this.objectStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Chunk data, MsgAbbrevJVMConnection connection) throws ClassNotFoundException, IOException {
        super.init(data, 4);
        this.connection = connection;
        this.responseId = -1;
        this.user = null;
        this.setValidatingClass(false);
        this.header.readHeader(this, connection.getRemoteHeaderLength());
        if (this.connectionManager.thisRJVM != null) {
            this.header.src = this.connectionManager.thisRJVM.getID();
        }
        this.header.dest = JVMID.localID();
        if (this.requiresUnauthenticatedFilter()) {
            WebLogicObjectInputFilter.setUnauthenticatedFilterForStream(this.objectStream);
            this.objectStream.setFilterType(ChunkedObjectInputStream.FilterType.UNAUTHENTICATED);
        } else if (this.objectStream.getFilterType() == null && this.isTrustedClient()) {
            WebLogicObjectInputFilter.setWebLogicFilterForStreamWithOnlyBlock(this.objectStream);
            this.objectStream.setFilterType(ChunkedObjectInputStream.FilterType.WLS);
        } else if (this.objectStream.getFilterType() == null && KernelStatus.isServer()) {
            if (this.isAllowListEnabled()) {
                Object object = this.jep290Lock;
                synchronized (object) {
                    WebLogicObjectInputFilter.setAllowListViolationAction(this.getConnection().getChannel().getAllowListViolationAction());
                }
            }
            WebLogicObjectInputFilter.setWebLogicFilterForStream(this.objectStream);
            this.objectStream.setFilterType(ChunkedObjectInputStream.FilterType.WLS);
        }
        if (!KernelStatus.DEBUG || debugMessaging.isDebugEnabled()) {
            // empty if block
        }
        this.mark(this.header.abbrevOffset);
        this.skip(this.header.abbrevOffset - this.pos());
        connection.readMsgAbbrevs(this);
        this.reset();
        if (JVMID.localID().equals(this.header.dest)) {
            if (!this.header.getFlag(8)) {
                this.read81Contexts();
            } else {
                this.readExtendedContexts();
            }
        }
    }

    void setConnectionManager(ConnectionManager cm) {
        this.connectionManager = cm;
    }

    private void read81Contexts() throws IOException, ClassNotFoundException {
        if (this.header.getFlag(2)) {
            this.contexts.setContextData(0, this.readObject());
        }
        if (this.header.getFlag(4)) {
            this.contexts.setContextData(4, this.readObject());
        }
    }

    final void readExtendedContexts() throws IOException {
        int nc = this.read();
        for (int i = 0; i < nc; ++i) {
            try {
                boolean abbreved = this.readBoolean();
                ServiceContext sc = abbreved ? (ServiceContext)this.readImmutable() : (ServiceContext)this.readObject();
                if (sc == null) continue;
                this.contexts.setContext(sc);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public WorkContext readContext() throws IOException, ClassNotFoundException {
        Class rcClass = Utilities.loadClass(this.readASCII(), this.getCodebase());
        try {
            WorkContext runtimeContext = (WorkContext)rcClass.newInstance();
            runtimeContext.readContext(this);
            return runtimeContext;
        }
        catch (InstantiationException ie) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(ie);
        }
        catch (IllegalAccessException iae) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(iae);
        }
    }

    @Override
    public ReplyStream getResponseStream() throws IOException {
        return this.getMsgAbbrevOutputStream();
    }

    private MsgAbbrevOutputStream getMsgAbbrevOutputStream() throws IOException {
        MsgAbbrevOutputStream res;
        if (this.header.cmd == JVMMessage.Command.CMD_ONE_WAY) {
            throw new IOException("Requesting a response stream for oneWay request");
        }
        if (this.connectionManager.thisRJVM != null && this.connectionManager.thisRJVM.getID().equals(this.header.src)) {
            res = this.connectionManager.thisRJVM.getResponseStream(this.getServerChannel(), this.header.QOS, this.connection.getRemotePartitionName());
            if (USE_DUPLICATE_CONNECTION_RESPONSE && this.connection.isPhantom()) {
                res.setPhantomConnection(this.connection);
            }
        } else {
            RJVMImpl theRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(this.header.src);
            ServerChannel channelToUse = this.findServerChannelForOutputStream(theRJVM);
            res = theRJVM.getResponseStream(channelToUse, this.header.QOS, this.connection.getRemotePartitionName());
        }
        res.setReplyID(this.responseId);
        res.setUser(this.user);
        return res;
    }

    private ServerChannel findServerChannelForOutputStream(RJVMImpl srcRJVM) {
        ServerChannel channelToUse = this.getServerChannel();
        if (srcRJVM.getID().shouldUseProxy()) {
            channelToUse = ServerChannelManager.findOutboundServerChannel(srcRJVM.getID().getConnectToProtocol(channelToUse.getProtocol()));
            debugMessaging.debug("findServerChannelForOutputStream(" + srcRJVM + ") updated channelToUse due to proxy url to: " + channelToUse);
        }
        return channelToUse;
    }

    JVMMessage getMessageHeader() {
        return this.header;
    }

    void setResponseId(int rid) {
        this.responseId = rid;
    }

    @Override
    public RJVM getOrigin() {
        if (this.connectionManager.thisRJVM != null && this.connectionManager.thisRJVM.getID().equals(this.header.src)) {
            return this.connectionManager.thisRJVM;
        }
        return RJVMManager.getRJVMManager().findRemote(this.header.src);
    }

    @Override
    public String getRequestUrl() {
        return this.connection.getPartitionUrl();
    }

    public Protocol getProtocol() {
        return this.connection.getProtocol();
    }

    @Override
    public ServerChannel getServerChannel() {
        return this.connection.getChannel();
    }

    public MsgAbbrevJVMConnection getConnection() {
        return this.connection;
    }

    @Override
    public AbstractSubject getSubject() {
        return SecurityServiceManager.getSealedSubjectFromWire(kernelID, this.user);
    }

    AuthenticatedUser getAuthenticatedUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAuthenticatedUser(AuthenticatedUser au) throws IOException {
        this.user = au;
        if (this.objectStream.getFilterType() == ChunkedObjectInputStream.FilterType.UNAUTHENTICATED && this.user != null) {
            try {
                this.objectStream = new NestedObjectInputStream((InputStream)this);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (this.isTrustedClient()) {
                WebLogicObjectInputFilter.setWebLogicFilterForStreamWithOnlyBlock(this.objectStream);
            } else {
                if (this.isAllowListEnabled()) {
                    Object object = this.jep290Lock;
                    synchronized (object) {
                        WebLogicObjectInputFilter.setAllowListViolationAction(this.getConnection().getChannel().getAllowListViolationAction());
                    }
                }
                WebLogicObjectInputFilter.setWebLogicFilterForStream(this.objectStream);
            }
            this.objectStream.setFilterType(ChunkedObjectInputStream.FilterType.WLS);
        }
    }

    @Override
    public Object getTxContext() {
        return this.contexts.getContextData(0);
    }

    InboundMsgAbbrev getAbbrevs() {
        return this.abbrevs;
    }

    public boolean requiresUnauthenticatedFilter() {
        return KernelStatus.isServer() && !RMIEnvironment.getEnvironment().isRemoteAnonymousRMIT3Enabled() && this.getAuthenticatedUser() == null && this.getConnection().requiresUnauthenticatedFilter(this.getMessageHeader(), this);
    }

    public boolean isTrustedClient() {
        return this.getConnection().isTrustedClient(this.getMessageHeader(), this);
    }

    public boolean isAllowListEnabled() {
        return this.getConnection().isAllowListEnabled();
    }

    public String getAllowListViolationAction() {
        return this.getConnection().getAllowListViolationAction();
    }

    public boolean requiresWLSFilter() {
        return KernelStatus.isServer() && this.getConnection().requiresWLSFilter(this.getMessageHeader(), this);
    }

    public String getCodebase() {
        if (this.connectionManager.thisRJVM == null) {
            return null;
        }
        if (this.codebase == null) {
            RJVMImpl rjvm = this.connectionManager.thisRJVM;
            this.codebase = rjvm.getCodebase(this.getConnection().getProtocol());
        }
        return this.codebase;
    }

    @Override
    public ContextHandler getContextHandler() {
        return this.connection.getContextHandler();
    }

    @Override
    public final Object getContext(int id) {
        return this.contexts.getContextData(id);
    }

    public final boolean hasContext(int id) {
        return this.contexts.getContext(id) != null;
    }

    @Override
    public void retrieveThreadLocalContext() throws IOException {
        if (this.header.getFlag(16)) {
            this.readExtendedContexts();
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException {
        this.lastCTE = (ClassTableEntry)this.readImmutable();
        return this.lastCTE.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class resolveClass(ObjectStreamClass descriptor) throws InvalidClassException, ClassNotFoundException {
        ClassTableEntry classTableEntry = this.lastCTE;
        synchronized (classTableEntry) {
            try {
                WebLogicObjectInputFilter.checkLegacyBlacklistIfNeeded(descriptor.getName());
            }
            catch (InvalidClassException ice) {
                if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled()) {
                    RJVMLogger.logDebug("Unauthorized deserialization attempt");
                }
                throw ice;
            }
            ClassLoader ccl = RJVMEnvironment.getEnvironment().getContextClassLoader();
            if (this.lastCTE.getClazz() == null || this.lastCTE.getClazzLoader() != ccl) {
                String classname = this.lastCTE.getDescriptor().getName();
                if (this.isPreDiabloPeer()) {
                    classname = JMXInteropHelper.getJMXInteropClassName(classname);
                }
                this.lastCTE.setClazz((Class)PRIMITIVE_MAP.get(classname));
                if (this.lastCTE.getClazz() == null) {
                    Class<?> clazz = this.loadReplacementClass(ccl, classname);
                    if (clazz == null) {
                        clazz = this.loadClass(ccl, classname);
                    }
                    this.lastCTE.setClazz(clazz);
                }
                this.lastCTE.setClazzLoader(ccl);
            }
            this.lastClass = this.lastCTE.getClazz();
        }
        this.getInputStream().validateReturnType(this.lastClass);
        return this.lastClass;
    }

    private Class<?> loadReplacementClass(ClassLoader ccl, String classname) {
        return ExceptionClassReplacer.getReplacementClassIfAvailable(ccl, classname);
    }

    private Class<?> loadClass(ClassLoader ccl, String classname) throws ClassNotFoundException {
        return Utilities.loadClass(classname, this.lastCTE.getAnnotation(), this.getCodebase(), ccl);
    }

    @Override
    protected final Class loadClass(String classname, String annotation) throws ClassNotFoundException {
        return Utilities.loadClass(classname, annotation, this.getCodebase());
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        PeerInfo info = this.getPeerInfo();
        String annotation = null;
        if (info.getMajor() > 8 || info.getMajor() == 8 && info.getServicePack() >= 2 || info.getMajor() == 7 && info.getServicePack() >= 5 || info.getMajor() == 6 && info.getServicePack() >= 7) {
            annotation = this.readUTF();
        }
        return RJVMEnvironment.getEnvironment().resolveProxyClass(interfaces, annotation, this.getCodebase());
    }

    @Override
    public void close() {
        super.close();
        this.methodInited = false;
        this.abbrevs.reset();
        this.lastClass = null;
        this.connection = null;
        this.responseId = -1;
        this.user = null;
        this.immutableNum = 0;
        this.contexts.reset();
        try {
            this.initNestedStream();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        this.methodDescriptor = null;
        this.lastCTE = null;
        this.connectionManager.releaseInputStream(this);
    }

    @Override
    public String toString() {
        return "weblogic.rjvm.MsgAbbrevInputStream - " + this.responseId + " from: '" + this.connectionManager.thisRJVM + "', user: '" + this.user + "', tx: '" + this.getTxContext() + '\'';
    }

    @Override
    public MsgInput getMsgInput() {
        return this;
    }

    @Override
    public boolean isCollocated() {
        return JVMID.localID().equals(this.header.src);
    }

    @Override
    public EndPoint getEndPoint() {
        return this.getOrigin();
    }

    @Override
    public RuntimeMethodDescriptor getRuntimeMethodDescriptor(RuntimeDescriptor rd) throws IOException {
        if (!this.methodInited) {
            this.methodDescriptor = (RuntimeMethodDescriptor)this.contexts.getContextData(6);
            if (this.methodDescriptor == null) {
                this.methodDescriptor = (RuntimeMethodDescriptor)this.readImmutable();
            }
            this.methodDescriptor = this.methodDescriptor.getCanonical(rd);
            this.methodInited = true;
        }
        return this.methodDescriptor;
    }

    @Override
    public Object getReplicaInfo() throws IOException {
        try {
            if (this.contexts.getContextData(3) == null) {
                this.contexts.setContextData(3, this.readObject());
            }
            return this.contexts.getContextData(3);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
    }

    @Override
    public Object getActivationID() throws IOException {
        try {
            if (this.contexts.getContextData(2) == null) {
                this.contexts.setContextData(2, this.readObject());
            }
            return this.contexts.getContextData(2);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
    }

    @Override
    public PeerInfo getPeerInfo() {
        return this.connectionManager.thisRJVM.getPeerInfo();
    }

    @Override
    public String getPartitionName() {
        return this.connection.getRemotePartitionName();
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return this.connection.getClusterInfo();
    }

    @Override
    public OutboundResponse getOutboundResponse() throws IOException {
        return this.getMsgAbbrevOutputStream();
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.connection.getJavaCertChain();
    }

    @Override
    public final Object readObjectWL() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    @Override
    public final Object readObjectWLValidated(Class returnType) throws IOException, ClassNotFoundException {
        return this.readObjectValidated(returnType);
    }

    public final Object readObjectWL(Class clazz) throws IOException, ClassNotFoundException {
        return this.readObject(clazz);
    }

    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        if (this.isPreDiabloPeer()) {
            return this.readObjectFromPreDiabloPeer();
        }
        try {
            return super.readObject();
        }
        catch (InvalidClassException ice) {
            if (KernelStatus.DEBUG && debugMessaging.isDebugEnabled() && ice.toString() != null && ice.toString().indexOf("REJECTED") >= 0) {
                RJVMLogger.logDebug("JEP290 filtering failed from " + this.header);
            }
            throw ice;
        }
    }

    private boolean isPreDiabloPeer() {
        RJVMImpl rjvm = this.connectionManager.thisRJVM;
        return rjvm == null || rjvm.isPreDiablo();
    }

    @Override
    public final String readString() throws IOException {
        byte b = this.readByte();
        if (b == 112) {
            return null;
        }
        return this.readUTF();
    }

    @Override
    public final Date readDate() throws IOException {
        try {
            return (Date)this.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Couldn't find class"))).initCause(cnfe);
        }
    }

    @Override
    public final ArrayList readArrayList() throws IOException, ClassNotFoundException {
        return (ArrayList)this.readObject();
    }

    @Override
    public final Properties readProperties() throws IOException {
        try {
            return (Properties)this.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Couldn't find class"))).initCause(cnfe);
        }
    }

    @Override
    public final byte[] readBytes() throws IOException {
        try {
            return (byte[])this.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Couldn't find class"))).initCause(cnfe);
        }
    }

    @Override
    public final Object[] readArrayOfObjects() throws IOException, ClassNotFoundException {
        return (Object[])this.readObject();
    }

    @Override
    public Object readImmutable() throws IOException {
        int i = this.readLength();
        Object o = this.abbrevs.getAbbrev();
        while (this.immutableNum++ < i) {
            o = this.abbrevs.getAbbrev();
        }
        return o;
    }

    @Override
    public String readAbbrevString() throws IOException {
        return (String)this.readImmutable();
    }

    @Override
    protected final void initNestedStream() throws IOException {
        if (!OBJECT_INPUT_STREAM_ACCESSIBLE_USING_REFLECTION || this.objectStream.getFilterType() == ChunkedObjectInputStream.FilterType.UNAUTHENTICATED) {
            this.objectStream = new NestedObjectInputStream((InputStream)this);
        } else {
            try {
                CLEAR_METHOD.invoke((Object)this.objectStream, NULL_ARGS);
                DATA_END_FLAG.setBoolean(this.objectStream, false);
                Object bin = BLOCK_DATA_IS.get(this.objectStream);
                Object in = PEEK_IS.get(bin);
                BLOCK_DATA_IS_END.setInt(bin, 0);
                BLOCK_DATA_IS_POS.setInt(bin, 0);
                BLOCK_DATA_IS_UNREAD.setInt(bin, 0);
                PEEK_IS_PEEKB.setInt(in, -1);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public NestedObjectInputStream getInputStream() {
        Debug.assertion(this.objectStream != null);
        return this.objectStream;
    }

    static {
        PRIMITIVE_MAP.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVE_MAP.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVE_MAP.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVE_MAP.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVE_MAP.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVE_MAP.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVE_MAP.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVE_MAP.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVE_MAP.put(Void.TYPE.getName(), Void.TYPE);
        debugMessaging = DebugLogger.getDebugLogger("DebugMessaging");
        kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private final class NestedObjectInputStream
    extends ChunkedObjectInputStream.NestedObjectInputStream
    implements WLObjectInput,
    CodeBaseInfo,
    ClusterInfoable,
    ServerChannelStream,
    WorkContextInput,
    PeerInfoable {
        private NestedObjectInputStream(InputStream in) throws IOException {
            super(MsgAbbrevInputStream.this, in, false);
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        private NestedObjectInputStream(InputStream in, boolean setFilter) throws IOException {
            super(MsgAbbrevInputStream.this, in, setFilter);
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            return MsgAbbrevInputStream.this.resolveProxyClass(interfaces);
        }

        @Override
        public Object readObjectWL() throws IOException, ClassNotFoundException {
            return MsgAbbrevInputStream.this.readObjectWL();
        }

        @Override
        public Object readObjectWLValidated(Class returnType) throws IOException, ClassNotFoundException {
            return MsgAbbrevInputStream.this.readObjectWLValidated(returnType);
        }

        @Override
        public String readString() throws IOException {
            return MsgAbbrevInputStream.this.readString();
        }

        @Override
        public Date readDate() throws IOException {
            return MsgAbbrevInputStream.this.readDate();
        }

        @Override
        public ArrayList readArrayList() throws IOException, ClassNotFoundException {
            return MsgAbbrevInputStream.this.readArrayList();
        }

        @Override
        public Properties readProperties() throws IOException {
            return MsgAbbrevInputStream.this.readProperties();
        }

        @Override
        public byte[] readBytes() throws IOException {
            return MsgAbbrevInputStream.this.readBytes();
        }

        @Override
        public Object[] readArrayOfObjects() throws IOException, ClassNotFoundException {
            return MsgAbbrevInputStream.this.readArrayOfObjects();
        }

        @Override
        public Object readImmutable() throws IOException {
            return MsgAbbrevInputStream.this.readImmutable();
        }

        @Override
        public String readAbbrevString() throws IOException {
            return MsgAbbrevInputStream.this.readAbbrevString();
        }

        @Override
        public String getCodebase() {
            return MsgAbbrevInputStream.this.getCodebase();
        }

        @Override
        public ServerChannel getServerChannel() {
            return MsgAbbrevInputStream.this.getServerChannel();
        }

        @Override
        public ClusterInfo getClusterInfo() {
            return MsgAbbrevInputStream.this.getClusterInfo();
        }

        @Override
        public WorkContext readContext() throws IOException, ClassNotFoundException {
            return MsgAbbrevInputStream.this.readContext();
        }

        @Override
        public PeerInfo getPeerInfo() {
            return MsgAbbrevInputStream.this.getPeerInfo();
        }
    }
}

