/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMImpl;
import weblogic.rmi.facades.RmiInvocationFacade;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.io.Chunk;

public class LocalConnectionManager
extends ConnectionManager {
    private static final DebugLogger LOGGER = DebugLogger.getDebugLogger("DebugLocalRemoteJVM");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    LocalConnectionManager(RJVMImpl rjvm) {
        super(rjvm);
    }

    @Override
    protected MsgAbbrevJVMConnection getConnectionInPairedConnTable(String remotePartitionName, byte protocolNum) {
        if (!KernelStatus.isServer()) {
            throw new UnsupportedOperationException("This should only be called on server side!");
        }
        String localPN = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext().getPartitionName();
        MsgAbbrevJVMConnection connection = this.getConnectionInPairedConnTable(remotePartitionName, localPN, protocolNum);
        if (connection != null) {
            return connection;
        }
        connection = new MsgAbbrevJVMConnection(){
            ServerChannel ch;

            @Override
            public ServerChannel getChannel() {
                if (this.ch == null) {
                    this.ch = LocalConnectionManager.this.thisRJVM.ensureChannel(null, (byte)101);
                }
                return this.ch;
            }

            @Override
            public InetAddress getInetAddress() {
                throw new UnsupportedOperationException("Should NEVER call this!");
            }

            @Override
            public InetAddress getLocalAddress() {
                throw new UnsupportedOperationException("Should NEVER call this!");
            }

            @Override
            public int getLocalPort() {
                throw new UnsupportedOperationException("Should NEVER call this!");
            }

            @Override
            public void connect(String host, InetAddress address, int port, int connectTimeout) throws IOException {
                throw new UnsupportedOperationException("Should NEVER call this!");
            }

            @Override
            protected void sendMsg(OutgoingMessage msg) throws IOException {
                if (KernelStatus.DEBUG && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("sendMsg(" + msg + ")");
                }
                try {
                    Chunk data = msg.getChunks();
                    MsgAbbrevInputStream mais = new MsgAbbrevInputStream(LocalConnectionManager.this);
                    mais.init(data, this);
                    this.getDispatcher().dispatch(this, mais);
                }
                catch (Exception e) {
                    throw new RuntimeException("fail to sendMsg by local connection " + this, e);
                }
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException("Should NEVER call this!");
            }
        };
        connection.init(RJVMEnvironment.getEnvironment().getAbbrevTableSize(), 19, -1, remotePartitionName, null, localPN);
        return connection.setDispatcher(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleRJVM(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        String partition = connection.getLocalPartitionName();
        try (ManagedInvocationContext mic = RmiInvocationFacade.setPartitionName(KERNEL_ID, partition);){
            if (KernelStatus.DEBUG && LOGGER.isDebugEnabled()) {
                LOGGER.debug("pushed CIC " + partition);
            }
            this.thisRJVM.dispatch(inputStream);
        }
        finally {
            if (KernelStatus.DEBUG && LOGGER.isDebugEnabled()) {
                LOGGER.debug("popped CIC " + partition);
            }
        }
    }

    @Override
    void handleIdentifyRequest(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
    }

    @Override
    void handleIdentifyResponse(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
    }

    @Override
    void handlePeerGone(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
    }
}

