/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import weblogic.rjvm.JVMID;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.ChunkedDataOutputStream;

public final class JVMMessage {
    public static final int MESSAGE_LENGTH_OFFSET = 4;
    public static final int HEADER_LENGTH = 19;
    static final int CONTEXT_JVMID_FLAG = 1;
    static final int CONTEXT_TX_FLAG = 2;
    static final int CONTEXT_TRACE_FLAG = 4;
    static final int CONTEXT_EXTENDED_FLAG = 8;
    static final int CONTEXT_EXTENDED_USER_FLAG = 16;
    Command cmd = Command.CMD_UNDEFINED;
    private int flags;
    byte QOS = (byte)101;
    boolean hasJVMIDs;
    boolean hasTX;
    boolean hasTrace;
    int responseId = -1;
    int invokableId = -1;
    int abbrevOffset;
    JVMID src;
    JVMID dest;

    JVMMessage() {
    }

    void init(JVMID dest, byte QOS, Command cmd) {
        this.init(dest, QOS, cmd, null);
    }

    void init(JVMID dest, byte QOS, Command cmd, JVMID localIDFromSrc) {
        this.cmd = cmd;
        this.QOS = QOS;
        this.dest = dest;
        this.src = JVMID.localID(localIDFromSrc);
    }

    void init(JVMMessage other) {
        this.init(other, false);
    }

    void init(JVMMessage other, boolean routeMsg) {
        this.cmd = other.cmd;
        this.QOS = other.QOS;
        this.hasJVMIDs = other.hasJVMIDs;
        this.hasTX = other.hasTX;
        this.hasTrace = other.hasTrace;
        this.flags = other.flags;
        this.responseId = other.responseId;
        this.invokableId = other.invokableId;
        this.src = routeMsg ? JVMID.createForRouteMsgOnly(other.src) : other.src;
        this.dest = other.dest;
        this.abbrevOffset = other.abbrevOffset;
    }

    final void reset() {
        this.hasJVMIDs = false;
        this.hasTX = false;
        this.hasTrace = false;
        this.responseId = 0;
        this.invokableId = 0;
        this.abbrevOffset = 0;
        this.flags = 0;
    }

    public void setFlag(int f) {
        this.flags |= f;
    }

    public boolean getFlag(int f) {
        return (this.flags & f) != 0;
    }

    void readHeader(ChunkedDataInputStream is, int remoteHeaderLen) {
        try {
            this.cmd = Command.getByValue(is.readByte());
            this.QOS = is.readByte();
            this.flags = is.readByte() & 0xFF;
            this.hasJVMIDs = this.getFlag(1);
            this.hasTX = this.getFlag(2);
            this.hasTrace = this.getFlag(4);
            this.responseId = is.readInt();
            this.invokableId = is.readInt();
            this.abbrevOffset = is.readInt();
            int skip = remoteHeaderLen - 19;
            if (skip > 0) {
                is.skip(skip);
            }
        }
        catch (IOException ioe) {
            throw new AssertionError("Exception reading message header", ioe);
        }
    }

    void writeHeader(ChunkedDataOutputStream out) {
        out.writeByte(this.cmd.value);
        out.writeByte(this.QOS);
        this.flags |= this.hasJVMIDs ? 1 : 0;
        out.writeByte(this.flags);
        out.writeInt(this.responseId);
        out.writeInt(this.invokableId);
        out.writeInt(this.abbrevOffset);
    }

    private String getFlags() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hasJVMIDs ? "JVMIDs Sent, " : "JVMIDs Not Sent, ");
        sb.append(this.hasTX ? "TX Context Sent, " : "TX Context Not Sent, ");
        sb.append("0x").append(Integer.toHexString(this.flags));
        return sb.toString();
    }

    public String toString() {
        return "JVMMessage from: '" + this.src + "' to: '" + this.dest + "' cmd: '" + this.cmd.name() + "', QOS: '" + this.QOS + "', responseId: '" + this.responseId + "', invokableId: '" + this.invokableId + "', flags: '" + this.getFlags() + "', abbrev offset: '" + this.abbrevOffset + "'";
    }

    static enum Command {
        CMD_UNDEFINED(0),
        CMD_IDENTIFY_REQUEST(1),
        CMD_IDENTIFY_RESPONSE(2),
        CMD_PEER_GONE(3),
        CMD_ONE_WAY(4),
        CMD_REQUEST(5),
        CMD_RESPONSE(6),
        CMD_ERROR_RESPONSE(7),
        CMD_INTERNAL(8),
        CMD_NO_ROUTE_IDENTIFY_REQUEST(9),
        CMD_TRANSLATED_IDENTIFY_RESPONSE(10),
        CMD_REQUEST_CLOSE(11),
        CMD_IDENTIFY_REQUEST_CSHARP(12),
        CMD_IDENTIFY_RESPONSE_CSHARP(13);

        private byte value;

        private Command(byte val) {
            this.value = val;
        }

        private static Command getByValue(byte value) {
            return Command.values()[value];
        }

        byte getValue() {
            return this.value;
        }
    }
}

