/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelStream;
import weblogic.rjvm.BubblingAbbrever;
import weblogic.rjvm.ClassTableEntry;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.spi.ServiceContext;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.utils.collections.Stack;
import weblogic.utils.io.FilteringObjectInputStream;
import weblogic.utils.io.Immutable;
import weblogic.utils.io.ReadObjectUtils;
import weblogic.utils.io.oif.WebLogicObjectInputFilter;

final class InboundMsgAbbrev {
    private static final boolean DEBUG = false;
    private static final Class[] ABBREV_CLASSES = new Class[]{String.class, ServiceContext.class, ClassTableEntry.class, JVMID.class, AuthenticatedUser.class, RuntimeMethodDescriptor.class, Immutable.class};
    private static boolean disableValidation = Boolean.getBoolean("weblogic.rjvm.disableValidation");
    private final Stack abbrevs = new Stack();

    InboundMsgAbbrev() {
    }

    void read(MsgAbbrevInputStream in, BubblingAbbrever at, MsgAbbrevJVMConnection conn) throws IOException, ClassNotFoundException {
        int numAbbrevs = in.readLength();
        for (int i = 0; i < numAbbrevs; ++i) {
            Object o;
            int abbrev = in.readLength();
            if (abbrev > at.getCapacity()) {
                o = this.readObject(in);
                at.getAbbrev(o);
                this.abbrevs.push(o);
            } else {
                o = at.getValue(abbrev);
                this.abbrevs.push(o);
            }
            if (i != 0 || !(this.abbrevs.peek() instanceof AuthenticatedUser) || conn == null) continue;
            AuthenticatedUser au = (AuthenticatedUser)this.abbrevs.peek();
            conn.validateRemoteAnonymousRMIT3Access(au, in.header, in);
        }
    }

    private Object readObject(MsgAbbrevInputStream in) throws IOException, ClassNotFoundException {
        try {
            return this.doReadObject(in);
        }
        catch (OutOfMemoryError oome) {
            throw ReadObjectUtils.handleOutOfMemoryError(oome);
        }
    }

    private Object doReadObject(MsgAbbrevInputStream in) throws IOException, ClassNotFoundException {
        int typecode = in.read();
        switch (typecode) {
            case 1: {
                return in.readASCII();
            }
            case 0: {
                if (disableValidation) {
                    return new ServerChannelInputStream(in).readObject();
                }
                return new ServerChannelInputStream(in).readObjectValidated(ABBREV_CLASSES);
            }
        }
        throw new StreamCorruptedException("Unknown typecode: '" + typecode + "'");
    }

    void reset() {
        this.abbrevs.clear();
    }

    void writeTo(MsgAbbrevOutputStream out, boolean preserveAbbrevs) {
        Stack abbrevStack = preserveAbbrevs ? (Stack)this.abbrevs.clone() : this.abbrevs;
        int abbrevsLen = abbrevStack.size();
        for (int i = 0; i < abbrevsLen; ++i) {
            out.getAbbrevs().addAbbrev(abbrevStack.pop());
        }
    }

    Object getAbbrev() {
        return this.abbrevs.pop();
    }

    public String toString() {
        return super.toString() + " - abbrevs: '" + this.abbrevs + "'";
    }

    private static class ServerChannelInputStream
    extends FilteringObjectInputStream
    implements ServerChannelStream {
        private final ServerChannel serverChannel;

        private ServerChannelInputStream(MsgAbbrevInputStream in) throws IOException {
            super(in, !in.requiresUnauthenticatedFilter(), !in.isTrustedClient(), in.getAllowListViolationAction());
            if (in.requiresUnauthenticatedFilter()) {
                WebLogicObjectInputFilter.setUnauthenticatedFilterForStream(this);
            } else if (in.isTrustedClient()) {
                WebLogicObjectInputFilter.setWebLogicFilterForStreamWithOnlyBlock(this);
            }
            this.serverChannel = in.getServerChannel();
        }

        @Override
        public ServerChannel getServerChannel() {
            return this.serverChannel;
        }

        protected Class resolveClass(ObjectStreamClass descriptor) throws ClassNotFoundException, IOException {
            this.checkLegacyBlacklistIfNeeded(descriptor.getName());
            Class<?> c = super.resolveClass(descriptor);
            if (c == null) {
                throw new ClassNotFoundException("super.resolveClass returns null.");
            }
            ObjectStreamClass localDesc = ObjectStreamClass.lookup(c);
            if (localDesc != null && localDesc.getSerialVersionUID() != descriptor.getSerialVersionUID()) {
                throw new ClassNotFoundException("different serialVersionUID. local: " + localDesc.getSerialVersionUID() + " remote: " + descriptor.getSerialVersionUID());
            }
            return c;
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            for (String intf : interfaces) {
                if (!intf.equals("java.rmi.registry.Registry")) continue;
                throw new InvalidObjectException("Unauthorized proxy deserialization");
            }
            return super.resolveProxyClass(interfaces);
        }
    }
}

