/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import weblogic.rjvm.InvokableFinder;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.RemoteInvokable;
import weblogic.utils.KeyTable;

final class Finder
implements InvokableFinder {
    private final KeyTable table = new KeyTable();

    Finder() {
    }

    private static RemoteInvokable unwarp(Object o) {
        return o instanceof HashWrapper ? (RemoteInvokable)((HashWrapper)o).value : (RemoteInvokable)o;
    }

    @Override
    public synchronized RemoteInvokable lookupRemoteInvokable(int id) {
        return Finder.unwarp(this.table.get(id));
    }

    @Override
    public synchronized void put(int id, RemoteInvokable ri) {
        Object o = this.table.get(id);
        if (o != null) {
            RJVMLogger.logBadInstall(id, o.toString(), ri.toString());
        }
        if (ri.hashCode() == id) {
            this.table.put(ri);
        } else {
            this.table.put(new HashWrapper(id, ri));
        }
    }

    @Override
    public synchronized void remove(int id) {
        this.table.remove(id);
    }

    private static final class HashWrapper {
        private final int key;
        private final Object value;

        HashWrapper(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            return this.key == other.hashCode();
        }
    }
}

