/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.util.HashMap;

public class DualKeysTable<K, V> {
    HashMap<K, ValueHolder<K, V>> table = new HashMap();

    public synchronized void put(K key, K alternateKey, V value) {
        if (value == null || key == null) {
            throw new NullPointerException();
        }
        this.putValue(key, new ValueHolder<K, V>(alternateKey, value));
        if (alternateKey != null && !alternateKey.equals(key)) {
            this.putValue(alternateKey, new ValueHolder<K, V>(key, value));
        }
    }

    private void putValue(K key, ValueHolder<K, V> newValueHolder) {
        ValueHolder<K, V> relatedEntryValueHolder;
        ValueHolder<K, V> removed;
        if (key != null && (removed = this.table.put(key, newValueHolder)) != null && removed.getRelatedKey() != null && (relatedEntryValueHolder = this.table.get(removed.getRelatedKey())) != null) {
            relatedEntryValueHolder.clearRelatedKey();
        }
    }

    public synchronized V get(K key) {
        ValueHolder<K, V> valueHolder;
        if (key != null && (valueHolder = this.table.get(key)) != null) {
            return valueHolder.getValue();
        }
        return null;
    }

    public synchronized V remove(K key) {
        ValueHolder<K, V> valueHolder;
        if (key != null && (valueHolder = this.table.remove(key)) != null) {
            if (valueHolder.getRelatedKey() != null) {
                this.table.remove(valueHolder.getRelatedKey());
            }
            return valueHolder.getValue();
        }
        return null;
    }

    public synchronized int getNumKeys() {
        return this.table.size();
    }

    private static class ValueHolder<K, V> {
        K relatedKey;
        V value;

        ValueHolder(K relatedKey, V value) {
            this.relatedKey = relatedKey;
            this.value = value;
        }

        K getRelatedKey() {
            return this.relatedKey;
        }

        V getValue() {
            return this.value;
        }

        void clearRelatedKey() {
            this.relatedKey = null;
        }
    }
}

