/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.rmi.Remote;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.rjvm.JVMID;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.utils.Debug;

public final class DisconnectMonitorImpl
implements DisconnectMonitorProvider {
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("DebugConnection");

    @Override
    public boolean addDisconnectListener(Remote stub, DisconnectListener listener) {
        DisconnectMonitorImpl.debug("addDisconnectListener(" + stub + ')');
        HostID hostID = DisconnectMonitorImpl.getHostIDFromStub(stub);
        if (hostID != null) {
            RMIRuntime.getRMIRuntime();
            EndPoint e = RMIRuntime.findEndPoint(hostID);
            if (e == null || e.isDead()) {
                DisconnectMonitorImpl.debug("Creating EndPoint for: " + stub + ", " + hostID);
                Debug.assertion(((JVMID)hostID).isServer());
                RMIRuntime.getRMIRuntime();
                e = RMIRuntime.findOrCreateEndPoint(hostID);
                if (e == null) {
                    DisconnectMonitorImpl.debug("Failed Creating EndPoint for: " + stub + ", " + hostID);
                }
            }
            if (e != null) {
                e.addDisconnectListener(stub, listener);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeDisconnectListener(Remote stub, DisconnectListener listener) {
        HostID hostID = DisconnectMonitorImpl.getHostIDFromStub(stub);
        if (hostID != null) {
            RMIRuntime.getRMIRuntime();
            EndPoint e = RMIRuntime.findEndPoint(hostID);
            if (e != null) {
                e.removeDisconnectListener(stub, listener);
            }
            return true;
        }
        return false;
    }

    private static HostID getHostIDFromStub(Remote o) {
        RemoteReference ref;
        HostID hostID;
        if (o == null) {
            return null;
        }
        if (o instanceof RemoteWrapper) {
            o = ((RemoteWrapper)((Object)o)).getRemoteDelegate();
        }
        if (o instanceof StubInfoIntf && (hostID = (ref = ((StubInfoIntf)((Object)o)).getStubInfo().getRemoteRef()).getHostID()) instanceof JVMID) {
            return hostID;
        }
        return null;
    }

    private static void debug(String msg) {
        if (debugConnection.isDebugEnabled()) {
            debugConnection.debug("<DisconnectMonitorImpl>: " + msg);
        }
    }
}

