/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import weblogic.common.internal.VersionInfo;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.basic.BasicT3ConnectionFactory;
import weblogic.rjvm.basic.BasicT3ProtocolHandler;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.utils.io.ChunkedObjectInputStream;
import weblogic.utils.io.ChunkedObjectOutputStream;

public class DefaultRJVMEnvironment
extends RJVMEnvironment {
    private static final int DEFAULT_ABBREV_TABLE_SIZE = 2048;
    private static final int DEFAULT_RJVM_IDLE_TIMEOUT = 0;
    private static final String DEFAULT_PROTOCOL_NAME = "t3";
    private static final String SECURE_PROTOCOL_NAME = "t3s";
    private static final String INTERNAL_CONTEXT_PATH = "/bea_wls_internal";
    private AuditableThreadLocal sslContextThreadLocal = AuditableThreadLocalFactory.createThreadLocal();

    @Override
    public void ensureInitialized() {
        VersionInfo.initialize("Oracle", "mSA", "12.1.2.0.0", "12.1.2.0.0", 12, 1, 2, 0, 0);
    }

    @Override
    public int getHeartbeatIdlePeriodsUntilTimeout() {
        return 4;
    }

    @Override
    public int getHeartbeatPeriodLengthMillis() {
        return 60000;
    }

    @Override
    public int getAbbrevTableSize() {
        return 2048;
    }

    @Override
    public boolean isTracingEnabled() {
        return false;
    }

    @Override
    public int getRjvmIdleTimeout() {
        return 0;
    }

    @Override
    public String getDefaultProtocolName() {
        return DEFAULT_PROTOCOL_NAME;
    }

    @Override
    public String getDefaultSecureProtocolName() {
        return SECURE_PROTOCOL_NAME;
    }

    @Override
    public String getAdminProtocolName() {
        return SECURE_PROTOCOL_NAME;
    }

    @Override
    public Class resolveProxyClass(String[] interfaces, String annotation, String codeBase) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Class[] intClasses = new Class[interfaces.length];
        for (int inc = 0; inc < interfaces.length; ++inc) {
            intClasses[inc] = cl.loadClass(interfaces[inc]);
        }
        return Proxy.getProxyClass(cl, intClasses);
    }

    @Override
    public Class resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
        return this.resolveProxyClass(interfaces, null, null);
    }

    @Override
    public Object copyObject(Object target) throws IOException, ClassNotFoundException {
        ChunkedObjectOutputStream objOut = new ChunkedObjectOutputStream();
        objOut.setReplacer(RemoteObjectReplacer.getReplacer());
        objOut.writeObject(target);
        objOut.close();
        ChunkedObjectInputStream objIn = new ChunkedObjectInputStream(objOut.getChunks(), 0);
        objIn.setReplacer(RemoteObjectReplacer.getReplacer());
        return objIn.readObject();
    }

    @Override
    public void registerRJVMProtocols() {
        RJVMManager.registerRJVMProtocol((byte)0, BasicT3ProtocolHandler.getHandler(), new BasicT3ConnectionFactory());
    }

    @Override
    public String getInternalWebAppContextPath() {
        return INTERNAL_CONTEXT_PATH;
    }

    @Override
    public ServerChannel createDefaultChannel(Protocol protocol) {
        return null;
    }

    @Override
    public boolean isLocalChannel(InetAddress address, int port) {
        return false;
    }

    @Override
    public String createClusterURL(ServerChannel channel) {
        throw new AssertionError((Object)"Clustering is not supported");
    }

    @Override
    public void invokeBootService(RemoteInvokable ri, MsgAbbrevInputStream input) throws RemoteException {
        throw new NoSuchObjectException("T3 Boot Services not implemented");
    }

    @Override
    public boolean isServerClusteringSupported() {
        return false;
    }

    @Override
    public ClassLoader getConnectionManagerClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public Object getSSLContext() {
        return this.sslContextThreadLocal.get();
    }

    @Override
    public void setSSLContext(Object sslContext) {
        this.sslContextThreadLocal.set(sslContext);
    }

    @Override
    public boolean isUserAnonymous(AuthenticatedSubject subject) {
        return SubjectUtils.isUserAnonymous(subject);
    }

    @Override
    public URLConnection createURLConnection(URL u, ServerChannel channel) throws IOException {
        return null;
    }

    @Override
    public RJVM getRJVM(byte targetQOS, HostID hostID) throws IOException {
        return null;
    }
}

