/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.MarshalException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import weblogic.common.internal.PeerInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.invocation.PartitionTable;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.InboundMsgAbbrev;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.JVMMessage;
import weblogic.rjvm.LocalRJVM;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.PartitionEventInterceptor;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneException;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.ProxyManager;
import weblogic.rjvm.RJVMImpl;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.RJVMManager;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.subject.SubjectManager;
import weblogic.utils.PropertyHelper;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class ConnectionManagerServer
extends ConnectionManager
implements PeerGoneListener {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final Set<ConnectionManagerServer> connectionManagers = Collections.newSetFromMap(new WeakHashMap());
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger("DebugConnection");
    private static final DebugLogger debugRouting = DebugLogger.getDebugLogger("DebugRouting");
    private PartitionEventInterceptor partitionEventInterceptor;
    private static boolean enableProtocolSwitch;
    private static boolean reuseDomainConnections;
    private static WorkManager msgRoutingWM;
    private static final int msgRoutingWMMinConstraint;
    private static InetAddress localhost;
    private boolean isMissedPeergone = false;
    private final HashMap<JVMID, RJVMImpl> table = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionManagerServer(RJVMImpl rjvm) {
        super(rjvm);
        if (rjvm != null) {
            this.partitionEventInterceptor = new PartitionEventInterceptor(this);
        }
        Set<ConnectionManagerServer> set = connectionManagers;
        synchronized (set) {
            connectionManagers.add(this);
            ConnectionManagerServer.initMsgRoutingWM();
        }
    }

    private static void initMsgRoutingWM() {
        if (msgRoutingWM == null) {
            msgRoutingWM = WorkManagerFactory.getInstance().findOrCreate("RJVMMsgRoutingWM", msgRoutingWMMinConstraint, -1);
        }
    }

    private boolean isLocalAddress(JVMID id) {
        InetAddress idAddress = id.address(true);
        InetAddress localAddress = JVMID.localID().address();
        return idAddress.equals(localAddress);
    }

    private boolean isLocal(JVMID id, MsgAbbrevJVMConnection connection) {
        boolean portMatches;
        int idPort;
        Protocol protocol;
        if (localhost == null) {
            try {
                localhost = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        boolean addressMatches = id.address().equals(connection.getLocalAddress()) || id.address().equals(JVMID.localID().address()) || id.address().equals(localhost) || this.thisRJVM == null && id.isBootstrapping();
        ServerChannel channel = connection.getChannel();
        if (!addressMatches && id.getPublicAddress() != null && channel != null) {
            addressMatches = id.getPublicAddress().equals(channel.getPublicAddress()) || id.getAddress().equals(channel.getPublicAddress());
        }
        Protocol adminProtocol = RJVMManager.getRJVMManager().getProtocol((byte)6);
        Protocol protocol2 = protocol = connection.getQOS() == 103 ? adminProtocol : connection.getProtocol();
        if (protocol != null && protocol.equals(adminProtocol)) {
            idPort = id.getPort(protocol);
            if (idPort == -1 && (idPort = id.getPort(RJVMManager.getRJVMManager().getProtocol((byte)2))) == -1) {
                idPort = id.getPort(RJVMManager.getRJVMManager().getProtocol((byte)3));
            }
        } else {
            idPort = id.getPort(protocol);
        }
        boolean bl = portMatches = idPort != -1 && (idPort == connection.getLocalPort() || idPort == JVMID.localID().getPort(protocol) || channel != null && idPort == channel.getPublicPort());
        if (enableProtocolSwitch || connection.proxied) {
            portMatches = this.thisRJVM == null && id.isBootstrapping() || portMatches;
        }
        return addressMatches && portMatches;
    }

    private static ManagedInvocationContext setPartitionInvocationContext(String partitionName) {
        ComponentInvocationContextManager manager = ComponentInvocationContextManager.getInstance(KERNEL_ID);
        ComponentInvocationContext cic = manager.createComponentInvocationContext(partitionName);
        return manager.setCurrentComponentInvocationContext(cic);
    }

    protected static String getCurrentPartitionName() {
        return ComponentInvocationContextManager.getInstance(KERNEL_ID).getCurrentComponentInvocationContext().getPartitionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    final void handleRJVM(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        Throwable throwable;
        ManagedInvocationContext mic;
        JVMMessage header = inputStream.getMessageHeader();
        if (!JVMID.localID().equals(header.dest)) {
            if (this.routeMsgForProxy(header.dest, inputStream)) {
                return;
            }
            if (this.isLocal(header.dest, connection)) {
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    debugConnection.debug("Message for this server has the wrong destination address: '" + header.dest + '\'');
                }
                this.sendPeerGoneMsg(header.dest, header.src, header.QOS, connection);
                return;
            }
            if (this.thisRJVM == null) {
                this.shouldNeverHappen(connection, "Server expected to route a message received over an uninitialized connection: '" + header + '\'');
                return;
            }
            this.connectionAppearsValid(connection);
            this.scheduleRouteMsg(inputStream);
            return;
        }
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            debugConnection.debug(String.format("ConnectionManagerServer Connection [%s] Current partition name [%s], pushing partition name [%s] in CIC", connection, ConnectionManagerServer.getCurrentPartitionName(), connection.getLocalPartitionName()));
        }
        try {
            block35: {
                block36: {
                    block37: {
                        block32: {
                            block33: {
                                block34: {
                                    mic = ConnectionManagerServer.setPartitionInvocationContext(connection.getLocalPartitionName());
                                    throwable = null;
                                    if (this.thisRJVM != null) break block32;
                                    this.shouldNeverHappen(connection, "Server received a message over an uninitialized connection: '" + header + '\'');
                                    if (mic == null) break block33;
                                    if (throwable == null) break block34;
                                    try {
                                        mic.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block33;
                                }
                                mic.close();
                            }
                            if (!KernelStatus.DEBUG) return;
                            if (!debugConnection.isDebugEnabled()) return;
                            debugConnection.debug(String.format("ConnectionManagerServer Popped Local partition Name [%s] Connection[%s], current CIC partition name is [%s]", connection.getLocalPartitionName(), connection, ConnectionManagerServer.getCurrentPartitionName()));
                            return;
                        }
                        if (!this.missedPeerGone(connection, inputStream, header)) break block35;
                        if (mic == null) break block36;
                        if (throwable == null) break block37;
                        try {
                            mic.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block36;
                    }
                    mic.close();
                }
                if (!KernelStatus.DEBUG) return;
                if (!debugConnection.isDebugEnabled()) return;
                debugConnection.debug(String.format("ConnectionManagerServer Popped Local partition Name [%s] Connection[%s], current CIC partition name is [%s]", connection.getLocalPartitionName(), connection, ConnectionManagerServer.getCurrentPartitionName()));
                return;
            }
            try {
                this.connectionAppearsValid(connection);
                if (this.thisRJVM.getID().equals(header.src)) {
                    this.thisRJVM.dispatch(inputStream);
                    break block38;
                }
                RJVMImpl theRJVM = RJVMManager.getRJVMManager().findRemote(header.src);
                if (theRJVM == null) {
                    if (header.cmd == JVMMessage.Command.CMD_INTERNAL && ProxyManager.getProxyManager().shouldUseProxy(header.src)) {
                        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                            debugConnection.debug("Server received a heartbeat message from an unknown JVM: '" + header.src + "'. Ignoring");
                        }
                        break block38;
                    }
                    this.shouldNeverHappen(connection, "Server received a routed message from an unknown JVM: '" + header.src + '\'');
                    break block38;
                }
                theRJVM.dispatch(inputStream);
                break block38;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            if (!KernelStatus.DEBUG) throw throwable6;
            if (!debugConnection.isDebugEnabled()) throw throwable6;
            debugConnection.debug(String.format("ConnectionManagerServer Popped Local partition Name [%s] Connection[%s], current CIC partition name is [%s]", connection.getLocalPartitionName(), connection, ConnectionManagerServer.getCurrentPartitionName()));
            throw throwable6;
        }
        {
            block38: {
                finally {
                    if (mic != null) {
                        if (throwable != null) {
                            try {
                                mic.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            mic.close();
                        }
                    }
                }
            }
            if (!KernelStatus.DEBUG) return;
            if (!debugConnection.isDebugEnabled()) return;
        }
        debugConnection.debug(String.format("ConnectionManagerServer Popped Local partition Name [%s] Connection[%s], current CIC partition name is [%s]", connection.getLocalPartitionName(), connection, ConnectionManagerServer.getCurrentPartitionName()));
    }

    private synchronized void connectionAppearsValid(MsgAbbrevJVMConnection connection) {
        if (this.getConnectionInPairedConnTable(connection) != connection) {
            // empty if block
        }
    }

    private boolean missedPeerGone(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream, JVMMessage header) {
        if (this.isMissedPeergone) {
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                debugConnection.debug("Another message came in before we swapped the connection manager: Received  " + header);
            }
            RJVMImpl theRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(header.src);
            ConnectionManager connMgr = theRJVM.findOrCreateConMan();
            if (((ConnectionManagerServer)connMgr).isMissedPeergone) {
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    debugConnection.debug("swapped connection manager '" + connMgr + "' is already in missedPeerGone mode !");
                }
                this.shouldNeverHappen(connection, "Unable to swap connection manager in missedPeerGone handling");
            }
            inputStream.setConnectionManager(connMgr);
            connMgr.handleRJVM(connection, inputStream);
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                debugConnection.debug("A response for this message must have been sent  :" + header);
            }
            return true;
        }
        MsgAbbrevJVMConnection existingConnection = this.getConnectionInPairedConnTable(connection);
        if (existingConnection == null || connection == existingConnection) {
            return false;
        }
        if (existingConnection.getMessagesSentCount() < 2L && existingConnection.getMessagesReceivedCount() < 2L) {
            return false;
        }
        if (header.src.isServer() && header.dest.isServer() && !this.possibleMissedPeergone) {
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                debugConnection.debug("Duplicate Connection between servers detected.");
            }
            return false;
        }
        this.isMissedPeergone = true;
        this.possibleMissedPeergone = false;
        connection.setWaitForPeergone(true);
        PeerInfo pi = this.thisRJVM.getPeerInfo();
        int periodLengthMillis = this.thisRJVM.getPeriodLengthMillis();
        byte[] sharedSecret = this.thisRJVM.getSharedSecret();
        this.thisRJVM.peerGone(new PeerGoneException("Duplicate Connection [" + connection.getChannel() + "]. RJVM Being Shutdown in favor of [" + existingConnection.getChannel() + ']'));
        RJVMImpl theRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(header.src);
        theRJVM.setSharedSecret(sharedSecret);
        theRJVM.completeConnectionSetup(periodLengthMillis, null, pi, connection, header.QOS);
        ConnectionManager theConMan = ConnectionManager.create(theRJVM);
        theConMan = theRJVM.findOrSetConMan(theConMan);
        inputStream.setConnectionManager(theConMan);
        if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
            debugConnection.debug("ConnectionManager in MsgAbbrevInputStream was replaced due to Missed peergone/Duplicate Connection.\n Old connection manager was '" + this + "'. New connection manager is '" + theConMan + '\'');
        }
        connection.setDispatcher(theConMan, false);
        theConMan.handleRJVM(connection, inputStream);
        return true;
    }

    @Override
    final void handleIdentifyRequest(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        JVMMessage header = inputStream.getMessageHeader();
        JVMID me = JVMID.localID();
        JVMID src = header.src;
        JVMID dest = header.dest;
        boolean proxied = false;
        if (src.isClient() && connection.proxied && !dest.equals(JVMID.localID())) {
            debugConnection.debug("Received a proxied connection" + src.toString());
            if (connection.getInetAddress() != null && dest.getInetAddress().equals(connection.getInetAddress())) {
                proxied = true;
            }
        }
        if (!(src.isServer() || src.getRouter() != null && src.getRouter().equals(me) && !proxied)) {
            src.setRouter(me);
        }
        if (!me.equals(dest) && this.routeMsgForProxy(header.dest, inputStream, connection)) {
            return;
        }
        if (header.cmd != JVMMessage.Command.CMD_NO_ROUTE_IDENTIFY_REQUEST && !me.equals(dest) && !this.isLocal(dest, connection)) {
            if (this.thisRJVM == null) {
                if (!dest.isBootstrapping()) {
                    this.shouldNeverHappen(connection, "Server expected to route a message received over an uninitialized connection: '" + header + '\'');
                } else {
                    RJVMLogger.logBadNAT(header.toString());
                    this.gotExceptionReceiving(connection, new IOException("Bad NAT request"));
                }
            } else {
                this.connectionAppearsValid(connection);
                this.scheduleRouteMsg(inputStream);
            }
            return;
        }
        if (!me.equals(dest) && this.isLocal(dest, connection) && !dest.isBootstrapping()) {
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                debugConnection.debug("CMD_IDENTIFY_REQUEST for this JVM has the wrong destination address: '" + dest + '\'');
            }
            this.sendPeerGoneMsg(dest, src, header.QOS, connection);
            return;
        }
        int remotePeriodLength = ConnectionManagerServer.readRemotePeriodLength(inputStream);
        byte[] sharedSecret = ConnectionManagerServer.readPublickey(inputStream);
        PeerInfo peerInfo = header.cmd == JVMMessage.Command.CMD_IDENTIFY_REQUEST_CSHARP ? ConnectionManagerServer.readDotNetClientPeerInfo(inputStream) : ConnectionManagerServer.readPeerInfo(inputStream);
        ServerChannel networkChannel = inputStream.getServerChannel();
        JVMMessage.Command responseCode = header.cmd == JVMMessage.Command.CMD_IDENTIFY_REQUEST_CSHARP ? JVMMessage.Command.CMD_IDENTIFY_RESPONSE_CSHARP : JVMMessage.Command.CMD_IDENTIFY_RESPONSE;
        MsgAbbrevOutputStream outputStream = (this.thisRJVM == null || !src.equals(this.thisRJVM.getID())) && peerInfo.getMajor() > 6 ? this.createIdentifyMsg(src, header.QOS, responseCode, networkChannel, peerInfo, dest) : this.createIdentifyMsg(src, header.QOS, responseCode, null, null);
        if (connection.getQOS() == 103) {
            outputStream.header.invokableId = 7938;
        }
        connection.sendMsg(outputStream);
        if (me.equals(src) || src.isBootstrapping() && this.isLocal(src, connection)) {
            if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                debugConnection.debug("Received CMD_IDENTIFY_REQUEST from self");
            }
            return;
        }
        RJVMImpl theRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(src);
        if (header.cmd == JVMMessage.Command.CMD_IDENTIFY_REQUEST_CSHARP) {
            theRJVM.setCSharpClient();
        }
        peerInfo.setIsServer(theRJVM.getID().isServer());
        theRJVM.completeConnectionSetup(remotePeriodLength, sharedSecret, peerInfo, connection, header.QOS);
        if (this.thisRJVM == null) {
            this.thisRJVM = theRJVM;
            ConnectionManager theConMan = this.thisRJVM.findOrSetConMan(this);
            connection.setDispatcher(theConMan, false);
            ConnectionManagerServer.setAppletRouter(theConMan);
            MsgAbbrevJVMConnection existingConnection = this.getConnectionInPairedConnTable(connection);
            if (existingConnection != null && existingConnection != connection) {
                theConMan.possibleMissedPeergone = existingConnection.getMessagesReceivedCount() >>> 1 > 0L;
            }
        } else if (this.thisRJVM.getID().equals(src)) {
            this.shouldNeverHappen(connection, "Server received an unrouted CMD_IDENTIFY_REQUEST through an established connection");
        } else {
            theRJVM.findOrCreateConManRouter(this);
            if (KernelStatus.DEBUG && debugRouting.isDebugEnabled()) {
                debugRouting.debug("Saving second stop server " + this + " as the router to " + src);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void handleIdentifyResponse(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        JVMMessage header = inputStream.getMessageHeader();
        JVMID me = JVMID.localID();
        JVMID src = header.src;
        JVMID dest = header.dest;
        if (!me.equals(dest)) {
            if (this.routeMsgForProxy(header.dest, inputStream)) {
                return;
            }
            if (this.isLocal(dest, connection)) {
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    debugConnection.debug("CMD_IDENTIFY_RESPONSE for this JVM has the wrong destination address: '" + dest + '\'');
                }
            } else {
                this.connectionAppearsValid(connection);
                this.scheduleRouteMsg(inputStream);
            }
        } else {
            if (me.equals(src)) {
                ConnectionManager bootstrapConMan;
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    debugConnection.debug("Received CMD_IDENTIFY_RESPONSE from self");
                }
                if (this.thisRJVM == null) {
                    this.bootstrapRJVM = LocalRJVM.getLocalRJVM();
                    bootstrapConMan = connection.getDispatcher();
                } else {
                    bootstrapConMan = this.thisRJVM.findOrCreateConMan();
                }
                if (bootstrapConMan != null) {
                    bootstrapConMan.bootstrapResponseReceived = true;
                    Object object = bootstrapConMan.bootstrapResult;
                    synchronized (object) {
                        bootstrapConMan.bootstrapResult.notify();
                    }
                }
                this.cleanShutdown(connection);
                return;
            }
            int remotePeriodLength = ConnectionManagerServer.readRemotePeriodLength(inputStream);
            byte[] sharedSecret = ConnectionManagerServer.readPublickey(inputStream);
            PeerInfo peerInfo = ConnectionManagerServer.readPeerInfo(inputStream);
            if (peerInfo != null && peerInfo.compareTo(PeerInfo.VERSION_DIABLO) >= 0) {
                src.cleanupPorts();
            }
            RJVMImpl theRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(src);
            if (peerInfo != null) {
                peerInfo.setIsServer(theRJVM.getID().isServer());
            }
            if (src.shouldUseProxy()) {
                theRJVM.findOrCreateConMan();
            } else {
                theRJVM.findOrSetConMan(this);
            }
            this.bootstrapRJVM = this.thisRJVM;
            theRJVM.completeConnectionSetup(remotePeriodLength, sharedSecret, peerInfo, connection, header.QOS);
            ConnectionManager theConMan = null;
            ConnectionManager bootstrapConMan = null;
            if (this.thisRJVM == null) {
                this.thisRJVM = theRJVM;
                theConMan = this.thisRJVM.findOrSetConMan(this);
                if (theConMan != this && KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    debugConnection.debug("Another bootstrapping RJVM beat us to creating a connection");
                }
                bootstrapConMan = connection.getDispatcher();
                if (header.invokableId == 7938) {
                    this.thisRJVM.convertedToAdminQOS = true;
                }
                theConMan.possibleMissedPeergone = false;
                connection.setDispatcher(theConMan, true);
                ConnectionManagerServer.setAppletRouter(theConMan);
            } else if (this.thisRJVM.getID().equals(src)) {
                bootstrapConMan = theConMan = this.thisRJVM.findOrCreateConMan();
                ConnectionManagerServer.setAppletRouter(theConMan);
            } else {
                if (ProxyManager.getProxyManager().shouldUseProxy(src)) {
                    bootstrapConMan = this.findMatchingBootstrapConMan(src);
                }
                if (bootstrapConMan == null) {
                    bootstrapConMan = theRJVM.findOrCreateConMan();
                }
            }
            if (this.thisRJVM != theRJVM) {
                if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                    debugConnection.debug(" Replacing thisRJVM  : " + this.thisRJVM + " with theRJVM : " + theRJVM + " as RJVMManager returned a new RJVM for source");
                }
                this.thisRJVM = theRJVM;
            }
            if (theConMan != null) {
                connection.setClusterInfo(ConnectionManagerServer.readClusterInfo(inputStream, peerInfo, theRJVM.getID()));
            }
            if (bootstrapConMan != null) {
                bootstrapConMan.bootstrapResponseReceived = true;
                bootstrapConMan.bootstrapRJVM = src.shouldUseProxy() ? theRJVM : this.thisRJVM;
                Object object = bootstrapConMan.bootstrapResult;
                synchronized (object) {
                    bootstrapConMan.bootstrapResult.notify();
                }
            }
        }
    }

    private ConnectionManager findMatchingBootstrapConMan(JVMID src) {
        for (ConnectionManager connectionManager : connectionManagers) {
            if (connectionManager.getJVMID() == null || !connectionManager.getJVMID().shouldUseProxy() || !connectionManager.waitingForBootstrapResult || !ProxyManager.matchesHostAddress(src, connectionManager.getJVMID().getHostAddress())) continue;
            return connectionManager;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void handlePeerGone(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        if (this.thisRJVM == null) {
            ConnectionManager bootstrapConMan = connection.getDispatcher();
            if (bootstrapConMan != null) {
                bootstrapConMan.bootstrapResponseReceived = true;
                this.bootstrapRJVM = null;
                Object object = bootstrapConMan.bootstrapResult;
                synchronized (object) {
                    bootstrapConMan.bootstrapResult.notify();
                }
            }
        } else {
            JVMMessage header = inputStream.getMessageHeader();
            if (!JVMID.localID().equals(header.dest)) {
                if (this.routeMsgForProxy(header.dest, inputStream)) {
                    return;
                }
                if (this.isLocal(header.dest, connection)) {
                    if (KernelStatus.DEBUG && debugConnection.isDebugEnabled()) {
                        debugConnection.debug("PeerGone message for this JVM has the wrong destination address: '" + header.dest + '\'');
                    }
                } else {
                    this.connectionAppearsValid(connection);
                    this.scheduleRouteMsg(inputStream);
                }
            } else {
                String message = "Peer requested connection shutdown";
                if (this.thisRJVM.getID().equals(header.src)) {
                    this.thisRJVM.findOrCreateConMan();
                    this.thisRJVM.peerGone(new PeerGoneException(message));
                } else {
                    RJVMImpl theRJVM = RJVMManager.getRJVMManager().findRemote(header.src);
                    if (theRJVM != null) {
                        theRJVM.findOrCreateConMan();
                        theRJVM.peerGone(new PeerGoneException(message));
                    }
                }
            }
        }
    }

    private boolean routeMsgForProxy(JVMID dest, MsgAbbrevInputStream inputStream) {
        return this.routeMsgForProxy(dest, inputStream, null);
    }

    private boolean routeMsgForProxy(JVMID dest, MsgAbbrevInputStream inputStream, MsgAbbrevJVMConnection connection) {
        if (dest.shouldUseProxy() && !this.isLocalAddress(dest)) {
            this.scheduleRouteMsg(inputStream, connection);
            return true;
        }
        return false;
    }

    private void scheduleRouteMsg(MsgAbbrevInputStream inputStream) {
        this.scheduleRouteMsg(inputStream, null);
    }

    private void scheduleRouteMsg(final MsgAbbrevInputStream inputStream, final MsgAbbrevJVMConnection connection) {
        final AuthenticatedSubject subject = RMIEnvironment.getEnvironment().getCurrentSubjectForWire(KERNEL_ID);
        Runnable routeMsg = new Runnable(){

            @Override
            public void run() {
                if (subject != null) {
                    SubjectManager.getSubjectManager().pushSubject(KERNEL_ID, subject);
                }
                ConnectionManagerServer.this.routeMsg(inputStream, connection);
            }
        };
        msgRoutingWM.schedule(routeMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final synchronized void shutdown() {
        if (this.partitionEventInterceptor != null) {
            this.partitionEventInterceptor.close();
        }
        super.shutdown();
        HashMap<JVMID, RJVMImpl> hashMap = this.table;
        synchronized (hashMap) {
            Iterator<RJVMImpl> routers = this.table.values().iterator();
            while (routers.hasNext()) {
                RJVMImpl rjvm = routers.next();
                JVMID thisRJVMID = this.thisRJVM.getID();
                rjvm.findOrCreateConMan().cancelIO(thisRJVMID);
                rjvm.removePeerGoneListener(this);
                routers.remove();
            }
        }
    }

    private static void copyMessageContext(MsgAbbrevInputStream inputStream, MsgAbbrevOutputStream outputStream, boolean preserveAbbrevs) throws IOException {
        InboundMsgAbbrev abbrevs = inputStream.getAbbrevs();
        abbrevs.writeTo(outputStream, preserveAbbrevs);
        outputStream.setUser(inputStream.getAuthenticatedUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoutersTable(RJVMImpl destRJVM) {
        HashMap<JVMID, RJVMImpl> hashMap = this.table;
        synchronized (hashMap) {
            RJVMImpl res = this.table.get(destRJVM.getID());
            if (res == null) {
                this.table.put(destRJVM.getID(), destRJVM);
                destRJVM.addPeerGoneListener(this);
            }
        }
    }

    private void routeMsg(MsgAbbrevInputStream inputStream, MsgAbbrevJVMConnection connection) {
        MsgAbbrevJVMConnection outConnection;
        MsgAbbrevOutputStream outputStream;
        boolean setupNeeded;
        JVMMessage header = inputStream.getMessageHeader();
        boolean bl = setupNeeded = connection != null && this.thisRJVM == null;
        if (KernelStatus.DEBUG && debugRouting.isDebugEnabled()) {
            debugRouting.debug("Routing message to: " + header.dest);
        }
        RJVMImpl destRJVM = null;
        String remotePN = inputStream.getConnection().getRemotePartitionName();
        try {
            int n;
            JVMID destJVMID = header.dest;
            if (destJVMID.isServer()) {
                destRJVM = RJVMManager.getRJVMManager().findRemoteForRouting(header.dest);
                if (destRJVM == null) {
                    destRJVM = (RJVMImpl)RJVMManager.getRJVMManager().findOrCreate(destJVMID.getHostAddress(), destJVMID.getInetAddress(), destJVMID.getPort(), inputStream.getProtocol().getProtocolName(), null, 0, inputStream.getConnection().getLocalPartitionURL());
                }
            } else {
                destRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(header.dest);
            }
            outputStream = destRJVM.findOrCreateConMan().getOutputStreamByName(null, remotePN);
            outputStream.header.init(header, true);
            ConnectionManagerServer.copyMessageContext(inputStream, outputStream, setupNeeded);
            if (setupNeeded) {
                inputStream.mark(0);
            }
            byte[] tmp = new byte[1024];
            for (int toCopy = header.abbrevOffset - inputStream.pos(); toCopy > 0; toCopy -= n) {
                n = inputStream.read(tmp, 0, Math.min(tmp.length, toCopy));
                outputStream.write(tmp, 0, n);
            }
        }
        catch (IOException e) {
            this.gotExceptionSending(header, new MarshalException("Error creating routed message", e));
            return;
        }
        try {
            outConnection = destRJVM.findOrCreateConMan().getOrMakeConnection(header.QOS, remotePN);
        }
        catch (IOException e) {
            this.gotExceptionSending(header, new ConnectException("Error creating connection to: '" + destRJVM.getID() + "' while routing message", e));
            return;
        }
        if (outConnection == null) {
            this.gotExceptionSending(header, new ConnectException("Unable to get a direct connection to: '" + destRJVM + '\''));
            return;
        }
        this.updateRoutersTable(destRJVM);
        if (setupNeeded) {
            this.setRJVMFromRoutedMessage(inputStream, connection);
        }
        outConnection.sendMsg(outputStream);
    }

    private void setRJVMFromRoutedMessage(MsgAbbrevInputStream inputStream, MsgAbbrevJVMConnection connection) {
        JVMMessage header = inputStream.header;
        inputStream.reset();
        int remotePeriodLength = ConnectionManagerServer.readRemotePeriodLength(inputStream);
        byte[] sharedSecret = ConnectionManagerServer.readPublickey(inputStream);
        PeerInfo peerInfo = header.cmd == JVMMessage.Command.CMD_IDENTIFY_REQUEST_CSHARP ? ConnectionManagerServer.readDotNetClientPeerInfo(inputStream) : ConnectionManagerServer.readPeerInfo(inputStream);
        RJVMImpl srcRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(JVMID.createForRouteMsgOnly(header.src));
        ConnectionManager theConMan = srcRJVM.findOrSetConMan(this);
        connection.setDispatcher(theConMan, false);
        connection.setForMultipleSrcs(true);
        ConnectionManagerServer.setAppletRouter(theConMan);
        peerInfo.setIsServer(srcRJVM.getID().isServer());
        srcRJVM.completeConnectionSetup(remotePeriodLength, sharedSecret, peerInfo, connection, header.QOS);
        if (this.thisRJVM == null) {
            this.thisRJVM = srcRJVM;
            this.thisRJVM.addPeerGoneListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerGone(PeerGoneEvent e) {
        RJVMImpl rjvm = (RJVMImpl)e.getSource();
        JVMID rjvmID = rjvm.getID();
        HashMap<JVMID, RJVMImpl> hashMap = this.table;
        synchronized (hashMap) {
            RJVMImpl res = this.table.get(rjvmID);
            if (res == null) {
                return;
            }
            this.table.remove(rjvmID);
        }
        this.sendPeerGoneMsg(rjvmID, this.thisRJVM.getID(), (byte)101, null);
    }

    @Override
    String getPartitionNameByURL(String partitionURL) {
        String pName = super.getPartitionNameByURL(partitionURL);
        if (pName == null && reuseDomainConnections) {
            try {
                pName = PartitionTable.getInstance().lookup(partitionURL).getPartitionName();
            }
            catch (URISyntaxException ex) {
                return PartitionTable.getInstance().getGlobalPartitionName();
            }
        }
        return pName;
    }

    static {
        String s = System.getProperty("weblogic.rjvm.enableprotocolswitch");
        if (s != null) {
            enableProtocolSwitch = true;
        }
        reuseDomainConnections = PropertyHelper.getBoolean("weblogic.rjvm.reuseDomainConnections");
        msgRoutingWMMinConstraint = PropertyHelper.getInteger("weblogic.rjvm.msgrouting.wm.min", 3);
        localhost = null;
    }
}

