/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rjvm;

import weblogic.common.internal.PeerInfo;
import weblogic.rjvm.ConnectionManager;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.JVMMessage;
import weblogic.rjvm.MsgAbbrevInputStream;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.PeerGoneException;
import weblogic.rjvm.RJVMImpl;
import weblogic.rjvm.RJVMManager;
import weblogic.rmi.extensions.UnrecoverableConnectionException;

public final class ConnectionManagerClient
extends ConnectionManager {
    public ConnectionManagerClient(RJVMImpl rjvm) {
        super(rjvm);
    }

    @Override
    final void handleRJVM(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        JVMMessage header = inputStream.getMessageHeader();
        if (!JVMID.localID().equals(header.dest)) {
            this.shouldNeverHappen(connection, "Client received a message for the wrong JVM: '" + header.dest + '\'');
            return;
        }
        if (this.thisRJVM == null) {
            this.shouldNeverHappen(connection, "Client received a message over an uninitialized connection: '" + header + '\'');
            return;
        }
        if (this.thisRJVM.getID().equals(header.src)) {
            this.thisRJVM.dispatch(inputStream);
        } else {
            RJVMImpl theRJVM = RJVMManager.getRJVMManager().findRemote(header.src);
            if (theRJVM == null) {
                this.shouldNeverHappen(connection, "Client received a routed message from an unknown JVM: '" + header.src + '\'');
            } else {
                theRJVM.dispatch(inputStream);
            }
        }
    }

    @Override
    final void handleIdentifyRequest(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        JVMMessage header = inputStream.getMessageHeader();
        if (!JVMID.localID().equals(header.dest)) {
            this.shouldNeverHappen(connection, "Client received a CMD_IDENTIFY_REQUEST for the wrong JVM: '" + header.dest + '\'');
            return;
        }
        if (this.thisRJVM == null) {
            this.shouldNeverHappen(connection, "Client received a CMD_IDENTIFY_REQUEST over an uninitialized connection.");
            return;
        }
        if (this.thisRJVM.getID().equals(header.src)) {
            this.shouldNeverHappen(connection, "Client received an unrouted CMD_IDENTIFY_REQUEST through an established connection");
            return;
        }
        MsgAbbrevOutputStream outputStream = this.createIdentifyMsg(header.src, header.QOS, JVMMessage.Command.CMD_IDENTIFY_RESPONSE, connection.getChannel(), null);
        connection.sendMsg(outputStream);
        int remotePeriodLength = ConnectionManagerClient.readRemotePeriodLength(inputStream);
        byte[] sharedSecret = ConnectionManagerClient.readPublickey(inputStream);
        PeerInfo peerInfo = ConnectionManagerClient.readPeerInfo(inputStream);
        RJVMImpl theRJVM = RJVMManager.getRJVMManager().findOrCreateRemote(header.src);
        peerInfo.setIsServer(theRJVM.getID().isServer());
        theRJVM.completeConnectionSetup(remotePeriodLength, sharedSecret, peerInfo, connection, header.QOS);
        if (!this.thisRJVM.getID().equals(theRJVM.getID())) {
            theRJVM.findOrCreateConManRouter(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void handleIdentifyResponse(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        ConnectionManager bootstrapConMan;
        JVMMessage header = inputStream.getMessageHeader();
        JVMID me = JVMID.localID();
        JVMID src = header.src;
        JVMID dest = header.dest;
        if (!me.equals(dest)) {
            this.shouldNeverHappen(connection, "Client received a CMD_IDENTIFY_RESPONSE for the wrong JVM: '" + dest + '\'');
        }
        if (!(dest.getRouter() == null || me.getRouter() != null && dest.getRouter().equals(me.getRouter()))) {
            me.setRouter(dest.getRouter());
        }
        int remotePeriodLength = ConnectionManagerClient.readRemotePeriodLength(inputStream);
        byte[] sharedSecret = ConnectionManagerClient.readPublickey(inputStream);
        PeerInfo peerInfo = ConnectionManagerClient.readPeerInfo(inputStream);
        if (peerInfo != null && peerInfo.compareTo(PeerInfo.VERSION_DIABLO) >= 0) {
            src.cleanupPorts();
        }
        RJVMImpl theRJVM = (RJVMImpl)RJVMManager.getRJVMManager().findOrCreate(src);
        if (peerInfo != null) {
            peerInfo.setIsServer(theRJVM.getID().isServer());
        }
        theRJVM.completeConnectionSetup(remotePeriodLength, sharedSecret, peerInfo, connection, header.QOS);
        ConnectionManager theConMan = null;
        if (this.thisRJVM == null) {
            this.thisRJVM = theRJVM;
            theConMan = this.thisRJVM.findOrSetConMan(this);
            bootstrapConMan = connection.getDispatcher();
            bootstrapConMan.bootstrapRJVM = this.thisRJVM;
            connection.setDispatcher(theConMan, true);
            if (header.invokableId == 7938) {
                this.thisRJVM.convertedToAdminQOS = true;
            }
            ConnectionManagerClient.setAppletRouter(theConMan);
        } else if (this.thisRJVM.getID().equals(src)) {
            bootstrapConMan = theConMan = this.thisRJVM.findOrCreateConMan();
            ConnectionManagerClient.setAppletRouter(theConMan);
        } else {
            bootstrapConMan = theRJVM.findOrCreateConMan();
        }
        if (theConMan != null) {
            connection.setClusterInfo(ConnectionManagerClient.readClusterInfo(inputStream, peerInfo, theRJVM.getID()));
        }
        if (bootstrapConMan != null) {
            bootstrapConMan.bootstrapResponseReceived = true;
            Object object = bootstrapConMan.bootstrapResult;
            synchronized (object) {
                if (this.bootstrapRJVM == null) {
                    this.bootstrapRJVM = theRJVM;
                }
                bootstrapConMan.bootstrapResult.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void handlePeerGone(MsgAbbrevJVMConnection connection, MsgAbbrevInputStream inputStream) {
        if (this.thisRJVM == null) {
            ConnectionManager bootstrapConMan = connection.getDispatcher();
            if (bootstrapConMan != null) {
                bootstrapConMan.bootstrapResponseReceived = true;
                this.bootstrapRJVM = null;
                Object object = bootstrapConMan.bootstrapResult;
                synchronized (object) {
                    bootstrapConMan.bootstrapResult.notify();
                }
            }
        } else {
            JVMMessage header = inputStream.getMessageHeader();
            if (!JVMID.localID().equals(header.dest)) {
                this.shouldNeverHappen(connection, "Client received a CMD_PEER_GONE for the wrong JVM: '" + header.dest + '\'');
                return;
            }
            String message = "Peer requested connection shutdown";
            if (this.thisRJVM.getID().equals(header.src)) {
                ConnectionManager bootstrapConMan = this.thisRJVM.findOrCreateConMan();
                this.thisRJVM.peerGone(new UnrecoverableConnectionException(message));
            } else {
                RJVMImpl theRJVM = RJVMManager.getRJVMManager().findRemote(header.src);
                if (theRJVM != null) {
                    theRJVM.findOrCreateConMan();
                    theRJVM.peerGone(new PeerGoneException(message));
                }
            }
        }
    }
}

