/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.net.SocketAddress;
import weblogic.protocol.ChannelList;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.spi.HostID;

public abstract class ServerChannelManager {
    private static volatile ServerChannelManager singleton;

    @Deprecated
    public static ServerChannel findServerChannel(HostID identity) {
        return ServerChannelManager.getServerChannelManager().getServerChannel(identity);
    }

    public static ServerChannel findServerChannel(HostID identity, Protocol protocol) {
        return ServerChannelManager.getServerChannelManager().getServerChannel(identity, protocol);
    }

    public static ServerChannel findServerChannel(HostID identity, Protocol protocol, String channelName) {
        return ServerChannelManager.getServerChannelManager().getServerChannel(identity, protocol, channelName);
    }

    public static ServerChannel findServerChannel(HostID identity, String channelName) {
        return ServerChannelManager.getServerChannelManager().getServerChannel(identity, channelName);
    }

    public static ServerChannel lookupServerChannel(HostID identity, String channelName) {
        return ServerChannelManager.getServerChannelManager().getAvailableServerChannel(identity, channelName);
    }

    public static int findLocalServerPort(Protocol protocol) {
        ServerChannel sc = ServerChannelManager.getServerChannelManager().getServerChannel((HostID)LocalServerIdentity.getIdentity(), protocol);
        if (sc == null) {
            return -1;
        }
        return sc.getPublicPort();
    }

    public static ServerChannel findLocalServerChannel(Protocol protocol) {
        return ServerChannelManager.getServerChannelManager().getServerChannel((HostID)LocalServerIdentity.getIdentity(), protocol);
    }

    public static ServerChannel findIPv4LocalServerChannel(Protocol protocol) {
        return ServerChannelManager.getServerChannelManager().getIPv4ServerChannel(LocalServerIdentity.getIdentity(), protocol);
    }

    public static ServerChannel findIPv6LocalServerChannel(Protocol protocol) {
        return ServerChannelManager.getServerChannelManager().getIPv6ServerChannel(LocalServerIdentity.getIdentity(), protocol);
    }

    public static ServerChannel findLocalServerChannel(String partitionName, String vtName, Protocol protocol) {
        return ServerChannelManager.getServerChannelManager().getServerChannel(LocalServerIdentity.getIdentity(), partitionName, vtName, protocol);
    }

    public static ServerChannel findLocalServerChannel(Protocol protocol, String channelName) {
        return ServerChannelManager.getServerChannelManager().getServerChannel(LocalServerIdentity.getIdentity(), protocol, channelName);
    }

    public static ServerChannel findLocalServerChannel(String channelName) {
        return ServerChannelManager.getServerChannelManager().getServerChannel((HostID)LocalServerIdentity.getIdentity(), channelName);
    }

    public static ServerChannel findDefaultLocalServerChannel() {
        ServerChannel sc = ServerChannelManager.findLocalServerChannel(ProtocolManager.getDefaultProtocol());
        if (sc == null && (sc = ServerChannelManager.findLocalServerChannel(ProtocolManager.getDefaultSecureProtocol())) == null) {
            sc = ServerChannelManager.findLocalServerChannel(ProtocolHandlerAdmin.PROTOCOL_ADMIN);
        }
        return sc;
    }

    public static String findLocalServerAddress(Protocol protocol) {
        ServerChannel sc = ServerChannelManager.getServerChannelManager().getServerChannel((HostID)LocalServerIdentity.getIdentity(), protocol);
        if (sc == null) {
            return null;
        }
        return sc.getPublicAddress();
    }

    public static ServerChannel findRelatedServerChannel(HostID identity, Protocol protocol, String publicAddress) {
        return ServerChannelManager.getServerChannelManager().getRelatedServerChannel(identity, protocol, publicAddress);
    }

    public static ServerChannel findOutboundServerChannel(Protocol protocol, String channelName) {
        return ServerChannelManager.getServerChannelManager().getOutboundServerChannel(protocol, channelName);
    }

    public static ServerChannel findOutboundServerChannel(Protocol protocol) {
        return ServerChannelManager.getServerChannelManager().getOutboundServerChannel(protocol, null);
    }

    public static ServerChannel findOutboundServerChannel(String channelName) {
        return ServerChannelManager.getServerChannelManager().getOutboundServerChannel(null, channelName);
    }

    public static ChannelList getLocalChannelsForExport() {
        return ServerChannelManager.getServerChannelManager().getLocalChannelList();
    }

    public static String findServerChannelNameForPeer(SocketAddress sa) {
        return ServerChannelManager.getServerChannelManager().findPreferredChannelName(sa);
    }

    public static final ServerChannelManager getServerChannelManager() {
        if (singleton == null) {
            singleton = SingletonMaker.singleton;
        }
        return singleton;
    }

    public static final void setServerChannelManager(ServerChannelManager manager) {
        singleton = manager;
    }

    public abstract long getAdminChannelCreationTime();

    public abstract ServerChannel getServerChannel(HostID var1);

    protected abstract ServerChannel getServerChannel(HostID var1, Protocol var2);

    protected abstract ServerChannel getIPv4ServerChannel(HostID var1, Protocol var2);

    protected abstract ServerChannel getIPv6ServerChannel(HostID var1, Protocol var2);

    protected abstract ServerChannel getServerChannel(HostID var1, Protocol var2, String var3);

    protected abstract ServerChannel getServerChannel(HostID var1, String var2, String var3, Protocol var4);

    protected abstract ServerChannel getServerChannel(HostID var1, String var2);

    protected abstract ServerChannel getAvailableServerChannel(HostID var1, String var2);

    protected abstract ServerChannel getRelatedServerChannel(HostID var1, Protocol var2, String var3);

    protected abstract ServerChannel getOutboundServerChannel(Protocol var1, String var2);

    protected ChannelList getLocalChannelList() {
        return null;
    }

    protected String findPreferredChannelName(SocketAddress sa) {
        return null;
    }

    public abstract void restartSSLChannels();

    private static class SingletonMaker {
        private static ServerChannelManager singleton = new ServerChannelManager(){

            @Override
            public long getAdminChannelCreationTime() {
                return 0L;
            }

            @Override
            public ServerChannel getServerChannel(HostID identity) {
                return null;
            }

            @Override
            protected ServerChannel getServerChannel(HostID identity, Protocol protocol) {
                return null;
            }

            @Override
            protected ServerChannel getIPv4ServerChannel(HostID identity, Protocol protocol) {
                return null;
            }

            @Override
            protected ServerChannel getIPv6ServerChannel(HostID identity, Protocol protocol) {
                return null;
            }

            @Override
            protected ServerChannel getServerChannel(HostID identity, Protocol protocol, String channelName) {
                return null;
            }

            @Override
            protected ServerChannel getServerChannel(HostID identity, String partitionName, String vtName, Protocol protocol) {
                return null;
            }

            @Override
            protected ServerChannel getServerChannel(HostID identity, String channelName) {
                return null;
            }

            @Override
            protected ServerChannel getAvailableServerChannel(HostID identity, String channelName) {
                return null;
            }

            @Override
            protected ServerChannel getRelatedServerChannel(HostID identity, Protocol protocol, String publicAddress) {
                return null;
            }

            @Override
            protected ServerChannel getOutboundServerChannel(Protocol protocol, String channel) {
                return protocol.getHandler().getDefaultServerChannel();
            }

            @Override
            public void restartSSLChannels() {
            }
        };

        private SingletonMaker() {
        }
    }
}

