/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolImpl;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.UnknownProtocolException;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.utils.Debug;

public class ProtocolManager {
    private static Protocol[] configuredProtocols = new Protocol[256];
    private static HashMap<String, Protocol> namedProtocols = new HashMap();

    private static ServerChannel[] createDefaultChannels() {
        ArrayList<ServerChannel> channels = new ArrayList<ServerChannel>();
        for (int i = 0; i < 256; ++i) {
            Protocol p = configuredProtocols[i];
            if (p == null || p.isUnknown() || !p.isEnabled() || p == ProtocolHandlerAdmin.PROTOCOL_ADMIN || p.getHandler().getPriority() < 0 || p.getHandler().getDefaultServerChannel() == null) continue;
            channels.add(p.getHandler().getDefaultServerChannel());
        }
        return channels.toArray(new ServerChannel[channels.size()]);
    }

    public static synchronized Iterator<Protocol> iterator() {
        return namedProtocols.values().iterator();
    }

    public static synchronized String[] getProtocols() {
        Set s = ((HashMap)namedProtocols.clone()).keySet();
        s.remove("unknown");
        return s.toArray(new String[s.size()]);
    }

    public static Protocol createProtocol(String name, String urlPrefix, boolean secure, ProtocolHandler handler) {
        return new ProtocolImpl(name, urlPrefix, secure, handler);
    }

    public static Protocol createProtocol(byte pn, String name, String urlPrefix, boolean secure, ProtocolHandler handler) {
        return new ProtocolImpl(pn, name, urlPrefix, secure, handler);
    }

    public static synchronized void registerProtocol(Protocol protocol) {
        Protocol obj = namedProtocols.get(protocol.getProtocolName().toLowerCase());
        if (obj != null) {
            throw new AssertionError((Object)("Tried to register protocol " + protocol + " but " + obj + "is already registered"));
        }
        namedProtocols.put(protocol.getProtocolName().toLowerCase(), protocol);
        ProtocolManager.configuredProtocols[protocol.toByte()] = protocol;
    }

    public static ServerChannel[] getDefaultServerChannels() {
        return SingletonChannelMaker.DEFAULT_CHANNELS;
    }

    public static Protocol getProtocolByName(String protocolName) {
        Debug.assertion(protocolName != null);
        Protocol p = namedProtocols.get(protocolName.toLowerCase());
        if (p == null) {
            return ProtocolImpl.PROTOCOL_UNKNOWN;
        }
        return p;
    }

    public static Protocol getRealProtocol(Protocol protocol) {
        Debug.assertion(protocol != null);
        if (protocol.getQOS() == 103) {
            return ProtocolManager.getDefaultAdminProtocol();
        }
        return protocol;
    }

    public static Protocol findProtocol(String protocolName) throws UnknownProtocolException {
        Protocol p = namedProtocols.get(protocolName.toLowerCase());
        if (p == null) {
            throw new UnknownProtocolException(protocolName);
        }
        return p;
    }

    public static Protocol getProtocolByIndex(int i) {
        if (configuredProtocols[i] == null) {
            return ProtocolImpl.PROTOCOL_UNKNOWN;
        }
        return configuredProtocols[i];
    }

    public static Protocol getDefaultProtocol() {
        return DefaultProtocolMaker.PROTOCOL;
    }

    public static Protocol getDefaultSecureProtocol() {
        return DefaultSecureProtocolMaker.PROTOCOL;
    }

    public static Protocol getDefaultAdminProtocol() {
        return DefaultAdminProtocolMaker.PROTOCOL;
    }

    public static Protocol getProtocol(byte QOS) {
        switch (QOS) {
            case 101: {
                return ProtocolManager.getDefaultProtocol();
            }
            case 102: {
                return ProtocolManager.getDefaultSecureProtocol();
            }
            case 103: {
                return ProtocolManager.getDefaultAdminProtocol();
            }
        }
        throw new IllegalArgumentException("Unknown QOS: '" + QOS + "'");
    }

    private static final class DefaultAdminProtocolMaker {
        private static final Protocol PROTOCOL;

        private DefaultAdminProtocolMaker() {
        }

        static {
            RJVMEnvironment.getEnvironment().ensureInitialized();
            PROTOCOL = ProtocolManager.getProtocolByName(RJVMEnvironment.getEnvironment().getAdminProtocolName());
        }
    }

    private static final class DefaultSecureProtocolMaker {
        private static final Protocol PROTOCOL;

        private DefaultSecureProtocolMaker() {
        }

        static {
            RJVMEnvironment.getEnvironment().ensureInitialized();
            PROTOCOL = ProtocolManager.getProtocolByName(RJVMEnvironment.getEnvironment().getDefaultSecureProtocolName());
        }
    }

    private static final class DefaultProtocolMaker {
        private static final Protocol PROTOCOL;

        private DefaultProtocolMaker() {
        }

        static {
            RJVMEnvironment.getEnvironment().ensureInitialized();
            PROTOCOL = ProtocolManager.getProtocolByName(RJVMEnvironment.getEnvironment().getDefaultProtocolName());
        }
    }

    private static final class SingletonChannelMaker {
        private static final ServerChannel[] DEFAULT_CHANNELS;

        private SingletonChannelMaker() {
        }

        static {
            RJVMEnvironment.getEnvironment().ensureInitialized();
            DEFAULT_CHANNELS = ProtocolManager.createDefaultChannels();
        }
    }
}

