/*
 * Decompiled with CFR 0.152.
 */
package weblogic.protocol;

import java.io.IOException;
import java.net.Socket;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.RJVMEnvironment;
import weblogic.socket.MuxableSocket;
import weblogic.utils.io.Chunk;

public class ProtocolHandlerAdmin
implements ProtocolHandler {
    private static final ProtocolHandler theOne = new ProtocolHandlerAdmin(ProtocolManager.getDefaultAdminProtocol().getHandler());
    public static final int PROTOCOL_ADMIN_FLAG = 64;
    public static final Protocol PROTOCOL_ADMIN = ProtocolManager.createProtocol((byte)6, "admin", KernelStatus.isServer() ? "admin" : ProtocolManager.getDefaultAdminProtocol().getAsURLPrefix(), false, ProtocolHandlerAdmin.getProtocolHandler());
    private final ProtocolHandler delegate;

    public static ProtocolHandler getProtocolHandler() {
        return theOne;
    }

    private ProtocolHandlerAdmin(ProtocolHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public final ServerChannel getDefaultServerChannel() {
        return ChannelInitializer.CHANNEL;
    }

    @Override
    public boolean claimSocket(Chunk head) {
        return this.delegate.claimSocket(head);
    }

    @Override
    public MuxableSocket createSocket(Chunk head, Socket s, ServerChannel networkChannel) throws IOException {
        return this.delegate.createSocket(head, s, networkChannel);
    }

    @Override
    public Protocol getProtocol() {
        return ProtocolManager.getDefaultAdminProtocol();
    }

    @Override
    public int getHeaderLength() {
        return this.delegate.getHeaderLength();
    }

    @Override
    public int getPriority() {
        return this.delegate.getPriority();
    }

    private static final class ChannelInitializer {
        private static final ServerChannel CHANNEL = RJVMEnvironment.getEnvironment().createDefaultChannel(PROTOCOL_ADMIN);

        private ChannelInitializer() {
        }
    }
}

