/*
 * Decompiled with CFR 0.152.
 */
package weblogic.platform;

import java.io.IOException;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeUtil {
    private static Unsafe unsafe = null;

    public static Object getObjectFieldValue(Object accessor, String fieldName) throws IOException {
        if (unsafe == null) {
            throw new IOException("Internal issue: cannot find field " + fieldName + " in " + accessor.getClass().getName());
        }
        Class<?> clz = accessor.getClass();
        Field f = UnsafeUtil.getField(clz, fieldName);
        if (f == null) {
            throw new IOException("Cannot find field " + fieldName + " in " + accessor.getClass().getName());
        }
        long fieldOffset = unsafe.objectFieldOffset(f);
        return unsafe.getObject(accessor, fieldOffset);
    }

    private static Field getField(Class accessor, String fieldName) {
        Class clz = accessor;
        Field f = null;
        while (f == null) {
            try {
                f = clz.getDeclaredField(fieldName);
                if (f == null) continue;
                break;
            }
            catch (NoSuchFieldException ignore) {
                if ((clz = clz.getSuperclass()) != null && clz != Object.class) continue;
                return null;
            }
        }
        return f;
    }

    public static int getIntFieldValue(Object accessor, String fieldName) throws IOException {
        if (unsafe == null) {
            throw new IOException("Internal issue: cannot find field " + fieldName + " in " + accessor.getClass().getName());
        }
        Class<?> clz = accessor.getClass();
        Field f = UnsafeUtil.getField(clz, fieldName);
        if (f == null) {
            throw new IOException("Cannot find field " + fieldName + " in " + accessor.getClass().getName());
        }
        long fieldOffset = unsafe.objectFieldOffset(f);
        return unsafe.getInt(accessor, fieldOffset);
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

