/*
 * Decompiled with CFR 0.152.
 */
package weblogic.platform;

import weblogic.platform.OperatingSystem;

public final class Unix
extends OperatingSystem {
    private static final String LIB_NAME = "weblogicunix1";
    private static boolean libLoaded = false;

    private static synchronized void initNative() {
        if (libLoaded) {
            return;
        }
        System.loadLibrary(LIB_NAME);
        libLoaded = true;
    }

    @Override
    public String getUser() {
        Unix.initNative();
        try {
            return Unix.getUser0();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean setUser(String user) {
        Unix.initNative();
        if (user == null) {
            throw new NullPointerException("null user String");
        }
        return Unix.setUser0(user);
    }

    @Override
    public String getGroup() {
        Unix.initNative();
        try {
            return Unix.getGroup0();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean setGroup(String group) {
        if (group == null) {
            throw new NullPointerException("null group String");
        }
        Unix.initNative();
        return Unix.setGroup0(group);
    }

    @Override
    public String getEffectiveUser() {
        Unix.initNative();
        try {
            return Unix.getEUser0();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean setEffectiveUser(String user) {
        if (user == null) {
            throw new NullPointerException("null user String");
        }
        Unix.initNative();
        return Unix.setEUser0(user);
    }

    @Override
    public String getEffectiveGroup() {
        Unix.initNative();
        try {
            return Unix.getEGroup0();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean setEffectiveGroup(String group) {
        if (group == null) {
            throw new NullPointerException("null group String");
        }
        Unix.initNative();
        return Unix.setEGroup0(group);
    }

    private static native String getUser0();

    private static native boolean setUser0(String var0);

    private static native String getGroup0();

    private static native boolean setGroup0(String var0);

    private static native String getEGroup0();

    private static native boolean setEGroup0(String var0);

    private static native String getEUser0();

    private static native boolean setEUser0(String var0);

    public static void main(String[] args) {
        try {
            System.out.println("Begining test of switching User to: " + args[0]);
            Unix u = new Unix();
            boolean success = u.setUser(args[0]);
            System.out.println("Did we switch to : " + args[0] + " : " + success);
            if (success) {
                System.out.println("Process will sleep for 2 minutes, please observe process and ensure that its owner is indeed the useryou provided.");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException ie) {
                    System.out.println("Sleep failed");
                    ie.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println("java weblogic.platform.Unix <user>\nwhere <user> is the user name you want to switch to.");
            System.out.println("Exception:");
            e.printStackTrace();
        }
    }
}

