/*
 * Decompiled with CFR 0.152.
 */
package weblogic.platform;

import java.io.SerializablePermission;

public final class JDK {
    private static JDK jdk = null;
    private static boolean noMaxMem;
    private int majorVersion = 0;
    private int minorVersion = 0;

    protected JDK() {
        String[] javaVersionElements = System.getProperty("java.runtime.version").split("\\.|_|-b|\\+|\\-");
        int offset = 0;
        if (javaVersionElements[0].equals("1")) {
            offset = 1;
        }
        try {
            if (javaVersionElements.length >= offset + 1) {
                this.majorVersion = Integer.parseInt(javaVersionElements[offset + 0]);
            }
            if (javaVersionElements.length >= offset + 2) {
                this.minorVersion = Integer.parseInt(javaVersionElements[offset + 1]);
            }
        }
        catch (NumberFormatException ignore) {
            return;
        }
    }

    protected JDK(int majorVersion, int minorVersion, int microVersion, String additionalVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public static synchronized JDK getJDK() {
        if (jdk != null) {
            return jdk;
        }
        jdk = new JDK();
        String javaVendor = System.getProperty("java.vendor");
        noMaxMem = javaVendor.startsWith("Microsoft") || javaVendor.startsWith("SuperCede") || javaVendor.startsWith("Tower");
        return jdk;
    }

    public boolean checkMemory(long freeMem, long totMem) {
        if (noMaxMem) {
            return true;
        }
        return freeMem > totMem / 4L;
    }

    public boolean isEnableReplaceObject(Class c) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new SerializablePermission("enableSubstitution"));
            }
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }
}

