/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class SecurityHelper {
    public static String getSystemProperty(final String key) {
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(key);
                }
            });
        }
        return System.getProperty(key);
    }

    public static String getSystemProperty(final String key, final String def) {
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(key, def);
                }
            });
        }
        return System.getProperty(key, def);
    }

    public static Integer getInteger(final String nm, final int val) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger(nm, val);
                }
            });
        }
        return Integer.getInteger(nm, val);
    }

    public static Boolean getBoolean(final String name) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean(name);
                }
            });
        }
        return Boolean.getBoolean(name);
    }
}

