/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import weblogic.net.http.HttpClient;
import weblogic.net.http.HttpURLConnection;
import weblogic.net.http.KeepAliveKey;
import weblogic.net.http.SecurityHelper;
import weblogic.utils.AssertionError;

public final class KeepAliveCache {
    private static int LIFETIME = 15000;
    private static int PROXY_LIFETIME = 20000;
    private static int INTERVAL_RATE = 2;
    private static int HEALTH_CHECK_TIMOUT = 1;
    private Timer timer;
    private final ConcurrentMap<KeepAliveKey, List<HttpClient>> cache;
    private Random random = new Random();

    public KeepAliveCache() {
        this.cache = new ConcurrentHashMap<KeepAliveKey, List<HttpClient>>();
        this.timer = new Timer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(HttpClient http) {
        if (this.isClientTimeout(http)) {
            http.closeServer();
            return;
        }
        final KeepAliveKey key = new KeepAliveKey(http.getURL(), http.getClientInfo(), http.instProxy);
        LinkedList<HttpClient> clients = (LinkedList<HttpClient>)this.cache.get(key);
        if (HttpURLConnection.debug) {
            HttpURLConnection.p("cache connection: " + http);
        }
        if (clients == null) {
            clients = new LinkedList<HttpClient>();
            List oldClients = this.cache.putIfAbsent(key, clients);
            if (oldClients != null) {
                List list = oldClients;
                synchronized (list) {
                    oldClients.add(http);
                    return;
                }
            }
            LinkedList<HttpClient> linkedList = clients;
            synchronized (linkedList) {
                clients.add(http);
            }
            int life = http.usingProxy ? PROXY_LIFETIME : LIFETIME;
            TimerTask task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List clients = (List)KeepAliveCache.this.cache.get(key);
                    if (clients == null) {
                        this.cancel();
                        return;
                    }
                    List list = clients;
                    synchronized (list) {
                        HttpClient client;
                        int i;
                        if (clients.isEmpty()) {
                            if (HttpURLConnection.debug) {
                                HttpURLConnection.p("cancel cleanup timer task: " + this);
                            }
                            KeepAliveCache.this.cache.remove(key);
                            this.cancel();
                            return;
                        }
                        for (i = 0; i < clients.size() && KeepAliveCache.this.isClientTimeout(client = (HttpClient)clients.get(i)); ++i) {
                            if (HttpURLConnection.debug) {
                                HttpURLConnection.p("cleanup invalid client: " + client);
                            }
                            client.closeServer();
                        }
                        clients.subList(0, i).clear();
                    }
                }
            };
            try {
                if (HttpURLConnection.debug) {
                    HttpURLConnection.p("init timer task: " + task);
                }
                this.timer.schedule(task, life, (long)(life / INTERVAL_RATE));
            }
            catch (IllegalStateException ise) {
                throw new AssertionError("Keep-Alive timer task cancelled: " + task);
            }
        }
        LinkedList<HttpClient> linkedList = clients;
        synchronized (linkedList) {
            clients.add(http);
        }
    }

    public HttpClient get(URL url, Object info) {
        return this.get(url, info, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient get(URL url, Object info, Proxy proxy) {
        KeepAliveKey key = new KeepAliveKey(url, info, proxy);
        List clients = (List)this.cache.get(key);
        if (clients == null || clients.isEmpty()) {
            if (HttpURLConnection.debug) {
                HttpURLConnection.p("doesn't hit for: " + key);
            }
            return null;
        }
        HttpClient client = null;
        List list = clients;
        synchronized (list) {
            if (clients.size() == 0) {
                return null;
            }
            client = (HttpClient)clients.remove(this.random.nextInt(clients.size()));
        }
        if (client != null && !this.isClientTimeout(client)) {
            if (HEALTH_CHECK_TIMOUT > 0 && !this.isSocketChannelHealthy(client)) {
                client.closeServer();
                return null;
            }
            if (HttpURLConnection.debug) {
                HttpURLConnection.p("reuse connection from cache: " + client);
            }
            return client;
        }
        if (client != null) {
            client.closeServer();
        }
        return null;
    }

    private boolean isClientTimeout(HttpClient http) {
        long sinceLastUsed = System.currentTimeMillis() - http.lastUsed;
        return http.usingProxy ? sinceLastUsed > (long)PROXY_LIFETIME : sinceLastUsed > (long)LIFETIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSocketChannelHealthy(HttpClient http) {
        block29: {
            boolean bl;
            int retVal = 0;
            boolean setBlocking = false;
            SocketChannel sc = null;
            try {
                sc = http.serverSocket.getChannel();
                if (sc == null) {
                    boolean bl2 = this.isSocketHealthy(http);
                    return bl2;
                }
                if (sc.isBlocking()) {
                    setBlocking = true;
                    sc.configureBlocking(false);
                }
                if ((retVal = sc.read(ByteBuffer.allocate(1))) != 0) break block29;
                bl = true;
            }
            catch (SocketException socketException) {
                break block29;
            }
            catch (IOException iOException) {
                break block29;
            }
            finally {
                try {
                    if (setBlocking) {
                        sc.configureBlocking(true);
                    }
                }
                catch (ClosedChannelException closedChannelException) {
                }
                catch (IOException iOException) {}
            }
            return bl;
        }
        return false;
    }

    private boolean isSocketHealthy(HttpClient http) {
        try {
            http.serverSocket.setSoTimeout(HEALTH_CHECK_TIMOUT);
            http.serverSocket.getInputStream().read();
        }
        catch (SocketTimeoutException e) {
            return true;
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static {
        try {
            LIFETIME = SecurityHelper.getInteger("http.keepAliveCache.lifeTime", LIFETIME);
            PROXY_LIFETIME = SecurityHelper.getInteger("http.keepAliveCache.proxyLifeTime", PROXY_LIFETIME);
            HEALTH_CHECK_TIMOUT = SecurityHelper.getInteger("http.keepAliveCache.socketHealthCheckTimeout", HEALTH_CHECK_TIMOUT);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

