/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import weblogic.kernel.KernelStatus;
import weblogic.net.NetLogger;
import weblogic.net.http.HttpOutputStream;
import weblogic.net.http.HttpURLConnection;
import weblogic.net.http.KeepAliveCache;
import weblogic.net.http.KeepAliveStream;
import weblogic.net.http.MessageHeader;
import weblogic.net.http.ParseUtil;
import weblogic.net.http.SecurityHelper;
import weblogic.security.Security;
import weblogic.security.subject.SubjectManager;
import weblogic.socket.WeblogicSocketFactory;
import weblogic.socket.utils.RegexpPool;
import weblogic.utils.http.HttpChunkInputStream;

class HttpClient {
    public static final String HTTP_10 = "HTTP/1.0";
    public static final String HTTP_11 = "HTTP/1.1";
    static final boolean SECURITY_MANAGER_ENABLED;
    private static final int HTTP_CONTINUE = 100;
    private static final int httpPortNumber = 80;
    protected Proxy instProxy;
    protected String proxyHost = null;
    protected int proxyPort = 80;
    private static KeepAliveCache kac;
    protected InputStream kas;
    protected Socket serverSocket;
    protected HttpOutputStream serverOutput;
    protected InputStream serverInput;
    protected boolean usingHttp11;
    private SocketFactory socketFactory;
    private CookieHandler cookieHandler;
    public boolean usingProxy = false;
    protected String host;
    protected int port;
    protected int numReq = 0;
    private static boolean keepAliveProp;
    boolean keepingAlive = false;
    protected int readTimeout = -1;
    protected int connectTimeout = -1;
    protected URL url;
    protected HttpURLConnection connection;
    protected boolean ignoreSystemNonProxyHosts = false;
    protected boolean ignoreProxy = false;
    protected static boolean useProxyOnly;
    protected RegexpPool dontProxy;
    long lastUsed = System.currentTimeMillis();
    protected Object muxableSocket;
    protected Runnable scavenger;

    private void resetProperties() {
        try {
            String rawList;
            this.proxyHost = SecurityHelper.getSystemProperty("http.proxyHost");
            this.proxyPort = SecurityHelper.getInteger("http.proxyPort", 80);
            if (this.proxyHost == null) {
                this.proxyHost = SecurityHelper.getSystemProperty("proxyHost");
                this.proxyPort = SecurityHelper.getInteger("proxyPort", 80);
            }
            if (this.proxyHost != null && this.proxyHost.length() == 0) {
                this.proxyHost = null;
            }
            if ((rawList = SecurityHelper.getSystemProperty("http.nonProxyHosts")) == null) {
                rawList = SecurityHelper.getSystemProperty("nonProxyHosts");
            }
            if (rawList != null) {
                this.dontProxy = new RegexpPool();
                StringTokenizer st = new StringTokenizer(rawList, "|", false);
                boolean hasDuplicates = false;
                while (st.hasMoreTokens()) {
                    if (this.dontProxy.add(st.nextToken().toLowerCase())) continue;
                    hasDuplicates = true;
                }
                if (hasDuplicates) {
                    NetLogger.logDuplicateExpression("http", rawList, null);
                }
            }
        }
        catch (SecurityException e) {
            this.proxyHost = null;
            this.proxyPort = 80;
            this.dontProxy = null;
        }
    }

    protected boolean shouldCheckAccessForProxiedHost() {
        return Boolean.valueOf(SecurityHelper.getSystemProperty("weblogic.http.client.performAccessCheckForProxiedHost", "true"));
    }

    protected HttpClient(URL url, Proxy p, SocketFactory factory, boolean http11, int conTimeout, int rdTimeout, boolean isIgnoreSystemNonProxyHosts, boolean isIgnoreProxy) throws IOException {
        this.url = url;
        this.port = url.getPort();
        this.host = url.getHost();
        this.setSocketFactory(factory);
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setReadTimeout(rdTimeout);
        this.connectTimeout = conTimeout;
        this.instProxy = p == null ? Proxy.NO_PROXY : p;
        this.numReq = 0;
        this.usingHttp11 = http11;
        this.ignoreSystemNonProxyHosts = isIgnoreSystemNonProxyHosts;
        this.ignoreProxy = isIgnoreProxy;
        this.cookieHandler = HttpClient.getCookieHandler();
    }

    static CookieHandler getCookieHandler() {
        if (SECURITY_MANAGER_ENABLED) {
            return AccessController.doPrivileged(new PrivilegedAction<CookieHandler>(){

                @Override
                public CookieHandler run() {
                    return CookieHandler.getDefault();
                }
            });
        }
        return CookieHandler.getDefault();
    }

    public void setHttp11(boolean useHttp11) {
        this.usingHttp11 = useHttp11;
    }

    public String toString() {
        return super.toString() + "[url:" + this.url + " sock:" + this.serverSocket + " requests:" + this.numReq + " ka:" + this.keepingAlive + "]";
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    void setKeepingAlive(boolean b) {
        this.keepingAlive = b;
    }

    public InputStream getInputStream() {
        if (this.kas != null) {
            return this.kas;
        }
        return this.serverInput;
    }

    public HttpOutputStream getOutputStream() {
        return this.serverOutput;
    }

    String getProxyHost() {
        if (this.instProxy != Proxy.NO_PROXY) {
            return ((InetSocketAddress)this.instProxy.address()).getHostName();
        }
        return this.proxyHost;
    }

    int getProxyPort() {
        if (this.instProxy != Proxy.NO_PROXY) {
            return ((InetSocketAddress)this.instProxy.address()).getPort();
        }
        return this.proxyPort;
    }

    URL getURL() {
        return this.url;
    }

    Object getClientInfo() {
        return null;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory == null ? SocketFactory.getDefault() : this.socketFactory;
    }

    public void setSocketFactory(SocketFactory fact) {
        this.socketFactory = fact;
    }

    protected int getDefaultPort() {
        return 80;
    }

    protected static HttpClient findInCache(URL url, Object info, Proxy proxy) {
        return kac.get(url, info, proxy);
    }

    static HttpClient New(URL url, Proxy p, SocketFactory factory, boolean http11, int conTimeout, int rdTimeout, boolean isIgnoreSystemNonProxyHosts, boolean isIgnoreProxy) throws IOException {
        if (isIgnoreSystemNonProxyHosts || isIgnoreProxy) {
            return HttpClient.New(url, p, factory, http11, conTimeout, rdTimeout, false, isIgnoreSystemNonProxyHosts, isIgnoreProxy);
        }
        return HttpClient.New(url, p, factory, http11, conTimeout, rdTimeout, true, isIgnoreSystemNonProxyHosts, isIgnoreProxy);
    }

    static HttpClient New(URL url, Proxy p, SocketFactory factory, boolean http11, int conTimeout, int rdTimeout, boolean useCache, boolean isIgnoreSystemNonProxyHosts, boolean isIgnoreProxy) throws IOException {
        HttpClient ret = null;
        if (useCache) {
            ret = HttpClient.findInCache(url, null, p);
        }
        if (ret == null) {
            ret = new HttpClient(url, p, factory, http11, conTimeout, rdTimeout, isIgnoreSystemNonProxyHosts, isIgnoreProxy);
            ret.openServer();
        } else {
            ret.url = url;
            ret.setReadTimeout(rdTimeout < 0 ? 0 : rdTimeout);
            ret.setHttp11(http11);
        }
        return ret;
    }

    public static void finished(HttpClient done) {
        if (HttpURLConnection.debug) {
            HttpURLConnection.p("Closing " + done);
        }
        if (!done.ignoreProxy && !done.ignoreSystemNonProxyHosts && done.isKeepingAlive()) {
            ++done.numReq;
            done.kas = null;
            done.usingHttp11 = false;
            if (done.connection != null) {
                done.connection.finish();
                done.connection = null;
            }
            kac.put(done);
        } else {
            done.closeServer();
        }
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    protected void openServer(String server, int port) throws IOException {
        StringBuilder sb = new StringBuilder();
        SecurityManager security = System.getSecurityManager();
        if (security != null && this.shouldCheckAccessForProxiedHost()) {
            security.checkConnect(server, port);
        }
        this.resetAsyncState();
        InetAddress[] addresses = InetAddress.getAllByName(server);
        for (int i = 0; i < addresses.length; ++i) {
            try {
                if (this.connectTimeout > 0) {
                    SocketFactory factory = this.getSocketFactory();
                    if (factory instanceof WeblogicSocketFactory) {
                        this.serverSocket = ((WeblogicSocketFactory)factory).createSocket(addresses[i], port, this.connectTimeout);
                        break;
                    }
                    this.serverSocket = this.getSocketFactory().createSocket();
                    this.serverSocket.connect(new InetSocketAddress(addresses[i], port), this.connectTimeout);
                    break;
                }
                this.serverSocket = this.getSocketFactory().createSocket(addresses[i], port);
                break;
            }
            catch (ConnectException ce) {
                sb.append("  [" + i + "] address:'" + addresses[i] + "',port:'" + port + "' : " + ce.toString() + "\n");
                continue;
            }
        }
        if (this.serverSocket == null) {
            throw new ConnectException("Tried all: '" + addresses.length + "' addresses, but could not connect over HTTP to server: '" + server + "', port: '" + port + "'\n failed reasons:\n" + sb.toString());
        }
        this.serverSocket.setTcpNoDelay(true);
        if (this.readTimeout > -1) {
            this.serverSocket.setSoTimeout(this.readTimeout);
        }
        this.serverOutput = new HttpOutputStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
    }

    protected String getProtocol() {
        return "http";
    }

    static boolean isProxyAllowed(String hostStr, RegexpPool dontProxy) {
        boolean proxyAllowed = true;
        String host = hostStr.toLowerCase();
        if (dontProxy != null) {
            if (dontProxy.match(host)) {
                proxyAllowed = false;
            } else {
                try {
                    InetAddress hostInetAddr = InetAddress.getByName(host);
                    String hostName = hostInetAddr.getHostName();
                    if (dontProxy.match(hostName)) {
                        proxyAllowed = false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return proxyAllowed;
    }

    protected void openServer() throws IOException {
        this.resetProperties();
        SecurityManager security = System.getSecurityManager();
        boolean accessCheckProxiedHost = this.shouldCheckAccessForProxiedHost();
        if (security != null) {
            if (!(this.instProxy == Proxy.NO_PROXY && this.proxyHost == null || accessCheckProxiedHost)) {
                InetSocketAddress proxyAdd = (InetSocketAddress)this.instProxy.address();
                security.checkConnect(proxyAdd.getHostName(), proxyAdd.getPort());
            } else if (accessCheckProxiedHost) {
                security.checkConnect(this.host, this.port);
            }
        }
        if (this.isKeepingAlive()) {
            return;
        }
        String p = this.url.getProtocol();
        if (!this.getProtocol().equals(p)) {
            throw new ProtocolException("Unsupported protocol: " + p + "'");
        }
        if (!this.ignoreProxy && this.instProxy != Proxy.NO_PROXY && (this.ignoreSystemNonProxyHosts || HttpClient.isProxyAllowed(this.host, this.dontProxy))) {
            InetSocketAddress proxyAdd = (InetSocketAddress)this.instProxy.address();
            try {
                this.openServer(proxyAdd.getHostName(), proxyAdd.getPort());
                this.usingProxy = true;
                return;
            }
            catch (IOException ioe) {
                NetLogger.logIOExceptionWithoutRetry(proxyAdd.getHostName(), "" + proxyAdd.getPort(), ioe);
                throw ioe;
            }
        }
        if (!this.ignoreProxy && this.proxyHost != null && HttpClient.isProxyAllowed(this.host, this.dontProxy)) {
            try {
                this.openServer(this.proxyHost, this.proxyPort);
                this.usingProxy = true;
                return;
            }
            catch (IOException ioe) {
                if (useProxyOnly) {
                    throw ioe;
                }
                NetLogger.logIOException(this.proxyHost, "" + this.proxyPort, this.host, "" + this.port, ioe);
            }
        }
        if (!useProxyOnly) {
            this.openServer(this.host, this.port);
        }
    }

    public String getURLFile() {
        if (this.usingProxy) {
            String result = this.url.getProtocol() + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                result = result + ":" + this.url.getPort();
            }
            return result + this.url.getFile();
        }
        String file = this.url.getFile();
        if (file == null || file.length() == 0) {
            file = "/";
        }
        return file;
    }

    public void setReadTimeout(int i) {
        this.readTimeout = i;
        if (this.serverSocket != null && this.readTimeout > -1) {
            try {
                this.serverSocket.setSoTimeout(this.readTimeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    void setConnection(HttpURLConnection con) {
        this.connection = con;
    }

    void parseHTTP(final MessageHeader responses) throws IOException {
        String resp;
        URI uri;
        this.keepingAlive = false;
        try {
            responses.parseHeader(this.serverInput);
        }
        catch (InterruptedIOException iioe) {
            this.resetAsyncState();
            throw iioe;
        }
        if (this.cookieHandler != null && (uri = ParseUtil.toURI(this.url)) != null) {
            if (KernelStatus.isServer()) {
                Security.runAs(SubjectManager.getSubjectManager().getAnonymousSubject().getSubject(), new PrivilegedAction(){

                    public Object run() {
                        block3: {
                            try {
                                if (HttpURLConnection.debug) {
                                    HttpURLConnection.p("save cookies: " + responses.getHeaders());
                                }
                                HttpClient.this.cookieHandler.put(uri, responses.getHeaders());
                            }
                            catch (IOException ie) {
                                if (!HttpURLConnection.debug) break block3;
                                HttpURLConnection.p(ie.toString());
                            }
                        }
                        return null;
                    }
                });
            } else {
                this.cookieHandler.put(uri, responses.getHeaders());
                if (HttpURLConnection.debug) {
                    HttpURLConnection.p("save cookies: " + responses.getHeaders());
                }
            }
        }
        boolean isHttp11Response = (resp = responses.getValue(0)) != null && resp.startsWith(HTTP_11);
        int code = -1;
        if (resp != null) {
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            try {
                code = Integer.parseInt(resp.substring(ind, ind + 3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (code == 100) {
                this.parseHTTP(responses);
            }
        }
        int cl = -1;
        boolean noMsgBodyRespCode = code == 204 || code == 304;
        try {
            cl = Integer.parseInt(responses.findValue("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.usingHttp11) {
            this.keepingAlive = true;
        }
        String keep = null;
        if (this.usingProxy) {
            keep = responses.findValue("Proxy-Connection");
        }
        if (keep == null) {
            keep = responses.findValue("Connection");
        }
        if (keep != null) {
            if ((keep = keep.toLowerCase()).equals("keep-alive")) {
                if (cl > 0) {
                    this.keepingAlive = true;
                }
            } else if (keep.equals("close")) {
                this.keepingAlive = false;
            }
        } else if (!isHttp11Response) {
            this.keepingAlive = false;
        }
        this.kas = this.serverInput;
        if (this.usingHttp11) {
            String chunked = responses.findValue("Transfer-Encoding");
            if (chunked != null && chunked.equalsIgnoreCase("chunked")) {
                this.kas = new HttpChunkInputStream(this.serverInput){

                    @Override
                    public void close() throws IOException {
                        if (this.in == null) {
                            return;
                        }
                        int skipCount = this.available();
                        this.skip(skipCount);
                        this.in.close();
                        this.in = null;
                    }
                };
                cl = -1;
            } else if (cl == -1 && code != 204 && code != 304) {
                this.keepingAlive = false;
            }
        }
        this.kas = new KeepAliveStream(this, this.kas, cl, noMsgBodyRespCode);
    }

    void closeServer() {
        try {
            this.keepingAlive = false;
            this.resetAsyncState();
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (HttpURLConnection.debug) {
            HttpURLConnection.p("Closed " + this);
        }
    }

    protected void finalize() throws Throwable {
        this.resetAsyncState();
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    Socket getSocket() {
        return this.serverSocket;
    }

    void setInputStream(InputStream overridingInputStream) {
        this.serverInput = overridingInputStream;
    }

    void setMuxableSocket(Object socket) {
        this.muxableSocket = socket;
    }

    Object getMuxableSocket() {
        return this.muxableSocket;
    }

    private void resetAsyncState() {
        if (this.scavenger != null) {
            try {
                this.scavenger.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.muxableSocket = null;
        this.scavenger = null;
    }

    void setScavenger(Runnable scavenger) {
        this.scavenger = scavenger;
    }

    static {
        kac = new KeepAliveCache();
        keepAliveProp = true;
        useProxyOnly = Boolean.getBoolean("weblogic.httpclient.avoidRetryConnectWithoutProxy");
        try {
            String keepAlive = SecurityHelper.getSystemProperty("http.keepAlive");
            if (keepAlive != null) {
                keepAliveProp = Boolean.valueOf(keepAlive);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SECURITY_MANAGER_ENABLED = System.getSecurityManager() != null;
    }
}

