/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import weblogic.net.http.BaseHandler;
import weblogic.net.http.NETEnvironment;
import weblogic.net.http.SOAPHttpURLConnection;

public class Handler
extends BaseHandler {
    public Handler() {
    }

    public Handler(boolean protocolFlag) {
        this.isHTTP = protocolFlag;
    }

    @Override
    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        String proto = u.getProtocol().toLowerCase();
        if (proto.equals("http")) {
            return new SOAPHttpURLConnection(u, p);
        }
        if (proto.equals("https")) {
            return NETEnvironment.getNETEnvironment().getHttpsURLConnection(u, p);
        }
        return null;
    }

    @Override
    protected int getDefaultPort() {
        return this.isHTTP ? 80 : 443;
    }
}

