/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net.http;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import weblogic.net.NetLogger;
import weblogic.net.http.NETEnvironment;
import weblogic.net.http.SecurityHelper;
import weblogic.net.https.Handler;

public class BaseHandler
extends URLStreamHandler {
    protected boolean isHTTP = true;
    protected static final int HTTP_DEFAULT_PORT = 80;
    protected static final int HTTPS_DEFAULT_PORT = 443;
    private static final String[] NEEDED_CLASSES;
    private static boolean inited;

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return this.openConnection(u, null);
    }

    public static void init() {
        if (NETEnvironment.getNETEnvironment().useSunHttpHandler()) {
            return;
        }
        if (inited) {
            return;
        }
        inited = true;
        try {
            if (SecurityHelper.getBoolean("UseSunHttpHandler").booleanValue()) {
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            String jpe = SecurityHelper.getSystemProperty("javaplugin.enabled");
            for (int i = 0; i < NEEDED_CLASSES.length; ++i) {
                try {
                    Class.forName(NEEDED_CLASSES[i]);
                    continue;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable td) {
                    // empty catch block
                }
            }
            String sFactory = SecurityHelper.getSystemProperty("weblogic.net.http.URLStreamHandlerFactory");
            if (sFactory != null) {
                boolean hasException = false;
                try {
                    Class<?> c = Class.forName(sFactory);
                    Class[] main_signature = new Class[]{String[].class};
                    Object[] args = new Object[]{new String[0]};
                    c.getMethod("main", main_signature).invoke(null, args);
                }
                catch (IllegalAccessException ilae) {
                    hasException = true;
                    NetLogger.logHandlerInitFailure("IllegalAccessException", sFactory, ilae);
                }
                catch (InvocationTargetException ite) {
                    hasException = true;
                    NetLogger.logHandlerInitFailure("InvocationTargetException", sFactory, ite);
                }
                catch (NoSuchMethodException nsme) {
                    hasException = true;
                    NetLogger.logHandlerInitFailure("NoSuchMethodException", sFactory, nsme);
                }
                catch (ClassNotFoundException cnfe) {
                    hasException = true;
                    NetLogger.logHandlerInitFailure("ClassNotFoundException", sFactory, cnfe);
                }
                catch (Error err) {
                    hasException = true;
                    NetLogger.logHandlerInitFailure("Error", sFactory, err);
                }
                if (!hasException) {
                    return;
                }
            }
            URLStreamHandlerFactory fac = new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String proto) {
                    if ("http".equals(proto)) {
                        return new weblogic.net.http.Handler(true);
                    }
                    if ("https".equals(proto)) {
                        return new Handler(false);
                    }
                    return null;
                }
            };
            if (jpe == null || jpe.equals("false")) {
                URL.setURLStreamHandlerFactory(fac);
            }
        }
        catch (SecurityException e) {
            System.out.println("caught a SecurityException.  That's OK.");
            return;
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static {
        String hv = SecurityHelper.getSystemProperty("SunDefaultHostnameVerifier");
        if (hv != null) {
            try {
                Object verObject = Class.forName(hv).newInstance();
                if (verObject instanceof HostnameVerifier) {
                    HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)verObject);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        NEEDED_CLASSES = new String[]{"weblogic.net.http.BaseHandler", "weblogic.net.http.Handler", "weblogic.net.http.HttpClient", "weblogic.net.http.HttpOutputStream", "weblogic.net.http.HttpURLConnection", "weblogic.net.http.HttpUnauthorizedException", "weblogic.net.http.KeepAliveCache", "weblogic.net.http.KeepAliveStream", "weblogic.net.http.MessageHeader", "weblogic.net.http.KeepAliveKey", "weblogic.net.http.HttpsURLConnection", "weblogic.net.http.HttpsClient", "weblogic.net.https.Handler"};
        inited = false;
    }
}

