/*
 * Decompiled with CFR 0.152.
 */
package weblogic.net;

import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.CatalogMessage;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerRegistry;
import weblogic.i18n.logging.MessageLoggerRegistryListener;
import weblogic.i18ntools.L10nLookup;

public class NetLogger {
    private static final String LOCALIZER_CLASS = "weblogic.net.NetLogLocalizer";

    private static MessageLogger findMessageLogger() {
        return MessageLoggerRegistry.findMessageLogger(NetLogger.class.getName());
    }

    public static String logDuplicateExpression(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        CatalogMessage catalogMessage = new CatalogMessage("000902", 8, args, MessageLoggerInitializer.LOCALIZER);
        catalogMessage.setStackTraceEnabled(false);
        catalogMessage.setDiagnosticVolume("Off");
        catalogMessage.setExcludePartition(true);
        MessageLoggerInitializer.INSTANCE.messageLogger.log(catalogMessage);
        return "000902";
    }

    public static String logIOException(String arg0, String arg1, String arg2, String arg3, Throwable arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        CatalogMessage catalogMessage = new CatalogMessage("000903", 8, args, MessageLoggerInitializer.LOCALIZER);
        catalogMessage.setStackTraceEnabled(true);
        catalogMessage.setDiagnosticVolume("Off");
        catalogMessage.setExcludePartition(true);
        MessageLoggerInitializer.INSTANCE.messageLogger.log(catalogMessage);
        return "000903";
    }

    public static String logHandlerInitFailure(String arg0, String arg1, Throwable arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        CatalogMessage catalogMessage = new CatalogMessage("000904", 8, args, MessageLoggerInitializer.LOCALIZER);
        catalogMessage.setStackTraceEnabled(true);
        catalogMessage.setDiagnosticVolume("Off");
        catalogMessage.setExcludePartition(true);
        MessageLoggerInitializer.INSTANCE.messageLogger.log(catalogMessage);
        return "000904";
    }

    public static String logFailedToConnect(String arg0, String arg1, Exception arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        CatalogMessage catalogMessage = new CatalogMessage("000905", 16, args, MessageLoggerInitializer.LOCALIZER);
        catalogMessage.setStackTraceEnabled(false);
        catalogMessage.setDiagnosticVolume("Off");
        catalogMessage.setExcludePartition(true);
        MessageLoggerInitializer.INSTANCE.messageLogger.log(catalogMessage);
        return "000905";
    }

    public static String logIOExceptionWithoutRetry(String arg0, String arg1, Throwable arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        CatalogMessage catalogMessage = new CatalogMessage("000906", 8, args, MessageLoggerInitializer.LOCALIZER);
        catalogMessage.setStackTraceEnabled(true);
        catalogMessage.setDiagnosticVolume("Off");
        catalogMessage.setExcludePartition(true);
        MessageLoggerInitializer.INSTANCE.messageLogger.log(catalogMessage);
        return "000906";
    }

    private static final class MessageLoggerInitializer
    implements MessageLoggerRegistryListener {
        private static final MessageLoggerInitializer INSTANCE = new MessageLoggerInitializer();
        private static final Localizer LOCALIZER = L10nLookup.getLocalizer(Locale.getDefault(), "weblogic.net.NetLogLocalizer", NetLogger.class.getClassLoader());
        private MessageLogger messageLogger = NetLogger.access$000();

        private MessageLoggerInitializer() {
            MessageLoggerRegistry.addMessageLoggerRegistryListener(this);
        }

        @Override
        public void messageLoggerRegistryUpdated() {
            this.messageLogger = NetLogger.findMessageLogger();
        }
    }
}

