/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.messaging.ID;
import weblogic.messaging.common.IDImpl;
import weblogic.messaging.common.MessagingUtilities;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InteropJMSVoidResponsePreDiablo;
import weblogic.messaging.dispatcher.Invocable;
import weblogic.messaging.dispatcher.InvocableManager;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.dispatcher.VoidResponse;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.work.WorkManager;

public abstract class Request
extends Response
implements Runnable,
AsyncResultListener,
Externalizable {
    static final long serialVersionUID = -3580248041850964617L;
    protected ID invocableId;
    protected int methodId;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int INVOCABLE_ID_MASK = 256;
    private static final int CORRELATION_ID_MASK = 512;
    public static final int START = 0;
    public static final int FINISH = 2;
    public static final int COMPLETED = Integer.MAX_VALUE;
    public static final int REMOTE = -42;
    private int state;
    private Response result;
    private Throwable throwableResponse;
    private Request parent;
    private Request child;
    protected Request next;
    private int numWaiting;
    private int numChildren;
    private boolean isCollocated;
    private boolean running;
    private WorkManager workManager;
    private boolean isSyncRequest;
    private AsyncResult asyncResult;
    private FutureResponse futureResponse;
    private boolean needFillInStackTrace;
    private int tranInfo;
    public static final int NO_TRAN = 0;
    public static final int HAVE_TRAN = 1;
    public static final int DONT_KNOW_IF_TRAN = 2;
    private Transaction transaction;
    private Invocable invocable;
    private InvocableMonitor invocableMonitor;
    private InteropJMSVoidResponsePreDiablo appVoidResponse;
    private boolean shortened;
    private volatile boolean parentResumeNewThread;
    private CompletionListener completionListener;
    private transient DispatcherPartition4rmic dispatcherPartition4rmic;
    static boolean TODOSAGREMOVEreportOnce = true;
    private static SimpleDateFormat sdf = new SimpleDateFormat("(EEE MMM dd, HH:mm:ss.SSS)");
    public static final int RMI_TRANSACTION = 1;
    public static final int RMI_FUTURE_RESPONSE = 2;
    public static final int RMI_SYNC = 16;
    public static final int RMI_ASYNC_RESULT = 32;
    public static final int RMI_ONEWAY = 64;

    public Request(ID invocableId, int methodId) {
        this(invocableId, methodId, new VoidResponse());
    }

    public Request(ID invocableId, int methodId, InteropJMSVoidResponsePreDiablo appVoidResponse) {
        this.invocableId = invocableId;
        this.methodId = methodId;
        this.result = this;
        this.isCollocated = true;
        this.appVoidResponse = appVoidResponse;
    }

    public final void setAppVoidResponse(InteropJMSVoidResponsePreDiablo appVoidResponse) {
        this.appVoidResponse = appVoidResponse;
    }

    InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public final void setInvocableId(ID invocableId) {
        this.invocableId = invocableId;
    }

    public final ID getInvocableId() {
        return this.invocableId;
    }

    public final void setMethodId(int methodId) {
        this.methodId = methodId;
    }

    public final int getMethodId() {
        return this.methodId;
    }

    public final void clearResult() {
        this.result = this;
        this.throwableResponse = null;
    }

    public final void clearState() {
        this.clearResult();
        this.setNumChildren(0);
    }

    private int getNumChildren() {
        return this.numChildren;
    }

    private void setNumChildren(int val) {
        this.numChildren = val;
    }

    int incNumChildren() {
        return ++this.numChildren;
    }

    private int decNumChildren() {
        return --this.numChildren;
    }

    public boolean isServerOneWay() {
        return false;
    }

    public boolean isServerToServer() {
        return false;
    }

    public void setDispatcherPartition4rmic(DispatcherPartition4rmic dispatcherPartition4rmic) {
        if (this.dispatcherPartition4rmic == null) {
            this.dispatcherPartition4rmic = dispatcherPartition4rmic;
        }
    }

    public void clearDispatcherPartition4rmic() {
        this.dispatcherPartition4rmic = null;
    }

    protected DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.dispatcherPartition4rmic;
    }

    protected WorkManager getWorkManager() {
        if (this.workManager != null) {
            return this.workManager;
        }
        return this.getDispatcherPartition4rmic().getDefaultWorkManager();
    }

    public void setWorkManager(WorkManager wm) {
        this.workManager = wm;
    }

    public final boolean hasResults() {
        return this.result != this || this.throwableResponse != null;
    }

    public final void setResult(Response result) {
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyResult(Throwable throwable, boolean needFillInStackTrace) {
        InvocableMonitor invocableMonitor;
        boolean switchThreads;
        Request resumeExecution;
        Request request = this;
        synchronized (request) {
            resumeExecution = this.childResult(throwable, needFillInStackTrace);
            switchThreads = this.parentResumeNewThread;
            invocableMonitor = this.invocableMonitor;
        }
        this.doExecute(resumeExecution, switchThreads, invocableMonitor);
    }

    private void doExecute(Request resumeExecution, boolean switchThreads, InvocableMonitor invocableMonitor) {
        if (invocableMonitor != null) {
            this.clearInvocableMonitor();
        }
        if (resumeExecution == this) {
            if (switchThreads) {
                this.getWorkManager().schedule(this);
            } else {
                this.run();
            }
        } else if (resumeExecution != null) {
            resumeExecution.resumeExecution(switchThreads);
        }
    }

    Request childResult(Response candidate) {
        if (this.throwableResponse == null && (this.result == this || this.result == null && candidate != null || this.result instanceof InteropJMSVoidResponsePreDiablo && !(candidate instanceof InteropJMSVoidResponsePreDiablo))) {
            this.setResult(candidate);
        }
        return this.decrementNumChildren();
    }

    private Request childResult(Throwable throwableResponse, boolean needFillInStackTrace) {
        if (this.throwableResponse == null) {
            this.throwableResponse = throwableResponse;
            this.needFillInStackTrace = needFillInStackTrace;
            if (this.getNumChildren() > 1 || this.futureResponse != null) {
                this.setNumChildren(1);
            }
        }
        return this.decrementNumChildren();
    }

    void complete(Throwable throwable, boolean needFillInStackTrace) {
        this.setParentResumeNewThread(true);
        this.notifyResult(throwable, needFillInStackTrace);
    }

    private Request decrementNumChildren() {
        if (this.getNumChildren() > 0) {
            if (this.decNumChildren() == 0) {
                if (this.numWaiting > 0) {
                    this.notifyAll();
                }
                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                    JMSDebug.JMSDispatcher.debug("Request():: decrementNumChildren/true ZERO numChildren=" + this.getNumChildren() + " state=" + this.dbgState(this.state) + " running=" + this.isRunning() + " this=" + this + " parent=" + this.parent);
                }
                if (this.state == -42) {
                    this.setState(Integer.MAX_VALUE);
                    this.doCompletionListener(true);
                    return this.parent;
                }
                if (this.isRunning()) {
                    return null;
                }
                return this;
            }
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("Request():: decrementNumChildren/true POSITIVE numChildren=" + this.getNumChildren() + " state=" + this.dbgState(this.state) + " running=" + this.isRunning() + " " + this);
            }
        } else {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("Request():: decrementNumChildren/true IGNORED numChildren=" + this.getNumChildren() + " state=" + this.dbgState(this.state) + " running=" + this.isRunning() + " " + this);
            }
            this.notifyAll();
        }
        return null;
    }

    boolean hasListener() {
        return this.completionListener != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCompletionListener(boolean scheduleCompletionListener) {
        Throwable throwable;
        Response response;
        CompletionListener listener;
        Request request = this;
        synchronized (request) {
            if (this.completionListener == null) {
                return;
            }
            listener = this.completionListener;
            this.completionListener = null;
            response = this.result;
            throwable = this.throwableResponse;
            if (scheduleCompletionListener) {
                this.getWorkManager().schedule(new Runnable(){

                    @Override
                    public void run() {
                        Request.runCompletionListener(listener, throwable, response);
                    }
                });
                return;
            }
        }
        Request.runCompletionListener(listener, throwable, response);
    }

    public void rememberChild(Request newChild) {
        if (this.child != null) {
            if (this.child.throwableResponse != null) {
                return;
            }
            if (newChild.throwableResponse == null && (this.child.result != null && newChild.result == null || this.child.result instanceof InteropJMSVoidResponsePreDiablo && !(newChild.result instanceof InteropJMSVoidResponsePreDiablo))) {
                return;
            }
        }
        this.child = newChild;
    }

    public Request getChild() {
        return this.child;
    }

    public synchronized void waitForNotRunningResult() {
        if (!(!this.hasResults() || this.isRunning() || this.getState() != Integer.MAX_VALUE && this.getState() != -42 || this.throwableResponse == null && this.getNumChildren() != 0)) {
            return;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("Request():: waitForNotRunningResult() state=" + this.dbgState(this.state) + ", numChildren=" + this.getNumChildren() + " running=" + this.isRunning() + " " + this);
        }
        this.sleepTillNotified(true);
    }

    private String dbgState(int state) {
        String msg;
        switch (state) {
            case 0: {
                msg = "START:" + state;
                break;
            }
            case 0x7FFFFFFF: {
                msg = "COMPLETED:" + state;
                break;
            }
            case -42: {
                msg = "REMOTE:" + state;
                break;
            }
            case 1: {
                msg = "CONTINUE:" + state;
                break;
            }
            case 2: {
                msg = "TRY || FINISH:" + state;
                break;
            }
            case 3: {
                msg = "RETRY:" + state;
                break;
            }
            case 4: {
                msg = "AFTER_START_IP:" + state;
                break;
            }
            case 5: {
                msg = "AFTER_POST_AUTH_IP:" + state;
                break;
            }
            case 6: {
                msg = "RETURN_FROM_START_IP:" + state;
                break;
            }
            case 7: {
                msg = "RETURN_FROM_POST_AUTH_IP:" + state;
                break;
            }
            case 8: {
                msg = "RELEASE_FANOUT:" + state;
                break;
            }
            case 1101: {
                msg = "BEExtension.SEND_WAIT_FOR_COMPLETE:" + state;
                break;
            }
            case 1102: {
                msg = "SEND_ISSUE_MESSAGE";
                break;
            }
            case 1103: {
                msg = "SEND_COMPLETE:" + state;
                break;
            }
            case 1104: {
                msg = "SEND_UNKNOWN:" + state;
                break;
            }
            default: {
                msg = "unk:" + state;
            }
        }
        return msg;
    }

    public synchronized Response getResult() throws Throwable {
        while (this.result == this && this.throwableResponse == null) {
            this.sleepTillNotified(true);
        }
        if (this.throwableResponse != null) {
            Throwable wrappedCause;
            if (this.throwableResponse instanceof DispatcherException && (wrappedCause = this.throwableResponse.getCause()) != null) {
                this.throwableResponse = wrappedCause;
            }
            if (this.needFillInStackTrace) {
                this.needFillInStackTrace = false;
                this.throwableResponse = StackTraceUtilsClient.getThrowableWithCause(this.throwableResponse);
            }
            throw this.throwableResponse;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sleepTillNotified(boolean needResult) {
        if (needResult ? this.hasResults() : this.getNumChildren() < 1) {
            return;
        }
        ++this.numWaiting;
        try {
            if (this.tranInfo == 1 && this.transaction == null) {
                this.forceSuspendTransaction();
            }
            do {
                this.wait();
            } while (!(needResult ? this.hasResults() : this.getNumChildren() < 1));
            return;
        }
        catch (InterruptedException ie) {
            RuntimeException rte = new RuntimeException(ie);
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug(rte.getMessage(), rte);
            }
            throw rte;
        }
        finally {
            --this.numWaiting;
            try {
                if (this.transaction != null) {
                    this.resumeTransaction();
                }
            }
            finally {
                if (this.numWaiting > 0) {
                    this.notify();
                }
            }
        }
    }

    public final synchronized void setState(int state) {
        this.state = state;
    }

    public final int getState() {
        return this.state;
    }

    public final void resumeRequest(Throwable throwable, boolean needFillInStackTrace) {
        this.notifyResult(throwable, needFillInStackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resumeRequest(Response childResult) {
        boolean switchThreads;
        Request resumeExecution;
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("Request():: resumeRequest() " + this + ", has completionListener " + this.completionListener);
        }
        Request request = this;
        synchronized (request) {
            resumeExecution = this.childResult(childResult);
            switchThreads = this.parentResumeNewThread;
        }
        this.doExecute(resumeExecution, switchThreads, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resumeExecution(boolean switchThreads) {
        Request resumeExecution;
        Request request = this;
        synchronized (request) {
            resumeExecution = this.decrementNumChildren();
        }
        this.doExecute(resumeExecution, switchThreads |= this.parentResumeNewThread, null);
    }

    protected abstract Throwable getAppException(String var1, Throwable var2);

    @Override
    public final void handleResult(AsyncResult asyncResult) {
        Throwable throwable;
        Response result = null;
        Object obj = null;
        try {
            obj = asyncResult.getObject();
            result = (Response)obj;
            throwable = null;
        }
        catch (ClassCastException unusedCCE) {
            throwable = obj instanceof Throwable ? (Throwable)obj : this.getAppException("Unexpected remote response" + result, unusedCCE);
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (!this.getParentResumeNewThread()) {
            this.setParentResumeNewThread(true);
            if (TODOSAGREMOVEreportOnce) {
                TODOSAGREMOVEreportOnce = false;
                new Exception("messaging.Request TODOSAGREMOVEreportOnce " + this).printStackTrace();
            }
        }
        if (throwable != null) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("Request.handleResult() : " + this + " " + result, throwable);
            }
            this.notifyResult(throwable, true);
        } else {
            this.resumeRequest(result);
        }
    }

    public final synchronized void needOutsideResult() {
        this.incNumChildren();
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("needOutside numChildren = " + this.getNumChildren() + " on " + this);
        }
    }

    public final synchronized boolean fanoutComplete(boolean voidResponse) {
        if (this.decNumChildren() == 0) {
            if (!this.hasResults() && voidResponse) {
                this.setResult((Response)((Object)this.appVoidResponse));
            }
            return false;
        }
        return true;
    }

    public final synchronized boolean fanoutCompleteSuspendIfHaveChildren(boolean voidResponse) {
        if (this.decNumChildren() == 0) {
            if (!this.hasResults() && voidResponse) {
                this.setResult((Response)((Object)this.appVoidResponse));
            }
            return false;
        }
        if (this.transaction == null) {
            this.forceSuspendTransaction();
        }
        return true;
    }

    final void setFutureResponse(FutureResponse futureResponse) {
        this.futureResponse = futureResponse;
    }

    public final void setNext(Request next) {
        this.next = next;
    }

    public final Request getNext() {
        return this.next;
    }

    final Request getParent() {
        return this.parent;
    }

    public boolean isCollocated() {
        return this.isCollocated;
    }

    boolean isSyncRequest() {
        return this.isSyncRequest;
    }

    void setSyncRequest(boolean val) {
        this.isSyncRequest = val;
    }

    void setRunning(boolean val) {
        this.running = val;
    }

    private boolean isRunning() {
        return this.running;
    }

    public void setListener(CompletionListener cl) {
        this.completionListener = cl;
    }

    final void setAsyncResult(AsyncResult asyncResult) {
        this.asyncResult = asyncResult;
    }

    private static synchronized String timeString() {
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    private String requestName() {
        return this.requestThreadTime() + " " + this.getClass().getName() + ", state=" + this.dbgState(this.state) + ", numChildren= " + this.getNumChildren() + ", , hasResults()=" + this.hasResults() + ", " + this;
    }

    private String requestThreadTime() {
        return "@" + Request.timeString() + " Request Thread:" + Thread.currentThread().getName();
    }

    @Override
    public String toDbgString() {
        return this.requestName();
    }

    protected abstract int getInvocableTypeMask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Response wrappedFiniteStateMachine() throws Exception {
        FutureResponse futureResponseCopy;
        AsyncResult asyncResultCopy;
        Response throwable2;
        int localState;
        Response response;
        CompletionListener localListener;
        boolean switchThreads;
        Request parentCopy;
        Response responseCopy;
        Throwable throwableResponseCopy;
        block59: {
            Request parentClone;
            throwableResponseCopy = null;
            responseCopy = this;
            parentCopy = null;
            switchThreads = false;
            localListener = null;
            InvocableMonitor invocableMonitorCopy = null;
            response = this;
            synchronized (response) {
                if (this.isRunning()) {
                    return this;
                }
                if (this.state == -42) {
                    if (this.throwableResponse == null) {
                        if (this.getNumChildren() != 0) return this;
                        if (!this.hasResults()) return this;
                    }
                    localState = Integer.MAX_VALUE;
                    this.setState(Integer.MAX_VALUE);
                } else if (this.state == Integer.MAX_VALUE || this.throwableResponse != null && (this.futureResponse != null || this.asyncResult != null)) {
                    localState = Integer.MAX_VALUE;
                    invocableMonitorCopy = this.invocableMonitor;
                }
                if (this.transaction != null) {
                    this.resumeTransaction();
                }
                this.setRunning(true);
                parentClone = this.parent;
                localState = -42;
            }
            Request rootParent = this;
            while (rootParent.isCollocated && rootParent.parent != null) {
                if (this == rootParent) {
                    rootParent = parentClone;
                    continue;
                }
                rootParent = rootParent.parent;
            }
            while (true) {
                parentCopy = null;
                try {
                    if (this.invocable == null) {
                        InvocableManager im;
                        int typ = this.methodId & this.getInvocableTypeMask();
                        DispatcherPartition4rmic dpc4rmic = this.getDispatcherPartition4rmic();
                        try {
                            InvocableManagerDelegate invocableManagerDelegate = dpc4rmic.getInvocableManagerDelegate();
                            im = invocableManagerDelegate.getInvocableManager();
                        }
                        catch (Exception e) {
                            IOException ex = new IOException(e.getMessage() + "[methodId=" + this.methodId + ", type=" + typ + ", invocableId=" + this.invocableId + ", Request=" + this + "]", e);
                            if (!JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) throw ex;
                            JMSDebug.JMSDispatcher.debug(ex.getMessage(), ex);
                            throw ex;
                        }
                        try {
                            this.invocable = im.invocableFind(typ, this.invocableId);
                        }
                        catch (Exception e) {
                            Exception ex = new Exception(e.getMessage() + "[methodId=" + this.methodId + ", type=" + typ + ", invocableId=" + this.invocableId + ", Request=" + this + "]", e);
                            if (!JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) throw ex;
                            JMSDebug.JMSDispatcher.debug(ex.getMessage(), ex);
                            throw ex;
                        }
                        if (invocableMonitorCopy == null && (invocableMonitorCopy = this.invocable.getInvocableMonitor()) != null) {
                            invocableMonitorCopy.increment();
                            Request request = this;
                            synchronized (request) {
                                this.invocableMonitor = invocableMonitorCopy;
                            }
                        }
                    } else {
                        this.getDispatcherPartition4rmic().getInvocableManagerDelegate();
                    }
                    localState = this.invocable.invoke(this);
                }
                catch (Throwable throwable2) {
                    throwableResponseCopy = throwable2;
                    localState = Integer.MAX_VALUE;
                }
                throwable2 = this;
                synchronized (throwable2) {
                    if (this.state == -42) {
                        if (this.throwableResponse != null || this.getNumChildren() == 0 && this.hasResults()) {
                            localState = Integer.MAX_VALUE;
                            this.setState(Integer.MAX_VALUE);
                            this.setRunning(false);
                        } else {
                            this.setRunning(false);
                            if (this.transaction != null) return this;
                            if (this.tranInfo == 0) {
                                if (!this.hasTransaction()) return this;
                            }
                            this.forceSuspendTransaction();
                            return this;
                        }
                    }
                    if (localState == Integer.MAX_VALUE || this.state == Integer.MAX_VALUE || this.throwableResponse != null) break;
                    if (this.getNumChildren() == 0) {
                        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                            JMSDebug.JMSDispatcher.debug(" *** run the fsm of " + this + " again ***");
                        }
                        if (this.transaction != null) {
                            this.resumeTransaction();
                        }
                        continue;
                    }
                    if (!rootParent.isCollocated || !rootParent.isSyncRequest) break;
                    this.sleepTillNotified(false);
                    if (this.state == Integer.MAX_VALUE || this.throwableResponse != null) break;
                }
            }
            {
                block56: {
                    block58: {
                        block57: {
                            if (localState != Integer.MAX_VALUE && this.state != Integer.MAX_VALUE && this.throwableResponse == null) break block56;
                            localState = Integer.MAX_VALUE;
                            this.setState(Integer.MAX_VALUE);
                            this.setRunning(false);
                            asyncResultCopy = this.asyncResult;
                            this.asyncResult = null;
                            futureResponseCopy = this.futureResponse;
                            this.futureResponse = null;
                            localListener = this.completionListener;
                            this.completionListener = null;
                            if (throwableResponseCopy == null) break block57;
                            if (this.throwableResponse != null) {
                                throwableResponseCopy = this.throwableResponse;
                                break block58;
                            } else {
                                this.throwableResponse = throwableResponseCopy;
                                if (this.getNumChildren() > 0) {
                                    this.setNumChildren(0);
                                }
                            }
                            break block58;
                        }
                        if (this.throwableResponse != null) {
                            throwableResponseCopy = this.throwableResponse;
                        } else {
                            responseCopy = this.result;
                        }
                    }
                    if (throwableResponseCopy != null) {
                        Throwable wrappedCause;
                        if (throwableResponseCopy instanceof DispatcherException && (wrappedCause = throwableResponseCopy.getCause()) != null) {
                            this.throwableResponse = throwableResponseCopy = wrappedCause;
                        }
                        if (this.needFillInStackTrace) {
                            this.needFillInStackTrace = false;
                            throwableResponseCopy = StackTraceUtilsClient.getThrowableWithCause(throwableResponseCopy);
                        }
                    }
                    if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                        JMSDebug.JMSDispatcher.debug("     -- COMPLETED " + this + "--");
                    }
                    if (this.parent != null) {
                        parentCopy = this.parent;
                        switchThreads = this.parentResumeNewThread;
                    }
                    if (this.numWaiting > 0) {
                        this.notifyAll();
                    }
                    break block59;
                }
                if (this.transaction == null && (this.tranInfo != 0 || this.hasTransaction())) {
                    this.forceSuspendTransaction();
                }
                this.setRunning(false);
                asyncResultCopy = null;
                futureResponseCopy = null;
            }
        }
        if (localState != Integer.MAX_VALUE) {
            return responseCopy;
        }
        if (parentCopy != null) {
            parentCopy.resumeExecution(switchThreads || parentCopy.parentResumeNewThread);
        }
        try {
            Request.runCompletionListener(localListener, throwableResponseCopy, responseCopy);
            if (asyncResultCopy == null && futureResponseCopy == null) {
                if (throwableResponseCopy == null) {
                    response = responseCopy;
                    return response;
                }
                try {
                    throwable2 = this.getResult();
                    return throwable2;
                }
                catch (RuntimeException th) {
                    throw th;
                }
                catch (Error th) {
                    throw th;
                }
                catch (Throwable th) {
                    throw (Exception)th;
                }
            }
            response = Request.doRMIResponse(this, throwableResponseCopy, responseCopy, asyncResultCopy, futureResponseCopy);
            return response;
        }
        finally {
            this.clearInvocableMonitor();
        }
    }

    void setInvocable(Invocable invocable) {
        this.invocable = invocable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearInvocableMonitor() {
        InvocableMonitor invocableMonitor;
        Request request = this;
        synchronized (request) {
            if (this.invocableMonitor == null) {
                return;
            }
            invocableMonitor = this.invocableMonitor;
            this.invocableMonitor = null;
        }
        invocableMonitor.decrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response doRMIResponse(Request request, Throwable throwableResponseCopy, Response responseCopy, AsyncResult asyncResultCopy, FutureResponse futureResponseCopy) {
        block17: {
            try {
                if (throwableResponseCopy != null && futureResponseCopy != null) {
                    futureResponseCopy.sendThrowable(new DispatcherException(throwableResponseCopy));
                    break block17;
                }
                if (asyncResultCopy != null) {
                    try {
                        if (throwableResponseCopy != null) {
                            asyncResultCopy.setResult(new DispatcherException(throwableResponseCopy));
                        } else {
                            asyncResultCopy.setResult(responseCopy);
                        }
                        futureResponseCopy.send();
                    }
                    catch (Exception e) {
                        if (throwableResponseCopy == null) {
                            Request request2 = request;
                            synchronized (request2) {
                                request.throwableResponse = throwableResponseCopy = e;
                            }
                        }
                        futureResponseCopy.sendThrowable(new DispatcherException(throwableResponseCopy));
                    }
                    break block17;
                }
                if (futureResponseCopy != null) {
                    if (throwableResponseCopy != null) {
                        futureResponseCopy.sendThrowable(new DispatcherException(throwableResponseCopy));
                    } else {
                        futureResponseCopy.getMsgOutput().writeObject(responseCopy, responseCopy.getClass());
                        futureResponseCopy.send();
                    }
                }
            }
            catch (RemoteException ignored) {
                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                    ignored.printStackTrace();
                }
            }
            catch (IOException ignored) {
                if (!JMSDebug.JMSDispatcher.isDebugEnabled()) break block17;
                ignored.printStackTrace();
            }
        }
        return responseCopy;
    }

    private static void runCompletionListener(CompletionListener listener, Throwable throwable, Response response) {
        if (listener != null) {
            if (throwable != null) {
                listener.onException(throwable);
            } else {
                listener.onCompletion(response);
            }
        }
    }

    public abstract int remoteSignature();

    public abstract Response createResponse();

    final synchronized void setParentResumeNewThread(boolean val) {
        this.parentResumeNewThread = val;
    }

    public final boolean getParentResumeNewThread() {
        return this.parentResumeNewThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchAsync(Dispatcher dispatcher, Request request) throws DispatcherException {
        Request request2 = this;
        synchronized (request2) {
            request.clearDispatcherPartition4rmic();
            request.parent = this;
            this.incNumChildren();
        }
        if (JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) {
            JMSDebug.JMSDispatcherVerbose.debug("dispatchAsync:" + dispatcher.getId() + " request:" + request.requestName());
        }
        dispatcher.dispatchAsync(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchAsyncWithId(Dispatcher dispatcher, Request request, int id) throws DispatcherException {
        Request request2 = this;
        synchronized (request2) {
            request.clearDispatcherPartition4rmic();
            request.parent = this;
            this.incNumChildren();
        }
        if (JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) {
            JMSDebug.JMSDispatcherVerbose.debug("dispatchAsyncWithId:" + dispatcher.getId() + " request:" + request.requestName());
        }
        dispatcher.dispatchAsyncWithId(request, id);
    }

    public Request() {
        this.result = this;
        this.isCollocated = true;
    }

    void writeShortened(ObjectOutput out) throws IOException {
        this.shortened = true;
        this.writeExternal(out);
        this.shortened = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int mask = 1;
        if (!this.shortened && this.invocableId != null) {
            mask |= 0x100;
        }
        out.writeInt(mask);
        if (!this.shortened && this.invocableId != null) {
            this.invocableId.writeExternal(out);
        }
        out.writeInt(this.methodId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, new IDImpl());
    }

    protected final void readExternal(ObjectInput in, ID id) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1) {
            throw MessagingUtilities.versionIOException(version, 1, 1);
        }
        if ((mask & 0x100) != 0) {
            this.invocableId = id;
            this.invocableId.readExternal(in);
        }
        if ((mask & 0x200) != 0) {
            in.readLong();
        }
        this.methodId = in.readInt();
        this.isCollocated = false;
    }

    private boolean hasTransaction() {
        if (this.tranInfo == 2) {
            try {
                this.tranInfo = (this.remoteSignature() & 1) != 0 && Request.getTranManager().getTransaction() != null ? 1 : 0;
            }
            catch (SystemException se) {
                this.tranInfo = 0;
            }
        }
        return this.tranInfo == 1;
    }

    public final void setTranInfo(int tranInfo) {
        this.tranInfo = tranInfo;
    }

    private synchronized boolean forceSuspendTransaction() {
        if (this.transaction != null) {
            throw new Error("transaction suspended twice");
        }
        this.transaction = Request.getTranManager().forceSuspend();
        if (this.transaction == null) {
            this.tranInfo = 0;
            return false;
        }
        this.tranInfo = 1;
        return true;
    }

    private static ClientTransactionManager getTranManager() {
        return TransactionHelper.getTransactionHelper().getTransactionManager();
    }

    private synchronized void resumeTransaction() {
        if (this.transaction == null) {
            throw new Error("transaction resumed twice");
        }
        Request.getTranManager().forceResume(this.transaction);
        this.transaction = null;
    }

    static {
        sdf.setTimeZone(TimeZone.getDefault());
    }
}

