/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import jakarta.transaction.Transaction;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.DispatcherPartitionContext;
import weblogic.messaging.ID;
import weblogic.messaging.common.JMSCICHelper;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherCommon;
import weblogic.messaging.dispatcher.DispatcherEndPoint;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherOneWay;
import weblogic.messaging.dispatcher.DispatcherPeerGoneListener;
import weblogic.messaging.dispatcher.DispatcherRemote;
import weblogic.messaging.dispatcher.DispatcherStateChangeListener;
import weblogic.messaging.dispatcher.DispatcherUtils;
import weblogic.messaging.dispatcher.DispatcherWrapper;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.ResourceSetup;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.dispatcher.VoidResponse;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.AsyncResultFactory;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.spi.EndPoint;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;

public class DispatcherWrapperState
implements Dispatcher,
DisconnectListener,
RemoteWrapper,
TimerListener,
Runnable,
DispatcherCommon,
ResourceSetup {
    static final long serialVersionUID = -360573074488373048L;
    private final String name;
    private final DispatcherId dispatcherId;
    private PeerInfo peerInfo;
    private String peerGonePartitionName;
    private final DispatcherPartitionContext dispatcherPartitionContext;
    private final HashMap optionalMap;
    private DispatcherRemote dispatcherRemote;
    private DispatcherOneWay dispatcherOneWay;
    private boolean peerGone;
    private boolean peerGoneIsOn = false;
    private int refCount = 1;
    private Exception exceptionForPeerGone;
    private boolean fireListeners;
    private final transient HashMap listenersMap = new HashMap();
    private final transient HashMap stateChangeListeners = new HashMap();
    private int stateChangeListenersInExecution;
    private static final transient int PEERGONE_DELAY = 100;
    private static VoidResponse voidResponse = new VoidResponse();
    private static final ClientTransactionManager tranManager = TransactionHelper.getTransactionHelper().getTransactionManager();

    public DispatcherWrapperState(DispatcherWrapper remoteDispatcherWrapper, DispatcherPartitionContext dispatcherPartitionContext, HashMap optionalMap) throws DispatcherException {
        this.dispatcherId = remoteDispatcherWrapper.getId();
        this.name = remoteDispatcherWrapper.getName();
        this.dispatcherRemote = remoteDispatcherWrapper.getRemoteDispatcher();
        this.dispatcherOneWay = remoteDispatcherWrapper.getOneWayDispatcher();
        this.peerInfo = remoteDispatcherWrapper.getPeerInfo();
        this.dispatcherPartitionContext = dispatcherPartitionContext;
        this.optionalMap = optionalMap;
        this.peerGonePartitionName = DispatcherUtils.getPartitionName();
        this.addPeerGoneListener();
    }

    public final synchronized boolean getPeerGoneCache() {
        return this.peerGone;
    }

    public synchronized boolean removeRefCount() {
        --this.refCount;
        return this.refCount > 0;
    }

    public synchronized void addRefCount() {
        ++this.refCount;
    }

    public synchronized int getRefCount() {
        return this.refCount;
    }

    public final synchronized HashMap deleteNotify() {
        this.removePeerGoneListener();
        JMSEnvironment.getJMSEnvironment().cleanupDispatcherRemote(this.dispatcherRemote, this.dispatcherOneWay);
        return this.optionalMap;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final DispatcherId getId() {
        return this.dispatcherId;
    }

    @Override
    public final boolean isLocal() {
        return false;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    @Override
    public final Remote getRemoteDelegate() {
        return this.dispatcherRemote;
    }

    @Override
    public void dispatchAsync(Request request) throws DispatcherException {
        this.dispatchAsyncRemote(request, 0, false);
    }

    @Override
    public void dispatchAsyncWithId(Request request, int id) throws DispatcherException {
        this.dispatchAsyncRemote(request, id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchAsyncRemote(Request request, int id, boolean withid) throws DispatcherException {
        block17: {
            this.preAsync(request);
            try {
                if (0 != (request.remoteSignature() & 1)) {
                    if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                        JMSDebug.JMSDispatcher.debug("DispatcherWrapperState.dispatchAsyncRemote(request=" + request + ", id=" + id + ", withid=" + withid + ")");
                    }
                    AsyncResult asyncResult = AsyncResultFactory.getCallbackableResult(request);
                    if (withid) {
                        this.dispatcherRemote.dispatchAsyncTranFutureWithId(request, asyncResult, id);
                    } else {
                        this.dispatcherRemote.dispatchAsyncTranFuture(request, asyncResult);
                    }
                    break block17;
                }
                Transaction saveTx = null;
                try {
                    saveTx = tranManager.forceSuspend();
                    if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                        JMSDebug.JMSDispatcher.debug("DispatcherWrapperState.dispatchAsyncRemote(request=" + request + ", id=" + id + ", withid=" + withid + "), saveTx=" + saveTx);
                    }
                    AsyncResult asyncResult = AsyncResultFactory.getCallbackableResult(request);
                    if (withid) {
                        this.dispatcherRemote.dispatchAsyncFutureWithId(request, asyncResult, id);
                    } else {
                        this.dispatcherRemote.dispatchAsyncFuture(request, asyncResult);
                    }
                }
                finally {
                    if (saveTx != null) {
                        tranManager.forceResume(saveTx);
                    }
                }
            }
            catch (DispatcherException de) {
                request.complete(de, false);
                throw de;
            }
            catch (RemoteRuntimeException rre) {
                DispatcherException de = new DispatcherException(rre.getNestedException());
                request.complete(de, false);
                throw de;
            }
            catch (RemoteException re) {
                DispatcherException de = new DispatcherException(re);
                request.complete(de, false);
                throw de;
            }
            catch (Error err) {
                request.complete(err, false);
                throw err;
            }
            catch (RuntimeException rte) {
                request.complete(rte, false);
                throw rte;
            }
        }
    }

    @Override
    public void dispatchNoReply(Request request) throws DispatcherException {
        if ((request.remoteSignature() & 1) == 0) {
            this.preRemote(request);
            try {
                this.dispatcherOneWay.dispatchOneWay(request);
                this.postRMI(request, voidResponse);
            }
            catch (RemoteRuntimeException rre) {
                DispatcherException de = new DispatcherException(rre.getNestedException());
                request.complete(de, false);
                throw de;
            }
            catch (RemoteException re) {
                DispatcherException de = new DispatcherException(re);
                request.complete(de, false);
                throw de;
            }
            catch (Error err) {
                request.complete(err, false);
                throw err;
            }
            catch (RuntimeException rte) {
                request.complete(rte, false);
                throw rte;
            }
        } else {
            DispatcherException de = new DispatcherException("Transactions not supported for one-way calls");
            request.complete(de, false);
            throw de;
        }
    }

    @Override
    public void dispatchNoReplyWithId(Request request, int id) throws DispatcherException {
        this.preRemote(request);
        if ((request.remoteSignature() & 1) == 0) {
            try {
                this.dispatcherOneWay.dispatchOneWayWithId(request, id);
                this.postRMI(request, voidResponse);
            }
            catch (RemoteRuntimeException rre) {
                DispatcherException de = new DispatcherException(rre.getNestedException());
                request.complete(de, false);
                throw de;
            }
            catch (RemoteException re) {
                DispatcherException de = new DispatcherException(re);
                request.complete(de, false);
                throw de;
            }
            catch (Error err) {
                request.complete(err, false);
                throw err;
            }
            catch (RuntimeException rte) {
                request.complete(rte, false);
                throw rte;
            }
        } else {
            DispatcherException de = new DispatcherException("Transactions not supported for one-way calls");
            request.complete(de, false);
            throw de;
        }
    }

    @Override
    public Response dispatchSync(Request request) throws DispatcherException {
        return this.dispatchSyncNoTran(request);
    }

    private String preSync(Request request) {
        request.setSyncRequest(true);
        return this.preRemote(request);
    }

    private String preAsync(Request request) {
        return this.preRemote(request);
    }

    private String preRemote(Request request) {
        request.setDispatcherPartition4rmic(this.dispatcherPartitionContext);
        request.setPeerInfo(this.peerInfo);
        request.setState(-42);
        request.setParentResumeNewThread(true);
        request.incNumChildren();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response postRMI(Request request, Response childResult) {
        InvocableMonitor invocableMonitor;
        Request request2 = request;
        synchronized (request2) {
            request.childResult(childResult);
            invocableMonitor = request.getInvocableMonitor();
        }
        if (invocableMonitor != null) {
            request.clearInvocableMonitor();
        }
        return childResult;
    }

    public Response dispatchSyncTranWithId(Request request, int id) throws DispatcherException {
        this.preSync(request);
        try {
            return this.postRMI(request, this.dispatcherRemote.dispatchSyncTranFutureWithId(request, id));
        }
        catch (DispatcherException de) {
            request.complete(de, false);
            throw de;
        }
        catch (RemoteRuntimeException rre) {
            DispatcherException de = new DispatcherException(rre.getNestedException());
            request.complete(de, false);
            throw de;
        }
        catch (RemoteException re) {
            DispatcherException de = new DispatcherException(re);
            request.complete(de, false);
            throw de;
        }
        catch (Error err) {
            request.complete(err, false);
            throw err;
        }
        catch (RuntimeException rte) {
            request.complete(rte, false);
            throw rte;
        }
    }

    @Override
    public Response dispatchSyncTran(Request request) throws DispatcherException {
        this.preSync(request);
        try {
            return this.postRMI(request, this.dispatcherRemote.dispatchSyncTranFuture(request));
        }
        catch (DispatcherException de) {
            request.complete(de, false);
            throw de;
        }
        catch (RemoteRuntimeException rre) {
            DispatcherException de = new DispatcherException(rre.getNestedException());
            request.complete(de, false);
            throw de;
        }
        catch (RemoteException re) {
            DispatcherException de = new DispatcherException(re);
            request.complete(de, false);
            throw de;
        }
        catch (Error err) {
            request.complete(err, false);
            throw err;
        }
        catch (RuntimeException rte) {
            request.complete(rte, false);
            throw rte;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response dispatchSyncNoTranWithId(Request request, int id) throws DispatcherException {
        Transaction saveTx = tranManager.forceSuspend();
        try {
            Response response = this.dispatchSyncTranWithId(request, id);
            return response;
        }
        finally {
            if (saveTx != null) {
                tranManager.forceResume(saveTx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response dispatchSyncNoTran(Request request) throws DispatcherException {
        Transaction saveTx = tranManager.forceSuspend();
        try {
            Response response = this.dispatchSyncTran(request);
            return response;
        }
        finally {
            if (saveTx != null) {
                tranManager.forceResume(saveTx);
            }
        }
    }

    @Override
    public void onDisconnect(DisconnectEvent reason) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherWrapperState.onDisconnect");
        }
        this.removePeerGoneListener();
        this.schedulePeerGone(new Exception(reason.getThrowable()));
    }

    public synchronized void addPeerGoneListener() throws DispatcherException {
        if (this.dispatcherRemote == null) {
            if (this.peerGoneIsOn) {
                return;
            }
            DispatcherException de = new DispatcherException("dispatcherRemote is null");
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug(de.getMessage(), de);
            }
            throw de;
        }
        DisconnectMonitor dm = DisconnectMonitorListImpl.getDisconnectMonitor();
        try {
            Remote r = this.dispatcherRemote;
            if (r instanceof RemoteWrapper) {
                r = ((RemoteWrapper)((Object)r)).getRemoteDelegate();
            }
            dm.addDisconnectListener(r, this);
        }
        catch (DisconnectMonitorUnavailableException hmue) {
            DispatcherException de = new DispatcherException(hmue.getMessage() + " for " + this.dispatcherId);
            de.initCause(hmue);
            throw de;
        }
        this.peerGoneIsOn = true;
    }

    public synchronized void removePeerGoneListener() {
        block9: {
            if (!this.peerGoneIsOn) {
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("DispatcherWrapperState; removePeerGoneListener; dispatcherId: " + this.getId().getDetail() + " !peerGoneIsOn, returning");
                }
                return;
            }
            this.peerGoneIsOn = false;
            if (this.dispatcherRemote == null) {
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("DispatcherWrapperState; removePeerGoneListener; dispatcherId: " + this.getId().getDetail() + " dispatcherRemote == null");
                }
                return;
            }
            DisconnectMonitor dm = DisconnectMonitorListImpl.getDisconnectMonitor();
            try {
                EndPoint endPoint;
                Remote r = this.dispatcherRemote;
                if (r instanceof RemoteWrapper) {
                    r = ((RemoteWrapper)((Object)r)).getRemoteDelegate();
                }
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("DispatcherWrapperState; removePeerGoneListener; dispatcherId: " + this.getId().getDetail());
                }
                dm.removeDisconnectListener(r, this);
                if (r instanceof DispatcherEndPoint && (endPoint = ((DispatcherEndPoint)((Object)r)).getEndPoint()) != null) {
                    endPoint.removeDisconnectListener(r, this);
                }
            }
            catch (Exception e) {
                if (!JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) break block9;
                JMSDebug.JMSDispatcherLifecycle.debug("DispatcherWrapperState; removePeerGoneListener; dispatcherId: " + this.getId().getDetail(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DispatcherPeerGoneListener addDispatcherPeerGoneListener(DispatcherPeerGoneListener listener) {
        DispatcherPeerGoneListener origPeerGoneListener;
        DispatcherWrapperState dispatcherWrapperState = this;
        synchronized (dispatcherWrapperState) {
            origPeerGoneListener = (DispatcherPeerGoneListener)this.listenersMap.get(listener.getId());
            if (this.exceptionForPeerGone == null) {
                if (origPeerGoneListener == null) {
                    origPeerGoneListener = listener;
                    this.listenersMap.put(listener.getId(), origPeerGoneListener);
                    if (listener instanceof DispatcherStateChangeListener) {
                        this.stateChangeListeners.put(listener.getId(), origPeerGoneListener);
                    }
                }
                origPeerGoneListener.incrementRefCount();
                return origPeerGoneListener;
            }
        }
        try {
            listener.dispatcherPeerGone(this.exceptionForPeerGone, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dispatcherWrapperState = this;
        synchronized (dispatcherWrapperState) {
            return origPeerGoneListener == null ? listener : origPeerGoneListener;
        }
    }

    @Override
    public synchronized void removeDispatcherPeerGoneListener(DispatcherPeerGoneListener listener) {
        ID id = listener.getId();
        DispatcherPeerGoneListener pListener = (DispatcherPeerGoneListener)this.listenersMap.get(id);
        if (pListener == null) {
            return;
        }
        if (pListener.decrementRefCount() == 0) {
            this.listenersMap.remove(id);
            if (pListener instanceof DispatcherStateChangeListener) {
                this.stateChangeListeners.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePeerGone(Exception reason) {
        Error err;
        RuntimeException rte;
        block21: {
            boolean noStateChangeListeners;
            boolean needToSchedule = false;
            boolean listenerInExecution = false;
            rte = null;
            err = null;
            while (true) {
                DispatcherStateChangeListener dscl;
                DispatcherWrapperState dispatcherWrapperState = this;
                synchronized (dispatcherWrapperState) {
                    this.peerGone = true;
                    if (this.exceptionForPeerGone == null) {
                        this.exceptionForPeerGone = reason;
                        needToSchedule = true;
                    }
                    if (listenerInExecution) {
                        --this.stateChangeListenersInExecution;
                    }
                    if (noStateChangeListeners = this.stateChangeListeners.isEmpty()) {
                        if (this.stateChangeListenersInExecution == 0) {
                            this.notifyAll();
                        }
                        break;
                    }
                    dscl = this.removeLockedStateChangeListener();
                    if (dscl == null) {
                        if (this.stateChangeListenersInExecution == 0) {
                            this.notifyAll();
                        }
                        break;
                    }
                    if (!listenerInExecution) {
                        listenerInExecution = true;
                        ++this.stateChangeListenersInExecution;
                    }
                }
                try {
                    dscl.stateChangeListener(dscl, reason);
                }
                catch (Error error) {
                    if (err != null || rte != null) continue;
                    err = error;
                }
                catch (RuntimeException runtime) {
                    if (err != null || rte != null) continue;
                    rte = runtime;
                }
            }
            if (needToSchedule && this.dispatcherPartitionContext.isPartitionActive()) {
                if (noStateChangeListeners) {
                    this.dispatcherPartitionContext.getDefaultWorkManager().schedule(this);
                } else {
                    try {
                        this.dispatcherPartitionContext.getDefaultTimerManager().schedule((TimerListener)this, 100L);
                    }
                    catch (IllegalStateException ise) {
                        if (!JMSDebug.JMSDispatcher.isDebugEnabled()) break block21;
                        JMSDebug.JMSDispatcher.debug("Unable to schedule a disconnect notification on a shuting down server.");
                    }
                }
            }
        }
        if (rte != null) {
            throw rte;
        }
        if (err != null) {
            throw err;
        }
    }

    private DispatcherStateChangeListener removeLockedStateChangeListener() {
        Iterator iterator = this.stateChangeListeners.values().iterator();
        while (iterator.hasNext()) {
            DispatcherStateChangeListener dscl = (DispatcherStateChangeListener)iterator.next();
            if (!dscl.holdsLock()) continue;
            iterator.remove();
            return dscl;
        }
        return null;
    }

    @Override
    public void timerExpired(Timer timer) {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        err = null;
        rte = null;
        if (!this.dispatcherPartitionContext.isPartitionActive()) {
            return;
        }
        mic = JMSCICHelper.pushJMSCICByPartitionName(this.dispatcherPartitionContext, this.peerGonePartitionName);
        var6_4 = null;
        try {
            this.dispatcherPartitionContext.removeDispatcherReference(this, true);
            while (true) {
                block32: {
                    var9_10 = this;
                    // MONITORENTER : var9_10
                    while (this.stateChangeListenersInExecution > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    v0 = isStateChangeListener = this.stateChangeListeners.isEmpty() == false;
                    if (!isStateChangeListener) break block32;
                    itr = this.stateChangeListeners.values().iterator();
                    ** GOTO lbl35
                }
                if (!this.fireListeners) {
                    this.fireListeners = true;
                    this.notifyAll();
                }
                if (this.listenersMap.isEmpty()) {
                    if (rte != null) {
                        throw rte;
                    }
                    if (err != null) {
                        throw err;
                    }
                    // MONITOREXIT : var9_10
                    return;
                }
                itr = this.listenersMap.values().iterator();
lbl35:
                // 2 sources

                reason = this.exceptionForPeerGone;
                pgl = (DispatcherPeerGoneListener)itr.next();
                itr.remove();
                // MONITOREXIT : var9_10
                if (isStateChangeListener) {
                    try {
                        ((DispatcherStateChangeListener)pgl).stateChangeListener((DispatcherStateChangeListener)pgl, reason);
                    }
                    catch (Error error) {
                        if (err != null || rte != null) continue;
                        err = error;
                    }
                    catch (RuntimeException runtime) {
                        if (err != null || rte != null) continue;
                        rte = runtime;
                    }
                    continue;
                }
                try {
                    pgl.dispatcherPeerGone(reason, this);
                }
                catch (Error error) {
                    if (err != null || rte != null) continue;
                    err = error;
                }
                catch (RuntimeException runtime) {
                    if (err != null || rte != null) continue;
                    rte = runtime;
                }
                continue;
                break;
            }
        }
        catch (Throwable var7_8) {
            var6_4 = var7_8;
            throw var7_8;
        }
        finally {
            if (mic != null) {
                if (var6_4 != null) {
                    try {
                        mic.close();
                    }
                    catch (Throwable var10_16) {
                        var6_4.addSuppressed(var10_16);
                    }
                } else {
                    mic.close();
                }
            }
        }
    }

    public String toString() {
        return "DispWrapperState #" + this.hashCode() + " dispatcherId: " + this.dispatcherId + " name: " + this.name + " peerGonePartitionName: " + this.peerGonePartitionName;
    }

    @Override
    public void giveRequestResource(Request request) {
        request.setDispatcherPartition4rmic(this.dispatcherPartitionContext);
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.dispatcherPartitionContext;
    }
}

