/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.visibility.utils;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanNameUtil {
    public static final String PARTITION_KEY = "Partition";
    public static final String GLOBAL_PARTITION_NAME = "DOMAIN";
    public static final String REALM_RUNTIME_KEY = "RealmRuntime";
    private static String[] deploymentRuntimeMBeanTypes = new String[]{"AppDeploymentRuntime", "LibDeploymentRuntime", "DeploymentProgressObject"};
    private static String[] jdkDomains = new String[]{"JMImplementation", "com.sun.management", "java.lang", "java.nio", "java.util.logging"};

    public static boolean isJDKMBean(ObjectName objectName) {
        return objectName != null && Arrays.asList(jdkDomains).contains(objectName.getDomain());
    }

    public static boolean isGlobalMBean(ObjectName oname) {
        return !(MBeanNameUtil.isWLSMBean(oname) ? oname.getKeyProperty(PARTITION_KEY) != null || oname.getKeyProperty("PartitionRuntime") != null || oname.getKeyProperty("DomainPartitionRuntime") != null || MBeanNameUtil.getPartitionNameFromParentKey(oname) != null : oname.getKeyProperty(PARTITION_KEY) != null || oname.getKeyProperty("domainPartition") != null);
    }

    public static boolean isWLSMBean(ObjectName objectName) {
        return objectName != null && "com.bea".equals(objectName.getDomain());
    }

    public static String getPartitionNameFromParentKey(ObjectName objectName) {
        String parentKey = objectName.getKeyProperty("Parent");
        if (parentKey == null) {
            return null;
        }
        String partitionKey = MBeanNameUtil.findPartitionNameFromParentKey(parentKey, PARTITION_KEY);
        if (partitionKey != null) {
            return partitionKey;
        }
        partitionKey = MBeanNameUtil.findPartitionNameFromParentKey(parentKey, "PartitionRuntime");
        if (partitionKey != null) {
            return partitionKey;
        }
        return MBeanNameUtil.findPartitionNameFromParentKey(parentKey, "DomainPartitionRuntime");
    }

    private static String findPartitionNameFromParentKey(String parentKey, String partitionIdentificationName) {
        String regexPrefix = ".+\\/";
        String regexSuffix = "s\\[(.*?)\\]";
        Pattern pattern = Pattern.compile(regexPrefix + partitionIdentificationName + regexSuffix);
        Matcher matcher = pattern.matcher(parentKey);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean containsDecorator(ObjectName objectName) {
        return objectName.getKeyPropertyList().containsKey(PARTITION_KEY) || objectName.getKeyPropertyList().containsKey("PartitionRuntime") || objectName.getKeyPropertyList().containsKey("DomainPartitionRuntime") || objectName.getKeyPropertyList().containsKey("domainPartition");
    }

    public static boolean isWLSMBeanInSamePartition(String partitionName, ObjectName oname) {
        return oname.getDomain().equals("com.bea") && oname.getKeyProperty(PARTITION_KEY) != null && oname.getKeyProperty(PARTITION_KEY).equals(partitionName) || oname.getKeyProperty("PartitionRuntime") != null && oname.getKeyProperty("PartitionRuntime").equals(partitionName) || oname.getKeyProperty("DomainPartitionRuntime") != null && oname.getKeyProperty("DomainPartitionRuntime").equals(partitionName);
    }

    public static boolean isMBeanInSamePartition(String partitionName, ObjectName oname) {
        return oname.getKeyProperty(PARTITION_KEY) != null && oname.getKeyProperty(PARTITION_KEY).equals(partitionName) || oname.getKeyProperty("PartitionRuntime") != null && oname.getKeyProperty("PartitionRuntime").equals(partitionName) || oname.getKeyProperty("DomainPartitionRuntime") != null && oname.getKeyProperty("DomainPartitionRuntime").equals(partitionName);
    }

    public static boolean isCoherenceMBean(ObjectName objectName) {
        return objectName != null && (objectName.getKeyPropertyList().containsKey("domainPartition") || "Coherence".equals(objectName.getDomain()));
    }

    public static boolean isCoherenceMBeanInSamePartition(String partitionName, ObjectName oname) {
        return oname.getKeyProperty("domainPartition") != null && oname.getKeyProperty("domainPartition").equals(partitionName);
    }

    public static boolean isResourceGroupMBean(ObjectName oname) {
        String type;
        return MBeanNameUtil.isGlobalMBean(oname) && (type = oname.getKeyProperty("Type")) != null && type.equals("ResourceGroup");
    }

    public static boolean isResourceGroupMBeanInSamePartition(ObjectName oname, String[] rgNames) {
        String name;
        if (MBeanNameUtil.isResourceGroupMBean(oname) && (name = oname.getKeyProperty("Name")) != null && rgNames != null) {
            for (String rgName : rgNames) {
                if (!name.equals(rgName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWLSDeploymentRuntime(ObjectName oname) {
        if (MBeanNameUtil.isGlobalMBean(oname)) {
            String type = oname.getKeyProperty("Type");
            for (String deploymentRuntimeMBean : deploymentRuntimeMBeanTypes) {
                if (type == null || !type.equals(deploymentRuntimeMBean)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPartitionOwnedWLSDeploymentMBeanInSamePartition(String partitionName, ObjectName oname) {
        int index;
        String name;
        return MBeanNameUtil.isWLSDeploymentRuntime(oname) && (name = oname.getKeyProperty("Name")) != null && (index = name.indexOf("$")) != -1 && name.substring(index, name.length()).equals(partitionName);
    }

    public static boolean isWLSPartitionConfigurationMBean(ObjectName oname) {
        String[] partitionTypes = new String[]{PARTITION_KEY, "PartitionRuntime", "DomainPartitionRuntime", "PartitionLifeCycleRuntime", "ResourceGroupLifeCycleRuntime"};
        if (oname.getDomain().equals("com.bea")) {
            String type = oname.getKeyProperty("Type");
            for (String partitionType : partitionTypes) {
                if (type == null || !type.equals(partitionType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWLSPartitionConfigurationMBeanInSamePartition(String partitionName, ObjectName oname) {
        if (MBeanNameUtil.isWLSPartitionConfigurationMBean(oname)) {
            String name = oname.getKeyProperty("Name");
            if (name != null && name.equals(partitionName)) {
                return true;
            }
            String rgLifeCycleRuntime = oname.getKeyProperty("PartitionLifeCycleRuntime");
            if (rgLifeCycleRuntime != null && rgLifeCycleRuntime.equals(partitionName)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isWLSVirtualTargetMBean(ObjectName oname) {
        return oname.getDomain().equals("com.bea") && oname.toString().contains("VirtualTarget");
    }

    public static boolean isAvailableTarget(String name, String[] targetNames) {
        for (int i = 0; i < targetNames.length; ++i) {
            if (name == null || !name.equals(targetNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isSecurityMBean(ObjectName name) {
        return "Security".equals(name.getDomain());
    }

    public static boolean isWLSRealmRuntimeMBean(ObjectName name) {
        return name.getDomain().equals("com.bea") && (name.getKeyProperty(REALM_RUNTIME_KEY) != null || REALM_RUNTIME_KEY.equals(name.getKeyProperty("Type")));
    }

    public static String findPartitionName(ObjectName objectName) {
        String partitionKey = objectName.getKeyProperty(PARTITION_KEY);
        if (partitionKey != null) {
            return partitionKey;
        }
        partitionKey = objectName.getKeyProperty("PartitionRuntime");
        if (partitionKey != null) {
            return partitionKey;
        }
        partitionKey = objectName.getKeyProperty("DomainPartitionRuntime");
        if (partitionKey != null) {
            return partitionKey;
        }
        partitionKey = MBeanNameUtil.getPartitionNameFromParentKey(objectName);
        if (partitionKey != null) {
            return partitionKey;
        }
        return GLOBAL_PARTITION_NAME;
    }

    public static ObjectName addLocation(ObjectName name, String location) {
        Hashtable<String, String> table = name.getKeyPropertyList();
        table.put("Location", location);
        try {
            return new ObjectName(name.getDomain(), table);
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ObjectName removeLocation(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        if (objectName.getKeyProperty("Location") == null) {
            return objectName;
        }
        Hashtable<String, String> table = objectName.getKeyPropertyList();
        try {
            StringBuffer newObjectNameString = new StringBuffer();
            if (objectName.isDomainPattern()) {
                newObjectNameString.append("*:");
            } else {
                newObjectNameString.append(objectName.getDomain() + ":");
            }
            Iterator<Map.Entry<String, String>> entries = table.entrySet().iterator();
            boolean firstEntry = true;
            while (entries.hasNext()) {
                Map.Entry<String, String> entry = entries.next();
                if (entry.getKey().equals("Location")) continue;
                if (!firstEntry) {
                    newObjectNameString.append(",");
                }
                newObjectNameString.append(entry.getKey() + "=" + entry.getValue());
                firstEntry = false;
            }
            if (objectName.isPropertyPattern()) {
                if (!firstEntry) {
                    newObjectNameString.append(",");
                }
                newObjectNameString.append("*");
            }
            return new ObjectName(newObjectNameString.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
    }
}

