/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.jndi.ThreadLocalMap;
import weblogic.management.remote.common.RMIConnectionWrapper;
import weblogic.management.remote.common.RMIServerWrapper;
import weblogic.management.remote.common.WLSJMXConnector;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.security.Security;

public class WLSRMIConnector
extends RMIConnector
implements DisconnectListener,
WLSJMXConnector {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger("DebugJMXCoreConcise");
    private Subject subject;
    private final RMIServerWrapper server;
    private DisconnectMonitor monitor;
    private ClassLoader jmxLoader;
    private Map<String, ?> env;
    private ComponentInvocationContext cic;
    private ComponentInvocationContextManager securedCICM;
    private static Method isLocalMethod;

    public WLSRMIConnector(RMIServerWrapper rmiServer, Map map, Subject subject, ClassLoader jmxLoader) {
        this(rmiServer, map, subject, jmxLoader, null, null);
    }

    public WLSRMIConnector(RMIServerWrapper rmiServer, Map map, Subject subject, ClassLoader jmxLoader, ComponentInvocationContext cic, ComponentInvocationContextManager securedCICM) {
        super(rmiServer, map);
        this.subject = subject;
        this.server = rmiServer;
        this.jmxLoader = jmxLoader;
        this.env = map;
        this.cic = cic;
        this.securedCICM = securedCICM;
        if (this.checkLocalWithReflection(rmiServer)) {
            return;
        }
        try {
            this.monitor = DisconnectMonitorListImpl.getDisconnectMonitor();
            this.monitor.addDisconnectListener(rmiServer, this);
        }
        catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
            // empty catch block
        }
    }

    private boolean checkLocalWithReflection(RMIServer rmiServer) {
        if (isLocalMethod != null) {
            try {
                return (Boolean)isLocalMethod.invoke(null, rmiServer);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect(DisconnectEvent event) {
        ClassLoader old = this.pushJMXClassLoader();
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("WLSRMIConnector: onDisconnect ");
            }
            this.server.disconnected();
            this.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.popJMXClassLoader(old);
        }
    }

    private ClassLoader pushJMXClassLoader() {
        final Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        if (this.jmxLoader != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    t.setContextClassLoader(WLSRMIConnector.this.jmxLoader);
                    return null;
                }
            });
        }
        return old;
    }

    private void popJMXClassLoader(final ClassLoader old) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(old);
                return null;
            }
        });
    }

    @Override
    public void connect() throws IOException {
        ClassLoader old = this.pushJMXClassLoader();
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WLSRMIConnector.this.doConnect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        finally {
            this.popJMXClassLoader(old);
        }
    }

    private void doConnect() throws IOException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("WLSRMIConnector: doConnect ");
        }
        super.connect();
    }

    public synchronized void connect(Map map) throws IOException {
        final Map finalMap = map;
        ClassLoader old = this.pushJMXClassLoader();
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WLSRMIConnector.this.doConnect(finalMap);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        finally {
            this.popJMXClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doConnect(Map map) throws IOException {
        block24: {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("WLSRMIConnector: doConnect ");
            }
            Long timeout = null;
            String providerUrl = null;
            if (map != null) {
                timeout = (Long)map.get("jmx.remote.x.request.waiting.timeout");
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("WLSRMIConnector: doConnect - jmx.remote.x.request.waiting.timeout = " + timeout);
                }
                providerUrl = (String)map.get("java.naming.provider.url");
            }
            try {
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                if (timeout != null || providerUrl != null) {
                    if (timeout != null) {
                        ht.put("weblogic.jndi.responseReadTimeout", timeout);
                        ht.put("weblogic.jndi.connectTimeout", timeout);
                    }
                    if (providerUrl != null) {
                        ht.put("java.naming.provider.url", providerUrl);
                    }
                    ThreadLocalMap.push(ht);
                }
                if (this.cic != null) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("WLSRMIConnector: Register ComponentInvocationContext: cic = " + this.cic);
                    }
                    try (ManagedInvocationContext mic = this.securedCICM.setCurrentComponentInvocationContext(this.cic);){
                        super.connect(map);
                        break block24;
                    }
                }
                super.connect(map);
            }
            finally {
                if (timeout != null) {
                    ThreadLocalMap.pop();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        ClassLoader old = this.pushJMXClassLoader();
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WLSRMIConnector.this.removeDisconnectListener();
                    WLSRMIConnector.this.doClose();
                    return null;
                }
            });
            this.server.clearTimeouts();
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        finally {
            this.popJMXClassLoader(old);
        }
    }

    private void doClose() throws IOException {
        block4: {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("WLSRMIConnector: doClose ");
            }
            super.close();
            try {
                Class<?> cls = Class.forName("weblogic.corba.j2ee.naming.ORBHelper");
                Method meth = cls.getDeclaredMethod("removeCurrentClientSecurityContext", new Class[0]);
                meth.invoke(cls, new Object[0]);
            }
            catch (NoClassDefFoundError cls) {
            }
            catch (Exception ex) {
                if (!debugLogger.isDebugEnabled()) break block4;
                debugLogger.debug("WLSRMIConnector: doClose: exception when removeCurrentClientSecurityContext: " + ex);
            }
        }
    }

    private void removeDisconnectListener() {
        try {
            if (this.monitor != null) {
                this.monitor.removeDisconnectListener(this.server, this);
            }
        }
        catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection(Locale locale) throws IOException {
        ClassLoader old = this.pushJMXClassLoader();
        try {
            MBeanServerConnection connection = super.getMBeanServerConnection();
            if (this.server == null) {
                MBeanServerConnection mBeanServerConnection = connection;
                return mBeanServerConnection;
            }
            String connId = this.getConnectionId();
            Object object = this.server;
            synchronized (object) {
                for (RMIConnectionWrapper rmiConnWrapper : this.server.getConnections()) {
                    if (rmiConnWrapper == null || !connId.equals(rmiConnWrapper.getConnectionId())) continue;
                    rmiConnWrapper.setLocale(locale);
                    break;
                }
            }
            object = connection;
            return object;
        }
        finally {
            this.popJMXClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection(Subject delegationSubject, Locale locale) throws IOException {
        ClassLoader old = this.pushJMXClassLoader();
        try {
            MBeanServerConnection connection = super.getMBeanServerConnection(delegationSubject);
            if (this.server == null) {
                MBeanServerConnection mBeanServerConnection = connection;
                return mBeanServerConnection;
            }
            String connId = this.getConnectionId();
            for (RMIConnectionWrapper rmiConnWrapper : this.server.getConnections()) {
                if (!connId.equals(rmiConnWrapper.getConnectionId())) continue;
                rmiConnWrapper.setLocale(delegationSubject, locale);
                break;
            }
            MBeanServerConnection mBeanServerConnection = connection;
            return mBeanServerConnection;
        }
        finally {
            this.popJMXClassLoader(old);
        }
    }

    static {
        Class<?> serverHelperClass = null;
        try {
            serverHelperClass = Class.forName("weblogic.rmi.extensions.server.ServerHelper");
        }
        catch (ClassNotFoundException e) {
            isLocalMethod = null;
        }
        if (serverHelperClass != null) {
            Class[] arguments = new Class[]{Remote.class};
            try {
                isLocalMethod = serverHelperClass.getDeclaredMethod("isLocal", arguments);
            }
            catch (NoSuchMethodException e) {
                isLocalMethod = null;
            }
        }
    }
}

